"""${entity_name} Repository Implementation.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from uuid import UUID

from ${module_name}.domain.entity.${entity_name_lower} import ${entity_name}
from ${module_name}.domain.repository.${entity_name_lower}_repository import ${entity_name}Repository
from ${module_name}.infrastructure.persistence.database import db


class SQLAlchemy${entity_name}Repository(${entity_name}Repository):
    """SQLAlchemy implementation of ${entity_name}Repository."""

    def find_by_id(self, id: UUID) -> ${entity_name} | None:
        """Find ${entity_name_lower} by ID."""
        return db.session.query(${entity_name}).filter(${entity_name}.id == id).first()

    def find_all(self, limit: int = 100, offset: int = 0) -> list[${entity_name}]:
        """Find all ${entity_name_plural}."""
        return db.session.query(${entity_name}).limit(limit).offset(offset).all()

    def save(self, entity: ${entity_name}) -> ${entity_name}:
        """Save ${entity_name_lower}."""
        db.session.add(entity)
        db.session.commit()
        db.session.refresh(entity)
        return entity

    def delete(self, id: UUID) -> bool:
        """Delete ${entity_name_lower} by ID."""
        entity = self.find_by_id(id)
        if entity:
            db.session.delete(entity)
            db.session.commit()
            return True
        return False
