"""Health Check Handler.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from flask import Blueprint, jsonify, current_app
from flasgger import swag_from

health_bp = Blueprint("health", __name__)


@health_bp.route("/health", methods=["GET"])
@swag_from({
    "tags": ["Health"],
    "summary": "Health check endpoint",
    "description": "Returns the health status of the service",
    "responses": {
        200: {
            "description": "Service is healthy",
            "schema": {
                "type": "object",
                "properties": {
                    "status": {"type": "string", "example": "healthy"},
                    "service": {"type": "string"},
                    "version": {"type": "string"},
                }
            }
        }
    }
})
def health_check():
    """Health check endpoint."""
    config = current_app.config.get("APP_CONFIG")
    return jsonify({
        "status": "healthy",
        "service": config.service_name if config else "${service_name}",
        "version": config.service_version if config else "${service_version}",
    })


@health_bp.route("/ready", methods=["GET"])
def readiness_check():
    """Readiness check endpoint."""
    # Add database connectivity check here
    return jsonify({"status": "ready"})


@health_bp.route("/live", methods=["GET"])
def liveness_check():
    """Liveness check endpoint."""
    return jsonify({"status": "alive"})
