# ${project_name}

RESTful API built with Flask, SQLAlchemy, and DDD + CQRS architecture.

Auto-generated by TelemetryFlow RESTful API Generator.

## Features

- **DDD Architecture**: Domain-Driven Design with clear separation of concerns
- **CQRS Pattern**: Command Query Responsibility Segregation
- **Flask**: Lightweight and flexible web framework
- **SQLAlchemy**: ORM with support for PostgreSQL, MySQL, SQLite
- **JWT Authentication**: Secure API authentication
- **Swagger/OpenAPI**: Interactive API documentation
- **TelemetryFlow**: Built-in observability with metrics, logs, and traces

## Quick Start

### Prerequisites

- Python 3.12+
- PostgreSQL (or SQLite for development)

### Installation

```bash
# Clone the repository
cd ${project_name}

# Create virtual environment
python -m venv .venv
source .venv/bin/activate  # On Windows: .venv\Scripts\activate

# Install dependencies
pip install -e ".[dev]"

# Copy environment configuration
cp .env.example .env

# Edit .env with your settings
```

### Running the Application

```bash
# Development mode
make run

# Or with Docker
make docker-up
```

### API Documentation

Once running, visit:
- Swagger UI: http://localhost:${server_port}/apidocs

## Project Structure

```
${project_name}/
├── src/${module_name}/
│   ├── domain/              # Domain layer
│   │   ├── entity/          # Domain entities
│   │   └── repository/      # Repository interfaces
│   ├── application/         # Application layer (CQRS)
│   │   ├── command/         # Commands
│   │   ├── query/           # Queries
│   │   ├── handler/         # Command & Query handlers
│   │   └── dto/             # Data Transfer Objects
│   ├── infrastructure/      # Infrastructure layer
│   │   ├── config/          # Configuration
│   │   ├── persistence/     # Database implementation
│   │   └── http/            # HTTP handlers & middleware
│   └── main.py              # Application entry point
├── tests/                   # Test files
├── migrations/              # Database migrations
├── docs/                    # Documentation
├── pyproject.toml           # Project configuration
├── Dockerfile               # Docker configuration
├── docker-compose.yml       # Docker Compose
└── Makefile                 # Build automation
```

## Adding New Entities

Use the TelemetryFlow RESTful API generator to add new entities:

```bash
telemetryflow-restapi entity -n User -f 'name:string,email:string,password:string'
```

This generates:
- Domain entity with SQLAlchemy model
- Repository interface and implementation
- CQRS commands, queries, and handlers
- HTTP handlers with CRUD endpoints
- Database migration

## License

MIT License
