"""${project_name} - Main Application Entry Point.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

import os

from dotenv import load_dotenv

# Load environment variables
load_dotenv()

from ${module_name}.infrastructure.http.server import create_app
from ${module_name}.infrastructure.config import get_config


def main() -> None:
    """Main entry point."""
    config = get_config()
    app = create_app(config)

    host = os.getenv("${env_prefix}_HOST", "0.0.0.0")
    port = int(os.getenv("${env_prefix}_PORT", "${server_port}"))
    debug = os.getenv("${env_prefix}_DEBUG", "false").lower() == "true"

    print(f"Starting ${project_name} on {host}:{port}")
    app.run(host=host, port=port, debug=debug)


if __name__ == "__main__":
    main()
