ANALYZER_DASHBOARD = "/analyzer"
ANALYZER_PREFIX = ANALYZER_DASHBOARD
CHEMISTRY_PREFIX = "/chemistry"
EXECUTE_PREFIX = "/execute"
COMBINATORIAL_OPTIMIZATION_PREFIX = "/combinatorial_optimization"
QSVM_PREFIX = "/qsvm"
ANALYZER_CIRCUIT_PAGE = "circuit"
DEFAULT_ANALYZER_FE_APP = "https://analyzer.classiquantum.com"
ANALYZER_FULL_FE_APP = DEFAULT_ANALYZER_FE_APP + ANALYZER_CIRCUIT_PAGE
ANALYZER_FE_LOCAL_APP = "http://localhost:4200"

ANALYZER_QC_GRAPH = "/graphs/qubits_connectivity"
ANALYZER_QC_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_QC_GRAPH

ANALYZER_HC_GRAPH = "/graphs/hardware_connectivity"
ANALYZER_HC_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_HC_GRAPH

ANALYZER_HEATMAP_GRAPH = "/graphs/heatmap"
ANALYZER_HEATMAP_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_HEATMAP_GRAPH

ANALYZER_GATE_HISTO_GRAPH = "/graphs/gate_histo"
ANALYZER_GATE_HISTO_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_GATE_HISTO_GRAPH

ANALYZER_HC_TABLE_GRAPH = "/graphs/hardware_comparison_table"
ANALYZER_HC_TABLE_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_HC_TABLE_GRAPH

ANALYZER_OPTIONAL_DEVICES = "/graphs/available_devices"
ANALYZER_OPTIONAL_DEVICES_FULL_PATH = ANALYZER_PREFIX + ANALYZER_OPTIONAL_DEVICES

TASKS_SUFFIX = "/tasks"
QUANTUM_PROGRAM_SUFFIX = "/quantum_program"
GROVER_SUFFIX = "/grover"
FINANCE_SUFFIX = "/finance"
VQE_SUFFIX = "/vqe"
RB = "/rb"
ANALYZER_DATA_TASK = f"{TASKS_SUFFIX}/data"
ANALYZER_DATA_TASK_UPLOAD_FILE = f"{TASKS_SUFFIX}/data/file_upload"
ANALYZER_DATA_FULL_PATH = f"{ANALYZER_PREFIX}{ANALYZER_DATA_TASK}"
ASYNC_TASKS_SUFFIX = "/async_tasks"
TASKS_GENERATE_SUFFIX = TASKS_SUFFIX + "/generate"
TASKS_GAS_SUFFIX = "/tasks/gas"
TASKS_SOLVE_SUFFIX = "/tasks/solve"
TASKS_SOLVE_GAS_ASYNC_SUFFIX = "/tasks/solve_gas_async"
TASKS_SOLVE_VQE_ASYNC_SUFFIX = "/tasks/solve_vqe_async"

TASKS_SOLVE_CLASSICALLY_SUFFIX = "/tasks/solve_classically"
TASKS_MODEL_SUFFIX = "/tasks/model"
TASKS_OPERATOR_SUFFIX = "/tasks/operator"
TASKS_OBJECTIVE_SUFFIX = "/tasks/objective"
TASKS_INITIAL_POINT_SUFFIX = "/tasks/initial_point"
TASK_TRAIN_SUFFIX = TASKS_SUFFIX + "/train"
TASK_TEST_SUFFIX = TASKS_SUFFIX + "/test"
TASK_PREDICT_SUFFIX = TASKS_SUFFIX + "/predict"
TASK_RB_SUFFIX = TASKS_SUFFIX + RB
TASKS_GENERATE_FULL_PATH = TASKS_GENERATE_SUFFIX
TASKS_SOLVE_EXACT_SUFFIX = "/tasks/solve_exact"
TASKS_UCC_OPERATORS_SUFFIX = "/tasks/ucc_operators"

EXECUTE_QUANTUM_PROGRAM_FULL_PATH = EXECUTE_PREFIX + QUANTUM_PROGRAM_SUFFIX
EXECUTE_GROVER_FULL_PATH = EXECUTE_PREFIX + GROVER_SUFFIX
EXECUTE_FINANCE_FULL_PATH = EXECUTE_PREFIX + FINANCE_SUFFIX
EXECUTE_VQE_FULL_PATH = EXECUTE_PREFIX + VQE_SUFFIX
EXECUTE_ASYNC_TASKS_FULL_PATH = EXECUTE_PREFIX + ASYNC_TASKS_SUFFIX

ANALYZER_FULL_PATH = ANALYZER_PREFIX + TASKS_SUFFIX
ANALYZER_RB_FULL_PATH = ANALYZER_PREFIX + TASK_RB_SUFFIX

COMBINATORIAL_OPTIMIZATION_GAS_CIRCUIT_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_GAS_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_SOLVE_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_SOLVE_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_SOLVE_GAS_ASYNC_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_SOLVE_GAS_ASYNC_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_SOLVE_VQE_ASYNC_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_SOLVE_VQE_ASYNC_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_SOLVE_CLASSICALLY_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_SOLVE_CLASSICALLY_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_MODEL_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_MODEL_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_OPERATOR_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_OPERATOR_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_OBJECTIVE_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_OBJECTIVE_SUFFIX
)
COMBINATORIAL_OPTIMIZATION_INITIAL_POINT_FULL_PATH = (
    COMBINATORIAL_OPTIMIZATION_PREFIX + TASKS_INITIAL_POINT_SUFFIX
)

CHEMISTRY_GENERATE_HAMILTONIAN_FULL_PATH = CHEMISTRY_PREFIX + TASKS_SUFFIX
CHEMISTRY_GENERATE_UCC_OPERATORS_FULL_PATH = (
    CHEMISTRY_PREFIX + TASKS_UCC_OPERATORS_SUFFIX
)
CHEMISTRY_SOLVE_EXACT_FULL_PATH = CHEMISTRY_PREFIX + TASKS_SOLVE_EXACT_SUFFIX
CHEMISTRY_SOLVE_FULL_PATH = CHEMISTRY_PREFIX + TASKS_SOLVE_SUFFIX

QSVM_TRAIN = QSVM_PREFIX + TASK_TRAIN_SUFFIX
QSVM_TEST = QSVM_PREFIX + TASK_TEST_SUFFIX
QSVM_PREDICT = QSVM_PREFIX + TASK_PREDICT_SUFFIX
