
#THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT CHANGE MANUALLY

import grequests
from aipha_geo_solutions.webservice_api import AiphaClient, command_request, finished_services_request, check_services_completed, execute
import time
import json
import asyncio

def list_running_services(client):

  return running_services_request(
        client.get_username(),
        client.get_token(),
        client.get_server_address(),
        client.get_verify_ssl())



def wait_for_completion(client, req_list):
  services = execute(req_list)
  results = []
  for service_id in range(len(services)):
    service = services[service_id]
    try:
      result = json.loads(service.text)
      if 'error' in result:
         raise RuntimeError('AIPHAProcessingError: ' + str(result['error']))
      results.append(result)
    except Exception as e:
      for idx in range(3): #10 times retry
        time.sleep(120)
        retried_service = execute([req_list[service_id]])
        try:
          result = json.loads(retried_service[0].text)
          results.append(result)
          break
        except Exception as ex1:
          if idx == 3:
            print(retried_service)
            result = json.loads(retried_service[0].text)
            results.append(result)
      raise RuntimeError(str(e))
  
  def await_completion(client, services):
    pid_services = []  
    for service in services:
      if isinstance(service, dict) and 'pid' in service:
        pid_services.append(service['pid'])
      else:
        pid_services.append(service)
    completed = False
    while not completed:
      time.sleep(1.0)
      try:
        tasks_completed =  finished_services_request(
          client.get_username(),
          client.get_token(),
          json.dumps(pid_services),
          client.get_server_address(),
          client.get_verify_ssl())
      except Exception as e:
        tasks_completed = [False for _ in pid_services]
      all_complited = True
      
      for task_id in tasks_completed:
        if not tasks_completed[task_id]:
          all_complited = False
      pid_services = [pid_service for pid_service in pid_services if pid_service not in tasks_completed or not tasks_completed[pid_service]]
      completed = all_complited
  await_completion(client, results)
  return results

def las2las(client,
     i='file.las',
     o='file.las',
     instance_type='nano'):
      '''
    | 
    | las2las( client,
    |      i='file.las',
    |      o='file.las',
    |      instance_type='nano' )

:param i: 
:param o: 
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "las2las",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


def las2las_folder(client,
     folder_i='/folder_i',
     folder_o='/folder_o',
     worker_instance_type='nano',
     manager_instance_type="small",
     extension_i=".las",
     extension_o=".las",
     skip_existing_files = False):
      '''
    | 
    | las2las_folder(client,
    |      i='/i',
    |      o='/o',
    |      worker_instance_type='nano',
    |      manager_instance_type="small",
    |      extension_i=".las",
    |      extension_o=".las",
    |      skip_existing_files = False )

:param folder_i: 
:param folder_o: 
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_i: File extension of files in folder for folder_i
:param extension_o: File extension of files in folder for folder_o
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_i']
      del all_parameters['folder_o']
      del all_parameters['extension_i']
      del all_parameters['extension_o']

      cmd_str = json.dumps(all_parameters)
      parameters = "i,o"
      folders = folder_i + "," + folder_o
      extensions = extension_i + "," + extension_o
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "las2las" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


def sleep_infinity(client,
     instance_type='P2'):
      '''
    | 
    | sleep_infinity( client,
    |      instance_type='P2' )

:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "sleep infinity",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


def sleep_infinity_folder(client,
     worker_instance_type='P2',
     manager_instance_type="small",
     skip_existing_files = False):
      '''
    | 
    | sleep_infinity_folder(client,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      skip_existing_files = False )

:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']


      cmd_str = json.dumps(all_parameters)
      parameters = ""
      folders = ""
      extensions = ""
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "sleep infinity" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class sys:
   def create_directory_in_cloud(client,
     destination='data',
     instance_type='x2large'):
      '''
    | 
    | create_directory_in_cloud( client,
    |      destination='data',
    |      instance_type='x2large' )

:param destination: Destionation location on host. default folder: ./data
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "create directory in cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def create_directory_in_cloud_folder(client,
     folder_destination='/folder_destination',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_destination=".laz",
     skip_existing_files = False):
      '''
    | 
    | create_directory_in_cloud_folder(client,
    |      destination='/destination',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_destination=".data",
    |      skip_existing_files = False )

:param folder_destination: Destionation location on host. default folder: ./data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_destination']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "destination"
      folders = folder_destination
      extensions = extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "create directory in cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def upload_data_from_cloud(client,
     url='',
     target='data',
     protocol='',
     username='',
     password='',
     port=21,
     instance_type='x2large'):
      '''
    | 
    | upload_data_from_cloud( client,
    |      url='',
    |      target='data',
    |      protocol='',
    |      username='',
    |      password='',
    |      port=21,
    |      instance_type='x2large' )

:param url: destination URL
:param target: Target location on host for upload. default folder: ./data
:param protocol: protocol: : automatically try to infer protocol, ftp: ftp, sftp: sftp
:param username: Username
:param password: Password
:param port: port
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "upload data from cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def upload_data_from_cloud_folder(client,
     url='',
     folder_target='/folder_target',
     protocol='',
     username='',
     password='',
     port=21,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     skip_existing_files = False):
      '''
    | 
    | upload_data_from_cloud_folder(client,
    |      url='',
    |      target='/target',
    |      protocol='',
    |      username='',
    |      password='',
    |      port=21,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".data",
    |      skip_existing_files = False )

:param url: destination URL
:param protocol: protocol: : automatically try to infer protocol, ftp: ftp, sftp: sftp
:param username: Username
:param password: Password
:param port: port
:param folder_target: Target location on host for upload. default folder: ./data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['extension_target']

      cmd_str = json.dumps(all_parameters)
      parameters = "target"
      folders = folder_target
      extensions = extension_target
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "upload data from cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_corresponding_path(client,
     original_file='path.txt',
     original_identifier_file='idx.txt',
     corresponding_file='cor.txt',
     output_file='res.txt',
     selection_criteria='oldest',
     default_value='__original__',
     instance_type='x2large'):
      '''
    | 
    | select_corresponding_path( client,
    |      original_file='path.txt',
    |      original_identifier_file='idx.txt',
    |      corresponding_file='cor.txt',
    |      output_file='res.txt',
    |      selection_criteria='oldest',
    |      default_value='__original__',
    |      instance_type='x2large' )

:param original_file: original paths
:param original_identifier_file: original identifiers
:param corresponding_file: corresponding paths
:param output_file: output file
:param selection_criteria: selection criteria: [oldest, newest, shortest, longest]
:param default_value: default value if no corresponding path is found
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "select corresponding path",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_corresponding_path_folder(client,
     original_folder='/original_folder',
     original_identifier_folder='/original_identifier_folder',
     corresponding_folder='/corresponding_folder',
     output_folder='/output_folder',
     selection_criteria='oldest',
     default_value='__original__',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_original_file=".txt",
     extension_original_identifier_file=".txt",
     extension_corresponding_file=".txt",
     extension_output_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | select_corresponding_path_folder(client,
    |      original_folder='/original_folder',
    |      original_identifier_folder='/original_identifier_folder',
    |      corresponding_folder='/corresponding_folder',
    |      output_folder='/output_folder',
    |      selection_criteria='oldest',
    |      default_value='__original__',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_original_folder=".txt",
    |      extension_original_identifier_folder=".txt",
    |      extension_corresponding_folder=".txt",
    |      extension_output_folder=".txt",
    |      skip_existing_files = False )

:param selection_criteria: selection criteria: [oldest, newest, shortest, longest]
:param default_value: default value if no corresponding path is found
:param original_folder: original folders
:param original_identifier_folder: original identifiers
:param corresponding_folder: corresponding folders
:param output_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_original_folder: File extension of files in folder for original_folder
:param extension_original_identifier_folder: File extension of files in folder for original_identifier_folder
:param extension_corresponding_folder: File extension of files in folder for corresponding_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['original_folder']
      del all_parameters['original_identifier_folder']
      del all_parameters['corresponding_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_original_file']
      del all_parameters['extension_original_identifier_file']
      del all_parameters['extension_corresponding_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "original_file,original_identifier_file,corresponding_file,output_file"
      folders = original_folder + "," + original_identifier_folder + "," + corresponding_folder + "," + output_folder
      extensions = extension_original_file + "," + extension_original_identifier_file + "," + extension_corresponding_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "select corresponding path" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def remove_files_from_cloud(client,
     target='',
     instance_type='x2large'):
      '''
    | 
    | remove_files_from_cloud( client,
    |      target='',
    |      instance_type='x2large' )

:param target: Target to be deleted
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "remove files from cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def remove_files_from_cloud_folder(client,
     folder_target='/folder_target',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     skip_existing_files = False):
      '''
    | 
    | remove_files_from_cloud_folder(client,
    |      target='/target',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".",
    |      skip_existing_files = False )

:param folder_target: Target to be deleted
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['extension_target']

      cmd_str = json.dumps(all_parameters)
      parameters = "target"
      folders = folder_target
      extensions = extension_target
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "remove files from cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def split_path(client,
     in_path='',
     out_path='',
     split_type='filename',
     instance_type='x2large'):
      '''
    | 
    | split_path( client,
    |      in_path='',
    |      out_path='',
    |      split_type='filename',
    |      instance_type='x2large' )

:param in_path: input path
:param out_path: output path
:param split_type: split type: [filename, dirname, basename, ext]
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "split path",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def split_path_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     split_type='filename',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_path=".laz",
     extension_out_path=".laz",
     skip_existing_files = False):
      '''
    | 
    | split_path_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      split_type='filename',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".",
    |      extension_out_folder=".",
    |      skip_existing_files = False )

:param split_type: split type: [filename, dirname, basename, ext]
:param in_folder: input folder
:param out_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_path']
      del all_parameters['extension_out_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_path,out_path"
      folders = in_folder + "," + out_folder
      extensions = extension_in_path + "," + extension_out_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "split path" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def find_file_paths(client,
     input_files='files.txt',
     output_files='paths.txt',
     search_folder='/search_folder',
     replace_in='',
     replace_out='',
     substrings='',
     instance_type='x2large'):
      '''
    | 
    | find_file_paths( client,
    |      input_files='files.txt',
    |      output_files='paths.txt',
    |      search_folder='/search_folder',
    |      replace_in='',
    |      replace_out='',
    |      substrings='',
    |      instance_type='x2large' )

:param input_files: File containing the list of filenames
:param output_files: Path to save the modified filelist
:param search_folder:  Folder to traverse for finding files
:param replace_in: The part to replace in the filenames
:param replace_out: The new part to replace with
:param substrings:  a list of substrings that need to occure in the file paths to be vallid
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "find file paths",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def find_file_paths_folder(client,
     input_folders='/input_folders',
     output_folders='/output_folders',
     search_folder='/search_folder',
     replace_in='',
     replace_out='',
     substrings='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_files=".txt",
     extension_output_files=".txt",
     skip_existing_files = False):
      '''
    | 
    | find_file_paths_folder(client,
    |      input_folders='/input_folders',
    |      output_folders='/output_folders',
    |      search_folder='/search_folder',
    |      replace_in='',
    |      replace_out='',
    |      substrings='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folders=".txt",
    |      extension_output_folders=".txt",
    |      skip_existing_files = False )

:param search_folder:  Folder to traverse for finding files
:param replace_in: The part to replace in the filenames
:param replace_out: The new part to replace with
:param substrings:  a list of substrings that need to occure in the file paths to be vallid
:param input_folders: File containing the list of foldernames
:param output_folders: Path to save the modified folderlist
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folders: File extension of files in folder for input_folders
:param extension_output_folders: File extension of files in folder for output_folders
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folders']
      del all_parameters['output_folders']
      del all_parameters['extension_input_files']
      del all_parameters['extension_output_files']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_files,output_files"
      folders = input_folders + "," + output_folders
      extensions = extension_input_files + "," + extension_output_files
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "find file paths" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def move_file_in_cloud(client,
     target='',
     destination='',
     instance_type='x2large'):
      '''
    | 
    | move_file_in_cloud( client,
    |      target='',
    |      destination='',
    |      instance_type='x2large' )

:param target: Target to be moved
:param destination: Destination
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "move file in cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def move_file_in_cloud_folder(client,
     folder_target='/folder_target',
     folder_destination='/folder_destination',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     extension_destination=".laz",
     skip_existing_files = False):
      '''
    | 
    | move_file_in_cloud_folder(client,
    |      target='/target',
    |      destination='/destination',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".",
    |      extension_destination=".",
    |      skip_existing_files = False )

:param folder_target: Target to be moved
:param folder_destination: Destination
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['folder_destination']
      del all_parameters['extension_target']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "target,destination"
      folders = folder_target + "," + folder_destination
      extensions = extension_target + "," + extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "move file in cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def copy_file_in_cloud(client,
     target='',
     destination='',
     instance_type='x2large'):
      '''
    | 
    | copy_file_in_cloud( client,
    |      target='',
    |      destination='',
    |      instance_type='x2large' )

:param target: Target to be moved
:param destination: Destination
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "copy file in cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def copy_file_in_cloud_folder(client,
     folder_target='/folder_target',
     folder_destination='/folder_destination',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     extension_destination=".laz",
     skip_existing_files = False):
      '''
    | 
    | copy_file_in_cloud_folder(client,
    |      target='/target',
    |      destination='/destination',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".",
    |      extension_destination=".",
    |      skip_existing_files = False )

:param folder_target: Target to be moved
:param folder_destination: Destination
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['folder_destination']
      del all_parameters['extension_target']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "target,destination"
      folders = folder_target + "," + folder_destination
      extensions = extension_target + "," + extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "copy file in cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def touch_file_in_cloud(client,
     target='file.txt',
     instance_type='x2large'):
      '''
    | 
    | touch_file_in_cloud( client,
    |      target='file.txt',
    |      instance_type='x2large' )

:param target: File to be touched
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "touch file in cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def touch_file_in_cloud_folder(client,
     folder_target='/folder_target',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".txt",
     skip_existing_files = False):
      '''
    | 
    | touch_file_in_cloud_folder(client,
    |      target='/target',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".txt",
    |      skip_existing_files = False )

:param folder_target: File to be touched
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['extension_target']

      cmd_str = json.dumps(all_parameters)
      parameters = "target"
      folders = folder_target
      extensions = extension_target
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "touch file in cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_by_identifier(client,
     original_folder='original_folder',
     original_identifier_file='idx.txt',
     output_folder='output_folder',
     instance_type='x2large'):
      '''
    | 
    | select_by_identifier( client,
    |      original_folder='original_folder',
    |      original_identifier_file='idx.txt',
    |      output_folder='output_folder',
    |      instance_type='x2large' )

:param original_folder: original folder
:param original_identifier_file: original identifiers
:param output_folder: output folder
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "select by identifier",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_by_identifier_folder(client,
     folder_original_folder='/folder_original_folder',
     original_identifier_folder='/original_identifier_folder',
     folder_output_folder='/folder_output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_original_folder=".laz",
     extension_original_identifier_file=".txt",
     extension_output_folder=".laz",
     skip_existing_files = False):
      '''
    | 
    | select_by_identifier_folder(client,
    |      original_folder='/original_folder',
    |      original_identifier_folder='/original_identifier_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_original_folder=".original_folder",
    |      extension_original_identifier_folder=".txt",
    |      extension_output_folder=".output_folder",
    |      skip_existing_files = False )

:param folder_original_folder: original folder
:param original_identifier_folder: original identifiers
:param folder_output_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_original_folder: File extension of files in folder for folder_original_folder
:param extension_original_identifier_folder: File extension of files in folder for original_identifier_folder
:param extension_output_folder: File extension of files in folder for folder_output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_original_folder']
      del all_parameters['original_identifier_folder']
      del all_parameters['folder_output_folder']
      del all_parameters['extension_original_folder']
      del all_parameters['extension_original_identifier_file']
      del all_parameters['extension_output_folder']

      cmd_str = json.dumps(all_parameters)
      parameters = "original_folder,original_identifier_file,output_folder"
      folders = folder_original_folder + "," + original_identifier_folder + "," + folder_output_folder
      extensions = extension_original_folder + "," + extension_original_identifier_file + "," + extension_output_folder
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "select by identifier" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def recursive_list(client,
     target='target/',
     destination='output.txt',
     instance_type='x2large'):
      '''
    | 
    | recursive_list( client,
    |      target='target/',
    |      destination='output.txt',
    |      instance_type='x2large' )

:param target: Target folder to be listed recursively
:param destination: Output file
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "recursive list",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def recursive_list_folder(client,
     folder_target='/folder_target',
     folder_destination='/folder_destination',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     extension_destination=".txt",
     skip_existing_files = False):
      '''
    | 
    | recursive_list_folder(client,
    |      target='/target',
    |      destination='/destination',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".target/",
    |      extension_destination=".txt",
    |      skip_existing_files = False )

:param folder_target: Target folder to be listed recursively
:param folder_destination: Output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['folder_destination']
      del all_parameters['extension_target']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "target,destination"
      folders = folder_target + "," + folder_destination
      extensions = extension_target + "," + extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "recursive list" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def rename_file_in_cloud(client,
     target='',
     prefix='',
     suffix='',
     replace_from='',
     replace_to='',
     replace_count=0,
     instance_type='x2large'):
      '''
    | 
    | rename_file_in_cloud( client,
    |      target='',
    |      prefix='',
    |      suffix='',
    |      replace_from='',
    |      replace_to='',
    |      replace_count=0,
    |      instance_type='x2large' )

:param target: Target to be renamed
:param prefix: add prefix
:param suffix: add suffix
:param replace_from: replace string in filename
:param replace_to: replace string in filename
:param replace_count: replace string in filename
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "rename file in cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def rename_file_in_cloud_folder(client,
     folder_target='/folder_target',
     prefix='',
     suffix='',
     replace_from='',
     replace_to='',
     replace_count=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     skip_existing_files = False):
      '''
    | 
    | rename_file_in_cloud_folder(client,
    |      target='/target',
    |      prefix='',
    |      suffix='',
    |      replace_from='',
    |      replace_to='',
    |      replace_count=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".",
    |      skip_existing_files = False )

:param prefix: add prefix
:param suffix: add suffix
:param replace_from: replace string in filename
:param replace_to: replace string in filename
:param replace_count: replace string in filename
:param folder_target: Target to be renamed
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['extension_target']

      cmd_str = json.dumps(all_parameters)
      parameters = "target"
      folders = folder_target
      extensions = extension_target
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "rename file in cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def list_files_in_cloud(client,
     target='folder/',
     file_out='files.txt',
     instance_type='x2large'):
      '''
    | 
    | list_files_in_cloud( client,
    |      target='folder/',
    |      file_out='files.txt',
    |      instance_type='x2large' )

:param target: Target to be listet
:param file_out: output_file
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "list files in cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def list_files_in_cloud_folder(client,
     folder_target='/folder_target',
     folder_out='/folder_out',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     extension_file_out=".txt",
     skip_existing_files = False):
      '''
    | 
    | list_files_in_cloud_folder(client,
    |      target='/target',
    |      folder_out='/folder_out',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".folder/",
    |      extension_folder_out=".txt",
    |      skip_existing_files = False )

:param folder_target: Target to be listet
:param folder_out: output_folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['folder_out']
      del all_parameters['extension_target']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "target,file_out"
      folders = folder_target + "," + folder_out
      extensions = extension_target + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "list files in cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def download_data_to_cloud(client,
     url='',
     destination='data',
     protocol='',
     download_type=0,
     username='',
     password='',
     port=21,
     instance_type='x2large'):
      '''
    | 
    | download_data_to_cloud( client,
    |      url='',
    |      destination='data',
    |      protocol='',
    |      download_type=0,
    |      username='',
    |      password='',
    |      port=21,
    |      instance_type='x2large' )

:param url: URL to data
:param destination: Destionation location on host. default folder: ./data
:param protocol: protocol: : automatically try to infer protocol, ftp: ftp, sftp: sftp
:param download_type: download type: 0: all files from folder, 1: individual file
:param username: Username
:param password: Password
:param port: port
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "download data to cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def download_data_to_cloud_folder(client,
     url='',
     folder_destination='/folder_destination',
     protocol='',
     download_type=0,
     username='',
     password='',
     port=21,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_destination=".laz",
     skip_existing_files = False):
      '''
    | 
    | download_data_to_cloud_folder(client,
    |      url='',
    |      destination='/destination',
    |      protocol='',
    |      download_type=0,
    |      username='',
    |      password='',
    |      port=21,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_destination=".data",
    |      skip_existing_files = False )

:param url: URL to data
:param protocol: protocol: : automatically try to infer protocol, ftp: ftp, sftp: sftp
:param download_type: download type: 0: all files from folder, 1: individual file
:param username: Username
:param password: Password
:param port: port
:param folder_destination: Destionation location on host. default folder: ./data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_destination']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "destination"
      folders = folder_destination
      extensions = extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "download data to cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def download_from_s3_to_aipha(client,
     access_key_id='YOUR_KEY_ID',
     secret_access_key='YOUR_SECRET_KEY',
     aws_region='eu-central-1',
     target='file.laz',
     destination='file.laz',
     bucket_name='Your S3 bucket',
     instance_type='x2large'):
      '''Upload a file to an S3 bucket
    | 
    | download_from_s3_to_aipha( client,
    |      access_key_id='YOUR_KEY_ID',
    |      secret_access_key='YOUR_SECRET_KEY',
    |      aws_region='eu-central-1',
    |      target='file.laz',
    |      destination='file.laz',
    |      bucket_name='Your S3 bucket',
    |      instance_type='x2large' )

:param access_key_id: AWS access key ID
:param secret_access_key: AWS secret access key
:param aws_region: AWS region
:param target: File to download from s3
:param destination: Location to upload to aipha
:param bucket_name: S3 bucket name
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "download from s3 to aipha",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def download_from_s3_to_aipha_folder(client,
     access_key_id='YOUR_KEY_ID',
     secret_access_key='YOUR_SECRET_KEY',
     aws_region='eu-central-1',
     folder_target='/folder_target',
     folder_destination='/folder_destination',
     bucket_name='Your S3 bucket',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     extension_destination=".laz",
     skip_existing_files = False):
      '''Upload a file to an S3 bucket
    | 
    | download_from_s3_to_aipha_folder(client,
    |      access_key_id='YOUR_KEY_ID',
    |      secret_access_key='YOUR_SECRET_KEY',
    |      aws_region='eu-central-1',
    |      target='/target',
    |      destination='/destination',
    |      bucket_name='Your S3 bucket',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".laz",
    |      extension_destination=".laz",
    |      skip_existing_files = False )

:param access_key_id: AWS access key ID
:param secret_access_key: AWS secret access key
:param aws_region: AWS region
:param bucket_name: S3 bucket name
:param folder_target: File to download from s3
:param folder_destination: Location to upload to aipha
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['folder_destination']
      del all_parameters['extension_target']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "target,destination"
      folders = folder_target + "," + folder_destination
      extensions = extension_target + "," + extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "download from s3 to aipha" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def upload_from_aipha_to_s3(client,
     access_key_id='YOUR_KEY_ID',
     secret_access_key='YOUR_SECRET_KEY',
     aws_region='eu-central-1',
     target='file.laz',
     destination='file.laz',
     bucket_name='Your S3 bucket',
     instance_type='x2large'):
      '''Upload a file to an S3 bucket
    | 
    | upload_from_aipha_to_s3( client,
    |      access_key_id='YOUR_KEY_ID',
    |      secret_access_key='YOUR_SECRET_KEY',
    |      aws_region='eu-central-1',
    |      target='file.laz',
    |      destination='file.laz',
    |      bucket_name='Your S3 bucket',
    |      instance_type='x2large' )

:param access_key_id: AWS access key ID
:param secret_access_key: AWS secret access key
:param aws_region: AWS region
:param target: File to upload from aipha
:param destination: Location of file to upload on s3
:param bucket_name: S3 bucket name
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "upload from aipha to s3",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def upload_from_aipha_to_s3_folder(client,
     access_key_id='YOUR_KEY_ID',
     secret_access_key='YOUR_SECRET_KEY',
     aws_region='eu-central-1',
     folder_target='/folder_target',
     folder_destination='/folder_destination',
     bucket_name='Your S3 bucket',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_target=".laz",
     extension_destination=".laz",
     skip_existing_files = False):
      '''Upload a file to an S3 bucket
    | 
    | upload_from_aipha_to_s3_folder(client,
    |      access_key_id='YOUR_KEY_ID',
    |      secret_access_key='YOUR_SECRET_KEY',
    |      aws_region='eu-central-1',
    |      target='/target',
    |      destination='/destination',
    |      bucket_name='Your S3 bucket',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_target=".laz",
    |      extension_destination=".laz",
    |      skip_existing_files = False )

:param access_key_id: AWS access key ID
:param secret_access_key: AWS secret access key
:param aws_region: AWS region
:param bucket_name: S3 bucket name
:param folder_target: File to upload from aipha
:param folder_destination: Location of folder to upload on s3
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_target: File extension of files in folder for folder_target
:param extension_destination: File extension of files in folder for folder_destination
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_target']
      del all_parameters['folder_destination']
      del all_parameters['extension_target']
      del all_parameters['extension_destination']

      cmd_str = json.dumps(all_parameters)
      parameters = "target,destination"
      folders = folder_target + "," + folder_destination
      extensions = extension_target + "," + extension_destination
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "upload from aipha to s3" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class ml3d:
   def semantic_training_scf(client,
     data_in_path='/data/files/',
     out_model_parameters_path='trained_model/model_1',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='x,y,z',
     label_name='classification',
     max_epochs=500,
     learning_rate=1e-2,
     learning_rate_decay=0.95,
     feature_dimensions='16,64,128,256,512',
     batch_size=2,
     instance_type='x2large'):
      '''
    | 
    | semantic_training_scf( client,
    |      data_in_path='/data/files/',
    |      out_model_parameters_path='trained_model/model_1',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      label_name='classification',
    |      max_epochs=500,
    |      learning_rate=1e-2,
    |      learning_rate_decay=0.95,
    |      feature_dimensions='16,64,128,256,512',
    |      batch_size=2,
    |      instance_type='x2large' )

:param data_in_path:  path to folder that contains the training data
:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param learning_rate_decay: learning rate decay
:param feature_dimensions: feature dimensions
:param batch_size: batch_size
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic training scf",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_scf_folder(client,
     data_in_folder='/data_in_folder',
     out_model_parameters_path='trained_model/model_1',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='x,y,z',
     label_name='classification',
     max_epochs=500,
     learning_rate=1e-2,
     learning_rate_decay=0.95,
     feature_dimensions='16,64,128,256,512',
     batch_size=2,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     skip_existing_files = False):
      '''
    | 
    | semantic_training_scf_folder(client,
    |      data_in_folder='/data_in_folder',
    |      out_model_parameters_path='trained_model/model_1',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      label_name='classification',
    |      max_epochs=500,
    |      learning_rate=1e-2,
    |      learning_rate_decay=0.95,
    |      feature_dimensions='16,64,128,256,512',
    |      batch_size=2,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_data_in_folder="./data/files/",
    |      skip_existing_files = False )

:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param learning_rate_decay: learning rate decay
:param feature_dimensions: feature dimensions
:param batch_size: batch_size
:param data_in_folder:  folder to folder that contains the training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['extension_data_in_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path"
      folders = data_in_folder
      extensions = extension_data_in_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic training scf" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_scf(client,
     data_in_path='file.laz',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='x,y,z',
     label_name='classification',
     feature_dimensions='12,48,96,192,384',
     batch_size=2,
     results_labels_path='result.labels',
     in_model_parameters_path='results/Log_2022-11-10_11-42-05',
     results_probabilities_path='result_probs.npy',
     number_of_votes=5,
     instance_type='x2large'):
      '''
    | 
    | semantic_inference_scf( client,
    |      data_in_path='file.laz',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      label_name='classification',
    |      feature_dimensions='12,48,96,192,384',
    |      batch_size=2,
    |      results_labels_path='result.labels',
    |      in_model_parameters_path='results/Log_2022-11-10_11-42-05',
    |      results_probabilities_path='result_probs.npy',
    |      number_of_votes=5,
    |      instance_type='x2large' )

:param data_in_path:  path to file that contains the training data
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param feature_dimensions: feature dimensions
:param batch_size: batch_size
:param results_labels_path:  path to labels
:param in_model_parameters_path:  path to model
:param results_probabilities_path:  path to probabilities
:param number_of_votes: number of votes to vote for a class
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic inference scf",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_scf_folder(client,
     data_in_folder='/data_in_folder',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='x,y,z',
     label_name='classification',
     feature_dimensions='12,48,96,192,384',
     batch_size=2,
     results_labels_folder='/results_labels_folder',
     in_model_parameters_path='results/Log_2022-11-10_11-42-05',
     results_probabilities_folder='/results_probabilities_folder',
     number_of_votes=5,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     extension_results_labels_path=".labels",
     extension_results_probabilities_path=".npy",
     skip_existing_files = False):
      '''
    | 
    | semantic_inference_scf_folder(client,
    |      data_in_folder='/data_in_folder',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      label_name='classification',
    |      feature_dimensions='12,48,96,192,384',
    |      batch_size=2,
    |      results_labels_folder='/results_labels_folder',
    |      in_model_parameters_path='results/Log_2022-11-10_11-42-05',
    |      results_probabilities_folder='/results_probabilities_folder',
    |      number_of_votes=5,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_data_in_folder=".laz",
    |      extension_results_labels_folder=".labels",
    |      extension_results_probabilities_folder=".npy",
    |      skip_existing_files = False )

:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param feature_dimensions: feature dimensions
:param batch_size: batch_size
:param in_model_parameters_path:  path to model
:param number_of_votes: number of votes to vote for a class
:param data_in_folder:  folder to folder that contains the training data
:param results_labels_folder:  folder to labels
:param results_probabilities_folder:  folder to probabilities
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param extension_results_labels_folder: File extension of files in folder for results_labels_folder
:param extension_results_probabilities_folder: File extension of files in folder for results_probabilities_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['results_labels_folder']
      del all_parameters['results_probabilities_folder']
      del all_parameters['extension_data_in_path']
      del all_parameters['extension_results_labels_path']
      del all_parameters['extension_results_probabilities_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path,results_labels_path,results_probabilities_path"
      folders = data_in_folder + "," + results_labels_folder + "," + results_probabilities_folder
      extensions = extension_data_in_path + "," + extension_results_labels_path + "," + extension_results_probabilities_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic inference scf" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def knn_classification(client,
     in_path_to_points='new.laz',
     in_path_from_points='old.laz',
     out_path_labels='out.labels',
     out_path_probs='out.npy',
     k=3,
     max_distance=1.0,
     to_points_names='X,Y,Z',
     from_point_names='X,Y,Z',
     from_class_name='classification',
     instance_type='x2large'):
      '''
    | 
    | knn_classification( client,
    |      in_path_to_points='new.laz',
    |      in_path_from_points='old.laz',
    |      out_path_labels='out.labels',
    |      out_path_probs='out.npy',
    |      k=3,
    |      max_distance=1.0,
    |      to_points_names='X,Y,Z',
    |      from_point_names='X,Y,Z',
    |      from_class_name='classification',
    |      instance_type='x2large' )

:param in_path_to_points: input point cloud to be labeled
:param in_path_from_points: input reference point cloud
:param out_path_labels: out class labels
:param out_path_probs: out class probabilities
:param k: number of neighbors
:param max_distance: maximum distance
:param to_points_names: names of points to be labeled
:param from_point_names: names of reference points
:param from_class_name: name of reference classification
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "knn classification",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def knn_classification_folder(client,
     in_folder_to_points='/in_folder_to_points',
     in_folder_from_points='/in_folder_from_points',
     out_folder_labels='/out_folder_labels',
     out_folder_probs='/out_folder_probs',
     k=3,
     max_distance=1.0,
     to_points_names='X,Y,Z',
     from_point_names='X,Y,Z',
     from_class_name='classification',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_path_to_points=".laz",
     extension_in_path_from_points=".laz",
     extension_out_path_labels=".labels",
     extension_out_path_probs=".npy",
     skip_existing_files = False):
      '''
    | 
    | knn_classification_folder(client,
    |      in_folder_to_points='/in_folder_to_points',
    |      in_folder_from_points='/in_folder_from_points',
    |      out_folder_labels='/out_folder_labels',
    |      out_folder_probs='/out_folder_probs',
    |      k=3,
    |      max_distance=1.0,
    |      to_points_names='X,Y,Z',
    |      from_point_names='X,Y,Z',
    |      from_class_name='classification',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder_to_points=".laz",
    |      extension_in_folder_from_points=".laz",
    |      extension_out_folder_labels=".labels",
    |      extension_out_folder_probs=".npy",
    |      skip_existing_files = False )

:param k: number of neighbors
:param max_distance: maximum distance
:param to_points_names: names of points to be labeled
:param from_point_names: names of reference points
:param from_class_name: name of reference classification
:param in_folder_to_points: input point cloud to be labeled
:param in_folder_from_points: input reference point cloud
:param out_folder_labels: out class labels
:param out_folder_probs: out class probabilities
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder_to_points: File extension of files in folder for in_folder_to_points
:param extension_in_folder_from_points: File extension of files in folder for in_folder_from_points
:param extension_out_folder_labels: File extension of files in folder for out_folder_labels
:param extension_out_folder_probs: File extension of files in folder for out_folder_probs
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder_to_points']
      del all_parameters['in_folder_from_points']
      del all_parameters['out_folder_labels']
      del all_parameters['out_folder_probs']
      del all_parameters['extension_in_path_to_points']
      del all_parameters['extension_in_path_from_points']
      del all_parameters['extension_out_path_labels']
      del all_parameters['extension_out_path_probs']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_path_to_points,in_path_from_points,out_path_labels,out_path_probs"
      folders = in_folder_to_points + "," + in_folder_from_points + "," + out_folder_labels + "," + out_folder_probs
      extensions = extension_in_path_to_points + "," + extension_in_path_from_points + "," + extension_out_path_labels + "," + extension_out_path_probs
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "knn classification" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_rfcr(client,
     data_in_path='/data/files/',
     out_model_parameters_path='trained_model/model_1',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='x,y,z',
     label_name='classification',
     resolution=0.06,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     learning_rate_decay=0.1,
     learning_momentum=0.98,
     learning_gradient_clip_norm=100,
     first_features_dim=128,
     instance_type='x2large'):
      '''
    | 
    | semantic_training_rfcr( client,
    |      data_in_path='/data/files/',
    |      out_model_parameters_path='trained_model/model_1',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      label_name='classification',
    |      resolution=0.06,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      learning_rate_decay=0.1,
    |      learning_momentum=0.98,
    |      learning_gradient_clip_norm=100,
    |      first_features_dim=128,
    |      instance_type='x2large' )

:param data_in_path:  path to folder that contains the training data
:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param learning_rate_decay: learning rate decay
:param learning_momentum: learning momentum
:param learning_gradient_clip_norm: learning gradient clip threshold
:param first_features_dim: first features dimension
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic training rfcr",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_rfcr_folder(client,
     data_in_folder='/data_in_folder',
     out_model_parameters_path='trained_model/model_1',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='x,y,z',
     label_name='classification',
     resolution=0.06,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     learning_rate_decay=0.1,
     learning_momentum=0.98,
     learning_gradient_clip_norm=100,
     first_features_dim=128,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     skip_existing_files = False):
      '''
    | 
    | semantic_training_rfcr_folder(client,
    |      data_in_folder='/data_in_folder',
    |      out_model_parameters_path='trained_model/model_1',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      label_name='classification',
    |      resolution=0.06,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      learning_rate_decay=0.1,
    |      learning_momentum=0.98,
    |      learning_gradient_clip_norm=100,
    |      first_features_dim=128,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_data_in_folder="./data/files/",
    |      skip_existing_files = False )

:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param learning_rate_decay: learning rate decay
:param learning_momentum: learning momentum
:param learning_gradient_clip_norm: learning gradient clip threshold
:param first_features_dim: first features dimension
:param data_in_folder:  folder to folder that contains the training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['extension_data_in_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path"
      folders = data_in_folder
      extensions = extension_data_in_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic training rfcr" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_rfcr(client,
     data_in_path='data.laz',
     results_labels_path='result_labels.labels',
     results_probabilities_path='result_probabilities.npy',
     in_model_parameters_path='results/Log_2022-11-10_11-42-05',
     number_of_votes=5,
     feature_names='red,green,blue',
     point_names='x,y,z',
     instance_type='x2large'):
      '''
    | 
    | semantic_inference_rfcr( client,
    |      data_in_path='data.laz',
    |      results_labels_path='result_labels.labels',
    |      results_probabilities_path='result_probabilities.npy',
    |      in_model_parameters_path='results/Log_2022-11-10_11-42-05',
    |      number_of_votes=5,
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      instance_type='x2large' )

:param data_in_path:  path to data
:param results_labels_path:  path to labels
:param results_probabilities_path:  path to probabilities
:param in_model_parameters_path:  path to model
:param number_of_votes: number of votes to vote for a class
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic inference rfcr",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_rfcr_folder(client,
     data_in_folder='/data_in_folder',
     results_labels_folder='/results_labels_folder',
     results_probabilities_folder='/results_probabilities_folder',
     in_model_parameters_path='results/Log_2022-11-10_11-42-05',
     number_of_votes=5,
     feature_names='red,green,blue',
     point_names='x,y,z',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     extension_results_labels_path=".labels",
     extension_results_probabilities_path=".npy",
     skip_existing_files = False):
      '''
    | 
    | semantic_inference_rfcr_folder(client,
    |      data_in_folder='/data_in_folder',
    |      results_labels_folder='/results_labels_folder',
    |      results_probabilities_folder='/results_probabilities_folder',
    |      in_model_parameters_path='results/Log_2022-11-10_11-42-05',
    |      number_of_votes=5,
    |      feature_names='red,green,blue',
    |      point_names='x,y,z',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_data_in_folder=".laz",
    |      extension_results_labels_folder=".labels",
    |      extension_results_probabilities_folder=".npy",
    |      skip_existing_files = False )

:param in_model_parameters_path:  path to model
:param number_of_votes: number of votes to vote for a class
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param data_in_folder:  folder to data
:param results_labels_folder:  folder to labels
:param results_probabilities_folder:  folder to probabilities
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param extension_results_labels_folder: File extension of files in folder for results_labels_folder
:param extension_results_probabilities_folder: File extension of files in folder for results_probabilities_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['results_labels_folder']
      del all_parameters['results_probabilities_folder']
      del all_parameters['extension_data_in_path']
      del all_parameters['extension_results_labels_path']
      del all_parameters['extension_results_probabilities_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path,results_labels_path,results_probabilities_path"
      folders = data_in_folder + "," + results_labels_folder + "," + results_probabilities_folder
      extensions = extension_data_in_path + "," + extension_results_labels_path + "," + extension_results_probabilities_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic inference rfcr" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_pt_v2m2(client,
     data_in_path='in.laz',
     in_model_parameters_path='trained_model/model_ptv2m2',
     out_label_path='out.labels',
     out_probability_path='out.npy',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     number_of_votes=5,
     instance_type='P2'):
      '''PT v2m2 Inference
    | 
    | semantic_inference_pt_v2m2( client,
    |      data_in_path='in.laz',
    |      in_model_parameters_path='trained_model/model_ptv2m2',
    |      out_label_path='out.labels',
    |      out_probability_path='out.npy',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      number_of_votes=5,
    |      instance_type='P2' )

:param data_in_path:  path that contains the test data
:param in_model_parameters_path:  path to model
:param out_label_path:  path that contains the results
:param out_probability_path:  path that contains the results
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param number_of_votes: number of votes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic inference pt v2m2",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_pt_v2m2_folder(client,
     data_in_folder='/data_in_folder',
     in_model_parameters_path='trained_model/model_ptv2m2',
     out_label_folder='/out_label_folder',
     out_probability_folder='/out_probability_folder',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     number_of_votes=5,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     extension_out_label_path=".labels",
     extension_out_probability_path=".npy",
     skip_existing_files = False):
      '''PT v2m2 Inference
    | 
    | semantic_inference_pt_v2m2_folder(client,
    |      data_in_folder='/data_in_folder',
    |      in_model_parameters_path='trained_model/model_ptv2m2',
    |      out_label_folder='/out_label_folder',
    |      out_probability_folder='/out_probability_folder',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      number_of_votes=5,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_data_in_folder=".laz",
    |      extension_out_label_folder=".labels",
    |      extension_out_probability_folder=".npy",
    |      skip_existing_files = False )

:param in_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param number_of_votes: number of votes
:param data_in_folder:  folder that contains the test data
:param out_label_folder:  folder that contains the results
:param out_probability_folder:  folder that contains the results
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param extension_out_label_folder: File extension of files in folder for out_label_folder
:param extension_out_probability_folder: File extension of files in folder for out_probability_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['out_label_folder']
      del all_parameters['out_probability_folder']
      del all_parameters['extension_data_in_path']
      del all_parameters['extension_out_label_path']
      del all_parameters['extension_out_probability_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path,out_label_path,out_probability_path"
      folders = data_in_folder + "," + out_label_folder + "," + out_probability_folder
      extensions = extension_data_in_path + "," + extension_out_label_path + "," + extension_out_probability_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic inference pt v2m2" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_pt_v3m1(client,
     data_in_path='in.laz',
     in_model_parameters_path='trained_model/model_ptv2m2',
     out_label_path='out.labels',
     out_probability_path='out.npy',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     number_of_votes=5,
     instance_type='P2'):
      '''PT v3m1 Inference
    | 
    | semantic_inference_pt_v3m1( client,
    |      data_in_path='in.laz',
    |      in_model_parameters_path='trained_model/model_ptv2m2',
    |      out_label_path='out.labels',
    |      out_probability_path='out.npy',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      number_of_votes=5,
    |      instance_type='P2' )

:param data_in_path:  path that contains the test data
:param in_model_parameters_path:  path to model
:param out_label_path:  path that contains the results
:param out_probability_path:  path that contains the results
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param number_of_votes: number of votes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic inference pt v3m1",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_pt_v3m1_folder(client,
     data_in_folder='/data_in_folder',
     in_model_parameters_path='trained_model/model_ptv2m2',
     out_label_folder='/out_label_folder',
     out_probability_folder='/out_probability_folder',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     number_of_votes=5,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     extension_out_label_path=".labels",
     extension_out_probability_path=".npy",
     skip_existing_files = False):
      '''PT v3m1 Inference
    | 
    | semantic_inference_pt_v3m1_folder(client,
    |      data_in_folder='/data_in_folder',
    |      in_model_parameters_path='trained_model/model_ptv2m2',
    |      out_label_folder='/out_label_folder',
    |      out_probability_folder='/out_probability_folder',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      number_of_votes=5,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_data_in_folder=".laz",
    |      extension_out_label_folder=".labels",
    |      extension_out_probability_folder=".npy",
    |      skip_existing_files = False )

:param in_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param number_of_votes: number of votes
:param data_in_folder:  folder that contains the test data
:param out_label_folder:  folder that contains the results
:param out_probability_folder:  folder that contains the results
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param extension_out_label_folder: File extension of files in folder for out_label_folder
:param extension_out_probability_folder: File extension of files in folder for out_probability_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['out_label_folder']
      del all_parameters['out_probability_folder']
      del all_parameters['extension_data_in_path']
      del all_parameters['extension_out_label_path']
      del all_parameters['extension_out_probability_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path,out_label_path,out_probability_path"
      folders = data_in_folder + "," + out_label_folder + "," + out_probability_folder
      extensions = extension_data_in_path + "," + extension_out_label_path + "," + extension_out_probability_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic inference pt v3m1" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_spunet(client,
     data_in_path='in.laz',
     in_model_parameters_path='trained_model/model_1',
     out_label_path='out.labels',
     out_probability_path='out.npy',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     channels='32,64,128,256,256,128,96,96',
     layers='2,3,4,6,2,2,2,2',
     number_of_votes=5,
     instance_type='P2'):
      '''Spunet Inference
    | 
    | semantic_inference_spunet( client,
    |      data_in_path='in.laz',
    |      in_model_parameters_path='trained_model/model_1',
    |      out_label_path='out.labels',
    |      out_probability_path='out.npy',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      channels='32,64,128,256,256,128,96,96',
    |      layers='2,3,4,6,2,2,2,2',
    |      number_of_votes=5,
    |      instance_type='P2' )

:param data_in_path:  path that contains the test data
:param in_model_parameters_path:  path to model
:param out_label_path:  path that contains the results
:param out_probability_path:  path that contains the results
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param channels: comma separated list of channels
:param layers: comma separated list of layers
:param number_of_votes: number of votes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic inference spunet",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_inference_spunet_folder(client,
     data_in_folder='/data_in_folder',
     in_model_parameters_path='trained_model/model_1',
     out_label_folder='/out_label_folder',
     out_probability_folder='/out_probability_folder',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     channels='32,64,128,256,256,128,96,96',
     layers='2,3,4,6,2,2,2,2',
     number_of_votes=5,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     extension_out_label_path=".labels",
     extension_out_probability_path=".npy",
     skip_existing_files = False):
      '''Spunet Inference
    | 
    | semantic_inference_spunet_folder(client,
    |      data_in_folder='/data_in_folder',
    |      in_model_parameters_path='trained_model/model_1',
    |      out_label_folder='/out_label_folder',
    |      out_probability_folder='/out_probability_folder',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      channels='32,64,128,256,256,128,96,96',
    |      layers='2,3,4,6,2,2,2,2',
    |      number_of_votes=5,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_data_in_folder=".laz",
    |      extension_out_label_folder=".labels",
    |      extension_out_probability_folder=".npy",
    |      skip_existing_files = False )

:param in_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param channels: comma separated list of channels
:param layers: comma separated list of layers
:param number_of_votes: number of votes
:param data_in_folder:  folder that contains the test data
:param out_label_folder:  folder that contains the results
:param out_probability_folder:  folder that contains the results
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param extension_out_label_folder: File extension of files in folder for out_label_folder
:param extension_out_probability_folder: File extension of files in folder for out_probability_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['out_label_folder']
      del all_parameters['out_probability_folder']
      del all_parameters['extension_data_in_path']
      del all_parameters['extension_out_label_path']
      del all_parameters['extension_out_probability_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path,out_label_path,out_probability_path"
      folders = data_in_folder + "," + out_label_folder + "," + out_probability_folder
      extensions = extension_data_in_path + "," + extension_out_label_path + "," + extension_out_probability_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic inference spunet" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_pt_v2m2(client,
     data_in_path='/data/files/',
     out_model_parameters_path='trained_model/model_ptv2m2',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     final_div_factor=100,
     div_factor=10,
     weight_decay=0.005,
     instance_type='P2'):
      '''Pt v2m2 Training
    | 
    | semantic_training_pt_v2m2( client,
    |      data_in_path='/data/files/',
    |      out_model_parameters_path='trained_model/model_ptv2m2',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      final_div_factor=100,
    |      div_factor=10,
    |      weight_decay=0.005,
    |      instance_type='P2' )

:param data_in_path:  path to folder that contains the training data
:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param final_div_factor: final div factor for learning rate
:param div_factor: div factor for learning rate
:param weight_decay: weight decay
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic training pt v2m2",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_pt_v2m2_folder(client,
     data_in_folder='/data_in_folder',
     out_model_parameters_path='trained_model/model_ptv2m2',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     final_div_factor=100,
     div_factor=10,
     weight_decay=0.005,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     skip_existing_files = False):
      '''Pt v2m2 Training
    | 
    | semantic_training_pt_v2m2_folder(client,
    |      data_in_folder='/data_in_folder',
    |      out_model_parameters_path='trained_model/model_ptv2m2',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      final_div_factor=100,
    |      div_factor=10,
    |      weight_decay=0.005,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_data_in_folder="./data/files/",
    |      skip_existing_files = False )

:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param final_div_factor: final div factor for learning rate
:param div_factor: div factor for learning rate
:param weight_decay: weight decay
:param data_in_folder:  folder to folder that contains the training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['extension_data_in_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path"
      folders = data_in_folder
      extensions = extension_data_in_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic training pt v2m2" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_pt_v3m1(client,
     data_in_path='/data/files/',
     out_model_parameters_path='trained_model/model_ptv2m2',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     final_div_factor=100,
     div_factor=10,
     weight_decay=0.005,
     instance_type='P2'):
      '''Pt v3m1 Training
    | 
    | semantic_training_pt_v3m1( client,
    |      data_in_path='/data/files/',
    |      out_model_parameters_path='trained_model/model_ptv2m2',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      final_div_factor=100,
    |      div_factor=10,
    |      weight_decay=0.005,
    |      instance_type='P2' )

:param data_in_path:  path to folder that contains the training data
:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param final_div_factor: final div factor for learning rate
:param div_factor: div factor for learning rate
:param weight_decay: weight decay
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic training pt v3m1",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_pt_v3m1_folder(client,
     data_in_folder='/data_in_folder',
     out_model_parameters_path='trained_model/model_ptv2m2',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     final_div_factor=100,
     div_factor=10,
     weight_decay=0.005,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     skip_existing_files = False):
      '''Pt v3m1 Training
    | 
    | semantic_training_pt_v3m1_folder(client,
    |      data_in_folder='/data_in_folder',
    |      out_model_parameters_path='trained_model/model_ptv2m2',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      final_div_factor=100,
    |      div_factor=10,
    |      weight_decay=0.005,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_data_in_folder="./data/files/",
    |      skip_existing_files = False )

:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param final_div_factor: final div factor for learning rate
:param div_factor: div factor for learning rate
:param weight_decay: weight decay
:param data_in_folder:  folder to folder that contains the training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['extension_data_in_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path"
      folders = data_in_folder
      extensions = extension_data_in_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic training pt v3m1" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_spunet(client,
     data_in_path='/data/files/',
     out_model_parameters_path='trained_model/model_1',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     final_div_factor=100,
     div_factor=10,
     weight_decay=0.005,
     channels='32,64,128,256,256,128,96,96',
     layers='2,3,4,6,2,2,2,2',
     instance_type='P2'):
      '''Spunet Training
    | 
    | semantic_training_spunet( client,
    |      data_in_path='/data/files/',
    |      out_model_parameters_path='trained_model/model_1',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      final_div_factor=100,
    |      div_factor=10,
    |      weight_decay=0.005,
    |      channels='32,64,128,256,256,128,96,96',
    |      layers='2,3,4,6,2,2,2,2',
    |      instance_type='P2' )

:param data_in_path:  path to folder that contains the training data
:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param final_div_factor: final div factor for learning rate
:param div_factor: div factor for learning rate
:param weight_decay: weight decay
:param channels: comma separated list of channels
:param layers: comma separated list of layers
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "semantic training spunet",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def semantic_training_spunet_folder(client,
     data_in_folder='/data_in_folder',
     out_model_parameters_path='trained_model/model_1',
     class_names='1,2,3,4,5,6,7,8',
     feature_names='red,green,blue',
     point_names='X,Y,Z',
     label_name='classification',
     resolution=0.05,
     max_epochs=500,
     learning_rate=0.01,
     batch_size=10,
     final_div_factor=100,
     div_factor=10,
     weight_decay=0.005,
     channels='32,64,128,256,256,128,96,96',
     layers='2,3,4,6,2,2,2,2',
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_data_in_path=".laz",
     skip_existing_files = False):
      '''Spunet Training
    | 
    | semantic_training_spunet_folder(client,
    |      data_in_folder='/data_in_folder',
    |      out_model_parameters_path='trained_model/model_1',
    |      class_names='1,2,3,4,5,6,7,8',
    |      feature_names='red,green,blue',
    |      point_names='X,Y,Z',
    |      label_name='classification',
    |      resolution=0.05,
    |      max_epochs=500,
    |      learning_rate=0.01,
    |      batch_size=10,
    |      final_div_factor=100,
    |      div_factor=10,
    |      weight_decay=0.005,
    |      channels='32,64,128,256,256,128,96,96',
    |      layers='2,3,4,6,2,2,2,2',
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_data_in_folder="./data/files/",
    |      skip_existing_files = False )

:param out_model_parameters_path:  path to model
:param class_names: comma separated list of class names. Class 0 is always given and is used to denote unlabeled points.
:param feature_names: comma separated list of features that are provided
:param point_names: comma separated list of point identifiers in (las/laz)
:param label_name: label name for (las/laz)
:param resolution: resolution of the subsampled point cloud
:param max_epochs: maximum number of epochs
:param learning_rate: learning rate
:param batch_size: batch size
:param final_div_factor: final div factor for learning rate
:param div_factor: div factor for learning rate
:param weight_decay: weight decay
:param channels: comma separated list of channels
:param layers: comma separated list of layers
:param data_in_folder:  folder to folder that contains the training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_data_in_folder: File extension of files in folder for data_in_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['data_in_folder']
      del all_parameters['extension_data_in_path']

      cmd_str = json.dumps(all_parameters)
      parameters = "data_in_path"
      folders = data_in_folder
      extensions = extension_data_in_path
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "semantic training spunet" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def wireframe_estimation_inference(client,
     in_files='data_eval',
     out_result_files='result_wireframes',
     in_model_path='parameters_wireframe',
     knn_line=15,
     mode_wireframe_estimation='knn unassigned',
     num_votes=10,
     rotation_axis='z',
     instance_type='x2large'):
      '''[hidden] Wireframe estimation inference
    | 
    | wireframe_estimation_inference( client,
    |      in_files='data_eval',
    |      out_result_files='result_wireframes',
    |      in_model_path='parameters_wireframe',
    |      knn_line=15,
    |      mode_wireframe_estimation='knn unassigned',
    |      num_votes=10,
    |      rotation_axis='z',
    |      instance_type='x2large' )

:param in_files: input files or directory with training data
:param out_result_files: output files containing the wireframes
:param in_model_path:  model path
:param knn_line: knn line
:param mode_wireframe_estimation: mode for wireframe estimation
:param num_votes: number of votes for wireframe estimation
:param rotation_axis: rotation axis
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "wireframe estimation inference",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def wireframe_estimation_inference_folder(client,
     in_folders='/in_folders',
     out_result_folders='/out_result_folders',
     in_model_path='parameters_wireframe',
     knn_line=15,
     mode_wireframe_estimation='knn unassigned',
     num_votes=10,
     rotation_axis='z',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_files=".laz",
     extension_out_result_files=".laz",
     skip_existing_files = False):
      '''[hidden] Wireframe estimation inference
    | 
    | wireframe_estimation_inference_folder(client,
    |      in_folders='/in_folders',
    |      out_result_folders='/out_result_folders',
    |      in_model_path='parameters_wireframe',
    |      knn_line=15,
    |      mode_wireframe_estimation='knn unassigned',
    |      num_votes=10,
    |      rotation_axis='z',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folders=".data_eval",
    |      extension_out_result_folders=".result_wireframes",
    |      skip_existing_files = False )

:param in_model_path:  model path
:param knn_line: knn line
:param mode_wireframe_estimation: mode for wireframe estimation
:param num_votes: number of votes for wireframe estimation
:param rotation_axis: rotation axis
:param in_folders: input folders or directory with training data
:param out_result_folders: output folders containing the wireframes
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folders: File extension of files in folder for in_folders
:param extension_out_result_folders: File extension of files in folder for out_result_folders
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folders']
      del all_parameters['out_result_folders']
      del all_parameters['extension_in_files']
      del all_parameters['extension_out_result_files']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_files,out_result_files"
      folders = in_folders + "," + out_result_folders
      extensions = extension_in_files + "," + extension_out_result_files
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "wireframe estimation inference" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def vertices_estimation_inference(client,
     in_files='data_eval',
     out_files='result_vertices',
     in_model_path='parameters_model_test',
     batch_size=1,
     instance_type='x2large'):
      '''
    | 
    | vertices_estimation_inference( client,
    |      in_files='data_eval',
    |      out_files='result_vertices',
    |      in_model_path='parameters_model_test',
    |      batch_size=1,
    |      instance_type='x2large' )

:param in_files: input files or directory with training data
:param out_files: output files containing the vertices
:param in_model_path:  model path
:param batch_size: batch size for training
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "vertices estimation inference",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def vertices_estimation_inference_folder(client,
     in_folders='/in_folders',
     out_folders='/out_folders',
     in_model_path='parameters_model_test',
     batch_size=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_files=".laz",
     extension_out_files=".laz",
     skip_existing_files = False):
      '''
    | 
    | vertices_estimation_inference_folder(client,
    |      in_folders='/in_folders',
    |      out_folders='/out_folders',
    |      in_model_path='parameters_model_test',
    |      batch_size=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folders=".data_eval",
    |      extension_out_folders=".result_vertices",
    |      skip_existing_files = False )

:param in_model_path:  model path
:param batch_size: batch size for training
:param in_folders: input folders or directory with training data
:param out_folders: output folders containing the vertices
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folders: File extension of files in folder for in_folders
:param extension_out_folders: File extension of files in folder for out_folders
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folders']
      del all_parameters['out_folders']
      del all_parameters['extension_in_files']
      del all_parameters['extension_out_files']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_files,out_files"
      folders = in_folders + "," + out_folders
      extensions = extension_in_files + "," + extension_out_files
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "vertices estimation inference" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def wireframe_estimation_training(client,
     in_folder='data_train',
     in_wireframe_folder='data_train_wireframe',
     out_model_path='parameters_wireframe_14A_bce_interpolation',
     voxel_size=0.02,
     zero_centering='True',
     point_names='X,Y,Z',
     feature_names='',
     label_names='classification',
     num_classes=1,
     label_scales='0.01',
     learning_rate=5e-6,
     learning_decay=0.999,
     num_epochs=2000000,
     regularization_decay=1e-10,
     batch_size=5 ,
     save_after_epochs=1,
     backbone_type='MinkUNet14A',
     head_type_prob='HeadPointwise',
     criterion_type_prob='BCEMean',
     hidden_layers=8,
     max_interpolation_distance=0.75,
     dist_threshold=0.35,
     score_threshold=0.5,
     point_estimation_layers=3,
     point_estimation_channels=32,
     criterion_type_point='L1Mean',
     wireframe_criterion_type='BCEMean',
     wireframe_estimation_layers=3,
     wireframe_estimation_channels=32,
     weight_pred=2,
     weight_prob=6.5,
     weight_reconstruction=4.5,
     weight_wireframe=9,
     knn_line=10,
     distance_line=0.3,
     probabilistic='True',
     store_in_memory='True',
     mode_wireframe_estimation='knn',
     maximum_wireframe_samples=2500,
     wireframe_subsampling=5,
     wireframe_extrapolation_sampling=2,
     only_train_wireframe='False',
     instance_type='x2large'):
      '''[hidden] wireframe estimation training
    | 
    | wireframe_estimation_training( client,
    |      in_folder='data_train',
    |      in_wireframe_folder='data_train_wireframe',
    |      out_model_path='parameters_wireframe_14A_bce_interpolation',
    |      voxel_size=0.02,
    |      zero_centering='True',
    |      point_names='X,Y,Z',
    |      feature_names='',
    |      label_names='classification',
    |      num_classes=1,
    |      label_scales='0.01',
    |      learning_rate=5e-6,
    |      learning_decay=0.999,
    |      num_epochs=2000000,
    |      regularization_decay=1e-10,
    |      batch_size=5 ,
    |      save_after_epochs=1,
    |      backbone_type='MinkUNet14A',
    |      head_type_prob='HeadPointwise',
    |      criterion_type_prob='BCEMean',
    |      hidden_layers=8,
    |      max_interpolation_distance=0.75,
    |      dist_threshold=0.35,
    |      score_threshold=0.5,
    |      point_estimation_layers=3,
    |      point_estimation_channels=32,
    |      criterion_type_point='L1Mean',
    |      wireframe_criterion_type='BCEMean',
    |      wireframe_estimation_layers=3,
    |      wireframe_estimation_channels=32,
    |      weight_pred=2,
    |      weight_prob=6.5,
    |      weight_reconstruction=4.5,
    |      weight_wireframe=9,
    |      knn_line=10,
    |      distance_line=0.3,
    |      probabilistic='True',
    |      store_in_memory='True',
    |      mode_wireframe_estimation='knn',
    |      maximum_wireframe_samples=2500,
    |      wireframe_subsampling=5,
    |      wireframe_extrapolation_sampling=2,
    |      only_train_wireframe='False',
    |      instance_type='x2large' )

:param in_folder: input directory with training data
:param in_wireframe_folder: input directory with corresponding wireframe data
:param out_model_path:  model path
:param voxel_size: voxel size
:param zero_centering: zero centering
:param point_names: point names
:param feature_names: feature names
:param label_names: label names
:param num_classes: number of classes
:param label_scales: label scales
:param learning_rate: learning rate
:param learning_decay: learning rate decay
:param num_epochs: number of epochs
:param regularization_decay: regularization decay
:param batch_size: batch size for training
:param save_after_epochs: save after epochs
:param backbone_type: model type of backbone network
:param head_type_prob: model type of head network
:param criterion_type_prob: model type of criterion
:param hidden_layers: number of hidden layers
:param max_interpolation_distance: maximum distance to interpolate occluded points
:param dist_threshold: distance threshold for non-maxima suppression
:param score_threshold: score threshold for non-maxima suppression
:param point_estimation_layers: number of hidden layers for point estimation
:param point_estimation_channels: number of channels for point estimation
:param criterion_type_point: model type of criterion for point estimation
:param wireframe_criterion_type: model type of criterion for wireframe estimation
:param wireframe_estimation_layers: number of hidden layers for wireframe estimation
:param wireframe_estimation_channels: number of channels for wireframe estimation
:param weight_pred: weight for point estimation
:param weight_prob: weight for probability estimation
:param weight_reconstruction: weight for reconstruction
:param weight_wireframe: weight for wireframe estimation
:param knn_line: number of nearest neighbours for line estimation
:param distance_line: distance threshold for line estimation
:param probabilistic: probabilistic
:param store_in_memory: store in memory
:param mode_wireframe_estimation: wireframe mode
:param maximum_wireframe_samples: maximum number of wireframe samples
:param wireframe_subsampling: wireframe subsampling factor
:param wireframe_extrapolation_sampling: wireframe extrapolation sampling factor
:param only_train_wireframe: only train wireframe
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "wireframe estimation training",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def wireframe_estimation_training_folder(client,
     folder_in_folder='/folder_in_folder',
     folder_in_wireframe_folder='/folder_in_wireframe_folder',
     out_model_path='parameters_wireframe_14A_bce_interpolation',
     voxel_size=0.02,
     zero_centering='True',
     point_names='X,Y,Z',
     feature_names='',
     label_names='classification',
     num_classes=1,
     label_scales='0.01',
     learning_rate=5e-6,
     learning_decay=0.999,
     num_epochs=2000000,
     regularization_decay=1e-10,
     batch_size=5 ,
     save_after_epochs=1,
     backbone_type='MinkUNet14A',
     head_type_prob='HeadPointwise',
     criterion_type_prob='BCEMean',
     hidden_layers=8,
     max_interpolation_distance=0.75,
     dist_threshold=0.35,
     score_threshold=0.5,
     point_estimation_layers=3,
     point_estimation_channels=32,
     criterion_type_point='L1Mean',
     wireframe_criterion_type='BCEMean',
     wireframe_estimation_layers=3,
     wireframe_estimation_channels=32,
     weight_pred=2,
     weight_prob=6.5,
     weight_reconstruction=4.5,
     weight_wireframe=9,
     knn_line=10,
     distance_line=0.3,
     probabilistic='True',
     store_in_memory='True',
     mode_wireframe_estimation='knn',
     maximum_wireframe_samples=2500,
     wireframe_subsampling=5,
     wireframe_extrapolation_sampling=2,
     only_train_wireframe='False',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_folder=".laz",
     extension_in_wireframe_folder=".laz",
     skip_existing_files = False):
      '''[hidden] wireframe estimation training
    | 
    | wireframe_estimation_training_folder(client,
    |      in_folder='/in_folder',
    |      in_wireframe_folder='/in_wireframe_folder',
    |      out_model_path='parameters_wireframe_14A_bce_interpolation',
    |      voxel_size=0.02,
    |      zero_centering='True',
    |      point_names='X,Y,Z',
    |      feature_names='',
    |      label_names='classification',
    |      num_classes=1,
    |      label_scales='0.01',
    |      learning_rate=5e-6,
    |      learning_decay=0.999,
    |      num_epochs=2000000,
    |      regularization_decay=1e-10,
    |      batch_size=5 ,
    |      save_after_epochs=1,
    |      backbone_type='MinkUNet14A',
    |      head_type_prob='HeadPointwise',
    |      criterion_type_prob='BCEMean',
    |      hidden_layers=8,
    |      max_interpolation_distance=0.75,
    |      dist_threshold=0.35,
    |      score_threshold=0.5,
    |      point_estimation_layers=3,
    |      point_estimation_channels=32,
    |      criterion_type_point='L1Mean',
    |      wireframe_criterion_type='BCEMean',
    |      wireframe_estimation_layers=3,
    |      wireframe_estimation_channels=32,
    |      weight_pred=2,
    |      weight_prob=6.5,
    |      weight_reconstruction=4.5,
    |      weight_wireframe=9,
    |      knn_line=10,
    |      distance_line=0.3,
    |      probabilistic='True',
    |      store_in_memory='True',
    |      mode_wireframe_estimation='knn',
    |      maximum_wireframe_samples=2500,
    |      wireframe_subsampling=5,
    |      wireframe_extrapolation_sampling=2,
    |      only_train_wireframe='False',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".data_train",
    |      extension_in_wireframe_folder=".data_train_wireframe",
    |      skip_existing_files = False )

:param out_model_path:  model path
:param voxel_size: voxel size
:param zero_centering: zero centering
:param point_names: point names
:param feature_names: feature names
:param label_names: label names
:param num_classes: number of classes
:param label_scales: label scales
:param learning_rate: learning rate
:param learning_decay: learning rate decay
:param num_epochs: number of epochs
:param regularization_decay: regularization decay
:param batch_size: batch size for training
:param save_after_epochs: save after epochs
:param backbone_type: model type of backbone network
:param head_type_prob: model type of head network
:param criterion_type_prob: model type of criterion
:param hidden_layers: number of hidden layers
:param max_interpolation_distance: maximum distance to interpolate occluded points
:param dist_threshold: distance threshold for non-maxima suppression
:param score_threshold: score threshold for non-maxima suppression
:param point_estimation_layers: number of hidden layers for point estimation
:param point_estimation_channels: number of channels for point estimation
:param criterion_type_point: model type of criterion for point estimation
:param wireframe_criterion_type: model type of criterion for wireframe estimation
:param wireframe_estimation_layers: number of hidden layers for wireframe estimation
:param wireframe_estimation_channels: number of channels for wireframe estimation
:param weight_pred: weight for point estimation
:param weight_prob: weight for probability estimation
:param weight_reconstruction: weight for reconstruction
:param weight_wireframe: weight for wireframe estimation
:param knn_line: number of nearest neighbours for line estimation
:param distance_line: distance threshold for line estimation
:param probabilistic: probabilistic
:param store_in_memory: store in memory
:param mode_wireframe_estimation: wireframe mode
:param maximum_wireframe_samples: maximum number of wireframe samples
:param wireframe_subsampling: wireframe subsampling factor
:param wireframe_extrapolation_sampling: wireframe extrapolation sampling factor
:param only_train_wireframe: only train wireframe
:param folder_in_folder: input directory with training data
:param folder_in_wireframe_folder: input directory with corresponding wireframe data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for folder_in_folder
:param extension_in_wireframe_folder: File extension of files in folder for folder_in_wireframe_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in_folder']
      del all_parameters['folder_in_wireframe_folder']
      del all_parameters['extension_in_folder']
      del all_parameters['extension_in_wireframe_folder']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_folder,in_wireframe_folder"
      folders = folder_in_folder + "," + folder_in_wireframe_folder
      extensions = extension_in_folder + "," + extension_in_wireframe_folder
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "wireframe estimation training" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def universal_training(client,
     in_folder='data_train',
     out_model_path='parameters_model_test',
     voxel_size=0.02,
     zero_centering='True',
     point_names='X,Y,Z',
     feature_names='',
     label_names='classification',
     num_classes=1,
     label_scales='0.01',
     learning_rate=3e-6,
     learning_decay=0.9999,
     num_epochs=200000,
     regularization_decay=1e-9,
     batch_size=2,
     save_after_epochs=100,
     backbone_type='MinkUNet14A',
     head_type='HeadPointwise',
     criterion_type='L1Sum',
     probabilistic='True',
     hidden_layers=8,
     store_in_memory='True',
     instance_type='x2large'):
      '''
    | 
    | universal_training( client,
    |      in_folder='data_train',
    |      out_model_path='parameters_model_test',
    |      voxel_size=0.02,
    |      zero_centering='True',
    |      point_names='X,Y,Z',
    |      feature_names='',
    |      label_names='classification',
    |      num_classes=1,
    |      label_scales='0.01',
    |      learning_rate=3e-6,
    |      learning_decay=0.9999,
    |      num_epochs=200000,
    |      regularization_decay=1e-9,
    |      batch_size=2,
    |      save_after_epochs=100,
    |      backbone_type='MinkUNet14A',
    |      head_type='HeadPointwise',
    |      criterion_type='L1Sum',
    |      probabilistic='True',
    |      hidden_layers=8,
    |      store_in_memory='True',
    |      instance_type='x2large' )

:param in_folder: input directory with training data
:param out_model_path:  model path
:param voxel_size: voxel size
:param zero_centering: zero centering
:param point_names: point names
:param feature_names: feature names
:param label_names: label names
:param num_classes: number of classes
:param label_scales: label scales
:param learning_rate: learning rate
:param learning_decay: learning rate decay
:param num_epochs: number of epochs
:param regularization_decay: regularization decay
:param batch_size: batch size for training
:param save_after_epochs: save after epochs
:param backbone_type: model type of backbone network
:param head_type: model type of head network
:param criterion_type: model type of criterion
:param probabilistic: estimate probabilities: labels in [0,1]
:param hidden_layers: number of hidden layers
:param store_in_memory: store training data in memory
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "universal training",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def universal_training_folder(client,
     folder_in_folder='/folder_in_folder',
     out_model_path='parameters_model_test',
     voxel_size=0.02,
     zero_centering='True',
     point_names='X,Y,Z',
     feature_names='',
     label_names='classification',
     num_classes=1,
     label_scales='0.01',
     learning_rate=3e-6,
     learning_decay=0.9999,
     num_epochs=200000,
     regularization_decay=1e-9,
     batch_size=2,
     save_after_epochs=100,
     backbone_type='MinkUNet14A',
     head_type='HeadPointwise',
     criterion_type='L1Sum',
     probabilistic='True',
     hidden_layers=8,
     store_in_memory='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_folder=".laz",
     skip_existing_files = False):
      '''
    | 
    | universal_training_folder(client,
    |      in_folder='/in_folder',
    |      out_model_path='parameters_model_test',
    |      voxel_size=0.02,
    |      zero_centering='True',
    |      point_names='X,Y,Z',
    |      feature_names='',
    |      label_names='classification',
    |      num_classes=1,
    |      label_scales='0.01',
    |      learning_rate=3e-6,
    |      learning_decay=0.9999,
    |      num_epochs=200000,
    |      regularization_decay=1e-9,
    |      batch_size=2,
    |      save_after_epochs=100,
    |      backbone_type='MinkUNet14A',
    |      head_type='HeadPointwise',
    |      criterion_type='L1Sum',
    |      probabilistic='True',
    |      hidden_layers=8,
    |      store_in_memory='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".data_train",
    |      skip_existing_files = False )

:param out_model_path:  model path
:param voxel_size: voxel size
:param zero_centering: zero centering
:param point_names: point names
:param feature_names: feature names
:param label_names: label names
:param num_classes: number of classes
:param label_scales: label scales
:param learning_rate: learning rate
:param learning_decay: learning rate decay
:param num_epochs: number of epochs
:param regularization_decay: regularization decay
:param batch_size: batch size for training
:param save_after_epochs: save after epochs
:param backbone_type: model type of backbone network
:param head_type: model type of head network
:param criterion_type: model type of criterion
:param probabilistic: estimate probabilities: labels in [0,1]
:param hidden_layers: number of hidden layers
:param store_in_memory: store training data in memory
:param folder_in_folder: input directory with training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for folder_in_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in_folder']
      del all_parameters['extension_in_folder']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_folder"
      folders = folder_in_folder
      extensions = extension_in_folder
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "universal training" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def vertices_estimation_training(client,
     in_folder='data_train',
     in_vertices_folder='data_train_vertices',
     out_model_path='parameters_model_test',
     voxel_size=0.02,
     zero_centering='True',
     point_names='X,Y,Z',
     feature_names='',
     label_names='classification',
     num_classes=1,
     label_scales='0.01',
     learning_rate=1e-5,
     learning_decay=0.999,
     num_epochs=2000000,
     regularization_decay=1e-9,
     batch_size=5 ,
     save_after_epochs=100,
     backbone_type='MinkUNet14A',
     head_type_prob='HeadPointwise',
     criterion_type_prob='BCEMean',
     hidden_layers=8,
     max_interpolation_distance=0.75,
     dist_threshold=0.35,
     score_threshold=0.4,
     point_estimation_layers=3,
     point_estimation_channels=8,
     criterion_type_point='L1Mean',
     weight_pred=1.0,
     weight_prob=2.0,
     weight_reconstruction=4.0,
     probabilistic='True',
     instance_type='x2large'):
      '''
    | 
    | vertices_estimation_training( client,
    |      in_folder='data_train',
    |      in_vertices_folder='data_train_vertices',
    |      out_model_path='parameters_model_test',
    |      voxel_size=0.02,
    |      zero_centering='True',
    |      point_names='X,Y,Z',
    |      feature_names='',
    |      label_names='classification',
    |      num_classes=1,
    |      label_scales='0.01',
    |      learning_rate=1e-5,
    |      learning_decay=0.999,
    |      num_epochs=2000000,
    |      regularization_decay=1e-9,
    |      batch_size=5 ,
    |      save_after_epochs=100,
    |      backbone_type='MinkUNet14A',
    |      head_type_prob='HeadPointwise',
    |      criterion_type_prob='BCEMean',
    |      hidden_layers=8,
    |      max_interpolation_distance=0.75,
    |      dist_threshold=0.35,
    |      score_threshold=0.4,
    |      point_estimation_layers=3,
    |      point_estimation_channels=8,
    |      criterion_type_point='L1Mean',
    |      weight_pred=1.0,
    |      weight_prob=2.0,
    |      weight_reconstruction=4.0,
    |      probabilistic='True',
    |      instance_type='x2large' )

:param in_folder: input directory with training data
:param in_vertices_folder: input directory with corresponding vertex data
:param out_model_path:  model path
:param voxel_size: voxel size
:param zero_centering: zero centering
:param point_names: point names
:param feature_names: feature names
:param label_names: label names
:param num_classes: number of classes
:param label_scales: label scales
:param learning_rate: learning rate
:param learning_decay: learning rate decay
:param num_epochs: number of epochs
:param regularization_decay: regularization decay
:param batch_size: batch size for training
:param save_after_epochs: save after epochs
:param backbone_type: model type of backbone network
:param head_type_prob: model type of head network
:param criterion_type_prob: model type of criterion
:param hidden_layers: number of hidden layers
:param max_interpolation_distance: maximum distance to interpolate occluded points
:param dist_threshold: distance threshold for non-maximum suppression
:param score_threshold: score threshold for non-maximum suppression
:param point_estimation_layers: number of hidden layers for point estimation
:param point_estimation_channels: number of channels for point estimation
:param criterion_type_point: model type of criterion for point estimation
:param weight_pred: weight for point estimation
:param weight_prob: weight for probability estimation
:param weight_reconstruction: weight for reconstruction estimation
:param probabilistic: probabilistic
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "vertices estimation training",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def vertices_estimation_training_folder(client,
     folder_in_folder='/folder_in_folder',
     folder_in_vertices_folder='/folder_in_vertices_folder',
     out_model_path='parameters_model_test',
     voxel_size=0.02,
     zero_centering='True',
     point_names='X,Y,Z',
     feature_names='',
     label_names='classification',
     num_classes=1,
     label_scales='0.01',
     learning_rate=1e-5,
     learning_decay=0.999,
     num_epochs=2000000,
     regularization_decay=1e-9,
     batch_size=5 ,
     save_after_epochs=100,
     backbone_type='MinkUNet14A',
     head_type_prob='HeadPointwise',
     criterion_type_prob='BCEMean',
     hidden_layers=8,
     max_interpolation_distance=0.75,
     dist_threshold=0.35,
     score_threshold=0.4,
     point_estimation_layers=3,
     point_estimation_channels=8,
     criterion_type_point='L1Mean',
     weight_pred=1.0,
     weight_prob=2.0,
     weight_reconstruction=4.0,
     probabilistic='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_folder=".laz",
     extension_in_vertices_folder=".laz",
     skip_existing_files = False):
      '''
    | 
    | vertices_estimation_training_folder(client,
    |      in_folder='/in_folder',
    |      in_vertices_folder='/in_vertices_folder',
    |      out_model_path='parameters_model_test',
    |      voxel_size=0.02,
    |      zero_centering='True',
    |      point_names='X,Y,Z',
    |      feature_names='',
    |      label_names='classification',
    |      num_classes=1,
    |      label_scales='0.01',
    |      learning_rate=1e-5,
    |      learning_decay=0.999,
    |      num_epochs=2000000,
    |      regularization_decay=1e-9,
    |      batch_size=5 ,
    |      save_after_epochs=100,
    |      backbone_type='MinkUNet14A',
    |      head_type_prob='HeadPointwise',
    |      criterion_type_prob='BCEMean',
    |      hidden_layers=8,
    |      max_interpolation_distance=0.75,
    |      dist_threshold=0.35,
    |      score_threshold=0.4,
    |      point_estimation_layers=3,
    |      point_estimation_channels=8,
    |      criterion_type_point='L1Mean',
    |      weight_pred=1.0,
    |      weight_prob=2.0,
    |      weight_reconstruction=4.0,
    |      probabilistic='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".data_train",
    |      extension_in_vertices_folder=".data_train_vertices",
    |      skip_existing_files = False )

:param out_model_path:  model path
:param voxel_size: voxel size
:param zero_centering: zero centering
:param point_names: point names
:param feature_names: feature names
:param label_names: label names
:param num_classes: number of classes
:param label_scales: label scales
:param learning_rate: learning rate
:param learning_decay: learning rate decay
:param num_epochs: number of epochs
:param regularization_decay: regularization decay
:param batch_size: batch size for training
:param save_after_epochs: save after epochs
:param backbone_type: model type of backbone network
:param head_type_prob: model type of head network
:param criterion_type_prob: model type of criterion
:param hidden_layers: number of hidden layers
:param max_interpolation_distance: maximum distance to interpolate occluded points
:param dist_threshold: distance threshold for non-maximum suppression
:param score_threshold: score threshold for non-maximum suppression
:param point_estimation_layers: number of hidden layers for point estimation
:param point_estimation_channels: number of channels for point estimation
:param criterion_type_point: model type of criterion for point estimation
:param weight_pred: weight for point estimation
:param weight_prob: weight for probability estimation
:param weight_reconstruction: weight for reconstruction estimation
:param probabilistic: probabilistic
:param folder_in_folder: input directory with training data
:param folder_in_vertices_folder: input directory with corresponding vertex data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for folder_in_folder
:param extension_in_vertices_folder: File extension of files in folder for folder_in_vertices_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in_folder']
      del all_parameters['folder_in_vertices_folder']
      del all_parameters['extension_in_folder']
      del all_parameters['extension_in_vertices_folder']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_folder,in_vertices_folder"
      folders = folder_in_folder + "," + folder_in_vertices_folder
      extensions = extension_in_folder + "," + extension_in_vertices_folder
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "vertices estimation training" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def universal_inference(client,
     in_files='data_eval',
     out_files='results',
     in_model_path='parameters_model',
     instance_type='x2large'):
      '''
    | 
    | universal_inference( client,
    |      in_files='data_eval',
    |      out_files='results',
    |      in_model_path='parameters_model',
    |      instance_type='x2large' )

:param in_files: input files with training data
:param out_files: output files with training data
:param in_model_path:  model path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "universal inference",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def universal_inference_folder(client,
     in_folders='/in_folders',
     out_folders='/out_folders',
     in_model_path='parameters_model',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_files=".laz",
     extension_out_files=".laz",
     skip_existing_files = False):
      '''
    | 
    | universal_inference_folder(client,
    |      in_folders='/in_folders',
    |      out_folders='/out_folders',
    |      in_model_path='parameters_model',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folders=".data_eval",
    |      extension_out_folders=".results",
    |      skip_existing_files = False )

:param in_model_path:  model path
:param in_folders: input folders with training data
:param out_folders: output folders with training data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folders: File extension of files in folder for in_folders
:param extension_out_folders: File extension of files in folder for out_folders
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folders']
      del all_parameters['out_folders']
      del all_parameters['extension_in_files']
      del all_parameters['extension_out_files']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_files,out_files"
      folders = in_folders + "," + out_folders
      extensions = extension_in_files + "," + extension_out_files
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "universal inference" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class tdp:
   def point_cloud_classification_inference(client,
     file_in='file.laz',
     file_out='file.labels',
     model_path='network_parameters',
     cols_data='X,Y,Z',
     cols_labels='classification',
     instance_type='P2'):
      '''
    | 
    | point_cloud_classification_inference( client,
    |      file_in='file.laz',
    |      file_out='file.labels',
    |      model_path='network_parameters',
    |      cols_data='X,Y,Z',
    |      cols_labels='classification',
    |      instance_type='P2' )

:param file_in: input file
:param file_out: results file
:param model_path:  path to model
:param cols_data: attributes used
:param cols_labels: label name
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "point cloud classification inference",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def point_cloud_classification_inference_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     model_path='network_parameters',
     cols_data='X,Y,Z',
     cols_labels='classification',
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_file_in=".laz",
     extension_file_out=".labels",
     skip_existing_files = False):
      '''
    | 
    | point_cloud_classification_inference_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      model_path='network_parameters',
    |      cols_data='X,Y,Z',
    |      cols_labels='classification',
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_folder_in=".laz",
    |      extension_folder_out=".labels",
    |      skip_existing_files = False )

:param model_path:  path to model
:param cols_data: attributes used
:param cols_labels: label name
:param folder_in: input folder
:param folder_out: results folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "point cloud classification inference" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def convert_laz_point_formats(client,
     file_in='file.laz',
     file_out='file.labels',
     format=7,
     instance_type='P2'):
      '''
    | 
    | convert_laz_point_formats( client,
    |      file_in='file.laz',
    |      file_out='file.labels',
    |      format=7,
    |      instance_type='P2' )

:param file_in: input file
:param file_out: results file
:param format: format
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "convert laz point formats",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def convert_laz_point_formats_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     format=7,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_file_in=".laz",
     extension_file_out=".labels",
     skip_existing_files = False):
      '''
    | 
    | convert_laz_point_formats_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      format=7,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_folder_in=".laz",
    |      extension_folder_out=".labels",
    |      skip_existing_files = False )

:param format: format
:param folder_in: input folder
:param folder_out: results folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "convert laz point formats" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def segment_objects(client,
     in_points_file='laz_files_test',
     in_labels_file='laz_files_test',
     out_directory='segmented_object',
     out_prefix='object',
     label_col='classification',
     object_class=68,
     max_distance=2,
     min_points=100,
     instance_type='P2'):
      '''
    | 
    | segment_objects( client,
    |      in_points_file='laz_files_test',
    |      in_labels_file='laz_files_test',
    |      out_directory='segmented_object',
    |      out_prefix='object',
    |      label_col='classification',
    |      object_class=68,
    |      max_distance=2,
    |      min_points=100,
    |      instance_type='P2' )

:param in_points_file: input file points
:param in_labels_file: input file labels
:param out_directory: output directory
:param out_prefix: output filename prefix
:param label_col: label column id
:param object_class: obejct class
:param max_distance: maximum distance for segmentation
:param min_points: minimum number of points
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "segment objects",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def segment_objects_folder(client,
     in_points_folder='/in_points_folder',
     in_labels_folder='/in_labels_folder',
     out_directory='segmented_object',
     out_prefix='object',
     label_col='classification',
     object_class=68,
     max_distance=2,
     min_points=100,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_in_points_file=".laz",
     extension_in_labels_file=".laz",
     skip_existing_files = False):
      '''
    | 
    | segment_objects_folder(client,
    |      in_points_folder='/in_points_folder',
    |      in_labels_folder='/in_labels_folder',
    |      out_directory='segmented_object',
    |      out_prefix='object',
    |      label_col='classification',
    |      object_class=68,
    |      max_distance=2,
    |      min_points=100,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_in_points_folder=".laz_files_test",
    |      extension_in_labels_folder=".laz_files_test",
    |      skip_existing_files = False )

:param out_directory: output directory
:param out_prefix: output filename prefix
:param label_col: label column id
:param object_class: obejct class
:param max_distance: maximum distance for segmentation
:param min_points: minimum number of points
:param in_points_folder: input folder points
:param in_labels_folder: input folder labels
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_points_folder: File extension of files in folder for in_points_folder
:param extension_in_labels_folder: File extension of files in folder for in_labels_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_points_folder']
      del all_parameters['in_labels_folder']
      del all_parameters['extension_in_points_file']
      del all_parameters['extension_in_labels_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_points_file,in_labels_file"
      folders = in_points_folder + "," + in_labels_folder
      extensions = extension_in_points_file + "," + extension_in_labels_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "segment objects" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def point_cloud_filter_label_noise(client,
     file_in_data='file.laz',
     file_in_labels='file.labels',
     file_out='result.laz',
     k_nearest_neighbours=5,
     sigma=10.,
     dim=3,
     invalid_label=0,
     instance_type='P2'):
      '''
    | 
    | point_cloud_filter_label_noise( client,
    |      file_in_data='file.laz',
    |      file_in_labels='file.labels',
    |      file_out='result.laz',
    |      k_nearest_neighbours=5,
    |      sigma=10.,
    |      dim=3,
    |      invalid_label=0,
    |      instance_type='P2' )

:param file_in_data: input file data
:param file_in_labels: input file labels
:param file_out: output file
:param k_nearest_neighbours: k nearest neighbours
:param sigma: sigma
:param dim: dim
:param invalid_label: invalid class label
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "point cloud filter label noise",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def point_cloud_filter_label_noise_folder(client,
     folder_in_data='/folder_in_data',
     folder_in_labels='/folder_in_labels',
     folder_out='/folder_out',
     k_nearest_neighbours=5,
     sigma=10.,
     dim=3,
     invalid_label=0,
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_file_in_data=".laz",
     extension_file_in_labels=".labels",
     extension_file_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | point_cloud_filter_label_noise_folder(client,
    |      folder_in_data='/folder_in_data',
    |      folder_in_labels='/folder_in_labels',
    |      folder_out='/folder_out',
    |      k_nearest_neighbours=5,
    |      sigma=10.,
    |      dim=3,
    |      invalid_label=0,
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_folder_in_data=".laz",
    |      extension_folder_in_labels=".labels",
    |      extension_folder_out=".laz",
    |      skip_existing_files = False )

:param k_nearest_neighbours: k nearest neighbours
:param sigma: sigma
:param dim: dim
:param invalid_label: invalid class label
:param folder_in_data: input folder data
:param folder_in_labels: input folder labels
:param folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in_data: File extension of files in folder for folder_in_data
:param extension_folder_in_labels: File extension of files in folder for folder_in_labels
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in_data']
      del all_parameters['folder_in_labels']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in_data']
      del all_parameters['extension_file_in_labels']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in_data,file_in_labels,file_out"
      folders = folder_in_data + "," + folder_in_labels + "," + folder_out
      extensions = extension_file_in_data + "," + extension_file_in_labels + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "point cloud filter label noise" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def tower_displacement(client,
     laz_in_file_new='new.laz',
     laz_in_file_old='old.laz',
     laz_in_file_ref='ref.laz',
     tower_name='',
     year_new='2022',
     year_old='2020',
     year_ref='2018',
     results_out_file='result.txt',
     plots_out_path='plots/',
     instance_type='P2'):
      '''
    | 
    | tower_displacement( client,
    |      laz_in_file_new='new.laz',
    |      laz_in_file_old='old.laz',
    |      laz_in_file_ref='ref.laz',
    |      tower_name='',
    |      year_new='2022',
    |      year_old='2020',
    |      year_ref='2018',
    |      results_out_file='result.txt',
    |      plots_out_path='plots/',
    |      instance_type='P2' )

:param laz_in_file_new: laz input folder new data
:param laz_in_file_old: laz input folder last data
:param laz_in_file_ref: laz input folder first data
:param tower_name: tower name
:param year_new: year of new data
:param year_old: year of old data
:param year_ref: year of reference data
:param results_out_file: result folder path
:param plots_out_path:  result folder path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "tower displacement",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def tower_displacement_folder(client,
     laz_in_folder_new='/laz_in_folder_new',
     laz_in_folder_old='/laz_in_folder_old',
     laz_in_folder_ref='/laz_in_folder_ref',
     tower_name='',
     year_new='2022',
     year_old='2020',
     year_ref='2018',
     results_out_folder='/results_out_folder',
     plots_out_path='plots/',
     worker_instance_type='P2',
     manager_instance_type="small",
     extension_laz_in_file_new=".laz",
     extension_laz_in_file_old=".laz",
     extension_laz_in_file_ref=".laz",
     extension_results_out_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | tower_displacement_folder(client,
    |      laz_in_folder_new='/laz_in_folder_new',
    |      laz_in_folder_old='/laz_in_folder_old',
    |      laz_in_folder_ref='/laz_in_folder_ref',
    |      tower_name='',
    |      year_new='2022',
    |      year_old='2020',
    |      year_ref='2018',
    |      results_out_folder='/results_out_folder',
    |      plots_out_path='plots/',
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      extension_laz_in_folder_new=".laz",
    |      extension_laz_in_folder_old=".laz",
    |      extension_laz_in_folder_ref=".laz",
    |      extension_results_out_folder=".txt",
    |      skip_existing_files = False )

:param tower_name: tower name
:param year_new: year of new data
:param year_old: year of old data
:param year_ref: year of reference data
:param plots_out_path:  result folder path
:param laz_in_folder_new: laz input folder new data
:param laz_in_folder_old: laz input folder last data
:param laz_in_folder_ref: laz input folder first data
:param results_out_folder: result folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_laz_in_folder_new: File extension of files in folder for laz_in_folder_new
:param extension_laz_in_folder_old: File extension of files in folder for laz_in_folder_old
:param extension_laz_in_folder_ref: File extension of files in folder for laz_in_folder_ref
:param extension_results_out_folder: File extension of files in folder for results_out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['laz_in_folder_new']
      del all_parameters['laz_in_folder_old']
      del all_parameters['laz_in_folder_ref']
      del all_parameters['results_out_folder']
      del all_parameters['extension_laz_in_file_new']
      del all_parameters['extension_laz_in_file_old']
      del all_parameters['extension_laz_in_file_ref']
      del all_parameters['extension_results_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "laz_in_file_new,laz_in_file_old,laz_in_file_ref,results_out_file"
      folders = laz_in_folder_new + "," + laz_in_folder_old + "," + laz_in_folder_ref + "," + results_out_folder
      extensions = extension_laz_in_file_new + "," + extension_laz_in_file_old + "," + extension_laz_in_file_ref + "," + extension_results_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "tower displacement" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def merge_and_split_results_csv(client,
     new_tower_path='new_paths.txt',
     last_tower_path='last_paths.txt',
     reference_tower_path='reference_paths.txt',
     results_path_csv='results.csv',
     results_plots_path='results_plots',
     merged_results_path_csv='results/Reports_2023',
     resturctured_plots_path='results/10-Plots-Tragwerke',
     input_file_structure_path='input_file_structure.txt',
     year='2023',
     instance_type='P2'):
      '''[atr] Merge results csv
    | 
    | merge_and_split_results_csv( client,
    |      new_tower_path='new_paths.txt',
    |      last_tower_path='last_paths.txt',
    |      reference_tower_path='reference_paths.txt',
    |      results_path_csv='results.csv',
    |      results_plots_path='results_plots',
    |      merged_results_path_csv='results/Reports_2023',
    |      resturctured_plots_path='results/10-Plots-Tragwerke',
    |      input_file_structure_path='input_file_structure.txt',
    |      year='2023',
    |      instance_type='P2' )

:param new_tower_path:  input new path data
:param last_tower_path:  input last path 
:param reference_tower_path:  input reference path 
:param results_path_csv:  input results.csv path 
:param results_plots_path:  input results_plots path 
:param merged_results_path_csv:  output path 
:param resturctured_plots_path:  output path 
:param input_file_structure_path:  input file structure path 
:param year: year 
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "merge and split results csv",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def merge_and_split_results_csv_folder(client,
     new_tower_path='new_paths.txt',
     last_tower_path='last_paths.txt',
     reference_tower_path='reference_paths.txt',
     results_path_csv='results.csv',
     results_plots_path='results_plots',
     merged_results_path_csv='results/Reports_2023',
     resturctured_plots_path='results/10-Plots-Tragwerke',
     input_file_structure_path='input_file_structure.txt',
     year='2023',
     worker_instance_type='P2',
     manager_instance_type="small",
     skip_existing_files = False):
      '''[atr] Merge results csv
    | 
    | merge_and_split_results_csv_folder(client,
    |      new_tower_path='new_paths.txt',
    |      last_tower_path='last_paths.txt',
    |      reference_tower_path='reference_paths.txt',
    |      results_path_csv='results.csv',
    |      results_plots_path='results_plots',
    |      merged_results_path_csv='results/Reports_2023',
    |      resturctured_plots_path='results/10-Plots-Tragwerke',
    |      input_file_structure_path='input_file_structure.txt',
    |      year='2023',
    |      worker_instance_type='P2',
    |      manager_instance_type="small",
    |      skip_existing_files = False )

:param new_tower_path:  input new path data
:param last_tower_path:  input last path 
:param reference_tower_path:  input reference path 
:param results_path_csv:  input results.csv path 
:param results_plots_path:  input results_plots path 
:param merged_results_path_csv:  output path 
:param resturctured_plots_path:  output path 
:param input_file_structure_path:  input file structure path 
:param year: year 
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']


      cmd_str = json.dumps(all_parameters)
      parameters = ""
      folders = ""
      extensions = ""
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "merge and split results csv" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class ops3d:
   def uniform_downsampling(client,
     file_in='in.laz',
     file_out='out.laz',
     k=3,
     dtype='',
     instance_type='x2large'):
      '''
    | 
    | uniform_downsampling( client,
    |      file_in='in.laz',
    |      file_out='out.laz',
    |      k=3,
    |      dtype='',
    |      instance_type='x2large' )

:param file_in: input folder data
:param file_out: output folder
:param k: k
:param dtype: values from point cloud, e.g. X,Y,Z
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "uniform downsampling",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def uniform_downsampling_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     k=3,
     dtype='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".laz",
     extension_file_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | uniform_downsampling_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      k=3,
    |      dtype='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".laz",
    |      extension_folder_out=".laz",
    |      skip_existing_files = False )

:param k: k
:param dtype: values from point cloud, e.g. X,Y,Z
:param folder_in: input folder data
:param folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "uniform downsampling" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def make_laz_from_values(client,
     file_values_in='values.npy',
     file_points_out='points.laz',
     dtype='X,Y,Z',
     scale='0.01,0.01,0.01',
     point_format=7,
     instance_type='x2large'):
      '''
    | 
    | make_laz_from_values( client,
    |      file_values_in='values.npy',
    |      file_points_out='points.laz',
    |      dtype='X,Y,Z',
    |      scale='0.01,0.01,0.01',
    |      point_format=7,
    |      instance_type='x2large' )

:param file_values_in: input folder data
:param file_points_out: output folder
:param dtype: data channels
:param scale: scale value
:param point_format: point format
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "make laz from values",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def make_laz_from_values_folder(client,
     folder_values_in='/folder_values_in',
     folder_points_out='/folder_points_out',
     dtype='X,Y,Z',
     scale='0.01,0.01,0.01',
     point_format=7,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values_in=".npy",
     extension_file_points_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | make_laz_from_values_folder(client,
    |      folder_values_in='/folder_values_in',
    |      folder_points_out='/folder_points_out',
    |      dtype='X,Y,Z',
    |      scale='0.01,0.01,0.01',
    |      point_format=7,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values_in=".npy",
    |      extension_folder_points_out=".laz",
    |      skip_existing_files = False )

:param dtype: data channels
:param scale: scale value
:param point_format: point format
:param folder_values_in: input folder data
:param folder_points_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values_in: File extension of files in folder for folder_values_in
:param extension_folder_points_out: File extension of files in folder for folder_points_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values_in']
      del all_parameters['folder_points_out']
      del all_parameters['extension_file_values_in']
      del all_parameters['extension_file_points_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values_in,file_points_out"
      folders = folder_values_in + "," + folder_points_out
      extensions = extension_file_values_in + "," + extension_file_points_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "make laz from values" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def get_bounding_box(client,
     in_file='simple.laz',
     dimension=3,
     out_file='bounding_box.npy',
     instance_type='x2large'):
      '''Get bounding box from las or laz file
    | 
    | get_bounding_box( client,
    |      in_file='simple.laz',
    |      dimension=3,
    |      out_file='bounding_box.npy',
    |      instance_type='x2large' )

:param in_file: Input .laz file path
:param dimension: Dimension of the point cloud
:param out_file: Output bounding box file path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "get bounding box",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def get_bounding_box_folder(client,
     in_folder='/in_folder',
     dimension=3,
     out_folder='/out_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".laz",
     extension_out_file=".npy",
     skip_existing_files = False):
      '''Get bounding box from las or laz file
    | 
    | get_bounding_box_folder(client,
    |      in_folder='/in_folder',
    |      dimension=3,
    |      out_folder='/out_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".laz",
    |      extension_out_folder=".npy",
    |      skip_existing_files = False )

:param dimension: Dimension of the point cloud
:param in_folder: Input .laz folder folder
:param out_folder: Output bounding box folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "get bounding box" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def iterative_outlier_removal(client,
     folder_in='segmented_object',
     folder_out='iterative_outlier_removal',
     decay_factor=0.98,
     iteration_count=10,
     max_num_processes=0,
     instance_type='x2large'):
      '''
    | 
    | iterative_outlier_removal( client,
    |      folder_in='segmented_object',
    |      folder_out='iterative_outlier_removal',
    |      decay_factor=0.98,
    |      iteration_count=10,
    |      max_num_processes=0,
    |      instance_type='x2large' )

:param folder_in: input folder
:param folder_out: output folder
:param decay_factor: maximum quantile
:param iteration_count: minimum quantile
:param max_num_processes: Number of parallel processes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "iterative outlier removal",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def iterative_outlier_removal_folder(client,
     folder_folder_in='/folder_folder_in',
     folder_folder_out='/folder_folder_out',
     decay_factor=0.98,
     iteration_count=10,
     max_num_processes=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder_in=".laz",
     extension_folder_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | iterative_outlier_removal_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      decay_factor=0.98,
    |      iteration_count=10,
    |      max_num_processes=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".segmented_object",
    |      extension_folder_out=".iterative_outlier_removal",
    |      skip_existing_files = False )

:param decay_factor: maximum quantile
:param iteration_count: minimum quantile
:param max_num_processes: Number of parallel processes
:param folder_folder_in: input folder
:param folder_folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_folder_in
:param extension_folder_out: File extension of files in folder for folder_folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder_in']
      del all_parameters['folder_folder_out']
      del all_parameters['extension_folder_in']
      del all_parameters['extension_folder_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder_in,folder_out"
      folders = folder_folder_in + "," + folder_folder_out
      extensions = extension_folder_in + "," + extension_folder_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "iterative outlier removal" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_and_merge_polygons(client,
     point_cloud_files='points.laz',
     polygon_file='polygon.pickle',
     output_file='cropped.laz',
     instance_type='x2large'):
      '''
    | 
    | crop_and_merge_polygons( client,
    |      point_cloud_files='points.laz',
    |      polygon_file='polygon.pickle',
    |      output_file='cropped.laz',
    |      instance_type='x2large' )

:param point_cloud_files: Input file path for the point clouds
:param polygon_file: Input file path for the polygon (pickle)
:param output_file: Output file path for the cropped point cloud
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "crop and merge polygons",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_and_merge_polygons_folder(client,
     point_cloud_folders='/point_cloud_folders',
     polygon_folder='/polygon_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_point_cloud_files=".laz",
     extension_polygon_file=".pickle",
     extension_output_file=".laz",
     skip_existing_files = False):
      '''
    | 
    | crop_and_merge_polygons_folder(client,
    |      point_cloud_folders='/point_cloud_folders',
    |      polygon_folder='/polygon_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_point_cloud_folders=".laz",
    |      extension_polygon_folder=".pickle",
    |      extension_output_folder=".laz",
    |      skip_existing_files = False )

:param point_cloud_folders: Input folder folder for the point clouds
:param polygon_folder: Input folder folder for the polygon (pickle)
:param output_folder: Output folder folder for the cropped point cloud
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_point_cloud_folders: File extension of files in folder for point_cloud_folders
:param extension_polygon_folder: File extension of files in folder for polygon_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['point_cloud_folders']
      del all_parameters['polygon_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_point_cloud_files']
      del all_parameters['extension_polygon_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "point_cloud_files,polygon_file,output_file"
      folders = point_cloud_folders + "," + polygon_folder + "," + output_folder
      extensions = extension_point_cloud_files + "," + extension_polygon_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "crop and merge polygons" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def get_point_values(client,
     file_source_in='file.laz',
     file_labels_out='values.txt',
     dtype='classification',
     decomposed_labels='True',
     instance_type='x2large'):
      '''
    | 
    | get_point_values( client,
    |      file_source_in='file.laz',
    |      file_labels_out='values.txt',
    |      dtype='classification',
    |      decomposed_labels='True',
    |      instance_type='x2large' )

:param file_source_in: input file [.laz or .las]
:param file_labels_out: output file [.txt or .npy]
:param dtype: type
:param decomposed_labels: type
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "get point values",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def get_point_values_folder(client,
     folder_source_in='/folder_source_in',
     folder_labels_out='/folder_labels_out',
     dtype='classification',
     decomposed_labels='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_source_in=".laz",
     extension_file_labels_out=".txt",
     skip_existing_files = False):
      '''
    | 
    | get_point_values_folder(client,
    |      folder_source_in='/folder_source_in',
    |      folder_labels_out='/folder_labels_out',
    |      dtype='classification',
    |      decomposed_labels='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_source_in=".laz",
    |      extension_folder_labels_out=".txt",
    |      skip_existing_files = False )

:param dtype: type
:param decomposed_labels: type
:param folder_source_in: input folder [.laz or .las]
:param folder_labels_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_source_in: File extension of files in folder for folder_source_in
:param extension_folder_labels_out: File extension of files in folder for folder_labels_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_source_in']
      del all_parameters['folder_labels_out']
      del all_parameters['extension_file_source_in']
      del all_parameters['extension_file_labels_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_source_in,file_labels_out"
      folders = folder_source_in + "," + folder_labels_out
      extensions = extension_file_source_in + "," + extension_file_labels_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "get point values" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def density_based_clustering(client,
     filename='in.laz',
     cluster_id_filename='out.npy',
     cluster_centers_filename='out.laz',
     wireframe_filename='wireframe.npy',
     epsilon=0.25,
     min_samples=0,
     dim=3,
     wireframe='False',
     instance_type='x2large'):
      '''Density-based Point Cloud Clustering
    | 
    | density_based_clustering( client,
    |      filename='in.laz',
    |      cluster_id_filename='out.npy',
    |      cluster_centers_filename='out.laz',
    |      wireframe_filename='wireframe.npy',
    |      epsilon=0.25,
    |      min_samples=0,
    |      dim=3,
    |      wireframe='False',
    |      instance_type='x2large' )

:param filename: Input .laz file path
:param cluster_id_filename: Output cluster IDs file path
:param cluster_centers_filename: Output cluster centers .laz file path
:param wireframe_filename: Output wireframe connections file path
:param epsilon: DBSCAN epsilon
:param min_samples: DBSCAN min_samples
:param dim: Point dimension
:param wireframe: Whether to compute wireframe connections
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "density based clustering",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def density_based_clustering_folder(client,
     foldername='/foldername',
     cluster_id_foldername='/cluster_id_foldername',
     cluster_centers_foldername='/cluster_centers_foldername',
     wireframe_foldername='/wireframe_foldername',
     epsilon=0.25,
     min_samples=0,
     dim=3,
     wireframe='False',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_filename=".laz",
     extension_cluster_id_filename=".npy",
     extension_cluster_centers_filename=".laz",
     extension_wireframe_filename=".npy",
     skip_existing_files = False):
      '''Density-based Point Cloud Clustering
    | 
    | density_based_clustering_folder(client,
    |      foldername='/foldername',
    |      cluster_id_foldername='/cluster_id_foldername',
    |      cluster_centers_foldername='/cluster_centers_foldername',
    |      wireframe_foldername='/wireframe_foldername',
    |      epsilon=0.25,
    |      min_samples=0,
    |      dim=3,
    |      wireframe='False',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_foldername=".laz",
    |      extension_cluster_id_foldername=".npy",
    |      extension_cluster_centers_foldername=".laz",
    |      extension_wireframe_foldername=".npy",
    |      skip_existing_files = False )

:param epsilon: DBSCAN epsilon
:param min_samples: DBSCAN min_samples
:param dim: Point dimension
:param wireframe: Whether to compute wireframe connections
:param foldername: Input .laz folder folder
:param cluster_id_foldername: Output cluster IDs folder folder
:param cluster_centers_foldername: Output cluster centers .laz folder folder
:param wireframe_foldername: Output wireframe connections folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_foldername: File extension of files in folder for foldername
:param extension_cluster_id_foldername: File extension of files in folder for cluster_id_foldername
:param extension_cluster_centers_foldername: File extension of files in folder for cluster_centers_foldername
:param extension_wireframe_foldername: File extension of files in folder for wireframe_foldername
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['foldername']
      del all_parameters['cluster_id_foldername']
      del all_parameters['cluster_centers_foldername']
      del all_parameters['wireframe_foldername']
      del all_parameters['extension_filename']
      del all_parameters['extension_cluster_id_filename']
      del all_parameters['extension_cluster_centers_filename']
      del all_parameters['extension_wireframe_filename']

      cmd_str = json.dumps(all_parameters)
      parameters = "filename,cluster_id_filename,cluster_centers_filename,wireframe_filename"
      folders = foldername + "," + cluster_id_foldername + "," + cluster_centers_foldername + "," + wireframe_foldername
      extensions = extension_filename + "," + extension_cluster_id_filename + "," + extension_cluster_centers_filename + "," + extension_wireframe_filename
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "density based clustering" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_point_cloud_to_grid(client,
     in_path_points='in1.laz,in2.laz',
     in_path_grids='grid1.npy,grid2.npy,grid3.npy',
     out_path_points='out.laz,out2.laz',
     instance_type='x2large'):
      '''retile point clouds to grid
    | 
    | retile_point_cloud_to_grid( client,
    |      in_path_points='in1.laz,in2.laz',
    |      in_path_grids='grid1.npy,grid2.npy,grid3.npy',
    |      out_path_points='out.laz,out2.laz',
    |      instance_type='x2large' )

:param in_path_points: Output path for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
:param in_path_grids:  Output path for mapping that contains the tiles that are generated from point cloud x
:param out_path_points:  Output path to retiled point clouds
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "retile point cloud to grid",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_point_cloud_to_grid_folder(client,
     in_folder_points='/in_folder_points',
     in_path_grids='grid1.npy,grid2.npy,grid3.npy',
     out_path_points='out.laz,out2.laz',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_path_points=".laz",
     skip_existing_files = False):
      '''retile point clouds to grid
    | 
    | retile_point_cloud_to_grid_folder(client,
    |      in_folder_points='/in_folder_points',
    |      in_path_grids='grid1.npy,grid2.npy,grid3.npy',
    |      out_path_points='out.laz,out2.laz',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder_points=".laz",
    |      skip_existing_files = False )

:param in_path_grids:  Output path for mapping that contains the tiles that are generated from point cloud x
:param out_path_points:  Output path to retiled point clouds
:param in_folder_points: Output folder for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder_points: File extension of files in folder for in_folder_points
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder_points']
      del all_parameters['extension_in_path_points']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_path_points"
      folders = in_folder_points
      extensions = extension_in_path_points
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "retile point cloud to grid" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def make_line_model_from_points(client,
     folder_in='segmented_object',
     folder_out='vobject_coordinates3D',
     dim=3,
     max_num_processes=0,
     instance_type='x2large'):
      '''
    | 
    | make_line_model_from_points( client,
    |      folder_in='segmented_object',
    |      folder_out='vobject_coordinates3D',
    |      dim=3,
    |      max_num_processes=0,
    |      instance_type='x2large' )

:param folder_in: input folder data
:param folder_out: output folder
:param dim: dimension
:param max_num_processes: maximum number of processes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "make line model from points",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def make_line_model_from_points_folder(client,
     folder_folder_in='/folder_folder_in',
     folder_folder_out='/folder_folder_out',
     dim=3,
     max_num_processes=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder_in=".laz",
     extension_folder_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | make_line_model_from_points_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      dim=3,
    |      max_num_processes=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".segmented_object",
    |      extension_folder_out=".vobject_coordinates3D",
    |      skip_existing_files = False )

:param dim: dimension
:param max_num_processes: maximum number of processes
:param folder_folder_in: input folder data
:param folder_folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_folder_in
:param extension_folder_out: File extension of files in folder for folder_folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder_in']
      del all_parameters['folder_folder_out']
      del all_parameters['extension_folder_in']
      del all_parameters['extension_folder_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder_in,folder_out"
      folders = folder_folder_in + "," + folder_folder_out
      extensions = extension_folder_in + "," + extension_folder_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "make line model from points" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def fit_line_model(client,
     folder_in='segmented_object',
     folder_out='fit_line_model',
     residual_threshold=30.05,
     min_samples=2,
     max_trials=1,
     max_dim=3,
     max_num_processes=0,
     instance_type='x2large'):
      '''
    | 
    | fit_line_model( client,
    |      folder_in='segmented_object',
    |      folder_out='fit_line_model',
    |      residual_threshold=30.05,
    |      min_samples=2,
    |      max_trials=1,
    |      max_dim=3,
    |      max_num_processes=0,
    |      instance_type='x2large' )

:param folder_in: input folder
:param folder_out: output folder
:param residual_threshold: maximum quantile
:param min_samples: minimum quantile
:param max_trials: maximum number of trials
:param max_dim: max_dim 0: x, 1: y, 3: z
:param max_num_processes: Number of parallel processes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "fit line model",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def fit_line_model_folder(client,
     folder_folder_in='/folder_folder_in',
     folder_folder_out='/folder_folder_out',
     residual_threshold=30.05,
     min_samples=2,
     max_trials=1,
     max_dim=3,
     max_num_processes=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder_in=".laz",
     extension_folder_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | fit_line_model_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      residual_threshold=30.05,
    |      min_samples=2,
    |      max_trials=1,
    |      max_dim=3,
    |      max_num_processes=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".segmented_object",
    |      extension_folder_out=".fit_line_model",
    |      skip_existing_files = False )

:param residual_threshold: maximum quantile
:param min_samples: minimum quantile
:param max_trials: maximum number of trials
:param max_dim: max_dim 0: x, 1: y, 3: z
:param max_num_processes: Number of parallel processes
:param folder_folder_in: input folder
:param folder_folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_folder_in
:param extension_folder_out: File extension of files in folder for folder_folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder_in']
      del all_parameters['folder_folder_out']
      del all_parameters['extension_folder_in']
      del all_parameters['extension_folder_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder_in,folder_out"
      folders = folder_folder_in + "," + folder_folder_out
      extensions = extension_folder_in + "," + extension_folder_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "fit line model" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def iterative_closest_point(client,
     file_source_in='object1.laz',
     file_target_in='object2.laz',
     file_source_out='registered.laz',
     file_trafo_out='registered_trafo.txt',
     metric='point2point',
     threshold=0.2,
     max_correspondences=5,
     instance_type='x2large'):
      '''
    | 
    | iterative_closest_point( client,
    |      file_source_in='object1.laz',
    |      file_target_in='object2.laz',
    |      file_source_out='registered.laz',
    |      file_trafo_out='registered_trafo.txt',
    |      metric='point2point',
    |      threshold=0.2,
    |      max_correspondences=5,
    |      instance_type='x2large' )

:param file_source_in: input source file
:param file_target_in: input target file
:param file_source_out: output file
:param file_trafo_out: output transformation
:param metric: [max, min, same]: same value range relative to maximum point [max], relative to minimum point [min] or absolute coordinates [same]
:param threshold: threshold to crop values
:param max_correspondences: threshold max nearest neighbours
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "iterative closest point",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def iterative_closest_point_folder(client,
     folder_source_in='/folder_source_in',
     folder_target_in='/folder_target_in',
     folder_source_out='/folder_source_out',
     folder_trafo_out='/folder_trafo_out',
     metric='point2point',
     threshold=0.2,
     max_correspondences=5,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_source_in=".laz",
     extension_file_target_in=".laz",
     extension_file_source_out=".laz",
     extension_file_trafo_out=".txt",
     skip_existing_files = False):
      '''
    | 
    | iterative_closest_point_folder(client,
    |      folder_source_in='/folder_source_in',
    |      folder_target_in='/folder_target_in',
    |      folder_source_out='/folder_source_out',
    |      folder_trafo_out='/folder_trafo_out',
    |      metric='point2point',
    |      threshold=0.2,
    |      max_correspondences=5,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_source_in=".laz",
    |      extension_folder_target_in=".laz",
    |      extension_folder_source_out=".laz",
    |      extension_folder_trafo_out=".txt",
    |      skip_existing_files = False )

:param metric: [max, min, same]: same value range relative to maximum point [max], relative to minimum point [min] or absolute coordinates [same]
:param threshold: threshold to crop values
:param max_correspondences: threshold max nearest neighbours
:param folder_source_in: input source folder
:param folder_target_in: input target folder
:param folder_source_out: output folder
:param folder_trafo_out: output transformation
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_source_in: File extension of files in folder for folder_source_in
:param extension_folder_target_in: File extension of files in folder for folder_target_in
:param extension_folder_source_out: File extension of files in folder for folder_source_out
:param extension_folder_trafo_out: File extension of files in folder for folder_trafo_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_source_in']
      del all_parameters['folder_target_in']
      del all_parameters['folder_source_out']
      del all_parameters['folder_trafo_out']
      del all_parameters['extension_file_source_in']
      del all_parameters['extension_file_target_in']
      del all_parameters['extension_file_source_out']
      del all_parameters['extension_file_trafo_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_source_in,file_target_in,file_source_out,file_trafo_out"
      folders = folder_source_in + "," + folder_target_in + "," + folder_source_out + "," + folder_trafo_out
      extensions = extension_file_source_in + "," + extension_file_target_in + "," + extension_file_source_out + "," + extension_file_trafo_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "iterative closest point" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_points_to_polygon(client,
     in_points_file='points.laz',
     in_polygon_file='polygon.pickle',
     out_file='cropped.laz',
     instance_type='x2large'):
      '''
    | 
    | crop_points_to_polygon( client,
    |      in_points_file='points.laz',
    |      in_polygon_file='polygon.pickle',
    |      out_file='cropped.laz',
    |      instance_type='x2large' )

:param in_points_file: Input file path for the point cloud
:param in_polygon_file: Input file path for the polygon (pickle)
:param out_file: Output file path for the cropped point cloud
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "crop points to polygon",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_points_to_polygon_folder(client,
     in_points_folder='/in_points_folder',
     in_polygon_folder='/in_polygon_folder',
     out_folder='/out_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_points_file=".laz",
     extension_in_polygon_file=".pickle",
     extension_out_file=".laz",
     skip_existing_files = False):
      '''
    | 
    | crop_points_to_polygon_folder(client,
    |      in_points_folder='/in_points_folder',
    |      in_polygon_folder='/in_polygon_folder',
    |      out_folder='/out_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_points_folder=".laz",
    |      extension_in_polygon_folder=".pickle",
    |      extension_out_folder=".laz",
    |      skip_existing_files = False )

:param in_points_folder: Input folder folder for the point cloud
:param in_polygon_folder: Input folder folder for the polygon (pickle)
:param out_folder: Output folder folder for the cropped point cloud
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_points_folder: File extension of files in folder for in_points_folder
:param extension_in_polygon_folder: File extension of files in folder for in_polygon_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_points_folder']
      del all_parameters['in_polygon_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_points_file']
      del all_parameters['extension_in_polygon_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_points_file,in_polygon_file,out_file"
      folders = in_points_folder + "," + in_polygon_folder + "," + out_folder
      extensions = extension_in_points_file + "," + extension_in_polygon_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "crop points to polygon" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_grid_to_point_cloud(client,
     in_path_grid='point_cloud_grid',
     in_path_mapping='file_mapping.txt',
     out_path_points='out.laz',
     instance_type='x2large'):
      '''retile point clouds to grid
    | 
    | retile_grid_to_point_cloud( client,
    |      in_path_grid='point_cloud_grid',
    |      in_path_mapping='file_mapping.txt',
    |      out_path_points='out.laz',
    |      instance_type='x2large' )

:param in_path_grid:  folder that contains the retiled point clouds
:param in_path_mapping: Mapping that specifies, which point clouds of the grid intersect with the original point cloud
:param out_path_points: Output path for the merged point cloud
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "retile grid to point cloud",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_grid_to_point_cloud_folder(client,
     in_path_grid='point_cloud_grid',
     in_folder_mapping='/in_folder_mapping',
     out_folder_points='/out_folder_points',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_path_mapping=".txt",
     extension_out_path_points=".laz",
     skip_existing_files = False):
      '''retile point clouds to grid
    | 
    | retile_grid_to_point_cloud_folder(client,
    |      in_path_grid='point_cloud_grid',
    |      in_folder_mapping='/in_folder_mapping',
    |      out_folder_points='/out_folder_points',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder_mapping=".txt",
    |      extension_out_folder_points=".laz",
    |      skip_existing_files = False )

:param in_path_grid:  folder that contains the retiled point clouds
:param in_folder_mapping: Mapping that specifies, which point clouds of the grid intersect with the original point cloud
:param out_folder_points: Output folder for the merged point cloud
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder_mapping: File extension of files in folder for in_folder_mapping
:param extension_out_folder_points: File extension of files in folder for out_folder_points
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder_mapping']
      del all_parameters['out_folder_points']
      del all_parameters['extension_in_path_mapping']
      del all_parameters['extension_out_path_points']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_path_mapping,out_path_points"
      folders = in_folder_mapping + "," + out_folder_points
      extensions = extension_in_path_mapping + "," + extension_out_path_points
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "retile grid to point cloud" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def filter_label_noise(client,
     file_in_data='file.laz',
     file_in_labels='file.labels',
     file_out='result.laz',
     k_nearest_neighbours=5,
     sigma=10.,
     dim=3,
     invalid_label=0,
     instance_type='x2large'):
      '''
    | 
    | filter_label_noise( client,
    |      file_in_data='file.laz',
    |      file_in_labels='file.labels',
    |      file_out='result.laz',
    |      k_nearest_neighbours=5,
    |      sigma=10.,
    |      dim=3,
    |      invalid_label=0,
    |      instance_type='x2large' )

:param file_in_data: input file data
:param file_in_labels: input file labels
:param file_out: output file
:param k_nearest_neighbours: k nearest neighbours
:param sigma: sigma
:param dim: dim
:param invalid_label: invalid class label
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "filter label noise",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def filter_label_noise_folder(client,
     folder_in_data='/folder_in_data',
     folder_in_labels='/folder_in_labels',
     folder_out='/folder_out',
     k_nearest_neighbours=5,
     sigma=10.,
     dim=3,
     invalid_label=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in_data=".laz",
     extension_file_in_labels=".labels",
     extension_file_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | filter_label_noise_folder(client,
    |      folder_in_data='/folder_in_data',
    |      folder_in_labels='/folder_in_labels',
    |      folder_out='/folder_out',
    |      k_nearest_neighbours=5,
    |      sigma=10.,
    |      dim=3,
    |      invalid_label=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in_data=".laz",
    |      extension_folder_in_labels=".labels",
    |      extension_folder_out=".laz",
    |      skip_existing_files = False )

:param k_nearest_neighbours: k nearest neighbours
:param sigma: sigma
:param dim: dim
:param invalid_label: invalid class label
:param folder_in_data: input folder data
:param folder_in_labels: input folder labels
:param folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in_data: File extension of files in folder for folder_in_data
:param extension_folder_in_labels: File extension of files in folder for folder_in_labels
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in_data']
      del all_parameters['folder_in_labels']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in_data']
      del all_parameters['extension_file_in_labels']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in_data,file_in_labels,file_out"
      folders = folder_in_data + "," + folder_in_labels + "," + folder_out
      extensions = extension_file_in_data + "," + extension_file_in_labels + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "filter label noise" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_circle(client,
     in_file='file.laz',
     out_file='cropped.laz',
     latitude=1,
     longitude=1,
     lat_lon_file='lat_lon.laz',
     radius=75,
     cols='',
     max_num_processes=0,
     instance_type='x2large'):
      '''
    | 
    | crop_circle( client,
    |      in_file='file.laz',
    |      out_file='cropped.laz',
    |      latitude=1,
    |      longitude=1,
    |      lat_lon_file='lat_lon.laz',
    |      radius=75,
    |      cols='',
    |      max_num_processes=0,
    |      instance_type='x2large' )

:param in_file: input file
:param out_file: output file
:param latitude: latitude
:param longitude: longitude
:param lat_lon_file: (optional) file with lat lon coordinates
:param radius: radius for cropping
:param cols: columns to be used, leave empty for all
:param max_num_processes: maximum number of processes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "crop circle",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_circle_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     latitude=1,
     longitude=1,
     lat_lon_folder='/lat_lon_folder',
     radius=75,
     cols='',
     max_num_processes=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".laz",
     extension_out_file=".laz",
     extension_lat_lon_file=".laz",
     skip_existing_files = False):
      '''
    | 
    | crop_circle_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      latitude=1,
    |      longitude=1,
    |      lat_lon_folder='/lat_lon_folder',
    |      radius=75,
    |      cols='',
    |      max_num_processes=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".laz",
    |      extension_out_folder=".laz",
    |      extension_lat_lon_folder=".laz",
    |      skip_existing_files = False )

:param latitude: latitude
:param longitude: longitude
:param radius: radius for cropping
:param cols: columns to be used, leave empty for all
:param max_num_processes: maximum number of processes
:param in_folder: input folder
:param out_folder: output folder
:param lat_lon_folder: (optional) folder with lat lon coordinates
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param extension_lat_lon_folder: File extension of files in folder for lat_lon_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['lat_lon_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']
      del all_parameters['extension_lat_lon_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file,lat_lon_file"
      folders = in_folder + "," + out_folder + "," + lat_lon_folder
      extensions = extension_in_file + "," + extension_out_file + "," + extension_lat_lon_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "crop circle" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_points_by_value(client,
     file_source_in='segmented_object',
     min_value=1,
     max_value=1,
     attribute='classification',
     file_source_out='aligned_points',
     keep_empty='True',
     instance_type='x2large'):
      '''Selects points by value of attribute
    | 
    | select_points_by_value( client,
    |      file_source_in='segmented_object',
    |      min_value=1,
    |      max_value=1,
    |      attribute='classification',
    |      file_source_out='aligned_points',
    |      keep_empty='True',
    |      instance_type='x2large' )

:param file_source_in: input file data
:param min_value: minimum value
:param max_value: maximum value
:param attribute: feature for selection
:param file_source_out: output file
:param keep_empty: save empty files
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "select points by value",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_points_by_value_folder(client,
     folder_source_in='/folder_source_in',
     min_value=1,
     max_value=1,
     attribute='classification',
     folder_source_out='/folder_source_out',
     keep_empty='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_source_in=".laz",
     extension_file_source_out=".laz",
     skip_existing_files = False):
      '''Selects points by value of attribute
    | 
    | select_points_by_value_folder(client,
    |      folder_source_in='/folder_source_in',
    |      min_value=1,
    |      max_value=1,
    |      attribute='classification',
    |      folder_source_out='/folder_source_out',
    |      keep_empty='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_source_in=".segmented_object",
    |      extension_folder_source_out=".aligned_points",
    |      skip_existing_files = False )

:param min_value: minimum value
:param max_value: maximum value
:param attribute: feature for selection
:param keep_empty: save empty files
:param folder_source_in: input folder data
:param folder_source_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_source_in: File extension of files in folder for folder_source_in
:param extension_folder_source_out: File extension of files in folder for folder_source_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_source_in']
      del all_parameters['folder_source_out']
      del all_parameters['extension_file_source_in']
      del all_parameters['extension_file_source_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_source_in,file_source_out"
      folders = folder_source_in + "," + folder_source_out
      extensions = extension_file_source_in + "," + extension_file_source_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "select points by value" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def uniform_down_sampling_voxel(client,
     input_file='in.laz',
     cols='',
     output_file='out.laz',
     voxel_size=0.05,
     instance_type='x2large'):
      '''Uniform down sampling of point cloud using voxel grids
    | 
    | uniform_down_sampling_voxel( client,
    |      input_file='in.laz',
    |      cols='',
    |      output_file='out.laz',
    |      voxel_size=0.05,
    |      instance_type='x2large' )

:param input_file: Input point cloud file
:param cols: Columns to read from input file, default is all columns
:param output_file: Output point cloud file
:param voxel_size: voxel size
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "uniform down sampling voxel",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def uniform_down_sampling_voxel_folder(client,
     input_folder='/input_folder',
     cols='',
     output_folder='/output_folder',
     voxel_size=0.05,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_output_file=".laz",
     skip_existing_files = False):
      '''Uniform down sampling of point cloud using voxel grids
    | 
    | uniform_down_sampling_voxel_folder(client,
    |      input_folder='/input_folder',
    |      cols='',
    |      output_folder='/output_folder',
    |      voxel_size=0.05,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_output_folder=".laz",
    |      skip_existing_files = False )

:param cols: Columns to read from input file, default is all columns
:param voxel_size: voxel size
:param input_folder: Input point cloud folder
:param output_folder: Output point cloud folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "uniform down sampling voxel" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def filter_label_disagreement_knn(client,
     file_points_in='file1.laz',
     file_labels_in='file2.npy',
     file_label_disagrement_in='values.npy',
     file_label_disagrement_out='values.npy',
     distance=2,
     classes_to_compare='2',
     comparison_type='2',
     class_to_filter=1,
     dim_data=3,
     knn=2,
     comparison_axis=-1,
     invalid_label=0,
     instance_type='x2large'):
      '''
    | 
    | filter_label_disagreement_knn( client,
    |      file_points_in='file1.laz',
    |      file_labels_in='file2.npy',
    |      file_label_disagrement_in='values.npy',
    |      file_label_disagrement_out='values.npy',
    |      distance=2,
    |      classes_to_compare='2',
    |      comparison_type='2',
    |      class_to_filter=1,
    |      dim_data=3,
    |      knn=2,
    |      comparison_axis=-1,
    |      invalid_label=0,
    |      instance_type='x2large' )

:param file_points_in: input file [.laz or .las]
:param file_labels_in: input file [.txt or .npy]
:param file_label_disagrement_in: input file[.txt or .npy]
:param file_label_disagrement_out: output file [.txt or .npy]
:param distance: distance threshold
:param classes_to_compare: classes to compare, comma separated
:param comparison_type: [ge: greater equal, le: less equal]
:param class_to_filter: class to filter
:param dim_data: Dimensions to use: 3: x,y,z; 2: x, y
:param knn: k-nearest-neighbours
:param comparison_axis: axis to compare: -1: eucledian distance; 0, 1 or 2: distance along x, y or z axis
:param invalid_label: invalid label
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "filter label disagreement knn",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def filter_label_disagreement_knn_folder(client,
     folder_points_in='/folder_points_in',
     folder_labels_in='/folder_labels_in',
     folder_label_disagrement_in='/folder_label_disagrement_in',
     folder_label_disagrement_out='/folder_label_disagrement_out',
     distance=2,
     classes_to_compare='2',
     comparison_type='2',
     class_to_filter=1,
     dim_data=3,
     knn=2,
     comparison_axis=-1,
     invalid_label=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_points_in=".laz",
     extension_file_labels_in=".npy",
     extension_file_label_disagrement_in=".npy",
     extension_file_label_disagrement_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | filter_label_disagreement_knn_folder(client,
    |      folder_points_in='/folder_points_in',
    |      folder_labels_in='/folder_labels_in',
    |      folder_label_disagrement_in='/folder_label_disagrement_in',
    |      folder_label_disagrement_out='/folder_label_disagrement_out',
    |      distance=2,
    |      classes_to_compare='2',
    |      comparison_type='2',
    |      class_to_filter=1,
    |      dim_data=3,
    |      knn=2,
    |      comparison_axis=-1,
    |      invalid_label=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_points_in=".laz",
    |      extension_folder_labels_in=".npy",
    |      extension_folder_label_disagrement_in=".npy",
    |      extension_folder_label_disagrement_out=".npy",
    |      skip_existing_files = False )

:param distance: distance threshold
:param classes_to_compare: classes to compare, comma separated
:param comparison_type: [ge: greater equal, le: less equal]
:param class_to_filter: class to filter
:param dim_data: Dimensions to use: 3: x,y,z; 2: x, y
:param knn: k-nearest-neighbours
:param comparison_axis: axis to compare: -1: eucledian distance; 0, 1 or 2: distance along x, y or z axis
:param invalid_label: invalid label
:param folder_points_in: input folder [.laz or .las]
:param folder_labels_in: input folder [.txt or .npy]
:param folder_label_disagrement_in: input folder[.txt or .npy]
:param folder_label_disagrement_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_points_in: File extension of files in folder for folder_points_in
:param extension_folder_labels_in: File extension of files in folder for folder_labels_in
:param extension_folder_label_disagrement_in: File extension of files in folder for folder_label_disagrement_in
:param extension_folder_label_disagrement_out: File extension of files in folder for folder_label_disagrement_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_points_in']
      del all_parameters['folder_labels_in']
      del all_parameters['folder_label_disagrement_in']
      del all_parameters['folder_label_disagrement_out']
      del all_parameters['extension_file_points_in']
      del all_parameters['extension_file_labels_in']
      del all_parameters['extension_file_label_disagrement_in']
      del all_parameters['extension_file_label_disagrement_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_points_in,file_labels_in,file_label_disagrement_in,file_label_disagrement_out"
      folders = folder_points_in + "," + folder_labels_in + "," + folder_label_disagrement_in + "," + folder_label_disagrement_out
      extensions = extension_file_points_in + "," + extension_file_labels_in + "," + extension_file_label_disagrement_in + "," + extension_file_label_disagrement_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "filter label disagreement knn" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def assign_point_labels(client,
     file_source_in='segmented_object.laz',
     file_labels_in='labels.npy',
     file_source_out='aligned_points.laz',
     dtype='classification',
     all_type='',
     instance_type='x2large'):
      '''
    | 
    | assign_point_labels( client,
    |      file_source_in='segmented_object.laz',
    |      file_labels_in='labels.npy',
    |      file_source_out='aligned_points.laz',
    |      dtype='classification',
    |      all_type='',
    |      instance_type='x2large' )

:param file_source_in: input folder data
:param file_labels_in: input folder labels
:param file_source_out: output folder
:param dtype: value
:param all_type: values to load
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "assign point labels",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def assign_point_labels_folder(client,
     folder_source_in='/folder_source_in',
     folder_labels_in='/folder_labels_in',
     folder_source_out='/folder_source_out',
     dtype='classification',
     all_type='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_source_in=".laz",
     extension_file_labels_in=".npy",
     extension_file_source_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | assign_point_labels_folder(client,
    |      folder_source_in='/folder_source_in',
    |      folder_labels_in='/folder_labels_in',
    |      folder_source_out='/folder_source_out',
    |      dtype='classification',
    |      all_type='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_source_in=".laz",
    |      extension_folder_labels_in=".npy",
    |      extension_folder_source_out=".laz",
    |      skip_existing_files = False )

:param dtype: value
:param all_type: values to load
:param folder_source_in: input folder data
:param folder_labels_in: input folder labels
:param folder_source_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_source_in: File extension of files in folder for folder_source_in
:param extension_folder_labels_in: File extension of files in folder for folder_labels_in
:param extension_folder_source_out: File extension of files in folder for folder_source_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_source_in']
      del all_parameters['folder_labels_in']
      del all_parameters['folder_source_out']
      del all_parameters['extension_file_source_in']
      del all_parameters['extension_file_labels_in']
      del all_parameters['extension_file_source_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_source_in,file_labels_in,file_source_out"
      folders = folder_source_in + "," + folder_labels_in + "," + folder_source_out
      extensions = extension_file_source_in + "," + extension_file_labels_in + "," + extension_file_source_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "assign point labels" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def quantile_filter(client,
     folder_in='segmented_object',
     folder_out='quantile_filterd',
     max_quantile=0.995,
     min_quantile=0.3,
     axis=2,
     max_num_processes=0,
     instance_type='x2large'):
      '''
    | 
    | quantile_filter( client,
    |      folder_in='segmented_object',
    |      folder_out='quantile_filterd',
    |      max_quantile=0.995,
    |      min_quantile=0.3,
    |      axis=2,
    |      max_num_processes=0,
    |      instance_type='x2large' )

:param folder_in: input folder
:param folder_out: output folder
:param max_quantile: maximum quantile
:param min_quantile: minimum quantile
:param axis: axis 0: x, 1: y, 2: z
:param max_num_processes: Number of parallel processes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "quantile filter",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def quantile_filter_folder(client,
     folder_folder_in='/folder_folder_in',
     folder_folder_out='/folder_folder_out',
     max_quantile=0.995,
     min_quantile=0.3,
     axis=2,
     max_num_processes=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder_in=".laz",
     extension_folder_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | quantile_filter_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      max_quantile=0.995,
    |      min_quantile=0.3,
    |      axis=2,
    |      max_num_processes=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".segmented_object",
    |      extension_folder_out=".quantile_filterd",
    |      skip_existing_files = False )

:param max_quantile: maximum quantile
:param min_quantile: minimum quantile
:param axis: axis 0: x, 1: y, 2: z
:param max_num_processes: Number of parallel processes
:param folder_folder_in: input folder
:param folder_folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_folder_in
:param extension_folder_out: File extension of files in folder for folder_folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder_in']
      del all_parameters['folder_folder_out']
      del all_parameters['extension_folder_in']
      del all_parameters['extension_folder_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder_in,folder_out"
      folders = folder_folder_in + "," + folder_folder_out
      extensions = extension_folder_in + "," + extension_folder_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "quantile filter" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_generate_grid_locally(client,
     in_path='file.laz',
     dimension=3,
     grid_size='20,20,50',
     offset_factor=0.,
     reference_point='',
     out_path_tiles='output_grid',
     out_path_mapping_slice_point_cloud='output_slice.txt',
     out_path_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles.txt',
     out_path_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud.txt',
     instance_type='x2large'):
      '''Create grid for retileing individual point clouds
    | 
    | retile_generate_grid_locally( client,
    |      in_path='file.laz',
    |      dimension=3,
    |      grid_size='20,20,50',
    |      offset_factor=0.,
    |      reference_point='',
    |      out_path_tiles='output_grid',
    |      out_path_mapping_slice_point_cloud='output_slice.txt',
    |      out_path_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles.txt',
    |      out_path_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud.txt',
    |      instance_type='x2large' )

:param in_path: path to laz files to be retiled
:param dimension: Dimension to be retiled (x,y) or (x,y,z)
:param grid_size: Grid size for retileing
:param offset_factor: Offset factor for grid generation
:param reference_point: Reference point for grid generation, empty for default (min_x, min_y, min_z)
:param out_path_tiles: Output bounding box / tiles path
:param out_path_mapping_slice_point_cloud: Output path for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
:param out_path_mapping_point_cloud_to_tiles: Output path for mapping that contains the tiles that are generated from point cloud x
:param out_path_mapping_tiles_to_point_cloud: Output path for mapping that contains the point clouds that are used to generate tile x
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "retile generate grid locally",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_generate_grid_locally_folder(client,
     in_folder='/in_folder',
     dimension=3,
     grid_size='20,20,50',
     offset_factor=0.,
     reference_point='',
     out_folder_tiles='/out_folder_tiles',
     out_folder_mapping_slice_point_cloud='/out_folder_mapping_slice_point_cloud',
     out_folder_mapping_point_cloud_to_tiles='/out_folder_mapping_point_cloud_to_tiles',
     out_folder_mapping_tiles_to_point_cloud='/out_folder_mapping_tiles_to_point_cloud',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_path=".laz",
     extension_out_path_tiles=".laz",
     extension_out_path_mapping_slice_point_cloud=".txt",
     extension_out_path_mapping_point_cloud_to_tiles=".txt",
     extension_out_path_mapping_tiles_to_point_cloud=".txt",
     skip_existing_files = False):
      '''Create grid for retileing individual point clouds
    | 
    | retile_generate_grid_locally_folder(client,
    |      in_folder='/in_folder',
    |      dimension=3,
    |      grid_size='20,20,50',
    |      offset_factor=0.,
    |      reference_point='',
    |      out_folder_tiles='/out_folder_tiles',
    |      out_folder_mapping_slice_point_cloud='/out_folder_mapping_slice_point_cloud',
    |      out_folder_mapping_point_cloud_to_tiles='/out_folder_mapping_point_cloud_to_tiles',
    |      out_folder_mapping_tiles_to_point_cloud='/out_folder_mapping_tiles_to_point_cloud',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".laz",
    |      extension_out_folder_tiles=".output_grid",
    |      extension_out_folder_mapping_slice_point_cloud=".txt",
    |      extension_out_folder_mapping_point_cloud_to_tiles=".txt",
    |      extension_out_folder_mapping_tiles_to_point_cloud=".txt",
    |      skip_existing_files = False )

:param dimension: Dimension to be retiled (x,y) or (x,y,z)
:param grid_size: Grid size for retileing
:param offset_factor: Offset factor for grid generation
:param reference_point: Reference point for grid generation, empty for default (min_x, min_y, min_z)
:param in_folder: folder to laz folders to be retiled
:param out_folder_tiles: Output bounding box / tiles folder
:param out_folder_mapping_slice_point_cloud: Output folder for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
:param out_folder_mapping_point_cloud_to_tiles: Output folder for mapping that contains the tiles that are generated from point cloud x
:param out_folder_mapping_tiles_to_point_cloud: Output folder for mapping that contains the point clouds that are used to generate tile x
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder_tiles: File extension of files in folder for out_folder_tiles
:param extension_out_folder_mapping_slice_point_cloud: File extension of files in folder for out_folder_mapping_slice_point_cloud
:param extension_out_folder_mapping_point_cloud_to_tiles: File extension of files in folder for out_folder_mapping_point_cloud_to_tiles
:param extension_out_folder_mapping_tiles_to_point_cloud: File extension of files in folder for out_folder_mapping_tiles_to_point_cloud
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder_tiles']
      del all_parameters['out_folder_mapping_slice_point_cloud']
      del all_parameters['out_folder_mapping_point_cloud_to_tiles']
      del all_parameters['out_folder_mapping_tiles_to_point_cloud']
      del all_parameters['extension_in_path']
      del all_parameters['extension_out_path_tiles']
      del all_parameters['extension_out_path_mapping_slice_point_cloud']
      del all_parameters['extension_out_path_mapping_point_cloud_to_tiles']
      del all_parameters['extension_out_path_mapping_tiles_to_point_cloud']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_path,out_path_tiles,out_path_mapping_slice_point_cloud,out_path_mapping_point_cloud_to_tiles,out_path_mapping_tiles_to_point_cloud"
      folders = in_folder + "," + out_folder_tiles + "," + out_folder_mapping_slice_point_cloud + "," + out_folder_mapping_point_cloud_to_tiles + "," + out_folder_mapping_tiles_to_point_cloud
      extensions = extension_in_path + "," + extension_out_path_tiles + "," + extension_out_path_mapping_slice_point_cloud + "," + extension_out_path_mapping_point_cloud_to_tiles + "," + extension_out_path_mapping_tiles_to_point_cloud
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "retile generate grid locally" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def align_points(client,
     folder_source_in='segmented_object',
     folder_transformation_in='transformations',
     folder_source_out='aligned_points',
     instance_type='x2large'):
      '''
    | 
    | align_points( client,
    |      folder_source_in='segmented_object',
    |      folder_transformation_in='transformations',
    |      folder_source_out='aligned_points',
    |      instance_type='x2large' )

:param folder_source_in: input folder data
:param folder_transformation_in: input folder transformation
:param folder_source_out: output folder
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "align points",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def align_points_folder(client,
     folder_folder_source_in='/folder_folder_source_in',
     folder_folder_transformation_in='/folder_folder_transformation_in',
     folder_folder_source_out='/folder_folder_source_out',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder_source_in=".laz",
     extension_folder_transformation_in=".laz",
     extension_folder_source_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | align_points_folder(client,
    |      folder_source_in='/folder_source_in',
    |      folder_transformation_in='/folder_transformation_in',
    |      folder_source_out='/folder_source_out',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_source_in=".segmented_object",
    |      extension_folder_transformation_in=".transformations",
    |      extension_folder_source_out=".aligned_points",
    |      skip_existing_files = False )

:param folder_folder_source_in: input folder data
:param folder_folder_transformation_in: input folder transformation
:param folder_folder_source_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_source_in: File extension of files in folder for folder_folder_source_in
:param extension_folder_transformation_in: File extension of files in folder for folder_folder_transformation_in
:param extension_folder_source_out: File extension of files in folder for folder_folder_source_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder_source_in']
      del all_parameters['folder_folder_transformation_in']
      del all_parameters['folder_folder_source_out']
      del all_parameters['extension_folder_source_in']
      del all_parameters['extension_folder_transformation_in']
      del all_parameters['extension_folder_source_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder_source_in,folder_transformation_in,folder_source_out"
      folders = folder_folder_source_in + "," + folder_folder_transformation_in + "," + folder_folder_source_out
      extensions = extension_folder_source_in + "," + extension_folder_transformation_in + "," + extension_folder_source_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "align points" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def uniform_down_sampling(client,
     input_file='in.laz',
     cols='',
     output_file='out.laz',
     every_k_points=2,
     instance_type='x2large'):
      '''Uniform down sampling of point cloud
    | 
    | uniform_down_sampling( client,
    |      input_file='in.laz',
    |      cols='',
    |      output_file='out.laz',
    |      every_k_points=2,
    |      instance_type='x2large' )

:param input_file: Input point cloud file
:param cols: Columns to read from input file, default is all columns
:param output_file: Output point cloud file
:param every_k_points: Keep every k points
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "uniform down sampling",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def uniform_down_sampling_folder(client,
     input_folder='/input_folder',
     cols='',
     output_folder='/output_folder',
     every_k_points=2,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_output_file=".laz",
     skip_existing_files = False):
      '''Uniform down sampling of point cloud
    | 
    | uniform_down_sampling_folder(client,
    |      input_folder='/input_folder',
    |      cols='',
    |      output_folder='/output_folder',
    |      every_k_points=2,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_output_folder=".laz",
    |      skip_existing_files = False )

:param cols: Columns to read from input file, default is all columns
:param every_k_points: Keep every k points
:param input_folder: Input point cloud folder
:param output_folder: Output point cloud folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "uniform down sampling" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def voxel_downsampling(client,
     file_in='segmented_object.laz',
     file_out='aligned_points.laz',
     voxel_size=0.1,
     dtype='',
     instance_type='x2large'):
      '''deprecated, please use unfiorm_down_sampling_voxel instead!
    | 
    | voxel_downsampling( client,
    |      file_in='segmented_object.laz',
    |      file_out='aligned_points.laz',
    |      voxel_size=0.1,
    |      dtype='',
    |      instance_type='x2large' )

:param file_in: input folder data
:param file_out: output folder
:param voxel_size: voxel size
:param dtype: values from point cloud, e.g. X,Y,Z
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "voxel downsampling",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def voxel_downsampling_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     voxel_size=0.1,
     dtype='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".laz",
     extension_file_out=".laz",
     skip_existing_files = False):
      '''deprecated, please use unfiorm_down_sampling_voxel instead!
    | 
    | voxel_downsampling_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      voxel_size=0.1,
    |      dtype='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".laz",
    |      extension_folder_out=".laz",
    |      skip_existing_files = False )

:param voxel_size: voxel size
:param dtype: values from point cloud, e.g. X,Y,Z
:param folder_in: input folder data
:param folder_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "voxel downsampling" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def get_meta_data(client,
     in_file='simple.laz',
     out_file='meta_data.json',
     instance_type='x2large'):
      '''Get meta data from las or laz file
    | 
    | get_meta_data( client,
    |      in_file='simple.laz',
    |      out_file='meta_data.json',
    |      instance_type='x2large' )

:param in_file: Input .laz file path
:param out_file: Output meta data file path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "get meta data",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def get_meta_data_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".laz",
     extension_out_file=".json",
     skip_existing_files = False):
      '''Get meta data from las or laz file
    | 
    | get_meta_data_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".laz",
    |      extension_out_folder=".json",
    |      skip_existing_files = False )

:param in_folder: Input .laz folder folder
:param out_folder: Output meta data folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "get meta data" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_center_object(client,
     in_directory='laz_files',
     out_file='out.laz',
     latitude=1,
     longitude=1,
     instance_type='x2large'):
      '''
    | 
    | select_center_object( client,
    |      in_directory='laz_files',
    |      out_file='out.laz',
    |      latitude=1,
    |      longitude=1,
    |      instance_type='x2large' )

:param in_directory: input directory
:param out_file: output file
:param latitude: latitude
:param longitude: longitude
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "select center object",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def select_center_object_folder(client,
     in_directory='laz_files',
     out_folder='/out_folder',
     latitude=1,
     longitude=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_out_file=".laz",
     skip_existing_files = False):
      '''
    | 
    | select_center_object_folder(client,
    |      in_directory='laz_files',
    |      out_folder='/out_folder',
    |      latitude=1,
    |      longitude=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_out_folder=".laz",
    |      skip_existing_files = False )

:param in_directory: input directory
:param latitude: latitude
:param longitude: longitude
:param out_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['out_folder']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "out_file"
      folders = out_folder
      extensions = extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "select center object" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_to_equal_value_range(client,
     folder1_in='segmented_object1',
     folder2_in='segmented_object2',
     folder1_out='crop_relative_height1',
     folder2_out='crop_relative_height2',
     reference='max',
     axis=2,
     max_num_processes=0,
     instance_type='x2large'):
      '''
    | 
    | crop_to_equal_value_range( client,
    |      folder1_in='segmented_object1',
    |      folder2_in='segmented_object2',
    |      folder1_out='crop_relative_height1',
    |      folder2_out='crop_relative_height2',
    |      reference='max',
    |      axis=2,
    |      max_num_processes=0,
    |      instance_type='x2large' )

:param folder1_in: input folder
:param folder2_in: input folder
:param folder1_out: output folder
:param folder2_out: output folder
:param reference: [max, min, same]: same value range relative to maximum point [max], relative to minimum point [min] or absolute coordinates [same]
:param axis: axis to crop values
:param max_num_processes: Number of parallel processes
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "crop to equal value range",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def crop_to_equal_value_range_folder(client,
     folder_folder1_in='/folder_folder1_in',
     folder_folder2_in='/folder_folder2_in',
     folder_folder1_out='/folder_folder1_out',
     folder_folder2_out='/folder_folder2_out',
     reference='max',
     axis=2,
     max_num_processes=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder1_in=".laz",
     extension_folder2_in=".laz",
     extension_folder1_out=".laz",
     extension_folder2_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | crop_to_equal_value_range_folder(client,
    |      folder1_in='/folder1_in',
    |      folder2_in='/folder2_in',
    |      folder1_out='/folder1_out',
    |      folder2_out='/folder2_out',
    |      reference='max',
    |      axis=2,
    |      max_num_processes=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder1_in=".segmented_object1",
    |      extension_folder2_in=".segmented_object2",
    |      extension_folder1_out=".crop_relative_height1",
    |      extension_folder2_out=".crop_relative_height2",
    |      skip_existing_files = False )

:param reference: [max, min, same]: same value range relative to maximum point [max], relative to minimum point [min] or absolute coordinates [same]
:param axis: axis to crop values
:param max_num_processes: Number of parallel processes
:param folder_folder1_in: input folder
:param folder_folder2_in: input folder
:param folder_folder1_out: output folder
:param folder_folder2_out: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder1_in: File extension of files in folder for folder_folder1_in
:param extension_folder2_in: File extension of files in folder for folder_folder2_in
:param extension_folder1_out: File extension of files in folder for folder_folder1_out
:param extension_folder2_out: File extension of files in folder for folder_folder2_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder1_in']
      del all_parameters['folder_folder2_in']
      del all_parameters['folder_folder1_out']
      del all_parameters['folder_folder2_out']
      del all_parameters['extension_folder1_in']
      del all_parameters['extension_folder2_in']
      del all_parameters['extension_folder1_out']
      del all_parameters['extension_folder2_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder1_in,folder2_in,folder1_out,folder2_out"
      folders = folder_folder1_in + "," + folder_folder2_in + "," + folder_folder1_out + "," + folder_folder2_out
      extensions = extension_folder1_in + "," + extension_folder2_in + "," + extension_folder1_out + "," + extension_folder2_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "crop to equal value range" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_generate_grid_globally(client,
     in_paths='file1.laz,file2.laz',
     dimension=3,
     grid_size='20,20,50',
     offset_factor=0.,
     reference_point='',
     out_path_tiles='output_grid',
     out_folder_mapping_slice_point_cloud='slices',
     out_folder_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles',
     out_folder_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud',
     instance_type='x2large'):
      '''Create grid for retileing point clouds over multiple georeferenced point clouds
    | 
    | retile_generate_grid_globally( client,
    |      in_paths='file1.laz,file2.laz',
    |      dimension=3,
    |      grid_size='20,20,50',
    |      offset_factor=0.,
    |      reference_point='',
    |      out_path_tiles='output_grid',
    |      out_folder_mapping_slice_point_cloud='slices',
    |      out_folder_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles',
    |      out_folder_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud',
    |      instance_type='x2large' )

:param in_paths: path to laz files to be retiled
:param dimension: Dimension to be retiled (x,y) or (x,y,z)
:param grid_size: Grid size for retileing
:param offset_factor: Offset factor for grid generation
:param reference_point: Reference point for grid generation, empty for default (min_x, min_y, min_z)
:param out_path_tiles: Output bounding box / tiles path
:param out_folder_mapping_slice_point_cloud:  Output path for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
:param out_folder_mapping_point_cloud_to_tiles:  Output path for mapping that contains the tiles that are generated from point cloud x
:param out_folder_mapping_tiles_to_point_cloud:  Output path for mapping that contains the point clouds that are used to generate tile x
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "retile generate grid globally",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_generate_grid_globally_folder(client,
     in_folders='/in_folders',
     dimension=3,
     grid_size='20,20,50',
     offset_factor=0.,
     reference_point='',
     out_folder_tiles='/out_folder_tiles',
     out_folder_mapping_slice_point_cloud='slices',
     out_folder_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles',
     out_folder_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_paths=".laz",
     extension_out_path_tiles=".laz",
     skip_existing_files = False):
      '''Create grid for retileing point clouds over multiple georeferenced point clouds
    | 
    | retile_generate_grid_globally_folder(client,
    |      in_folders='/in_folders',
    |      dimension=3,
    |      grid_size='20,20,50',
    |      offset_factor=0.,
    |      reference_point='',
    |      out_folder_tiles='/out_folder_tiles',
    |      out_folder_mapping_slice_point_cloud='slices',
    |      out_folder_mapping_point_cloud_to_tiles='mapping_point_cloud_to_tiles',
    |      out_folder_mapping_tiles_to_point_cloud='mapping_tiles_to_point_cloud',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folders=".laz",
    |      extension_out_folder_tiles=".output_grid",
    |      skip_existing_files = False )

:param dimension: Dimension to be retiled (x,y) or (x,y,z)
:param grid_size: Grid size for retileing
:param offset_factor: Offset factor for grid generation
:param reference_point: Reference point for grid generation, empty for default (min_x, min_y, min_z)
:param out_folder_mapping_slice_point_cloud:  Output path for mapping that contains the point clouds (including neighbouring point clouds) that are used to generate slices from point cloud x
:param out_folder_mapping_point_cloud_to_tiles:  Output path for mapping that contains the tiles that are generated from point cloud x
:param out_folder_mapping_tiles_to_point_cloud:  Output path for mapping that contains the point clouds that are used to generate tile x
:param in_folders: folder to laz folders to be retiled
:param out_folder_tiles: Output bounding box / tiles folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folders: File extension of files in folder for in_folders
:param extension_out_folder_tiles: File extension of files in folder for out_folder_tiles
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folders']
      del all_parameters['out_folder_tiles']
      del all_parameters['extension_in_paths']
      del all_parameters['extension_out_path_tiles']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_paths,out_path_tiles"
      folders = in_folders + "," + out_folder_tiles
      extensions = extension_in_paths + "," + extension_out_path_tiles
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "retile generate grid globally" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def point_cloud_to_dsm(client,
     file_points_in='points.laz',
     file_dsm_out='dsm.tif',
     file_dtm_out='dtm.tif',
     file_chm_out='chm.tif',
     grid_size=0.5,
     instance_type='x2large'):
      '''
    | 
    | point_cloud_to_dsm( client,
    |      file_points_in='points.laz',
    |      file_dsm_out='dsm.tif',
    |      file_dtm_out='dtm.tif',
    |      file_chm_out='chm.tif',
    |      grid_size=0.5,
    |      instance_type='x2large' )

:param file_points_in: input points
:param file_dsm_out: dsm file
:param file_dtm_out: dtm file
:param file_chm_out: chm file
:param grid_size: grid size
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "point cloud to dsm",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def point_cloud_to_dsm_folder(client,
     folder_points_in='/folder_points_in',
     folder_dsm_out='/folder_dsm_out',
     folder_dtm_out='/folder_dtm_out',
     folder_chm_out='/folder_chm_out',
     grid_size=0.5,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_points_in=".laz",
     extension_file_dsm_out=".tif",
     extension_file_dtm_out=".tif",
     extension_file_chm_out=".tif",
     skip_existing_files = False):
      '''
    | 
    | point_cloud_to_dsm_folder(client,
    |      folder_points_in='/folder_points_in',
    |      folder_dsm_out='/folder_dsm_out',
    |      folder_dtm_out='/folder_dtm_out',
    |      folder_chm_out='/folder_chm_out',
    |      grid_size=0.5,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_points_in=".laz",
    |      extension_folder_dsm_out=".tif",
    |      extension_folder_dtm_out=".tif",
    |      extension_folder_chm_out=".tif",
    |      skip_existing_files = False )

:param grid_size: grid size
:param folder_points_in: input points
:param folder_dsm_out: dsm folder
:param folder_dtm_out: dtm folder
:param folder_chm_out: chm folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_points_in: File extension of files in folder for folder_points_in
:param extension_folder_dsm_out: File extension of files in folder for folder_dsm_out
:param extension_folder_dtm_out: File extension of files in folder for folder_dtm_out
:param extension_folder_chm_out: File extension of files in folder for folder_chm_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_points_in']
      del all_parameters['folder_dsm_out']
      del all_parameters['folder_dtm_out']
      del all_parameters['folder_chm_out']
      del all_parameters['extension_file_points_in']
      del all_parameters['extension_file_dsm_out']
      del all_parameters['extension_file_dtm_out']
      del all_parameters['extension_file_chm_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_points_in,file_dsm_out,file_dtm_out,file_chm_out"
      folders = folder_points_in + "," + folder_dsm_out + "," + folder_dtm_out + "," + folder_chm_out
      extensions = extension_file_points_in + "," + extension_file_dsm_out + "," + extension_file_dtm_out + "," + extension_file_chm_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "point cloud to dsm" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class qc:
   def report_qc_classification(client,
     in_file='in.laz',
     out_file='out.txt',
     error_classes='148,149',
     error_names='Line,Tower',
     keep_error_free='True',
     instance_type='x2large'):
      '''
    | 
    | report_qc_classification( client,
    |      in_file='in.laz',
    |      out_file='out.txt',
    |      error_classes='148,149',
    |      error_names='Line,Tower',
    |      keep_error_free='True',
    |      instance_type='x2large' )

:param in_file: file with erroneous points
:param out_file: output report file
:param error_classes: error classes
:param error_names: error names
:param keep_error_free: Save empty files?
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "report qc classification",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_qc_classification_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     error_classes='148,149',
     error_names='Line,Tower',
     keep_error_free='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".laz",
     extension_out_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | report_qc_classification_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      error_classes='148,149',
    |      error_names='Line,Tower',
    |      keep_error_free='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".laz",
    |      extension_out_folder=".txt",
    |      skip_existing_files = False )

:param error_classes: error classes
:param error_names: error names
:param keep_error_free: Save empty files?
:param in_folder: folder with erroneous points
:param out_folder: output report folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "report qc classification" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_image_completeness(client,
     in_file='in_file.txt',
     in_meta_data_file='in_file.json',
     out_file='out_file.txt',
     grid_size=0.5,
     populated_class=1,
     small_holes_class=100,
     large_holes_class=255,
     keep_error_free='True',
     instance_type='x2large'):
      '''
    | 
    | report_image_completeness( client,
    |      in_file='in_file.txt',
    |      in_meta_data_file='in_file.json',
    |      out_file='out_file.txt',
    |      grid_size=0.5,
    |      populated_class=1,
    |      small_holes_class=100,
    |      large_holes_class=255,
    |      keep_error_free='True',
    |      instance_type='x2large' )

:param in_file: file with count of classes
:param in_meta_data_file: file with metadata
:param out_file: output report file
:param grid_size: grid size
:param populated_class: populated class
:param small_holes_class: small holes class
:param large_holes_class: large holes class
:param keep_error_free: Save empty files?
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "report image completeness",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_image_completeness_folder(client,
     in_folder='/in_folder',
     in_meta_data_folder='/in_meta_data_folder',
     out_folder='/out_folder',
     grid_size=0.5,
     populated_class=1,
     small_holes_class=100,
     large_holes_class=255,
     keep_error_free='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".txt",
     extension_in_meta_data_file=".json",
     extension_out_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | report_image_completeness_folder(client,
    |      in_folder='/in_folder',
    |      in_meta_data_folder='/in_meta_data_folder',
    |      out_folder='/out_folder',
    |      grid_size=0.5,
    |      populated_class=1,
    |      small_holes_class=100,
    |      large_holes_class=255,
    |      keep_error_free='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".txt",
    |      extension_in_meta_data_folder=".json",
    |      extension_out_folder=".txt",
    |      skip_existing_files = False )

:param grid_size: grid size
:param populated_class: populated class
:param small_holes_class: small holes class
:param large_holes_class: large holes class
:param keep_error_free: Save empty files?
:param in_folder: folder with count of classes
:param in_meta_data_folder: folder with metadata
:param out_folder: output report folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_in_meta_data_folder: File extension of files in folder for in_meta_data_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['in_meta_data_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_in_meta_data_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,in_meta_data_file,out_file"
      folders = in_folder + "," + in_meta_data_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_in_meta_data_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "report image completeness" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_vegetation_occurance(client,
     in_file='in_file.txt',
     out_file='out_file.txt',
     ground_classes_old='2,3,6,7,15',
     ground_classes_new='1,3,9,11,15',
     vegetation_old='6,7,15',
     vegetation_new='9,11,15',
     keep_error_free='True',
     instance_type='x2large'):
      '''
    | 
    | report_vegetation_occurance( client,
    |      in_file='in_file.txt',
    |      out_file='out_file.txt',
    |      ground_classes_old='2,3,6,7,15',
    |      ground_classes_new='1,3,9,11,15',
    |      vegetation_old='6,7,15',
    |      vegetation_new='9,11,15',
    |      keep_error_free='True',
    |      instance_type='x2large' )

:param in_file: file with erroneous points
:param out_file: output report file
:param ground_classes_old: ground classes
:param ground_classes_new: ground classes
:param vegetation_old: vegetation old classes
:param vegetation_new: vegetation new classes
:param keep_error_free: Save empty files?
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "report vegetation occurance",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_vegetation_occurance_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     ground_classes_old='2,3,6,7,15',
     ground_classes_new='1,3,9,11,15',
     vegetation_old='6,7,15',
     vegetation_new='9,11,15',
     keep_error_free='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".txt",
     extension_out_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | report_vegetation_occurance_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      ground_classes_old='2,3,6,7,15',
    |      ground_classes_new='1,3,9,11,15',
    |      vegetation_old='6,7,15',
    |      vegetation_new='9,11,15',
    |      keep_error_free='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".txt",
    |      extension_out_folder=".txt",
    |      skip_existing_files = False )

:param ground_classes_old: ground classes
:param ground_classes_new: ground classes
:param vegetation_old: vegetation old classes
:param vegetation_new: vegetation new classes
:param keep_error_free: Save empty files?
:param in_folder: folder with erroneous points
:param out_folder: output report folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "report vegetation occurance" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_lidar_completeness(client,
     in_file='in_file.txt',
     out_file='out_file.txt',
     grid_size=0.5,
     populated_class=1,
     small_holes_class=100,
     large_holes_class=255,
     keep_error_free='True',
     instance_type='x2large'):
      '''
    | 
    | report_lidar_completeness( client,
    |      in_file='in_file.txt',
    |      out_file='out_file.txt',
    |      grid_size=0.5,
    |      populated_class=1,
    |      small_holes_class=100,
    |      large_holes_class=255,
    |      keep_error_free='True',
    |      instance_type='x2large' )

:param in_file: file with erroneous points
:param out_file: output report file
:param grid_size: grid size
:param populated_class: populated class
:param small_holes_class: small holes class
:param large_holes_class: large holes class
:param keep_error_free: Save empty files?
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "report lidar completeness",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def report_lidar_completeness_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     grid_size=0.5,
     populated_class=1,
     small_holes_class=100,
     large_holes_class=255,
     keep_error_free='True',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".txt",
     extension_out_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | report_lidar_completeness_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      grid_size=0.5,
    |      populated_class=1,
    |      small_holes_class=100,
    |      large_holes_class=255,
    |      keep_error_free='True',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".txt",
    |      extension_out_folder=".txt",
    |      skip_existing_files = False )

:param grid_size: grid size
:param populated_class: populated class
:param small_holes_class: small holes class
:param large_holes_class: large holes class
:param keep_error_free: Save empty files?
:param in_folder: folder with erroneous points
:param out_folder: output report folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "report lidar completeness" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class val:
   def equal_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1,
     instance_type='x2large'):
      '''Equal operator on a matrix.
    | 
    | equal_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "equal constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def equal_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Equal operator on a matrix.
    | 
    | equal_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "equal constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_divide(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_divide( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy or .txt]
:param file_values2_in: input file [.npy or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values divide",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_divide_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_divide_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy or .txt]
:param folder_values2_in: input folder [.npy or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values divide" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def divide_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1.0,
     instance_type='x2large'):
      '''Divide a constant value from a matrix.
    | 
    | divide_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1.0,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to divide (default: 1.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "divide constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def divide_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Divide a constant value from a matrix.
    | 
    | divide_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to divide (default: 1.0)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "divide constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_less(client,
     infile1='in.npy',
     infile2='in.npy',
     outfile='out.npy',
     dtype='float',
     instance_type='x2large'):
      '''Elementwiese less operator on a matrix.
    | 
    | values_less( client,
    |      infile1='in.npy',
    |      infile2='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      instance_type='x2large' )

:param infile1: Input file path
:param infile2: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values less",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_less_folder(client,
     infolder1='/infolder1',
     infolder2='/infolder2',
     outfolder='/outfolder',
     dtype='float',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile1=".npy",
     extension_infile2=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Elementwiese less operator on a matrix.
    | 
    | values_less_folder(client,
    |      infolder1='/infolder1',
    |      infolder2='/infolder2',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder1=".npy",
    |      extension_infolder2=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param infolder1: Input folder folder
:param infolder2: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder1: File extension of files in folder for infolder1
:param extension_infolder2: File extension of files in folder for infolder2
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder1']
      del all_parameters['infolder2']
      del all_parameters['outfolder']
      del all_parameters['extension_infile1']
      del all_parameters['extension_infile2']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile1,infile2,outfile"
      folders = infolder1 + "," + infolder2 + "," + outfolder
      extensions = extension_infile1 + "," + extension_infile2 + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values less" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def add_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=0.0,
     instance_type='x2large'):
      '''Add a constant value to a matrix.
    | 
    | add_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=0.0,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to add (default: 0.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "add constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def add_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=0.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Add a constant value to a matrix.
    | 
    | add_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=0.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to add (default: 0.0)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "add constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_less_equal(client,
     infile1='in.npy',
     infile2='in.npy',
     outfile='out.npy',
     dtype='float',
     instance_type='x2large'):
      '''Elementwiese less equal operator on a matrix.
    | 
    | values_less_equal( client,
    |      infile1='in.npy',
    |      infile2='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      instance_type='x2large' )

:param infile1: Input file path
:param infile2: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values less equal",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_less_equal_folder(client,
     infolder1='/infolder1',
     infolder2='/infolder2',
     outfolder='/outfolder',
     dtype='float',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile1=".npy",
     extension_infile2=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Elementwiese less equal operator on a matrix.
    | 
    | values_less_equal_folder(client,
    |      infolder1='/infolder1',
    |      infolder2='/infolder2',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder1=".npy",
    |      extension_infolder2=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param infolder1: Input folder folder
:param infolder2: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder1: File extension of files in folder for infolder1
:param extension_infolder2: File extension of files in folder for infolder2
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder1']
      del all_parameters['infolder2']
      del all_parameters['outfolder']
      del all_parameters['extension_infile1']
      del all_parameters['extension_infile2']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile1,infile2,outfile"
      folders = infolder1 + "," + infolder2 + "," + outfolder
      extensions = extension_infile1 + "," + extension_infile2 + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values less equal" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_sliced_assign(client,
     file_in='file1.npy',
     file_out='values.txt',
     indices=':',
     file_values_in='file2.npy',
     default_value=0.0,
     instance_type='x2large'):
      '''
    | 
    | values_sliced_assign( client,
    |      file_in='file1.npy',
    |      file_out='values.txt',
    |      indices=':',
    |      file_values_in='file2.npy',
    |      default_value=0.0,
    |      instance_type='x2large' )

:param file_in: input file [.txt or .npy]
:param file_out: output file [.txt or .npy]
:param indices: indices to slice
:param file_values_in: input file [.txt or .npy]
:param default_value: default value to assign
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values sliced assign",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_sliced_assign_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     indices=':',
     folder_values_in='/folder_values_in',
     default_value=0.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".npy",
     extension_file_out=".txt",
     extension_file_values_in=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_sliced_assign_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      indices=':',
    |      folder_values_in='/folder_values_in',
    |      default_value=0.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".npy",
    |      extension_folder_out=".txt",
    |      extension_folder_values_in=".npy",
    |      skip_existing_files = False )

:param indices: indices to slice
:param default_value: default value to assign
:param folder_in: input folder [.txt or .npy]
:param folder_out: output folder [.txt or .npy]
:param folder_values_in: input folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param extension_folder_values_in: File extension of files in folder for folder_values_in
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['folder_values_in']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']
      del all_parameters['extension_file_values_in']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out,file_values_in"
      folders = folder_in + "," + folder_out + "," + folder_values_in
      extensions = extension_file_in + "," + extension_file_out + "," + extension_file_values_in
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values sliced assign" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def masked_assign_constant(client,
     file_values_in='file1.npy',
     constant=0.0,
     file_mask_in='file2.npy',
     file_values_out='values.npy',
     instance_type='x2large'):
      '''
    | 
    | masked_assign_constant( client,
    |      file_values_in='file1.npy',
    |      constant=0.0,
    |      file_mask_in='file2.npy',
    |      file_values_out='values.npy',
    |      instance_type='x2large' )

:param file_values_in: input file [.txt or .npy]
:param constant: constant value to assign
:param file_mask_in: input file that contains [0,1] values
:param file_values_out: output file [.txt or .npy]
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "masked assign constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def masked_assign_constant_folder(client,
     folder_values_in='/folder_values_in',
     constant=0.0,
     folder_mask_in='/folder_mask_in',
     folder_values_out='/folder_values_out',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values_in=".npy",
     extension_file_mask_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | masked_assign_constant_folder(client,
    |      folder_values_in='/folder_values_in',
    |      constant=0.0,
    |      folder_mask_in='/folder_mask_in',
    |      folder_values_out='/folder_values_out',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values_in=".npy",
    |      extension_folder_mask_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param constant: constant value to assign
:param folder_values_in: input folder [.txt or .npy]
:param folder_mask_in: input folder that contains [0,1] values
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values_in: File extension of files in folder for folder_values_in
:param extension_folder_mask_in: File extension of files in folder for folder_mask_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values_in']
      del all_parameters['folder_mask_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values_in']
      del all_parameters['extension_file_mask_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values_in,file_mask_in,file_values_out"
      folders = folder_values_in + "," + folder_mask_in + "," + folder_values_out
      extensions = extension_file_values_in + "," + extension_file_mask_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "masked assign constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def greater_equal_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1,
     instance_type='x2large'):
      '''Greater equal operator on a matrix.
    | 
    | greater_equal_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "greater equal constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def greater_equal_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Greater equal operator on a matrix.
    | 
    | greater_equal_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "greater equal constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_not_equal(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_not_equal( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy or .txt]
:param file_values2_in: input file [.npy or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values not equal",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_not_equal_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_not_equal_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy or .txt]
:param folder_values2_in: input folder [.npy or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values not equal" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def max(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     instance_type='x2large'):
      '''Maximum of a matrix.
    | 
    | max( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "max",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def max_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Maximum of a matrix.
    | 
    | max_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "max" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_masked_assign(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_mask_in='file2.npy',
     file_values_out='values.txt',
     instance_type='x2large'):
      '''
    | 
    | values_masked_assign( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_mask_in='file2.npy',
    |      file_values_out='values.txt',
    |      instance_type='x2large' )

:param file_values1_in: input file [.txt or .npy]
:param file_values2_in: input file [.txt or .npy]
:param file_mask_in: input file that contains [0,1] values
:param file_values_out: output file [.txt or .npy]
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values masked assign",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_masked_assign_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_mask_in='/folder_mask_in',
     folder_values_out='/folder_values_out',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_mask_in=".npy",
     extension_file_values_out=".txt",
     skip_existing_files = False):
      '''
    | 
    | values_masked_assign_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_mask_in='/folder_mask_in',
    |      folder_values_out='/folder_values_out',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_mask_in=".npy",
    |      extension_folder_values_out=".txt",
    |      skip_existing_files = False )

:param folder_values1_in: input folder [.txt or .npy]
:param folder_values2_in: input folder [.txt or .npy]
:param folder_mask_in: input folder that contains [0,1] values
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_mask_in: File extension of files in folder for folder_mask_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_mask_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_mask_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_mask_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_mask_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_mask_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values masked assign" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def replace_strings(client,
     file_in='file.txt',
     file_out='file.txt',
     replace_from='',
     replace_to='',
     instance_type='x2large'):
      '''Substrings replacement in an ASCII file
    | 
    | replace_strings( client,
    |      file_in='file.txt',
    |      file_out='file.txt',
    |      replace_from='',
    |      replace_to='',
    |      instance_type='x2large' )

:param file_in: Path to the input file
:param file_out: Path to the output file
:param replace_from: Comma-separated list of substrings to replace
:param replace_to: Comma-separated list of replacement substrings
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "replace strings",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def replace_strings_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     replace_from='',
     replace_to='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".txt",
     extension_file_out=".txt",
     skip_existing_files = False):
      '''Substrings replacement in an ASCII file
    | 
    | replace_strings_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      replace_from='',
    |      replace_to='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".txt",
    |      extension_folder_out=".txt",
    |      skip_existing_files = False )

:param replace_from: Comma-separated list of substrings to replace
:param replace_to: Comma-separated list of replacement substrings
:param folder_in: Path to the input folder
:param folder_out: Path to the output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "replace strings" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_greater_equal(client,
     infile1='in.npy',
     infile2='in.npy',
     outfile='out.npy',
     dtype='float',
     instance_type='x2large'):
      '''Elementwiese greater equal operator on a matrix.
    | 
    | values_greater_equal( client,
    |      infile1='in.npy',
    |      infile2='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      instance_type='x2large' )

:param infile1: Input file path
:param infile2: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values greater equal",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_greater_equal_folder(client,
     infolder1='/infolder1',
     infolder2='/infolder2',
     outfolder='/outfolder',
     dtype='float',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile1=".npy",
     extension_infile2=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Elementwiese greater equal operator on a matrix.
    | 
    | values_greater_equal_folder(client,
    |      infolder1='/infolder1',
    |      infolder2='/infolder2',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder1=".npy",
    |      extension_infolder2=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param infolder1: Input folder folder
:param infolder2: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder1: File extension of files in folder for infolder1
:param extension_infolder2: File extension of files in folder for infolder2
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder1']
      del all_parameters['infolder2']
      del all_parameters['outfolder']
      del all_parameters['extension_infile1']
      del all_parameters['extension_infile2']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile1,infile2,outfile"
      folders = infolder1 + "," + infolder2 + "," + outfolder
      extensions = extension_infile1 + "," + extension_infile2 + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values greater equal" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def less_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1,
     instance_type='x2large'):
      '''Less operator on a matrix.
    | 
    | less_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "less constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def less_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Less operator on a matrix.
    | 
    | less_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "less constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def subtract_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=0.0,
     instance_type='x2large'):
      '''Subtract a constant value from a matrix.
    | 
    | subtract_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=0.0,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to subtract (default: 0.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "subtract constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def subtract_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=0.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Subtract a constant value from a matrix.
    | 
    | subtract_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=0.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to subtract (default: 0.0)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "subtract constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_hstack(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     dtype='str',
     instance_type='x2large'):
      '''
    | 
    | values_hstack( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      dtype='str',
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy, .labels or .txt]
:param file_values2_in: input file [.npy, .labels or .txt]
:param file_values_out: output file [.txt or .npy]
:param dtype: data type
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values hstack",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_hstack_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     dtype='str',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_hstack_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      dtype='str',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param dtype: data type
:param folder_values1_in: input folder [.npy, .labels or .txt]
:param folder_values2_in: input folder [.npy, .labels or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values hstack" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def resize_slice_matrix(client,
     filename_in='in.npy',
     filename_out='out.npy',
     dtype='float',
     indices=':,124:,:3',
     default_value=0.0,
     instance_type='x2large'):
      '''Resize and slice a matrix based on indices.
    | 
    | resize_slice_matrix( client,
    |      filename_in='in.npy',
    |      filename_out='out.npy',
    |      dtype='float',
    |      indices=':,124:,:3',
    |      default_value=0.0,
    |      instance_type='x2large' )

:param filename_in: Input file path for the matrix
:param filename_out: Output file path for the resized and sliced matrix
:param dtype: Data type of the matrix (default: float)
:param indices: Indices to slice the matrix (in NumPy slicing convention)
:param default_value: Default value to fill when resizing (default: 0.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "resize slice matrix",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def resize_slice_matrix_folder(client,
     foldername_in='/foldername_in',
     foldername_out='/foldername_out',
     dtype='float',
     indices=':,124:,:3',
     default_value=0.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_filename_in=".npy",
     extension_filename_out=".npy",
     skip_existing_files = False):
      '''Resize and slice a matrix based on indices.
    | 
    | resize_slice_matrix_folder(client,
    |      foldername_in='/foldername_in',
    |      foldername_out='/foldername_out',
    |      dtype='float',
    |      indices=':,124:,:3',
    |      default_value=0.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_foldername_in=".npy",
    |      extension_foldername_out=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param indices: Indices to slice the matrix (in NumPy slicing convention)
:param default_value: Default value to fill when resizing (default: 0.0)
:param foldername_in: Input folder folder for the matrix
:param foldername_out: Output folder folder for the resized and sliced matrix
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_foldername_in: File extension of files in folder for foldername_in
:param extension_foldername_out: File extension of files in folder for foldername_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['foldername_in']
      del all_parameters['foldername_out']
      del all_parameters['extension_filename_in']
      del all_parameters['extension_filename_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "filename_in,filename_out"
      folders = foldername_in + "," + foldername_out
      extensions = extension_filename_in + "," + extension_filename_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "resize slice matrix" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def sum(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     axis=-1,
     instance_type='x2large'):
      '''Sum all values of a matrix.
    | 
    | sum( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      axis=-1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param axis: axis to sum [default -1: no axis is used]
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "sum",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def sum_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     axis=-1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Sum all values of a matrix.
    | 
    | sum_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      axis=-1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param axis: axis to sum [default -1: no axis is used]
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "sum" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def greater_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1,
     instance_type='x2large'):
      '''Greater operator on a matrix.
    | 
    | greater_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "greater constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def greater_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Greater operator on a matrix.
    | 
    | greater_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "greater constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def connected_components_labeling(client,
     filename_in='in.npy',
     filename_out='out.npy',
     dtype='float',
     no_type=0.0,
     value=1.0,
     instance_type='x2large'):
      '''Perform connected components labeling on a matrix.
    | 
    | connected_components_labeling( client,
    |      filename_in='in.npy',
    |      filename_out='out.npy',
    |      dtype='float',
    |      no_type=0.0,
    |      value=1.0,
    |      instance_type='x2large' )

:param filename_in: Input file path for the matrix
:param filename_out: Output file path for the labeled matrix
:param dtype: Data type of the matrix (default: float)
:param no_type: Value representing no_type in the matrix (default: 0.0)
:param value: Value representing value in the matrix (default: 1.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "connected components labeling",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def connected_components_labeling_folder(client,
     foldername_in='/foldername_in',
     foldername_out='/foldername_out',
     dtype='float',
     no_type=0.0,
     value=1.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_filename_in=".npy",
     extension_filename_out=".npy",
     skip_existing_files = False):
      '''Perform connected components labeling on a matrix.
    | 
    | connected_components_labeling_folder(client,
    |      foldername_in='/foldername_in',
    |      foldername_out='/foldername_out',
    |      dtype='float',
    |      no_type=0.0,
    |      value=1.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_foldername_in=".npy",
    |      extension_foldername_out=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param no_type: Value representing no_type in the matrix (default: 0.0)
:param value: Value representing value in the matrix (default: 1.0)
:param foldername_in: Input folder folder for the matrix
:param foldername_out: Output folder folder for the labeled matrix
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_foldername_in: File extension of files in folder for foldername_in
:param extension_foldername_out: File extension of files in folder for foldername_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['foldername_in']
      del all_parameters['foldername_out']
      del all_parameters['extension_filename_in']
      del all_parameters['extension_filename_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "filename_in,filename_out"
      folders = foldername_in + "," + foldername_out
      extensions = extension_filename_in + "," + extension_filename_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "connected components labeling" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_distance(client,
     filename_is='in1.npy',
     filename_should='in2.npy',
     output_file='out.npy',
     dtype='float',
     no_type=0.0,
     value=1.0,
     gridsize=1.0,
     instance_type='x2large'):
      '''Compute Euclidean distance from is matrix to should matrix.
    | 
    | values_distance( client,
    |      filename_is='in1.npy',
    |      filename_should='in2.npy',
    |      output_file='out.npy',
    |      dtype='float',
    |      no_type=0.0,
    |      value=1.0,
    |      gridsize=1.0,
    |      instance_type='x2large' )

:param filename_is: Input file path for is matrix
:param filename_should: Input file path for should matrix
:param output_file: Output file path for distances matrix
:param dtype: Data type of the matrices (default: float)
:param no_type: Value representing no_type in the matrices (default: 0.0)
:param value: Value representing value in the matrices (default: 1.0)
:param gridsize: Resolution of the spatial grid in meters (default: 1.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values distance",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_distance_folder(client,
     foldername_is='/foldername_is',
     foldername_should='/foldername_should',
     output_folder='/output_folder',
     dtype='float',
     no_type=0.0,
     value=1.0,
     gridsize=1.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_filename_is=".npy",
     extension_filename_should=".npy",
     extension_output_file=".npy",
     skip_existing_files = False):
      '''Compute Euclidean distance from is matrix to should matrix.
    | 
    | values_distance_folder(client,
    |      foldername_is='/foldername_is',
    |      foldername_should='/foldername_should',
    |      output_folder='/output_folder',
    |      dtype='float',
    |      no_type=0.0,
    |      value=1.0,
    |      gridsize=1.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_foldername_is=".npy",
    |      extension_foldername_should=".npy",
    |      extension_output_folder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrices (default: float)
:param no_type: Value representing no_type in the matrices (default: 0.0)
:param value: Value representing value in the matrices (default: 1.0)
:param gridsize: Resolution of the spatial grid in meters (default: 1.0)
:param foldername_is: Input folder folder for is matrix
:param foldername_should: Input folder folder for should matrix
:param output_folder: Output folder folder for distances matrix
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_foldername_is: File extension of files in folder for foldername_is
:param extension_foldername_should: File extension of files in folder for foldername_should
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['foldername_is']
      del all_parameters['foldername_should']
      del all_parameters['output_folder']
      del all_parameters['extension_filename_is']
      del all_parameters['extension_filename_should']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "filename_is,filename_should,output_file"
      folders = foldername_is + "," + foldername_should + "," + output_folder
      extensions = extension_filename_is + "," + extension_filename_should + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values distance" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_greater(client,
     infile1='in.npy',
     infile2='in.npy',
     outfile='out.npy',
     dtype='float',
     instance_type='x2large'):
      '''Elementwiese greater operator on a matrix.
    | 
    | values_greater( client,
    |      infile1='in.npy',
    |      infile2='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      instance_type='x2large' )

:param infile1: Input file path
:param infile2: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values greater",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_greater_folder(client,
     infolder1='/infolder1',
     infolder2='/infolder2',
     outfolder='/outfolder',
     dtype='float',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile1=".npy",
     extension_infile2=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Elementwiese greater operator on a matrix.
    | 
    | values_greater_folder(client,
    |      infolder1='/infolder1',
    |      infolder2='/infolder2',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder1=".npy",
    |      extension_infolder2=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param infolder1: Input folder folder
:param infolder2: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder1: File extension of files in folder for infolder1
:param extension_infolder2: File extension of files in folder for infolder2
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder1']
      del all_parameters['infolder2']
      del all_parameters['outfolder']
      del all_parameters['extension_infile1']
      del all_parameters['extension_infile2']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile1,infile2,outfile"
      folders = infolder1 + "," + infolder2 + "," + outfolder
      extensions = extension_infile1 + "," + extension_infile2 + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values greater" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_add(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_add( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy, .labels or .txt]
:param file_values2_in: input file [.npy, .labels or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values add",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_add_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_add_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy, .labels or .txt]
:param folder_values2_in: input folder [.npy, .labels or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values add" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def not_equal_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1,
     instance_type='x2large'):
      '''Not equal operator on a matrix.
    | 
    | not_equal_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "not equal constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def not_equal_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Not equal operator on a matrix.
    | 
    | not_equal_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "not equal constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def multiply_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1.0,
     instance_type='x2large'):
      '''Multiply a constant value from a matrix.
    | 
    | multiply_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1.0,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to multiply (default: 1.0)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "multiply constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def multiply_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Multiply a constant value from a matrix.
    | 
    | multiply_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Constant value to multiply (default: 1.0)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "multiply constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_assign(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_assign( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy or .txt]
:param file_values2_in: input file [.npy or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values assign",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_assign_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_assign_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy or .txt]
:param folder_values2_in: input folder [.npy or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values assign" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def sliced_assign_constant(client,
     file_in='file1.npy',
     file_out='values.txt',
     indices=':',
     constant=0.0,
     instance_type='x2large'):
      '''
    | 
    | sliced_assign_constant( client,
    |      file_in='file1.npy',
    |      file_out='values.txt',
    |      indices=':',
    |      constant=0.0,
    |      instance_type='x2large' )

:param file_in: input file [.txt or .npy]
:param file_out: output file [.txt or .npy]
:param indices: indices to slice
:param constant: constant value to assign
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "sliced assign constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def sliced_assign_constant_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     indices=':',
     constant=0.0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".npy",
     extension_file_out=".txt",
     skip_existing_files = False):
      '''
    | 
    | sliced_assign_constant_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      indices=':',
    |      constant=0.0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".npy",
    |      extension_folder_out=".txt",
    |      skip_existing_files = False )

:param indices: indices to slice
:param constant: constant value to assign
:param folder_in: input folder [.txt or .npy]
:param folder_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "sliced assign constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def count_unique_values(client,
     filename_in='in.npy',
     filename_out='out.npy',
     dtype='float',
     ignore='nan',
     instance_type='x2large'):
      '''Count unique occurrences of values in a matrix.
    | 
    | count_unique_values( client,
    |      filename_in='in.npy',
    |      filename_out='out.npy',
    |      dtype='float',
    |      ignore='nan',
    |      instance_type='x2large' )

:param filename_in: Input file path for the matrix
:param filename_out: Output file path for the unique counts matrix
:param dtype: Data type of the matrix (default: float)
:param ignore: Data value to ignore
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "count_unique_values",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def count_unique_values_folder(client,
     foldername_in='/foldername_in',
     foldername_out='/foldername_out',
     dtype='float',
     ignore='nan',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_filename_in=".npy",
     extension_filename_out=".npy",
     skip_existing_files = False):
      '''Count unique occurrences of values in a matrix.
    | 
    | count_unique_values_folder(client,
    |      foldername_in='/foldername_in',
    |      foldername_out='/foldername_out',
    |      dtype='float',
    |      ignore='nan',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_foldername_in=".npy",
    |      extension_foldername_out=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param ignore: Data value to ignore
:param foldername_in: Input folder folder for the matrix
:param foldername_out: Output folder folder for the unique counts matrix
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_foldername_in: File extension of files in folder for foldername_in
:param extension_foldername_out: File extension of files in folder for foldername_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['foldername_in']
      del all_parameters['foldername_out']
      del all_parameters['extension_filename_in']
      del all_parameters['extension_filename_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "filename_in,filename_out"
      folders = foldername_in + "," + foldername_out
      extensions = extension_filename_in + "," + extension_filename_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "count_unique_values" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def replace_in_string_array(client,
     file_in='in.txt',
     file_out='out.txt',
     tokens_to_replace='',
     replacement_tokens='',
     instance_type='x2large'):
      '''Replace tokens in a string array
    | 
    | replace_in_string_array( client,
    |      file_in='in.txt',
    |      file_out='out.txt',
    |      tokens_to_replace='',
    |      replacement_tokens='',
    |      instance_type='x2large' )

:param file_in: Input filename
:param file_out: Output filename
:param tokens_to_replace: Tokens to replace, comma separated
:param replacement_tokens: Replacement tokens, comma separated
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "replace in string array",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def replace_in_string_array_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     tokens_to_replace='',
     replacement_tokens='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".txt",
     extension_file_out=".txt",
     skip_existing_files = False):
      '''Replace tokens in a string array
    | 
    | replace_in_string_array_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      tokens_to_replace='',
    |      replacement_tokens='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".txt",
    |      extension_folder_out=".txt",
    |      skip_existing_files = False )

:param tokens_to_replace: Tokens to replace, comma separated
:param replacement_tokens: Replacement tokens, comma separated
:param folder_in: Input foldername
:param folder_out: Output foldername
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "replace in string array" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def hstack(client,
     file_values_in='file1.npy',
     file_values_out='values.npy',
     dtype='str',
     instance_type='x2large'):
      '''
    | 
    | hstack( client,
    |      file_values_in='file1.npy',
    |      file_values_out='values.npy',
    |      dtype='str',
    |      instance_type='x2large' )

:param file_values_in: input file [.npy, .labels or .txt]
:param file_values_out: output file [.txt or .npy]
:param dtype: data type
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "hstack",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def hstack_folder(client,
     folder_values_in='/folder_values_in',
     folder_values_out='/folder_values_out',
     dtype='str',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | hstack_folder(client,
    |      folder_values_in='/folder_values_in',
    |      folder_values_out='/folder_values_out',
    |      dtype='str',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param dtype: data type
:param folder_values_in: input folder [.npy, .labels or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values_in: File extension of files in folder for folder_values_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values_in,file_values_out"
      folders = folder_values_in + "," + folder_values_out
      extensions = extension_file_values_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "hstack" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def mask_subset(client,
     file_values1_in='file1.npy',
     file_mask_in='file2.npy',
     file_values_out='values.txt',
     instance_type='x2large'):
      '''
    | 
    | mask_subset( client,
    |      file_values1_in='file1.npy',
    |      file_mask_in='file2.npy',
    |      file_values_out='values.txt',
    |      instance_type='x2large' )

:param file_values1_in: input file [.txt or .npy]
:param file_mask_in: input file that contains [0,1] values
:param file_values_out: output file [.txt or .npy]
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "mask subset",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def mask_subset_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_mask_in='/folder_mask_in',
     folder_values_out='/folder_values_out',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_mask_in=".npy",
     extension_file_values_out=".txt",
     skip_existing_files = False):
      '''
    | 
    | mask_subset_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_mask_in='/folder_mask_in',
    |      folder_values_out='/folder_values_out',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_mask_in=".npy",
    |      extension_folder_values_out=".txt",
    |      skip_existing_files = False )

:param folder_values1_in: input folder [.txt or .npy]
:param folder_mask_in: input folder that contains [0,1] values
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_mask_in: File extension of files in folder for folder_mask_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_mask_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_mask_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_mask_in,file_values_out"
      folders = folder_values1_in + "," + folder_mask_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_mask_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "mask subset" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_multiply(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_multiply( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy or .txt]
:param file_values2_in: input file [.npy or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values multiply",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_multiply_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_multiply_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy or .txt]
:param folder_values2_in: input folder [.npy or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values multiply" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def slice_string_array(client,
     file_in='in.txt',
     file_out='out.txt',
     slices='',
     instance_type='x2large'):
      '''Slice a string array
    | 
    | slice_string_array( client,
    |      file_in='in.txt',
    |      file_out='out.txt',
    |      slices='',
    |      instance_type='x2large' )

:param file_in: Input filename
:param file_out: Output filename
:param slices: Slices to take
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "slice string array",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def slice_string_array_folder(client,
     folder_in='/folder_in',
     folder_out='/folder_out',
     slices='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_in=".txt",
     extension_file_out=".txt",
     skip_existing_files = False):
      '''Slice a string array
    | 
    | slice_string_array_folder(client,
    |      folder_in='/folder_in',
    |      folder_out='/folder_out',
    |      slices='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_in=".txt",
    |      extension_folder_out=".txt",
    |      skip_existing_files = False )

:param slices: Slices to take
:param folder_in: Input foldername
:param folder_out: Output foldername
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_in: File extension of files in folder for folder_in
:param extension_folder_out: File extension of files in folder for folder_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_in']
      del all_parameters['folder_out']
      del all_parameters['extension_file_in']
      del all_parameters['extension_file_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_in,file_out"
      folders = folder_in + "," + folder_out
      extensions = extension_file_in + "," + extension_file_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "slice string array" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_equal(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_equal( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy or .txt]
:param file_values2_in: input file [.npy or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values equal",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_equal_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_equal_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy or .txt]
:param folder_values2_in: input folder [.npy or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values equal" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def less_equal_constant(client,
     infile='in.npy',
     outfile='out.npy',
     dtype='float',
     constant=1,
     instance_type='x2large'):
      '''Less equal operator on a matrix.
    | 
    | less_equal_constant( client,
    |      infile='in.npy',
    |      outfile='out.npy',
    |      dtype='float',
    |      constant=1,
    |      instance_type='x2large' )

:param infile: Input file path
:param outfile: Output file path
:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "less equal constant",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def less_equal_constant_folder(client,
     infolder='/infolder',
     outfolder='/outfolder',
     dtype='float',
     constant=1,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_infile=".npy",
     extension_outfile=".npy",
     skip_existing_files = False):
      '''Less equal operator on a matrix.
    | 
    | less_equal_constant_folder(client,
    |      infolder='/infolder',
    |      outfolder='/outfolder',
    |      dtype='float',
    |      constant=1,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_infolder=".npy",
    |      extension_outfolder=".npy",
    |      skip_existing_files = False )

:param dtype: Data type of the matrix (default: float)
:param constant: Value to compare (default: 1)
:param infolder: Input folder folder
:param outfolder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_infolder: File extension of files in folder for infolder
:param extension_outfolder: File extension of files in folder for outfolder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['infolder']
      del all_parameters['outfolder']
      del all_parameters['extension_infile']
      del all_parameters['extension_outfile']

      cmd_str = json.dumps(all_parameters)
      parameters = "infile,outfile"
      folders = infolder + "," + outfolder
      extensions = extension_infile + "," + extension_outfile
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "less equal constant" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def vstack(client,
     file_values_in='file1.npy',
     file_values_out='values.npy',
     dtype='str',
     instance_type='x2large'):
      '''
    | 
    | vstack( client,
    |      file_values_in='file1.npy',
    |      file_values_out='values.npy',
    |      dtype='str',
    |      instance_type='x2large' )

:param file_values_in: input file [.npy, .labels or .txt]
:param file_values_out: output file [.txt or .npy]
:param dtype: data type
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "vstack",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def vstack_folder(client,
     folder_values_in='/folder_values_in',
     folder_values_out='/folder_values_out',
     dtype='str',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | vstack_folder(client,
    |      folder_values_in='/folder_values_in',
    |      folder_values_out='/folder_values_out',
    |      dtype='str',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param dtype: data type
:param folder_values_in: input folder [.npy, .labels or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values_in: File extension of files in folder for folder_values_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values_in,file_values_out"
      folders = folder_values_in + "," + folder_values_out
      extensions = extension_file_values_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "vstack" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def remap_values(client,
     file_values_in='file.npy',
     file_values_out='values.npy',
     map_in='1,2,3,4',
     map_out='3,1,2,2',
     dtype_in='int32',
     dtype_out='int32',
     unmapped='0',
     instance_type='x2large'):
      '''
    | 
    | remap_values( client,
    |      file_values_in='file.npy',
    |      file_values_out='values.npy',
    |      map_in='1,2,3,4',
    |      map_out='3,1,2,2',
    |      dtype_in='int32',
    |      dtype_out='int32',
    |      unmapped='0',
    |      instance_type='x2large' )

:param file_values_in: input file [.txt, .labels or .npy]
:param file_values_out: output file [.txt, .labels or .npy]
:param map_in: map in
:param map_out: map out
:param dtype_in: data type input
:param dtype_out: data type output
:param unmapped: default value for values where no mapping exists
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "remap values",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def remap_values_folder(client,
     folder_values_in='/folder_values_in',
     folder_values_out='/folder_values_out',
     map_in='1,2,3,4',
     map_out='3,1,2,2',
     dtype_in='int32',
     dtype_out='int32',
     unmapped='0',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | remap_values_folder(client,
    |      folder_values_in='/folder_values_in',
    |      folder_values_out='/folder_values_out',
    |      map_in='1,2,3,4',
    |      map_out='3,1,2,2',
    |      dtype_in='int32',
    |      dtype_out='int32',
    |      unmapped='0',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param map_in: map in
:param map_out: map out
:param dtype_in: data type input
:param dtype_out: data type output
:param unmapped: default value for values where no mapping exists
:param folder_values_in: input folder [.txt, .labels or .npy]
:param folder_values_out: output folder [.txt, .labels or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values_in: File extension of files in folder for folder_values_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values_in,file_values_out"
      folders = folder_values_in + "," + folder_values_out
      extensions = extension_file_values_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "remap values" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_subtract(client,
     file_values1_in='file1.npy',
     file_values2_in='file2.npy',
     file_values_out='values.npy',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     instance_type='x2large'):
      '''
    | 
    | values_subtract( client,
    |      file_values1_in='file1.npy',
    |      file_values2_in='file2.npy',
    |      file_values_out='values.npy',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      instance_type='x2large' )

:param file_values1_in: input file [.npy or .txt]
:param file_values2_in: input file [.npy or .txt]
:param file_values_out: output file [.txt or .npy]
:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "values subtract",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def values_subtract_folder(client,
     folder_values1_in='/folder_values1_in',
     folder_values2_in='/folder_values2_in',
     folder_values_out='/folder_values_out',
     ignore_label=float("nan"),
     value_subset1=float("nan"),
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_values1_in=".npy",
     extension_file_values2_in=".npy",
     extension_file_values_out=".npy",
     skip_existing_files = False):
      '''
    | 
    | values_subtract_folder(client,
    |      folder_values1_in='/folder_values1_in',
    |      folder_values2_in='/folder_values2_in',
    |      folder_values_out='/folder_values_out',
    |      ignore_label=float("nan"),
    |      value_subset1=float("nan"),
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_values1_in=".npy",
    |      extension_folder_values2_in=".npy",
    |      extension_folder_values_out=".npy",
    |      skip_existing_files = False )

:param ignore_label: ignore value default: nan
:param value_subset1: ignore value default: nan
:param folder_values1_in: input folder [.npy or .txt]
:param folder_values2_in: input folder [.npy or .txt]
:param folder_values_out: output folder [.txt or .npy]
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_values1_in: File extension of files in folder for folder_values1_in
:param extension_folder_values2_in: File extension of files in folder for folder_values2_in
:param extension_folder_values_out: File extension of files in folder for folder_values_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_values1_in']
      del all_parameters['folder_values2_in']
      del all_parameters['folder_values_out']
      del all_parameters['extension_file_values1_in']
      del all_parameters['extension_file_values2_in']
      del all_parameters['extension_file_values_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_values1_in,file_values2_in,file_values_out"
      folders = folder_values1_in + "," + folder_values2_in + "," + folder_values_out
      extensions = extension_file_values1_in + "," + extension_file_values2_in + "," + extension_file_values_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "values subtract" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class fvo:
   def model_swap_axis(client,
     input_file='in.dxf',
     output_file='out.dxf',
     instance_type='x2large'):
      '''
    | 
    | model_swap_axis( client,
    |      input_file='in.dxf',
    |      output_file='out.dxf',
    |      instance_type='x2large' )

:param input_file: input dxf file path
:param output_file: output dxf file path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "model swap axis",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def model_swap_axis_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".dxf",
     extension_output_file=".dxf",
     skip_existing_files = False):
      '''
    | 
    | model_swap_axis_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".dxf",
    |      extension_output_folder=".dxf",
    |      skip_existing_files = False )

:param input_folder: input dxf folder folder
:param output_folder: output dxf folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "model swap axis" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def estimate_vobject_coordinates(client,
     file_source_in='points.laz',
     file_trafo_out='trafo.txt',
     file_source_out='points.laz',
     instance_type='x2large'):
      '''
    | 
    | estimate_vobject_coordinates( client,
    |      file_source_in='points.laz',
    |      file_trafo_out='trafo.txt',
    |      file_source_out='points.laz',
    |      instance_type='x2large' )

:param file_source_in: input file data
:param file_trafo_out: output trafo
:param file_source_out: output file data
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "estimate vobject coordinates",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def estimate_vobject_coordinates_folder(client,
     folder_source_in='/folder_source_in',
     folder_trafo_out='/folder_trafo_out',
     folder_source_out='/folder_source_out',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_file_source_in=".laz",
     extension_file_trafo_out=".txt",
     extension_file_source_out=".laz",
     skip_existing_files = False):
      '''
    | 
    | estimate_vobject_coordinates_folder(client,
    |      folder_source_in='/folder_source_in',
    |      folder_trafo_out='/folder_trafo_out',
    |      folder_source_out='/folder_source_out',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_source_in=".laz",
    |      extension_folder_trafo_out=".txt",
    |      extension_folder_source_out=".laz",
    |      skip_existing_files = False )

:param folder_source_in: input folder data
:param folder_trafo_out: output trafo
:param folder_source_out: output folder data
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_folder_source_in: File extension of files in folder for folder_source_in
:param extension_folder_trafo_out: File extension of files in folder for folder_trafo_out
:param extension_folder_source_out: File extension of files in folder for folder_source_out
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_source_in']
      del all_parameters['folder_trafo_out']
      del all_parameters['folder_source_out']
      del all_parameters['extension_file_source_in']
      del all_parameters['extension_file_trafo_out']
      del all_parameters['extension_file_source_out']

      cmd_str = json.dumps(all_parameters)
      parameters = "file_source_in,file_trafo_out,file_source_out"
      folders = folder_source_in + "," + folder_trafo_out + "," + folder_source_out
      extensions = extension_file_source_in + "," + extension_file_trafo_out + "," + extension_file_source_out
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "estimate vobject coordinates" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def filter_valid_vertices(client,
     input_file='in.laz',
     input_file2='ref.laz',
     input_file_features='edges.npy',
     output_file='out.laz',
     output_file_features='edges.npy',
     min_distance=0.0,
     max_distance=100,
     instance_type='x2large'):
      '''Filter valid vertices from a DXF file.
    | 
    | filter_valid_vertices( client,
    |      input_file='in.laz',
    |      input_file2='ref.laz',
    |      input_file_features='edges.npy',
    |      output_file='out.laz',
    |      output_file_features='edges.npy',
    |      min_distance=0.0,
    |      max_distance=100,
    |      instance_type='x2large' )

:param input_file: Input laz or txt file to filter.
:param input_file2: Input laz or txt file as reference.
:param input_file_features: Input features file.
:param output_file: Output laz or txt file.
:param output_file_features: Output features file.
:param min_distance: Minimum distance.
:param max_distance: Maximum distance.
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "filter valid vertices",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def filter_valid_vertices_folder(client,
     input_folder='/input_folder',
     input_folder2='/input_folder2',
     input_folder_features='/input_folder_features',
     output_folder='/output_folder',
     output_folder_features='/output_folder_features',
     min_distance=0.0,
     max_distance=100,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_input_file2=".laz",
     extension_input_file_features=".npy",
     extension_output_file=".laz",
     extension_output_file_features=".npy",
     skip_existing_files = False):
      '''Filter valid vertices from a DXF file.
    | 
    | filter_valid_vertices_folder(client,
    |      input_folder='/input_folder',
    |      input_folder2='/input_folder2',
    |      input_folder_features='/input_folder_features',
    |      output_folder='/output_folder',
    |      output_folder_features='/output_folder_features',
    |      min_distance=0.0,
    |      max_distance=100,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_input_folder2=".laz",
    |      extension_input_folder_features=".npy",
    |      extension_output_folder=".laz",
    |      extension_output_folder_features=".npy",
    |      skip_existing_files = False )

:param min_distance: Minimum distance.
:param max_distance: Maximum distance.
:param input_folder: Input laz or txt folder to filter.
:param input_folder2: Input laz or txt folder as reference.
:param input_folder_features: Input features folder.
:param output_folder: Output laz or txt folder.
:param output_folder_features: Output features folder.
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_input_folder2: File extension of files in folder for input_folder2
:param extension_input_folder_features: File extension of files in folder for input_folder_features
:param extension_output_folder: File extension of files in folder for output_folder
:param extension_output_folder_features: File extension of files in folder for output_folder_features
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['input_folder2']
      del all_parameters['input_folder_features']
      del all_parameters['output_folder']
      del all_parameters['output_folder_features']
      del all_parameters['extension_input_file']
      del all_parameters['extension_input_file2']
      del all_parameters['extension_input_file_features']
      del all_parameters['extension_output_file']
      del all_parameters['extension_output_file_features']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,input_file2,input_file_features,output_file,output_file_features"
      folders = input_folder + "," + input_folder2 + "," + input_folder_features + "," + output_folder + "," + output_folder_features
      extensions = extension_input_file + "," + extension_input_file2 + "," + extension_input_file_features + "," + extension_output_file + "," + extension_output_file_features
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "filter valid vertices" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def align_top(client,
     input_file='in.laz',
     target_file='in.laz',
     output_file='out.laz',
     instance_type='x2large'):
      '''Zero centering of XYZ points in a LAZ file
    | 
    | align_top( client,
    |      input_file='in.laz',
    |      target_file='in.laz',
    |      output_file='out.laz',
    |      instance_type='x2large' )

:param input_file: input LAZ file path
:param target_file: input LAZ file path
:param output_file: output LAZ file path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "align top",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def align_top_folder(client,
     input_folder='/input_folder',
     target_folder='/target_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_target_file=".laz",
     extension_output_file=".laz",
     skip_existing_files = False):
      '''Zero centering of XYZ points in a LAZ file
    | 
    | align_top_folder(client,
    |      input_folder='/input_folder',
    |      target_folder='/target_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_target_folder=".laz",
    |      extension_output_folder=".laz",
    |      skip_existing_files = False )

:param input_folder: input LAZ folder folder
:param target_folder: input LAZ folder folder
:param output_folder: output LAZ folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_target_folder: File extension of files in folder for target_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['target_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_target_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,target_file,output_file"
      folders = input_folder + "," + target_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_target_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "align top" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def optimize_model_graph(client,
     in_dxf_file='in.dxf',
     in_point_cloud_file='in.laz',
     out_dxf_file='out.dxf',
     max_distance=0.35,
     num_iterations=4,
     instance_type='x2large'):
      '''Optimize the graph of a 3D model.
    | 
    | optimize_model_graph( client,
    |      in_dxf_file='in.dxf',
    |      in_point_cloud_file='in.laz',
    |      out_dxf_file='out.dxf',
    |      max_distance=0.35,
    |      num_iterations=4,
    |      instance_type='x2large' )

:param in_dxf_file: input file
:param in_point_cloud_file: input file
:param out_dxf_file: output file
:param max_distance: Maximum distance between a point and a graph node for the point to be considered a candidate for merging with the graph node.
:param num_iterations: Number of iterations to run the optimization.
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "optimize model graph",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def optimize_model_graph_folder(client,
     in_dxf_folder='/in_dxf_folder',
     in_point_cloud_folder='/in_point_cloud_folder',
     out_dxf_folder='/out_dxf_folder',
     max_distance=0.35,
     num_iterations=4,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_dxf_file=".dxf",
     extension_in_point_cloud_file=".laz",
     extension_out_dxf_file=".dxf",
     skip_existing_files = False):
      '''Optimize the graph of a 3D model.
    | 
    | optimize_model_graph_folder(client,
    |      in_dxf_folder='/in_dxf_folder',
    |      in_point_cloud_folder='/in_point_cloud_folder',
    |      out_dxf_folder='/out_dxf_folder',
    |      max_distance=0.35,
    |      num_iterations=4,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_dxf_folder=".dxf",
    |      extension_in_point_cloud_folder=".laz",
    |      extension_out_dxf_folder=".dxf",
    |      skip_existing_files = False )

:param max_distance: Maximum distance between a point and a graph node for the point to be considered a candidate for merging with the graph node.
:param num_iterations: Number of iterations to run the optimization.
:param in_dxf_folder: input folder
:param in_point_cloud_folder: input folder
:param out_dxf_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_dxf_folder: File extension of files in folder for in_dxf_folder
:param extension_in_point_cloud_folder: File extension of files in folder for in_point_cloud_folder
:param extension_out_dxf_folder: File extension of files in folder for out_dxf_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_dxf_folder']
      del all_parameters['in_point_cloud_folder']
      del all_parameters['out_dxf_folder']
      del all_parameters['extension_in_dxf_file']
      del all_parameters['extension_in_point_cloud_file']
      del all_parameters['extension_out_dxf_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_dxf_file,in_point_cloud_file,out_dxf_file"
      folders = in_dxf_folder + "," + in_point_cloud_folder + "," + out_dxf_folder
      extensions = extension_in_dxf_file + "," + extension_in_point_cloud_file + "," + extension_out_dxf_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "optimize model graph" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def simplify_model(client,
     in_file='in.dxf',
     out_file='out.dxf',
     layers='1',
     distance=0.25,
     instance_type='x2large'):
      '''Simplify a 3D model
    | 
    | simplify_model( client,
    |      in_file='in.dxf',
    |      out_file='out.dxf',
    |      layers='1',
    |      distance=0.25,
    |      instance_type='x2large' )

:param in_file: input file
:param out_file: output file
:param layers: layers to be processed
:param distance: Distance threshold for corner point suppression.
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "simplify model",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def simplify_model_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     layers='1',
     distance=0.25,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".dxf",
     extension_out_file=".dxf",
     skip_existing_files = False):
      '''Simplify a 3D model
    | 
    | simplify_model_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      layers='1',
    |      distance=0.25,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".dxf",
    |      extension_out_folder=".dxf",
    |      skip_existing_files = False )

:param layers: layers to be processed
:param distance: Distance threshold for corner point suppression.
:param in_folder: input folder
:param out_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "simplify model" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def connect_neighbouring_vertices_unassigned(client,
     input_file='points.laz',
     input_vertices='vertices.laz',
     output_file='output.dxf',
     max_line_distance=0.5,
     max_line_distance_corner=0.23,
     min_samples=3,
     instance_type='x2large'):
      '''Connect neighbouring vertices in a point cloud
    | 
    | connect_neighbouring_vertices_unassigned( client,
    |      input_file='points.laz',
    |      input_vertices='vertices.laz',
    |      output_file='output.dxf',
    |      max_line_distance=0.5,
    |      max_line_distance_corner=0.23,
    |      min_samples=3,
    |      instance_type='x2large' )

:param input_file: Input file with all 3D points
:param input_vertices: Input vertices
:param output_file: Output model
:param max_line_distance: Maximum distance between line and points to be considered as inlier
:param max_line_distance_corner: Maximum distance between vertices and points to be considered as inlier
:param min_samples: Minimum number of points to fit a line
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "connect neighbouring vertices unassigned",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def connect_neighbouring_vertices_unassigned_folder(client,
     input_folder='/input_folder',
     input_vertices='vertices.laz',
     output_folder='/output_folder',
     max_line_distance=0.5,
     max_line_distance_corner=0.23,
     min_samples=3,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_output_file=".dxf",
     skip_existing_files = False):
      '''Connect neighbouring vertices in a point cloud
    | 
    | connect_neighbouring_vertices_unassigned_folder(client,
    |      input_folder='/input_folder',
    |      input_vertices='vertices.laz',
    |      output_folder='/output_folder',
    |      max_line_distance=0.5,
    |      max_line_distance_corner=0.23,
    |      min_samples=3,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_output_folder=".dxf",
    |      skip_existing_files = False )

:param input_vertices: Input vertices
:param max_line_distance: Maximum distance between line and points to be considered as inlier
:param max_line_distance_corner: Maximum distance between vertices and points to be considered as inlier
:param min_samples: Minimum number of points to fit a line
:param input_folder: Input folder with all 3D points
:param output_folder: Output model
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "connect neighbouring vertices unassigned" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def export_vertices(client,
     in_file='in.laz',
     out_file='out.dxf',
     instance_type='x2large'):
      '''Export a 3D model from a point cloud
    | 
    | export_vertices( client,
    |      in_file='in.laz',
    |      out_file='out.dxf',
    |      instance_type='x2large' )

:param in_file: input file with edges encoded in the intensity field.
:param out_file: output file
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "export vertices",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def export_vertices_folder(client,
     in_folder='/in_folder',
     out_folder='/out_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".laz",
     extension_out_file=".dxf",
     skip_existing_files = False):
      '''Export a 3D model from a point cloud
    | 
    | export_vertices_folder(client,
    |      in_folder='/in_folder',
    |      out_folder='/out_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".laz",
    |      extension_out_folder=".dxf",
    |      skip_existing_files = False )

:param in_folder: input folder with edges encoded in the intensity field.
:param out_folder: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "export vertices" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def zero_centering(client,
     input_file='in.laz',
     output_file='out.laz',
     instance_type='x2large'):
      '''Zero centering of XYZ points in a LAZ file
    | 
    | zero_centering( client,
    |      input_file='in.laz',
    |      output_file='out.laz',
    |      instance_type='x2large' )

:param input_file: input LAZ file path
:param output_file: output LAZ file path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "zero centering",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def zero_centering_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_output_file=".laz",
     skip_existing_files = False):
      '''Zero centering of XYZ points in a LAZ file
    | 
    | zero_centering_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_output_folder=".laz",
    |      skip_existing_files = False )

:param input_folder: input LAZ folder folder
:param output_folder: output LAZ folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "zero centering" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def evaluate_model(client,
     data_is='is.laz',
     model_is='is.dxf',
     model_target='target.dxf',
     vertex_target_distance=0.5,
     instance_type='x2large'):
      '''Compare two 3D models
    | 
    | evaluate_model( client,
    |      data_is='is.laz',
    |      model_is='is.dxf',
    |      model_target='target.dxf',
    |      vertex_target_distance=0.5,
    |      instance_type='x2large' )

:param data_is: input file
:param model_is: input file
:param model_target: output file
:param vertex_target_distance: Distance threshold for corner point suppression.
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "evaluate model",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def evaluate_model_folder(client,
     data_is='is.laz',
     model_is='is.dxf',
     folder_model_target='/folder_model_target',
     vertex_target_distance=0.5,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_model_target=".dxf",
     skip_existing_files = False):
      '''Compare two 3D models
    | 
    | evaluate_model_folder(client,
    |      data_is='is.laz',
    |      model_is='is.dxf',
    |      model_target='/model_target',
    |      vertex_target_distance=0.5,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_model_target=".dxf",
    |      skip_existing_files = False )

:param data_is: input file
:param model_is: input file
:param vertex_target_distance: Distance threshold for corner point suppression.
:param folder_model_target: output folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_model_target: File extension of files in folder for folder_model_target
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_model_target']
      del all_parameters['extension_model_target']

      cmd_str = json.dumps(all_parameters)
      parameters = "model_target"
      folders = folder_model_target
      extensions = extension_model_target
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "evaluate model" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def import_vertices(client,
     in_file='in.dxf',
     layer='-1',
     out_file='out.laz',
     instance_type='x2large'):
      '''Extract visible face3d vertices from a DXF file.
    | 
    | import_vertices( client,
    |      in_file='in.dxf',
    |      layer='-1',
    |      out_file='out.laz',
    |      instance_type='x2large' )

:param in_file: Input DXF file path
:param layer: Layer names as comma-separated list
:param out_file: Output file path
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "import vertices",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def import_vertices_folder(client,
     in_folder='/in_folder',
     layer='-1',
     out_folder='/out_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_in_file=".dxf",
     extension_out_file=".laz",
     skip_existing_files = False):
      '''Extract visible face3d vertices from a DXF file.
    | 
    | import_vertices_folder(client,
    |      in_folder='/in_folder',
    |      layer='-1',
    |      out_folder='/out_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_in_folder=".dxf",
    |      extension_out_folder=".laz",
    |      skip_existing_files = False )

:param layer: Layer names as comma-separated list
:param in_folder: Input DXF folder folder
:param out_folder: Output folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_in_folder: File extension of files in folder for in_folder
:param extension_out_folder: File extension of files in folder for out_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['in_folder']
      del all_parameters['out_folder']
      del all_parameters['extension_in_file']
      del all_parameters['extension_out_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "in_file,out_file"
      folders = in_folder + "," + out_folder
      extensions = extension_in_file + "," + extension_out_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "import vertices" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def likelihood(client,
     input_file='in.laz',
     points_file='points.laz',
     output_file='out.laz',
     max_distance=0.5,
     missing_distance=1.5,
     missing_knn=2,
     instance_type='x2large'):
      '''Compute class conditional probability distribution
    | 
    | likelihood( client,
    |      input_file='in.laz',
    |      points_file='points.laz',
    |      output_file='out.laz',
    |      max_distance=0.5,
    |      missing_distance=1.5,
    |      missing_knn=2,
    |      instance_type='x2large' )

:param input_file: input LAZ file path
:param points_file: input LAZ file path
:param output_file: output LAZ file path
:param max_distance: probability max distance
:param missing_distance: interpolate missing points distance
:param missing_knn: interpolate number missing neighbours
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "likelihood",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def likelihood_folder(client,
     input_folder='/input_folder',
     points_folder='/points_folder',
     output_folder='/output_folder',
     max_distance=0.5,
     missing_distance=1.5,
     missing_knn=2,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_points_file=".laz",
     extension_output_file=".laz",
     skip_existing_files = False):
      '''Compute class conditional probability distribution
    | 
    | likelihood_folder(client,
    |      input_folder='/input_folder',
    |      points_folder='/points_folder',
    |      output_folder='/output_folder',
    |      max_distance=0.5,
    |      missing_distance=1.5,
    |      missing_knn=2,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_points_folder=".laz",
    |      extension_output_folder=".laz",
    |      skip_existing_files = False )

:param max_distance: probability max distance
:param missing_distance: interpolate missing points distance
:param missing_knn: interpolate number missing neighbours
:param input_folder: input LAZ folder folder
:param points_folder: input LAZ folder folder
:param output_folder: output LAZ folder folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_points_folder: File extension of files in folder for points_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['points_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_points_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,points_file,output_file"
      folders = input_folder + "," + points_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_points_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "likelihood" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class shp:
   def intersecting_polygons(client,
     input_file='polygon.pickle',
     comparison_folder='polygons',
     output_file='list.txt',
     instance_type='x2large'):
      '''
    | 
    | intersecting_polygons( client,
    |      input_file='polygon.pickle',
    |      comparison_folder='polygons',
    |      output_file='list.txt',
    |      instance_type='x2large' )

:param input_file: Input file for the polygon
:param comparison_folder:  Input folder containing polygons for comparison
:param output_file: Output file for the list of intersecting polygon filenames
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "intersecting polygons",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def intersecting_polygons_folder(client,
     input_folder='/input_folder',
     comparison_folder='polygons',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".pickle",
     extension_output_file=".txt",
     skip_existing_files = False):
      '''
    | 
    | intersecting_polygons_folder(client,
    |      input_folder='/input_folder',
    |      comparison_folder='polygons',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".pickle",
    |      extension_output_folder=".txt",
    |      skip_existing_files = False )

:param comparison_folder:  Input folder containing polygons for comparison
:param input_folder: Input folder for the polygon
:param output_folder: Output folder for the list of intersecting polygon foldernames
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "intersecting polygons" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def extract_multipolygons_from_shp(client,
     shp_file='',
     out_polygon_folder='polygons/',
     out_attributes_folder='attributes/',
     shape_id=-1,
     name_id=0,
     instance_type='x2large'):
      '''
    | 
    | extract_multipolygons_from_shp( client,
    |      shp_file='',
    |      out_polygon_folder='polygons/',
    |      out_attributes_folder='attributes/',
    |      shape_id=-1,
    |      name_id=0,
    |      instance_type='x2large' )

:param shp_file: input shp file
:param out_polygon_folder: folder with polygons from shape file
:param out_attributes_folder: folder with records from shape file
:param shape_id: id of polygon: [-1 parses all polygons]
:param name_id: id of polygon: [-1 ignores name]
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "extract multipolygons from shp",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def extract_multipolygons_from_shp_folder(client,
     shp_folder='/shp_folder',
     folder_out_polygon_folder='/folder_out_polygon_folder',
     folder_out_attributes_folder='/folder_out_attributes_folder',
     shape_id=-1,
     name_id=0,
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_shp_file=".laz",
     extension_out_polygon_folder=".laz",
     extension_out_attributes_folder=".laz",
     skip_existing_files = False):
      '''
    | 
    | extract_multipolygons_from_shp_folder(client,
    |      shp_folder='/shp_folder',
    |      out_polygon_folder='/out_polygon_folder',
    |      out_attributes_folder='/out_attributes_folder',
    |      shape_id=-1,
    |      name_id=0,
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_shp_folder=".",
    |      extension_out_polygon_folder=".polygons/",
    |      extension_out_attributes_folder=".attributes/",
    |      skip_existing_files = False )

:param shape_id: id of polygon: [-1 parses all polygons]
:param name_id: id of polygon: [-1 ignores name]
:param shp_folder: input shp folder
:param folder_out_polygon_folder: folder with polygons from shape folder
:param folder_out_attributes_folder: folder with records from shape folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_shp_folder: File extension of files in folder for shp_folder
:param extension_out_polygon_folder: File extension of files in folder for folder_out_polygon_folder
:param extension_out_attributes_folder: File extension of files in folder for folder_out_attributes_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['shp_folder']
      del all_parameters['folder_out_polygon_folder']
      del all_parameters['folder_out_attributes_folder']
      del all_parameters['extension_shp_file']
      del all_parameters['extension_out_polygon_folder']
      del all_parameters['extension_out_attributes_folder']

      cmd_str = json.dumps(all_parameters)
      parameters = "shp_file,out_polygon_folder,out_attributes_folder"
      folders = shp_folder + "," + folder_out_polygon_folder + "," + folder_out_attributes_folder
      extensions = extension_shp_file + "," + extension_out_polygon_folder + "," + extension_out_attributes_folder
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "extract multipolygons from shp" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def wireframe_to_dxf(client,
     input_file='vertices.laz',
     edges_file='edges.npy',
     output_file='polygon.dxf',
     instance_type='x2large'):
      '''
    | 
    | wireframe_to_dxf( client,
    |      input_file='vertices.laz',
    |      edges_file='edges.npy',
    |      output_file='polygon.dxf',
    |      instance_type='x2large' )

:param input_file: Input file for the vertices
:param edges_file: Input file for the edges
:param output_file: Output file for the dxf model
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "wireframe to dxf",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def wireframe_to_dxf_folder(client,
     input_folder='/input_folder',
     edges_folder='/edges_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".laz",
     extension_edges_file=".npy",
     extension_output_file=".dxf",
     skip_existing_files = False):
      '''
    | 
    | wireframe_to_dxf_folder(client,
    |      input_folder='/input_folder',
    |      edges_folder='/edges_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".laz",
    |      extension_edges_folder=".npy",
    |      extension_output_folder=".dxf",
    |      skip_existing_files = False )

:param input_folder: Input folder for the vertices
:param edges_folder: Input folder for the edges
:param output_folder: Output folder for the dxf model
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_edges_folder: File extension of files in folder for edges_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['edges_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_edges_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,edges_file,output_file"
      folders = input_folder + "," + edges_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_edges_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "wireframe to dxf" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def make_polygon_from_json(client,
     input_file='in.json',
     output_file='out.pickle',
     point_identifiers='min_x,min_y;min_x,max_y;max_x,max_y;max_x,min_y',
     instance_type='x2large'):
      '''
    | 
    | make_polygon_from_json( client,
    |      input_file='in.json',
    |      output_file='out.pickle',
    |      point_identifiers='min_x,min_y;min_x,max_y;max_x,max_y;max_x,min_y',
    |      instance_type='x2large' )

:param input_file: Input file for the json file
:param output_file: Output file for the polygon file
:param point_identifiers: Point identifiers for the polygon
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "make polygon from json",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def make_polygon_from_json_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     point_identifiers='min_x,min_y;min_x,max_y;max_x,max_y;max_x,min_y',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".json",
     extension_output_file=".pickle",
     skip_existing_files = False):
      '''
    | 
    | make_polygon_from_json_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      point_identifiers='min_x,min_y;min_x,max_y;max_x,max_y;max_x,min_y',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".json",
    |      extension_output_folder=".pickle",
    |      skip_existing_files = False )

:param point_identifiers: Point identifiers for the polygon
:param input_folder: Input folder for the json folder
:param output_folder: Output folder for the polygon folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "make polygon from json" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class image:
   def retile_images(client,
     folder_reference='.',
     folder_to_retile='.',
     output_folder='out1',
     extension_ref='.tif',
     extension_ret='.tif',
     instance_type='x2large'):
      '''
    | 
    | retile_images( client,
    |      folder_reference='.',
    |      folder_to_retile='.',
    |      output_folder='out1',
    |      extension_ref='.tif',
    |      extension_ret='.tif',
    |      instance_type='x2large' )

:param folder_reference: Reference folder with image dimensions and geolocations that should be used for retiling
:param folder_to_retile: Folder with images that should be retiled to match reference
:param output_folder: Folder with retiled images
:param extension_ref: file extension
:param extension_ret: file extension
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "retile images",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def retile_images_folder(client,
     folder_folder_reference='/folder_folder_reference',
     folder_folder_to_retile='/folder_folder_to_retile',
     folder_output_folder='/folder_output_folder',
     extension_ref='.tif',
     extension_ret='.tif',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_folder_reference="",
     extension_folder_to_retile="",
     extension_output_folder=".laz",
     skip_existing_files = False):
      '''
    | 
    | retile_images_folder(client,
    |      folder_reference='/folder_reference',
    |      folder_to_retile='/folder_to_retile',
    |      output_folder='/output_folder',
    |      extension_ref='.tif',
    |      extension_ret='.tif',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_folder_reference=".",
    |      extension_folder_to_retile=".",
    |      extension_output_folder=".out1",
    |      skip_existing_files = False )

:param folder_folder_reference: Reference folder with image dimensions and geolocations that should be used for retiling
:param folder_folder_to_retile: Folder with images that should be retiled to match reference
:param folder_output_folder: Folder with retiled images
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_ref: file extension
:param extension_ret: file extension
:param extension_folder_reference: File extension of files in folder for folder_folder_reference
:param extension_folder_to_retile: File extension of files in folder for folder_folder_to_retile
:param extension_output_folder: File extension of files in folder for folder_output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['folder_folder_reference']
      del all_parameters['folder_folder_to_retile']
      del all_parameters['folder_output_folder']
      del all_parameters['extension_folder_reference']
      del all_parameters['extension_folder_to_retile']
      del all_parameters['extension_output_folder']

      cmd_str = json.dumps(all_parameters)
      parameters = "folder_reference,folder_to_retile,output_folder"
      folders = folder_folder_reference + "," + folder_folder_to_retile + "," + folder_output_folder
      extensions = extension_folder_reference + "," + extension_folder_to_retile + "," + extension_output_folder
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "retile images" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def canny_edge_detection(client,
     input_file='in.tif',
     output_file='out.tif',
     sigma=1.0,
     low_threshold=0.1,
     high_threshold=0.2,
     values_subset='',
     instance_type='x2large'):
      '''Perform Canny edge detection on a georeferenced image and save the detected edges as a raster.
    | 
    | canny_edge_detection( client,
    |      input_file='in.tif',
    |      output_file='out.tif',
    |      sigma=1.0,
    |      low_threshold=0.1,
    |      high_threshold=0.2,
    |      values_subset='',
    |      instance_type='x2large' )

:param input_file: Input image file
:param output_file: Output edge raster file
:param sigma: Standard deviation of the Gaussian filter
:param low_threshold: Low threshold for hysteresis
:param high_threshold: High threshold for hysteresis
:param values_subset: Subset of values to extract contours from, all values by default
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "canny edge detection",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def canny_edge_detection_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     sigma=1.0,
     low_threshold=0.1,
     high_threshold=0.2,
     values_subset='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".tif",
     extension_output_file=".tif",
     skip_existing_files = False):
      '''Perform Canny edge detection on a georeferenced image and save the detected edges as a raster.
    | 
    | canny_edge_detection_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      sigma=1.0,
    |      low_threshold=0.1,
    |      high_threshold=0.2,
    |      values_subset='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".tif",
    |      extension_output_folder=".tif",
    |      skip_existing_files = False )

:param sigma: Standard deviation of the Gaussian filter
:param low_threshold: Low threshold for hysteresis
:param high_threshold: High threshold for hysteresis
:param values_subset: Subset of values to extract contours from, all values by default
:param input_folder: Input image folder
:param output_folder: Output edge raster folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "canny edge detection" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def image_metadata(client,
     input_file='in.tif',
     output_file='out.json',
     instance_type='x2large'):
      '''Obtain metadata of a georeferenced image and save it as a JSON file.
    | 
    | image_metadata( client,
    |      input_file='in.tif',
    |      output_file='out.json',
    |      instance_type='x2large' )

:param input_file: Input georeferenced image file
:param output_file: Output JSON file
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "image metadata",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def image_metadata_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".tif",
     extension_output_file=".json",
     skip_existing_files = False):
      '''Obtain metadata of a georeferenced image and save it as a JSON file.
    | 
    | image_metadata_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".tif",
    |      extension_output_folder=".json",
    |      skip_existing_files = False )

:param input_folder: Input georeferenced image folder
:param output_folder: Output JSON folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "image metadata" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def resize_image(client,
     input_file='in.tif',
     output_file='out.tif',
     new_grid_size=1.,
     compression='None',
     instance_type='x2large'):
      '''
    | 
    | resize_image( client,
    |      input_file='in.tif',
    |      output_file='out.tif',
    |      new_grid_size=1.,
    |      compression='None',
    |      instance_type='x2large' )

:param input_file: Input georeferenced image file
:param output_file: Output georeferenced image file
:param new_grid_size: New grid size in meters
:param compression: Compression method (e.g., deflate, lzw)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "resize image",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def resize_image_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     new_grid_size=1.,
     compression='None',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".tif",
     extension_output_file=".tif",
     skip_existing_files = False):
      '''
    | 
    | resize_image_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      new_grid_size=1.,
    |      compression='None',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".tif",
    |      extension_output_folder=".tif",
    |      skip_existing_files = False )

:param new_grid_size: New grid size in meters
:param compression: Compression method (e.g., deflate, lzw)
:param input_folder: Input georeferenced image folder
:param output_folder: Output georeferenced image folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "resize image" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def extract_contours(client,
     input_file='file.tif',
     value=0.5,
     output_file='file.shp',
     values_subset='',
     instance_type='x2large'):
      '''Extract contours from a georeferenced image and save them as a shapefile.
    | 
    | extract_contours( client,
    |      input_file='file.tif',
    |      value=0.5,
    |      output_file='file.shp',
    |      values_subset='',
    |      instance_type='x2large' )

:param input_file: Input georeferenced image file
:param value: Contour value
:param output_file: Output shapefile
:param values_subset: Subset of contour values, default is all values
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "extract contours",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def extract_contours_folder(client,
     input_folder='/input_folder',
     value=0.5,
     output_folder='/output_folder',
     values_subset='',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".tif",
     extension_output_file=".shp",
     skip_existing_files = False):
      '''Extract contours from a georeferenced image and save them as a shapefile.
    | 
    | extract_contours_folder(client,
    |      input_folder='/input_folder',
    |      value=0.5,
    |      output_folder='/output_folder',
    |      values_subset='',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".tif",
    |      extension_output_folder=".shp",
    |      skip_existing_files = False )

:param value: Contour value
:param values_subset: Subset of contour values, default is all values
:param input_folder: Input georeferenced image folder
:param output_folder: Output shapefolder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "extract contours" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def matrix_to_image(client,
     input_file='matrix.npy',
     output_file='image.tif',
     data_type='uint8',
     instance_type='x2large'):
      '''Convert a matrix to an image.
    | 
    | matrix_to_image( client,
    |      input_file='matrix.npy',
    |      output_file='image.tif',
    |      data_type='uint8',
    |      instance_type='x2large' )

:param input_file: Input matrix file (either .npy or .txt)
:param output_file: Output image file
:param data_type: Data type of the output image
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "matrix to image",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def matrix_to_image_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     data_type='uint8',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".npy",
     extension_output_file=".tif",
     skip_existing_files = False):
      '''Convert a matrix to an image.
    | 
    | matrix_to_image_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      data_type='uint8',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".npy",
    |      extension_output_folder=".tif",
    |      skip_existing_files = False )

:param data_type: Data type of the output image
:param input_folder: Input matrix folder (either .npy or .txt)
:param output_folder: Output image folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "matrix to image" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def image_to_matrix(client,
     input_file='image.tif',
     output_file='matrix.npy',
     instance_type='x2large'):
      '''Convert an image to a matrix.
    | 
    | image_to_matrix( client,
    |      input_file='image.tif',
    |      output_file='matrix.npy',
    |      instance_type='x2large' )

:param input_file: Input image file
:param output_file: Output matrix file (either .npy or .txt)
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "image to matrix",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def image_to_matrix_folder(client,
     input_folder='/input_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_input_file=".tif",
     extension_output_file=".npy",
     skip_existing_files = False):
      '''Convert an image to a matrix.
    | 
    | image_to_matrix_folder(client,
    |      input_folder='/input_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_input_folder=".tif",
    |      extension_output_folder=".npy",
    |      skip_existing_files = False )

:param input_folder: Input image folder
:param output_folder: Output matrix folder (either .npy or .txt)
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_input_folder: File extension of files in folder for input_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['input_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_input_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "input_file,output_file"
      folders = input_folder + "," + output_folder
      extensions = extension_input_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "image to matrix" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def polygon_to_image(client,
     geotiff_file='in.tif',
     pickle_file='in.pickle',
     output_file='out.tif',
     instance_type='x2large'):
      '''Generate an image of a multipolygon filled inside.
    | 
    | polygon_to_image( client,
    |      geotiff_file='in.tif',
    |      pickle_file='in.pickle',
    |      output_file='out.tif',
    |      instance_type='x2large' )

:param geotiff_file: Geotiff file with size and resolution information
:param pickle_file: Pickle file containing the Shapely polygon
:param output_file: Output georeferenced TIFF image
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "polygon to image",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def polygon_to_image_folder(client,
     geotiff_folder='/geotiff_folder',
     pickle_folder='/pickle_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_geotiff_file=".tif",
     extension_pickle_file=".pickle",
     extension_output_file=".tif",
     skip_existing_files = False):
      '''Generate an image of a multipolygon filled inside.
    | 
    | polygon_to_image_folder(client,
    |      geotiff_folder='/geotiff_folder',
    |      pickle_folder='/pickle_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_geotiff_folder=".tif",
    |      extension_pickle_folder=".pickle",
    |      extension_output_folder=".tif",
    |      skip_existing_files = False )

:param geotiff_folder: Geotiff folder with size and resolution information
:param pickle_folder: Pickle folder containing the Shapely polygon
:param output_folder: Output georeferenced TIFF image
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_geotiff_folder: File extension of files in folder for geotiff_folder
:param extension_pickle_folder: File extension of files in folder for pickle_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['geotiff_folder']
      del all_parameters['pickle_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_geotiff_file']
      del all_parameters['extension_pickle_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "geotiff_file,pickle_file,output_file"
      folders = geotiff_folder + "," + pickle_folder + "," + output_folder
      extensions = extension_geotiff_file + "," + extension_pickle_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "polygon to image" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())


   def assign_georeference(client,
     georeferenced_file='in1.tif',
     unreferenced_file='in2.tif',
     output_file='out.tif',
     instance_type='x2large'):
      '''Assign georeference from a georeferenced image to an unreferenced image.
    | 
    | assign_georeference( client,
    |      georeferenced_file='in1.tif',
    |      unreferenced_file='in2.tif',
    |      output_file='out.tif',
    |      instance_type='x2large' )

:param georeferenced_file: Georeferenced image file
:param unreferenced_file: Unreferenced image file
:param output_file: Output georeferenced image file
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "assign georeference",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


   def assign_georeference_folder(client,
     georeferenced_folder='/georeferenced_folder',
     unreferenced_folder='/unreferenced_folder',
     output_folder='/output_folder',
     worker_instance_type='x2large',
     manager_instance_type="small",
     extension_georeferenced_file=".tif",
     extension_unreferenced_file=".tif",
     extension_output_file=".tif",
     skip_existing_files = False):
      '''Assign georeference from a georeferenced image to an unreferenced image.
    | 
    | assign_georeference_folder(client,
    |      georeferenced_folder='/georeferenced_folder',
    |      unreferenced_folder='/unreferenced_folder',
    |      output_folder='/output_folder',
    |      worker_instance_type='x2large',
    |      manager_instance_type="small",
    |      extension_georeferenced_folder=".tif",
    |      extension_unreferenced_folder=".tif",
    |      extension_output_folder=".tif",
    |      skip_existing_files = False )

:param georeferenced_folder: Georeferenced image folder
:param unreferenced_folder: Unreferenced image folder
:param output_folder: Output georeferenced image folder
:param worker_instance_type: cloud instance type of worker nodes
:param manager_instance_type: cloud instance type of manager node
:param extension_georeferenced_folder: File extension of files in folder for georeferenced_folder
:param extension_unreferenced_folder: File extension of files in folder for unreferenced_folder
:param extension_output_folder: File extension of files in folder for output_folder
:param skip_existing_files: skip files that already exist in the output folder
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      del all_parameters['worker_instance_type']
      del all_parameters['manager_instance_type']
      del all_parameters['skip_existing_files']

      del all_parameters['georeferenced_folder']
      del all_parameters['unreferenced_folder']
      del all_parameters['output_folder']
      del all_parameters['extension_georeferenced_file']
      del all_parameters['extension_unreferenced_file']
      del all_parameters['extension_output_file']

      cmd_str = json.dumps(all_parameters)
      parameters = "georeferenced_file,unreferenced_file,output_file"
      folders = georeferenced_folder + "," + unreferenced_folder + "," + output_folder
      extensions = extension_georeferenced_file + "," + extension_unreferenced_file + "," + extension_output_file
      each_file_params = {
        "user_id": client.get_username(),
        "user_token": client.get_token(),
        "command": "'" + "assign georeference" + "'",
        "parameters_dictionary_str": "'" + cmd_str + "'",
        "server_address": client.get_server_address(),
        "verify_ssl": client.get_verify_ssl(),
        "folders": folders,
        "parameters": parameters,
        "extensions": extensions,
        "worker_instance_type": worker_instance_type,
        "instance_type": manager_instance_type,
        "skip_existing_files": skip_existing_files
      }

      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         each_file_params,
         client.get_server_address(),
         client.get_verify_ssl())





class pipe:
   def execute_each_file_in_folder(client,
     user_id='',
     user_token='',
     command='',
     parameters_dictionary_str='{}',
     server_address='',
     verify_ssl='True',
     folders='folder1,folder2',
     parameters='file1,file2',
     extensions='.laz,.laz',
     worker_instance_type='T4',
     skip_existing_files='False',
     instance_type='small'):
      '''
    | 
    | execute_each_file_in_folder( client,
    |      user_id='',
    |      user_token='',
    |      command='',
    |      parameters_dictionary_str='{}',
    |      server_address='',
    |      verify_ssl='True',
    |      folders='folder1,folder2',
    |      parameters='file1,file2',
    |      extensions='.laz,.laz',
    |      worker_instance_type='T4',
    |      skip_existing_files='False',
    |      instance_type='small' )

:param user_id: AIPHA user id
:param user_token: AIPHA user token
:param command: command name
:param parameters_dictionary_str: parameter string
:param server_address: filename
:param verify_ssl: filename
:param folders: adjustable names
:param parameters: adjustable parameters
:param extensions: adjustable extensions
:param worker_instance_type: worker instance type
:param skip_existing_files:  ignore existing files
:param instance_type: type of cloud instance used for processing
'''

      all_parameters = locals().copy()
      del all_parameters['client']
      return command_request(
         client.get_username(),
         client.get_token(),
         "execute each file in folder",
         all_parameters,
         client.get_server_address(),
         client.get_verify_ssl())


