"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssignOnLaunch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const HANDLER_PATH = path.join(__dirname, "../../assets/vpc/assign-on-launch.handler");
/**
 * Enables the "assignIpv6AddressOnCreation" attribute on selected subnets.
 *
 * @see {@link https://github.com/aws/aws-cdk/issues/894}
 * @see {@link https://github.com/aws/aws-cdk/issues/5927}
 */
class AssignOnLaunch extends constructs_1.Construct {
    /**
     * Creates a new BetterVpc.
     *
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param options - The constructor options.
     */
    constructor(scope, id, options) {
        super(scope, id);
        this.vpc = options.vpc;
        this.vpcPlacement = this.vpc.selectSubnets(options.vpcSubnets);
        const { subnetIds } = this.vpcPlacement;
        const { region, account, partition } = aws_cdk_lib_1.Stack.of(this);
        const onEventHandler = new aws_lambda_1.Function(this, "Function", {
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            handler: "index.handler",
            environment: { SUBNET_IDS: `${JSON.stringify(subnetIds)}` },
            code: aws_lambda_1.Code.fromAsset(HANDLER_PATH),
            timeout: aws_cdk_lib_1.Duration.seconds(300),
            initialPolicy: [
                new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ["ec2:ModifySubnetAttribute"],
                    resources: subnetIds.map((s) => `arn:${partition}:ec2:${region}:${account}:subnet/${s}`),
                }),
            ],
        });
        const provider = new custom_resources_1.Provider(this, "Provider", { onEventHandler });
        new aws_cdk_lib_1.CustomResource(this, "Resource", {
            serviceToken: provider.serviceToken,
        });
    }
}
exports.AssignOnLaunch = AssignOnLaunch;
_a = JSII_RTTI_SYMBOL_1;
AssignOnLaunch[_a] = { fqn: "shady-island.AssignOnLaunch", version: "0.0.1-alpha.22" };
//# sourceMappingURL=data:application/json;base64,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