import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorRouteDisableLinkToDefaultDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#cdn_frontdoor_custom_domain_ids CdnFrontdoorRouteDisableLinkToDefaultDomain#cdn_frontdoor_custom_domain_ids}
    */
    readonly cdnFrontdoorCustomDomainIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#cdn_frontdoor_route_id CdnFrontdoorRouteDisableLinkToDefaultDomain#cdn_frontdoor_route_id}
    */
    readonly cdnFrontdoorRouteId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#id CdnFrontdoorRouteDisableLinkToDefaultDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#timeouts CdnFrontdoorRouteDisableLinkToDefaultDomain#timeouts}
    */
    readonly timeouts?: CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts;
}
export interface CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#create CdnFrontdoorRouteDisableLinkToDefaultDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#delete CdnFrontdoorRouteDisableLinkToDefaultDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#read CdnFrontdoorRouteDisableLinkToDefaultDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain#update CdnFrontdoorRouteDisableLinkToDefaultDomain#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorRouteDisableLinkToDefaultDomainTimeoutsToTerraform(struct?: CdnFrontdoorRouteDisableLinkToDefaultDomainTimeoutsOutputReference | CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorRouteDisableLinkToDefaultDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain azurerm_cdn_frontdoor_route_disable_link_to_default_domain}
*/
export declare class CdnFrontdoorRouteDisableLinkToDefaultDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_route_disable_link_to_default_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cdn_frontdoor_route_disable_link_to_default_domain azurerm_cdn_frontdoor_route_disable_link_to_default_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorRouteDisableLinkToDefaultDomainConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorRouteDisableLinkToDefaultDomainConfig);
    private _cdnFrontdoorCustomDomainIds?;
    get cdnFrontdoorCustomDomainIds(): string[];
    set cdnFrontdoorCustomDomainIds(value: string[]);
    get cdnFrontdoorCustomDomainIdsInput(): string[] | undefined;
    private _cdnFrontdoorRouteId?;
    get cdnFrontdoorRouteId(): string;
    set cdnFrontdoorRouteId(value: string);
    get cdnFrontdoorRouteIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorRouteDisableLinkToDefaultDomainTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorRouteDisableLinkToDefaultDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
