"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesClusterNodePool = exports.KubernetesClusterNodePoolWindowsProfileOutputReference = exports.kubernetesClusterNodePoolWindowsProfileToTerraform = exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = exports.KubernetesClusterNodePoolTimeoutsOutputReference = exports.kubernetesClusterNodePoolTimeoutsToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = exports.KubernetesClusterNodePoolKubeletConfigOutputReference = exports.kubernetesClusterNodePoolKubeletConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function kubernetesClusterNodePoolKubeletConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_unsafe_sysctls: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.allowedUnsafeSysctls),
        container_log_max_line: cdktf.numberToTerraform(struct.containerLogMaxLine),
        container_log_max_size_mb: cdktf.numberToTerraform(struct.containerLogMaxSizeMb),
        cpu_cfs_quota_enabled: cdktf.booleanToTerraform(struct.cpuCfsQuotaEnabled),
        cpu_cfs_quota_period: cdktf.stringToTerraform(struct.cpuCfsQuotaPeriod),
        cpu_manager_policy: cdktf.stringToTerraform(struct.cpuManagerPolicy),
        image_gc_high_threshold: cdktf.numberToTerraform(struct.imageGcHighThreshold),
        image_gc_low_threshold: cdktf.numberToTerraform(struct.imageGcLowThreshold),
        pod_max_pid: cdktf.numberToTerraform(struct.podMaxPid),
        topology_manager_policy: cdktf.stringToTerraform(struct.topologyManagerPolicy),
    };
}
exports.kubernetesClusterNodePoolKubeletConfigToTerraform = kubernetesClusterNodePoolKubeletConfigToTerraform;
class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedUnsafeSysctls !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedUnsafeSysctls = this._allowedUnsafeSysctls;
        }
        if (this._containerLogMaxLine !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxLine = this._containerLogMaxLine;
        }
        if (this._containerLogMaxSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.containerLogMaxSizeMb = this._containerLogMaxSizeMb;
        }
        if (this._cpuCfsQuotaEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaEnabled = this._cpuCfsQuotaEnabled;
        }
        if (this._cpuCfsQuotaPeriod !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuCfsQuotaPeriod = this._cpuCfsQuotaPeriod;
        }
        if (this._cpuManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.cpuManagerPolicy = this._cpuManagerPolicy;
        }
        if (this._imageGcHighThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcHighThreshold = this._imageGcHighThreshold;
        }
        if (this._imageGcLowThreshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageGcLowThreshold = this._imageGcLowThreshold;
        }
        if (this._podMaxPid !== undefined) {
            hasAnyValues = true;
            internalValueResult.podMaxPid = this._podMaxPid;
        }
        if (this._topologyManagerPolicy !== undefined) {
            hasAnyValues = true;
            internalValueResult.topologyManagerPolicy = this._topologyManagerPolicy;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowedUnsafeSysctls = undefined;
            this._containerLogMaxLine = undefined;
            this._containerLogMaxSizeMb = undefined;
            this._cpuCfsQuotaEnabled = undefined;
            this._cpuCfsQuotaPeriod = undefined;
            this._cpuManagerPolicy = undefined;
            this._imageGcHighThreshold = undefined;
            this._imageGcLowThreshold = undefined;
            this._podMaxPid = undefined;
            this._topologyManagerPolicy = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowedUnsafeSysctls = value.allowedUnsafeSysctls;
            this._containerLogMaxLine = value.containerLogMaxLine;
            this._containerLogMaxSizeMb = value.containerLogMaxSizeMb;
            this._cpuCfsQuotaEnabled = value.cpuCfsQuotaEnabled;
            this._cpuCfsQuotaPeriod = value.cpuCfsQuotaPeriod;
            this._cpuManagerPolicy = value.cpuManagerPolicy;
            this._imageGcHighThreshold = value.imageGcHighThreshold;
            this._imageGcLowThreshold = value.imageGcLowThreshold;
            this._podMaxPid = value.podMaxPid;
            this._topologyManagerPolicy = value.topologyManagerPolicy;
        }
    }
    get allowedUnsafeSysctls() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_unsafe_sysctls'));
    }
    set allowedUnsafeSysctls(value) {
        this._allowedUnsafeSysctls = value;
    }
    resetAllowedUnsafeSysctls() {
        this._allowedUnsafeSysctls = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedUnsafeSysctlsInput() {
        return this._allowedUnsafeSysctls;
    }
    get containerLogMaxLine() {
        return this.getNumberAttribute('container_log_max_line');
    }
    set containerLogMaxLine(value) {
        this._containerLogMaxLine = value;
    }
    resetContainerLogMaxLine() {
        this._containerLogMaxLine = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxLineInput() {
        return this._containerLogMaxLine;
    }
    get containerLogMaxSizeMb() {
        return this.getNumberAttribute('container_log_max_size_mb');
    }
    set containerLogMaxSizeMb(value) {
        this._containerLogMaxSizeMb = value;
    }
    resetContainerLogMaxSizeMb() {
        this._containerLogMaxSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerLogMaxSizeMbInput() {
        return this._containerLogMaxSizeMb;
    }
    get cpuCfsQuotaEnabled() {
        return this.getBooleanAttribute('cpu_cfs_quota_enabled');
    }
    set cpuCfsQuotaEnabled(value) {
        this._cpuCfsQuotaEnabled = value;
    }
    resetCpuCfsQuotaEnabled() {
        this._cpuCfsQuotaEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaEnabledInput() {
        return this._cpuCfsQuotaEnabled;
    }
    get cpuCfsQuotaPeriod() {
        return this.getStringAttribute('cpu_cfs_quota_period');
    }
    set cpuCfsQuotaPeriod(value) {
        this._cpuCfsQuotaPeriod = value;
    }
    resetCpuCfsQuotaPeriod() {
        this._cpuCfsQuotaPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuCfsQuotaPeriodInput() {
        return this._cpuCfsQuotaPeriod;
    }
    get cpuManagerPolicy() {
        return this.getStringAttribute('cpu_manager_policy');
    }
    set cpuManagerPolicy(value) {
        this._cpuManagerPolicy = value;
    }
    resetCpuManagerPolicy() {
        this._cpuManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cpuManagerPolicyInput() {
        return this._cpuManagerPolicy;
    }
    get imageGcHighThreshold() {
        return this.getNumberAttribute('image_gc_high_threshold');
    }
    set imageGcHighThreshold(value) {
        this._imageGcHighThreshold = value;
    }
    resetImageGcHighThreshold() {
        this._imageGcHighThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcHighThresholdInput() {
        return this._imageGcHighThreshold;
    }
    get imageGcLowThreshold() {
        return this.getNumberAttribute('image_gc_low_threshold');
    }
    set imageGcLowThreshold(value) {
        this._imageGcLowThreshold = value;
    }
    resetImageGcLowThreshold() {
        this._imageGcLowThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageGcLowThresholdInput() {
        return this._imageGcLowThreshold;
    }
    get podMaxPid() {
        return this.getNumberAttribute('pod_max_pid');
    }
    set podMaxPid(value) {
        this._podMaxPid = value;
    }
    resetPodMaxPid() {
        this._podMaxPid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podMaxPidInput() {
        return this._podMaxPid;
    }
    get topologyManagerPolicy() {
        return this.getStringAttribute('topology_manager_policy');
    }
    set topologyManagerPolicy(value) {
        this._topologyManagerPolicy = value;
    }
    resetTopologyManagerPolicy() {
        this._topologyManagerPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topologyManagerPolicyInput() {
        return this._topologyManagerPolicy;
    }
}
exports.KubernetesClusterNodePoolKubeletConfigOutputReference = KubernetesClusterNodePoolKubeletConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolKubeletConfigOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolKubeletConfigOutputReference", version: "4.0.7" };
function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        fs_aio_max_nr: cdktf.numberToTerraform(struct.fsAioMaxNr),
        fs_file_max: cdktf.numberToTerraform(struct.fsFileMax),
        fs_inotify_max_user_watches: cdktf.numberToTerraform(struct.fsInotifyMaxUserWatches),
        fs_nr_open: cdktf.numberToTerraform(struct.fsNrOpen),
        kernel_threads_max: cdktf.numberToTerraform(struct.kernelThreadsMax),
        net_core_netdev_max_backlog: cdktf.numberToTerraform(struct.netCoreNetdevMaxBacklog),
        net_core_optmem_max: cdktf.numberToTerraform(struct.netCoreOptmemMax),
        net_core_rmem_default: cdktf.numberToTerraform(struct.netCoreRmemDefault),
        net_core_rmem_max: cdktf.numberToTerraform(struct.netCoreRmemMax),
        net_core_somaxconn: cdktf.numberToTerraform(struct.netCoreSomaxconn),
        net_core_wmem_default: cdktf.numberToTerraform(struct.netCoreWmemDefault),
        net_core_wmem_max: cdktf.numberToTerraform(struct.netCoreWmemMax),
        net_ipv4_ip_local_port_range_max: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMax),
        net_ipv4_ip_local_port_range_min: cdktf.numberToTerraform(struct.netIpv4IpLocalPortRangeMin),
        net_ipv4_neigh_default_gc_thresh1: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh1),
        net_ipv4_neigh_default_gc_thresh2: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh2),
        net_ipv4_neigh_default_gc_thresh3: cdktf.numberToTerraform(struct.netIpv4NeighDefaultGcThresh3),
        net_ipv4_tcp_fin_timeout: cdktf.numberToTerraform(struct.netIpv4TcpFinTimeout),
        net_ipv4_tcp_keepalive_intvl: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveIntvl),
        net_ipv4_tcp_keepalive_probes: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveProbes),
        net_ipv4_tcp_keepalive_time: cdktf.numberToTerraform(struct.netIpv4TcpKeepaliveTime),
        net_ipv4_tcp_max_syn_backlog: cdktf.numberToTerraform(struct.netIpv4TcpMaxSynBacklog),
        net_ipv4_tcp_max_tw_buckets: cdktf.numberToTerraform(struct.netIpv4TcpMaxTwBuckets),
        net_ipv4_tcp_tw_reuse: cdktf.booleanToTerraform(struct.netIpv4TcpTwReuse),
        net_netfilter_nf_conntrack_buckets: cdktf.numberToTerraform(struct.netNetfilterNfConntrackBuckets),
        net_netfilter_nf_conntrack_max: cdktf.numberToTerraform(struct.netNetfilterNfConntrackMax),
        vm_max_map_count: cdktf.numberToTerraform(struct.vmMaxMapCount),
        vm_swappiness: cdktf.numberToTerraform(struct.vmSwappiness),
        vm_vfs_cache_pressure: cdktf.numberToTerraform(struct.vmVfsCachePressure),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._fsAioMaxNr !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsAioMaxNr = this._fsAioMaxNr;
        }
        if (this._fsFileMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsFileMax = this._fsFileMax;
        }
        if (this._fsInotifyMaxUserWatches !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsInotifyMaxUserWatches = this._fsInotifyMaxUserWatches;
        }
        if (this._fsNrOpen !== undefined) {
            hasAnyValues = true;
            internalValueResult.fsNrOpen = this._fsNrOpen;
        }
        if (this._kernelThreadsMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.kernelThreadsMax = this._kernelThreadsMax;
        }
        if (this._netCoreNetdevMaxBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreNetdevMaxBacklog = this._netCoreNetdevMaxBacklog;
        }
        if (this._netCoreOptmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreOptmemMax = this._netCoreOptmemMax;
        }
        if (this._netCoreRmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemDefault = this._netCoreRmemDefault;
        }
        if (this._netCoreRmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreRmemMax = this._netCoreRmemMax;
        }
        if (this._netCoreSomaxconn !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreSomaxconn = this._netCoreSomaxconn;
        }
        if (this._netCoreWmemDefault !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemDefault = this._netCoreWmemDefault;
        }
        if (this._netCoreWmemMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netCoreWmemMax = this._netCoreWmemMax;
        }
        if (this._netIpv4IpLocalPortRangeMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMax = this._netIpv4IpLocalPortRangeMax;
        }
        if (this._netIpv4IpLocalPortRangeMin !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4IpLocalPortRangeMin = this._netIpv4IpLocalPortRangeMin;
        }
        if (this._netIpv4NeighDefaultGcThresh1 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh1 = this._netIpv4NeighDefaultGcThresh1;
        }
        if (this._netIpv4NeighDefaultGcThresh2 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh2 = this._netIpv4NeighDefaultGcThresh2;
        }
        if (this._netIpv4NeighDefaultGcThresh3 !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4NeighDefaultGcThresh3 = this._netIpv4NeighDefaultGcThresh3;
        }
        if (this._netIpv4TcpFinTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpFinTimeout = this._netIpv4TcpFinTimeout;
        }
        if (this._netIpv4TcpKeepaliveIntvl !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveIntvl = this._netIpv4TcpKeepaliveIntvl;
        }
        if (this._netIpv4TcpKeepaliveProbes !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveProbes = this._netIpv4TcpKeepaliveProbes;
        }
        if (this._netIpv4TcpKeepaliveTime !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpKeepaliveTime = this._netIpv4TcpKeepaliveTime;
        }
        if (this._netIpv4TcpMaxSynBacklog !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxSynBacklog = this._netIpv4TcpMaxSynBacklog;
        }
        if (this._netIpv4TcpMaxTwBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpMaxTwBuckets = this._netIpv4TcpMaxTwBuckets;
        }
        if (this._netIpv4TcpTwReuse !== undefined) {
            hasAnyValues = true;
            internalValueResult.netIpv4TcpTwReuse = this._netIpv4TcpTwReuse;
        }
        if (this._netNetfilterNfConntrackBuckets !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackBuckets = this._netNetfilterNfConntrackBuckets;
        }
        if (this._netNetfilterNfConntrackMax !== undefined) {
            hasAnyValues = true;
            internalValueResult.netNetfilterNfConntrackMax = this._netNetfilterNfConntrackMax;
        }
        if (this._vmMaxMapCount !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmMaxMapCount = this._vmMaxMapCount;
        }
        if (this._vmSwappiness !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmSwappiness = this._vmSwappiness;
        }
        if (this._vmVfsCachePressure !== undefined) {
            hasAnyValues = true;
            internalValueResult.vmVfsCachePressure = this._vmVfsCachePressure;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._fsAioMaxNr = undefined;
            this._fsFileMax = undefined;
            this._fsInotifyMaxUserWatches = undefined;
            this._fsNrOpen = undefined;
            this._kernelThreadsMax = undefined;
            this._netCoreNetdevMaxBacklog = undefined;
            this._netCoreOptmemMax = undefined;
            this._netCoreRmemDefault = undefined;
            this._netCoreRmemMax = undefined;
            this._netCoreSomaxconn = undefined;
            this._netCoreWmemDefault = undefined;
            this._netCoreWmemMax = undefined;
            this._netIpv4IpLocalPortRangeMax = undefined;
            this._netIpv4IpLocalPortRangeMin = undefined;
            this._netIpv4NeighDefaultGcThresh1 = undefined;
            this._netIpv4NeighDefaultGcThresh2 = undefined;
            this._netIpv4NeighDefaultGcThresh3 = undefined;
            this._netIpv4TcpFinTimeout = undefined;
            this._netIpv4TcpKeepaliveIntvl = undefined;
            this._netIpv4TcpKeepaliveProbes = undefined;
            this._netIpv4TcpKeepaliveTime = undefined;
            this._netIpv4TcpMaxSynBacklog = undefined;
            this._netIpv4TcpMaxTwBuckets = undefined;
            this._netIpv4TcpTwReuse = undefined;
            this._netNetfilterNfConntrackBuckets = undefined;
            this._netNetfilterNfConntrackMax = undefined;
            this._vmMaxMapCount = undefined;
            this._vmSwappiness = undefined;
            this._vmVfsCachePressure = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._fsAioMaxNr = value.fsAioMaxNr;
            this._fsFileMax = value.fsFileMax;
            this._fsInotifyMaxUserWatches = value.fsInotifyMaxUserWatches;
            this._fsNrOpen = value.fsNrOpen;
            this._kernelThreadsMax = value.kernelThreadsMax;
            this._netCoreNetdevMaxBacklog = value.netCoreNetdevMaxBacklog;
            this._netCoreOptmemMax = value.netCoreOptmemMax;
            this._netCoreRmemDefault = value.netCoreRmemDefault;
            this._netCoreRmemMax = value.netCoreRmemMax;
            this._netCoreSomaxconn = value.netCoreSomaxconn;
            this._netCoreWmemDefault = value.netCoreWmemDefault;
            this._netCoreWmemMax = value.netCoreWmemMax;
            this._netIpv4IpLocalPortRangeMax = value.netIpv4IpLocalPortRangeMax;
            this._netIpv4IpLocalPortRangeMin = value.netIpv4IpLocalPortRangeMin;
            this._netIpv4NeighDefaultGcThresh1 = value.netIpv4NeighDefaultGcThresh1;
            this._netIpv4NeighDefaultGcThresh2 = value.netIpv4NeighDefaultGcThresh2;
            this._netIpv4NeighDefaultGcThresh3 = value.netIpv4NeighDefaultGcThresh3;
            this._netIpv4TcpFinTimeout = value.netIpv4TcpFinTimeout;
            this._netIpv4TcpKeepaliveIntvl = value.netIpv4TcpKeepaliveIntvl;
            this._netIpv4TcpKeepaliveProbes = value.netIpv4TcpKeepaliveProbes;
            this._netIpv4TcpKeepaliveTime = value.netIpv4TcpKeepaliveTime;
            this._netIpv4TcpMaxSynBacklog = value.netIpv4TcpMaxSynBacklog;
            this._netIpv4TcpMaxTwBuckets = value.netIpv4TcpMaxTwBuckets;
            this._netIpv4TcpTwReuse = value.netIpv4TcpTwReuse;
            this._netNetfilterNfConntrackBuckets = value.netNetfilterNfConntrackBuckets;
            this._netNetfilterNfConntrackMax = value.netNetfilterNfConntrackMax;
            this._vmMaxMapCount = value.vmMaxMapCount;
            this._vmSwappiness = value.vmSwappiness;
            this._vmVfsCachePressure = value.vmVfsCachePressure;
        }
    }
    get fsAioMaxNr() {
        return this.getNumberAttribute('fs_aio_max_nr');
    }
    set fsAioMaxNr(value) {
        this._fsAioMaxNr = value;
    }
    resetFsAioMaxNr() {
        this._fsAioMaxNr = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsAioMaxNrInput() {
        return this._fsAioMaxNr;
    }
    get fsFileMax() {
        return this.getNumberAttribute('fs_file_max');
    }
    set fsFileMax(value) {
        this._fsFileMax = value;
    }
    resetFsFileMax() {
        this._fsFileMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsFileMaxInput() {
        return this._fsFileMax;
    }
    get fsInotifyMaxUserWatches() {
        return this.getNumberAttribute('fs_inotify_max_user_watches');
    }
    set fsInotifyMaxUserWatches(value) {
        this._fsInotifyMaxUserWatches = value;
    }
    resetFsInotifyMaxUserWatches() {
        this._fsInotifyMaxUserWatches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsInotifyMaxUserWatchesInput() {
        return this._fsInotifyMaxUserWatches;
    }
    get fsNrOpen() {
        return this.getNumberAttribute('fs_nr_open');
    }
    set fsNrOpen(value) {
        this._fsNrOpen = value;
    }
    resetFsNrOpen() {
        this._fsNrOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fsNrOpenInput() {
        return this._fsNrOpen;
    }
    get kernelThreadsMax() {
        return this.getNumberAttribute('kernel_threads_max');
    }
    set kernelThreadsMax(value) {
        this._kernelThreadsMax = value;
    }
    resetKernelThreadsMax() {
        this._kernelThreadsMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kernelThreadsMaxInput() {
        return this._kernelThreadsMax;
    }
    get netCoreNetdevMaxBacklog() {
        return this.getNumberAttribute('net_core_netdev_max_backlog');
    }
    set netCoreNetdevMaxBacklog(value) {
        this._netCoreNetdevMaxBacklog = value;
    }
    resetNetCoreNetdevMaxBacklog() {
        this._netCoreNetdevMaxBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreNetdevMaxBacklogInput() {
        return this._netCoreNetdevMaxBacklog;
    }
    get netCoreOptmemMax() {
        return this.getNumberAttribute('net_core_optmem_max');
    }
    set netCoreOptmemMax(value) {
        this._netCoreOptmemMax = value;
    }
    resetNetCoreOptmemMax() {
        this._netCoreOptmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreOptmemMaxInput() {
        return this._netCoreOptmemMax;
    }
    get netCoreRmemDefault() {
        return this.getNumberAttribute('net_core_rmem_default');
    }
    set netCoreRmemDefault(value) {
        this._netCoreRmemDefault = value;
    }
    resetNetCoreRmemDefault() {
        this._netCoreRmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemDefaultInput() {
        return this._netCoreRmemDefault;
    }
    get netCoreRmemMax() {
        return this.getNumberAttribute('net_core_rmem_max');
    }
    set netCoreRmemMax(value) {
        this._netCoreRmemMax = value;
    }
    resetNetCoreRmemMax() {
        this._netCoreRmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreRmemMaxInput() {
        return this._netCoreRmemMax;
    }
    get netCoreSomaxconn() {
        return this.getNumberAttribute('net_core_somaxconn');
    }
    set netCoreSomaxconn(value) {
        this._netCoreSomaxconn = value;
    }
    resetNetCoreSomaxconn() {
        this._netCoreSomaxconn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreSomaxconnInput() {
        return this._netCoreSomaxconn;
    }
    get netCoreWmemDefault() {
        return this.getNumberAttribute('net_core_wmem_default');
    }
    set netCoreWmemDefault(value) {
        this._netCoreWmemDefault = value;
    }
    resetNetCoreWmemDefault() {
        this._netCoreWmemDefault = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemDefaultInput() {
        return this._netCoreWmemDefault;
    }
    get netCoreWmemMax() {
        return this.getNumberAttribute('net_core_wmem_max');
    }
    set netCoreWmemMax(value) {
        this._netCoreWmemMax = value;
    }
    resetNetCoreWmemMax() {
        this._netCoreWmemMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netCoreWmemMaxInput() {
        return this._netCoreWmemMax;
    }
    get netIpv4IpLocalPortRangeMax() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_max');
    }
    set netIpv4IpLocalPortRangeMax(value) {
        this._netIpv4IpLocalPortRangeMax = value;
    }
    resetNetIpv4IpLocalPortRangeMax() {
        this._netIpv4IpLocalPortRangeMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMaxInput() {
        return this._netIpv4IpLocalPortRangeMax;
    }
    get netIpv4IpLocalPortRangeMin() {
        return this.getNumberAttribute('net_ipv4_ip_local_port_range_min');
    }
    set netIpv4IpLocalPortRangeMin(value) {
        this._netIpv4IpLocalPortRangeMin = value;
    }
    resetNetIpv4IpLocalPortRangeMin() {
        this._netIpv4IpLocalPortRangeMin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4IpLocalPortRangeMinInput() {
        return this._netIpv4IpLocalPortRangeMin;
    }
    get netIpv4NeighDefaultGcThresh1() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh1');
    }
    set netIpv4NeighDefaultGcThresh1(value) {
        this._netIpv4NeighDefaultGcThresh1 = value;
    }
    resetNetIpv4NeighDefaultGcThresh1() {
        this._netIpv4NeighDefaultGcThresh1 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh1Input() {
        return this._netIpv4NeighDefaultGcThresh1;
    }
    get netIpv4NeighDefaultGcThresh2() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh2');
    }
    set netIpv4NeighDefaultGcThresh2(value) {
        this._netIpv4NeighDefaultGcThresh2 = value;
    }
    resetNetIpv4NeighDefaultGcThresh2() {
        this._netIpv4NeighDefaultGcThresh2 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh2Input() {
        return this._netIpv4NeighDefaultGcThresh2;
    }
    get netIpv4NeighDefaultGcThresh3() {
        return this.getNumberAttribute('net_ipv4_neigh_default_gc_thresh3');
    }
    set netIpv4NeighDefaultGcThresh3(value) {
        this._netIpv4NeighDefaultGcThresh3 = value;
    }
    resetNetIpv4NeighDefaultGcThresh3() {
        this._netIpv4NeighDefaultGcThresh3 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4NeighDefaultGcThresh3Input() {
        return this._netIpv4NeighDefaultGcThresh3;
    }
    get netIpv4TcpFinTimeout() {
        return this.getNumberAttribute('net_ipv4_tcp_fin_timeout');
    }
    set netIpv4TcpFinTimeout(value) {
        this._netIpv4TcpFinTimeout = value;
    }
    resetNetIpv4TcpFinTimeout() {
        this._netIpv4TcpFinTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpFinTimeoutInput() {
        return this._netIpv4TcpFinTimeout;
    }
    get netIpv4TcpKeepaliveIntvl() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_intvl');
    }
    set netIpv4TcpKeepaliveIntvl(value) {
        this._netIpv4TcpKeepaliveIntvl = value;
    }
    resetNetIpv4TcpKeepaliveIntvl() {
        this._netIpv4TcpKeepaliveIntvl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveIntvlInput() {
        return this._netIpv4TcpKeepaliveIntvl;
    }
    get netIpv4TcpKeepaliveProbes() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_probes');
    }
    set netIpv4TcpKeepaliveProbes(value) {
        this._netIpv4TcpKeepaliveProbes = value;
    }
    resetNetIpv4TcpKeepaliveProbes() {
        this._netIpv4TcpKeepaliveProbes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveProbesInput() {
        return this._netIpv4TcpKeepaliveProbes;
    }
    get netIpv4TcpKeepaliveTime() {
        return this.getNumberAttribute('net_ipv4_tcp_keepalive_time');
    }
    set netIpv4TcpKeepaliveTime(value) {
        this._netIpv4TcpKeepaliveTime = value;
    }
    resetNetIpv4TcpKeepaliveTime() {
        this._netIpv4TcpKeepaliveTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpKeepaliveTimeInput() {
        return this._netIpv4TcpKeepaliveTime;
    }
    get netIpv4TcpMaxSynBacklog() {
        return this.getNumberAttribute('net_ipv4_tcp_max_syn_backlog');
    }
    set netIpv4TcpMaxSynBacklog(value) {
        this._netIpv4TcpMaxSynBacklog = value;
    }
    resetNetIpv4TcpMaxSynBacklog() {
        this._netIpv4TcpMaxSynBacklog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxSynBacklogInput() {
        return this._netIpv4TcpMaxSynBacklog;
    }
    get netIpv4TcpMaxTwBuckets() {
        return this.getNumberAttribute('net_ipv4_tcp_max_tw_buckets');
    }
    set netIpv4TcpMaxTwBuckets(value) {
        this._netIpv4TcpMaxTwBuckets = value;
    }
    resetNetIpv4TcpMaxTwBuckets() {
        this._netIpv4TcpMaxTwBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpMaxTwBucketsInput() {
        return this._netIpv4TcpMaxTwBuckets;
    }
    get netIpv4TcpTwReuse() {
        return this.getBooleanAttribute('net_ipv4_tcp_tw_reuse');
    }
    set netIpv4TcpTwReuse(value) {
        this._netIpv4TcpTwReuse = value;
    }
    resetNetIpv4TcpTwReuse() {
        this._netIpv4TcpTwReuse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netIpv4TcpTwReuseInput() {
        return this._netIpv4TcpTwReuse;
    }
    get netNetfilterNfConntrackBuckets() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_buckets');
    }
    set netNetfilterNfConntrackBuckets(value) {
        this._netNetfilterNfConntrackBuckets = value;
    }
    resetNetNetfilterNfConntrackBuckets() {
        this._netNetfilterNfConntrackBuckets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackBucketsInput() {
        return this._netNetfilterNfConntrackBuckets;
    }
    get netNetfilterNfConntrackMax() {
        return this.getNumberAttribute('net_netfilter_nf_conntrack_max');
    }
    set netNetfilterNfConntrackMax(value) {
        this._netNetfilterNfConntrackMax = value;
    }
    resetNetNetfilterNfConntrackMax() {
        this._netNetfilterNfConntrackMax = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netNetfilterNfConntrackMaxInput() {
        return this._netNetfilterNfConntrackMax;
    }
    get vmMaxMapCount() {
        return this.getNumberAttribute('vm_max_map_count');
    }
    set vmMaxMapCount(value) {
        this._vmMaxMapCount = value;
    }
    resetVmMaxMapCount() {
        this._vmMaxMapCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmMaxMapCountInput() {
        return this._vmMaxMapCount;
    }
    get vmSwappiness() {
        return this.getNumberAttribute('vm_swappiness');
    }
    set vmSwappiness(value) {
        this._vmSwappiness = value;
    }
    resetVmSwappiness() {
        this._vmSwappiness = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmSwappinessInput() {
        return this._vmSwappiness;
    }
    get vmVfsCachePressure() {
        return this.getNumberAttribute('vm_vfs_cache_pressure');
    }
    set vmVfsCachePressure(value) {
        this._vmVfsCachePressure = value;
    }
    resetVmVfsCachePressure() {
        this._vmVfsCachePressure = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vmVfsCachePressureInput() {
        return this._vmVfsCachePressure;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference", version: "4.0.7" };
function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        swap_file_size_mb: cdktf.numberToTerraform(struct.swapFileSizeMb),
        transparent_huge_page_defrag: cdktf.stringToTerraform(struct.transparentHugePageDefrag),
        transparent_huge_page_enabled: cdktf.stringToTerraform(struct.transparentHugePageEnabled),
        sysctl_config: kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct.sysctlConfig),
    };
}
exports.kubernetesClusterNodePoolLinuxOsConfigToTerraform = kubernetesClusterNodePoolLinuxOsConfigToTerraform;
class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // sysctl_config - computed: false, optional: true, required: false
        this._sysctlConfig = new KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference(this, "sysctl_config");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._swapFileSizeMb !== undefined) {
            hasAnyValues = true;
            internalValueResult.swapFileSizeMb = this._swapFileSizeMb;
        }
        if (this._transparentHugePageDefrag !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageDefrag = this._transparentHugePageDefrag;
        }
        if (this._transparentHugePageEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.transparentHugePageEnabled = this._transparentHugePageEnabled;
        }
        if (this._sysctlConfig?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.sysctlConfig = this._sysctlConfig?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._swapFileSizeMb = undefined;
            this._transparentHugePageDefrag = undefined;
            this._transparentHugePageEnabled = undefined;
            this._sysctlConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._swapFileSizeMb = value.swapFileSizeMb;
            this._transparentHugePageDefrag = value.transparentHugePageDefrag;
            this._transparentHugePageEnabled = value.transparentHugePageEnabled;
            this._sysctlConfig.internalValue = value.sysctlConfig;
        }
    }
    get swapFileSizeMb() {
        return this.getNumberAttribute('swap_file_size_mb');
    }
    set swapFileSizeMb(value) {
        this._swapFileSizeMb = value;
    }
    resetSwapFileSizeMb() {
        this._swapFileSizeMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get swapFileSizeMbInput() {
        return this._swapFileSizeMb;
    }
    get transparentHugePageDefrag() {
        return this.getStringAttribute('transparent_huge_page_defrag');
    }
    set transparentHugePageDefrag(value) {
        this._transparentHugePageDefrag = value;
    }
    resetTransparentHugePageDefrag() {
        this._transparentHugePageDefrag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageDefragInput() {
        return this._transparentHugePageDefrag;
    }
    get transparentHugePageEnabled() {
        return this.getStringAttribute('transparent_huge_page_enabled');
    }
    set transparentHugePageEnabled(value) {
        this._transparentHugePageEnabled = value;
    }
    resetTransparentHugePageEnabled() {
        this._transparentHugePageEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get transparentHugePageEnabledInput() {
        return this._transparentHugePageEnabled;
    }
    get sysctlConfig() {
        return this._sysctlConfig;
    }
    putSysctlConfig(value) {
        this._sysctlConfig.internalValue = value;
    }
    resetSysctlConfig() {
        this._sysctlConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sysctlConfigInput() {
        return this._sysctlConfig.internalValue;
    }
}
exports.KubernetesClusterNodePoolLinuxOsConfigOutputReference = KubernetesClusterNodePoolLinuxOsConfigOutputReference;
_c = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolLinuxOsConfigOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolLinuxOsConfigOutputReference", version: "4.0.7" };
function kubernetesClusterNodePoolTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.kubernetesClusterNodePoolTimeoutsToTerraform = kubernetesClusterNodePoolTimeoutsToTerraform;
class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.KubernetesClusterNodePoolTimeoutsOutputReference = KubernetesClusterNodePoolTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolTimeoutsOutputReference", version: "4.0.7" };
function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        max_surge: cdktf.stringToTerraform(struct.maxSurge),
    };
}
exports.kubernetesClusterNodePoolUpgradeSettingsToTerraform = kubernetesClusterNodePoolUpgradeSettingsToTerraform;
class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maxSurge !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxSurge = this._maxSurge;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maxSurge = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maxSurge = value.maxSurge;
        }
    }
    get maxSurge() {
        return this.getStringAttribute('max_surge');
    }
    set maxSurge(value) {
        this._maxSurge = value;
    }
    // Temporarily expose input value. Use with caution.
    get maxSurgeInput() {
        return this._maxSurge;
    }
}
exports.KubernetesClusterNodePoolUpgradeSettingsOutputReference = KubernetesClusterNodePoolUpgradeSettingsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolUpgradeSettingsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolUpgradeSettingsOutputReference", version: "4.0.7" };
function kubernetesClusterNodePoolWindowsProfileToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        outbound_nat_enabled: cdktf.booleanToTerraform(struct.outboundNatEnabled),
    };
}
exports.kubernetesClusterNodePoolWindowsProfileToTerraform = kubernetesClusterNodePoolWindowsProfileToTerraform;
class KubernetesClusterNodePoolWindowsProfileOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._outboundNatEnabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.outboundNatEnabled = this._outboundNatEnabled;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._outboundNatEnabled = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._outboundNatEnabled = value.outboundNatEnabled;
        }
    }
    get outboundNatEnabled() {
        return this.getBooleanAttribute('outbound_nat_enabled');
    }
    set outboundNatEnabled(value) {
        this._outboundNatEnabled = value;
    }
    resetOutboundNatEnabled() {
        this._outboundNatEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get outboundNatEnabledInput() {
        return this._outboundNatEnabled;
    }
}
exports.KubernetesClusterNodePoolWindowsProfileOutputReference = KubernetesClusterNodePoolWindowsProfileOutputReference;
_f = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePoolWindowsProfileOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePoolWindowsProfileOutputReference", version: "4.0.7" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
class KubernetesClusterNodePool extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterNodePoolConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_kubernetes_cluster_node_pool',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.39.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // kubelet_config - computed: false, optional: true, required: false
        this._kubeletConfig = new KubernetesClusterNodePoolKubeletConfigOutputReference(this, "kubelet_config");
        // linux_os_config - computed: false, optional: true, required: false
        this._linuxOsConfig = new KubernetesClusterNodePoolLinuxOsConfigOutputReference(this, "linux_os_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new KubernetesClusterNodePoolTimeoutsOutputReference(this, "timeouts");
        // upgrade_settings - computed: false, optional: true, required: false
        this._upgradeSettings = new KubernetesClusterNodePoolUpgradeSettingsOutputReference(this, "upgrade_settings");
        // windows_profile - computed: false, optional: true, required: false
        this._windowsProfile = new KubernetesClusterNodePoolWindowsProfileOutputReference(this, "windows_profile");
        this._capacityReservationGroupId = config.capacityReservationGroupId;
        this._customCaTrustEnabled = config.customCaTrustEnabled;
        this._enableAutoScaling = config.enableAutoScaling;
        this._enableHostEncryption = config.enableHostEncryption;
        this._enableNodePublicIp = config.enableNodePublicIp;
        this._evictionPolicy = config.evictionPolicy;
        this._fipsEnabled = config.fipsEnabled;
        this._hostGroupId = config.hostGroupId;
        this._id = config.id;
        this._kubeletDiskType = config.kubeletDiskType;
        this._kubernetesClusterId = config.kubernetesClusterId;
        this._maxCount = config.maxCount;
        this._maxPods = config.maxPods;
        this._messageOfTheDay = config.messageOfTheDay;
        this._minCount = config.minCount;
        this._mode = config.mode;
        this._name = config.name;
        this._nodeCount = config.nodeCount;
        this._nodeLabels = config.nodeLabels;
        this._nodePublicIpPrefixId = config.nodePublicIpPrefixId;
        this._nodeTaints = config.nodeTaints;
        this._orchestratorVersion = config.orchestratorVersion;
        this._osDiskSizeGb = config.osDiskSizeGb;
        this._osDiskType = config.osDiskType;
        this._osSku = config.osSku;
        this._osType = config.osType;
        this._podSubnetId = config.podSubnetId;
        this._priority = config.priority;
        this._proximityPlacementGroupId = config.proximityPlacementGroupId;
        this._scaleDownMode = config.scaleDownMode;
        this._spotMaxPrice = config.spotMaxPrice;
        this._tags = config.tags;
        this._ultraSsdEnabled = config.ultraSsdEnabled;
        this._vmSize = config.vmSize;
        this._vnetSubnetId = config.vnetSubnetId;
        this._workloadRuntime = config.workloadRuntime;
        this._zones = config.zones;
        this._kubeletConfig.internalValue = config.kubeletConfig;
        this._linuxOsConfig.internalValue = config.linuxOsConfig;
        this._timeouts.internalValue = config.timeouts;
        this._upgradeSettings.internalValue = config.upgradeSettings;
        this._windowsProfile.internalValue = config.windowsProfile;
    }
    get capacityReservationGroupId() {
        return this.getStringAttribute('capacity_reservation_group_id');
    }
    set capacityReservationGroupId(value) {
        this._capacityReservationGroupId = value;
    }
    resetCapacityReservationGroupId() {
        this._capacityReservationGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get capacityReservationGroupIdInput() {
        return this._capacityReservationGroupId;
    }
    get customCaTrustEnabled() {
        return this.getBooleanAttribute('custom_ca_trust_enabled');
    }
    set customCaTrustEnabled(value) {
        this._customCaTrustEnabled = value;
    }
    resetCustomCaTrustEnabled() {
        this._customCaTrustEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customCaTrustEnabledInput() {
        return this._customCaTrustEnabled;
    }
    get enableAutoScaling() {
        return this.getBooleanAttribute('enable_auto_scaling');
    }
    set enableAutoScaling(value) {
        this._enableAutoScaling = value;
    }
    resetEnableAutoScaling() {
        this._enableAutoScaling = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableAutoScalingInput() {
        return this._enableAutoScaling;
    }
    get enableHostEncryption() {
        return this.getBooleanAttribute('enable_host_encryption');
    }
    set enableHostEncryption(value) {
        this._enableHostEncryption = value;
    }
    resetEnableHostEncryption() {
        this._enableHostEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHostEncryptionInput() {
        return this._enableHostEncryption;
    }
    get enableNodePublicIp() {
        return this.getBooleanAttribute('enable_node_public_ip');
    }
    set enableNodePublicIp(value) {
        this._enableNodePublicIp = value;
    }
    resetEnableNodePublicIp() {
        this._enableNodePublicIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableNodePublicIpInput() {
        return this._enableNodePublicIp;
    }
    get evictionPolicy() {
        return this.getStringAttribute('eviction_policy');
    }
    set evictionPolicy(value) {
        this._evictionPolicy = value;
    }
    resetEvictionPolicy() {
        this._evictionPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evictionPolicyInput() {
        return this._evictionPolicy;
    }
    get fipsEnabled() {
        return this.getBooleanAttribute('fips_enabled');
    }
    set fipsEnabled(value) {
        this._fipsEnabled = value;
    }
    resetFipsEnabled() {
        this._fipsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fipsEnabledInput() {
        return this._fipsEnabled;
    }
    get hostGroupId() {
        return this.getStringAttribute('host_group_id');
    }
    set hostGroupId(value) {
        this._hostGroupId = value;
    }
    resetHostGroupId() {
        this._hostGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostGroupIdInput() {
        return this._hostGroupId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get kubeletDiskType() {
        return this.getStringAttribute('kubelet_disk_type');
    }
    set kubeletDiskType(value) {
        this._kubeletDiskType = value;
    }
    resetKubeletDiskType() {
        this._kubeletDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletDiskTypeInput() {
        return this._kubeletDiskType;
    }
    get kubernetesClusterId() {
        return this.getStringAttribute('kubernetes_cluster_id');
    }
    set kubernetesClusterId(value) {
        this._kubernetesClusterId = value;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesClusterIdInput() {
        return this._kubernetesClusterId;
    }
    get maxCount() {
        return this.getNumberAttribute('max_count');
    }
    set maxCount(value) {
        this._maxCount = value;
    }
    resetMaxCount() {
        this._maxCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxCountInput() {
        return this._maxCount;
    }
    get maxPods() {
        return this.getNumberAttribute('max_pods');
    }
    set maxPods(value) {
        this._maxPods = value;
    }
    resetMaxPods() {
        this._maxPods = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxPodsInput() {
        return this._maxPods;
    }
    get messageOfTheDay() {
        return this.getStringAttribute('message_of_the_day');
    }
    set messageOfTheDay(value) {
        this._messageOfTheDay = value;
    }
    resetMessageOfTheDay() {
        this._messageOfTheDay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageOfTheDayInput() {
        return this._messageOfTheDay;
    }
    get minCount() {
        return this.getNumberAttribute('min_count');
    }
    set minCount(value) {
        this._minCount = value;
    }
    resetMinCount() {
        this._minCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minCountInput() {
        return this._minCount;
    }
    get mode() {
        return this.getStringAttribute('mode');
    }
    set mode(value) {
        this._mode = value;
    }
    resetMode() {
        this._mode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get modeInput() {
        return this._mode;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nodeCount() {
        return this.getNumberAttribute('node_count');
    }
    set nodeCount(value) {
        this._nodeCount = value;
    }
    resetNodeCount() {
        this._nodeCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeCountInput() {
        return this._nodeCount;
    }
    get nodeLabels() {
        return this.getStringMapAttribute('node_labels');
    }
    set nodeLabels(value) {
        this._nodeLabels = value;
    }
    resetNodeLabels() {
        this._nodeLabels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeLabelsInput() {
        return this._nodeLabels;
    }
    get nodePublicIpPrefixId() {
        return this.getStringAttribute('node_public_ip_prefix_id');
    }
    set nodePublicIpPrefixId(value) {
        this._nodePublicIpPrefixId = value;
    }
    resetNodePublicIpPrefixId() {
        this._nodePublicIpPrefixId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodePublicIpPrefixIdInput() {
        return this._nodePublicIpPrefixId;
    }
    get nodeTaints() {
        return this.getListAttribute('node_taints');
    }
    set nodeTaints(value) {
        this._nodeTaints = value;
    }
    resetNodeTaints() {
        this._nodeTaints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nodeTaintsInput() {
        return this._nodeTaints;
    }
    get orchestratorVersion() {
        return this.getStringAttribute('orchestrator_version');
    }
    set orchestratorVersion(value) {
        this._orchestratorVersion = value;
    }
    resetOrchestratorVersion() {
        this._orchestratorVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orchestratorVersionInput() {
        return this._orchestratorVersion;
    }
    get osDiskSizeGb() {
        return this.getNumberAttribute('os_disk_size_gb');
    }
    set osDiskSizeGb(value) {
        this._osDiskSizeGb = value;
    }
    resetOsDiskSizeGb() {
        this._osDiskSizeGb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskSizeGbInput() {
        return this._osDiskSizeGb;
    }
    get osDiskType() {
        return this.getStringAttribute('os_disk_type');
    }
    set osDiskType(value) {
        this._osDiskType = value;
    }
    resetOsDiskType() {
        this._osDiskType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osDiskTypeInput() {
        return this._osDiskType;
    }
    get osSku() {
        return this.getStringAttribute('os_sku');
    }
    set osSku(value) {
        this._osSku = value;
    }
    resetOsSku() {
        this._osSku = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osSkuInput() {
        return this._osSku;
    }
    get osType() {
        return this.getStringAttribute('os_type');
    }
    set osType(value) {
        this._osType = value;
    }
    resetOsType() {
        this._osType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osTypeInput() {
        return this._osType;
    }
    get podSubnetId() {
        return this.getStringAttribute('pod_subnet_id');
    }
    set podSubnetId(value) {
        this._podSubnetId = value;
    }
    resetPodSubnetId() {
        this._podSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get podSubnetIdInput() {
        return this._podSubnetId;
    }
    get priority() {
        return this.getStringAttribute('priority');
    }
    set priority(value) {
        this._priority = value;
    }
    resetPriority() {
        this._priority = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get priorityInput() {
        return this._priority;
    }
    get proximityPlacementGroupId() {
        return this.getStringAttribute('proximity_placement_group_id');
    }
    set proximityPlacementGroupId(value) {
        this._proximityPlacementGroupId = value;
    }
    resetProximityPlacementGroupId() {
        this._proximityPlacementGroupId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proximityPlacementGroupIdInput() {
        return this._proximityPlacementGroupId;
    }
    get scaleDownMode() {
        return this.getStringAttribute('scale_down_mode');
    }
    set scaleDownMode(value) {
        this._scaleDownMode = value;
    }
    resetScaleDownMode() {
        this._scaleDownMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scaleDownModeInput() {
        return this._scaleDownMode;
    }
    get spotMaxPrice() {
        return this.getNumberAttribute('spot_max_price');
    }
    set spotMaxPrice(value) {
        this._spotMaxPrice = value;
    }
    resetSpotMaxPrice() {
        this._spotMaxPrice = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spotMaxPriceInput() {
        return this._spotMaxPrice;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get ultraSsdEnabled() {
        return this.getBooleanAttribute('ultra_ssd_enabled');
    }
    set ultraSsdEnabled(value) {
        this._ultraSsdEnabled = value;
    }
    resetUltraSsdEnabled() {
        this._ultraSsdEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ultraSsdEnabledInput() {
        return this._ultraSsdEnabled;
    }
    get vmSize() {
        return this.getStringAttribute('vm_size');
    }
    set vmSize(value) {
        this._vmSize = value;
    }
    // Temporarily expose input value. Use with caution.
    get vmSizeInput() {
        return this._vmSize;
    }
    get vnetSubnetId() {
        return this.getStringAttribute('vnet_subnet_id');
    }
    set vnetSubnetId(value) {
        this._vnetSubnetId = value;
    }
    resetVnetSubnetId() {
        this._vnetSubnetId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vnetSubnetIdInput() {
        return this._vnetSubnetId;
    }
    get workloadRuntime() {
        return this.getStringAttribute('workload_runtime');
    }
    set workloadRuntime(value) {
        this._workloadRuntime = value;
    }
    resetWorkloadRuntime() {
        this._workloadRuntime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workloadRuntimeInput() {
        return this._workloadRuntime;
    }
    get zones() {
        return cdktf.Fn.tolist(this.getListAttribute('zones'));
    }
    set zones(value) {
        this._zones = value;
    }
    resetZones() {
        this._zones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zonesInput() {
        return this._zones;
    }
    get kubeletConfig() {
        return this._kubeletConfig;
    }
    putKubeletConfig(value) {
        this._kubeletConfig.internalValue = value;
    }
    resetKubeletConfig() {
        this._kubeletConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubeletConfigInput() {
        return this._kubeletConfig.internalValue;
    }
    get linuxOsConfig() {
        return this._linuxOsConfig;
    }
    putLinuxOsConfig(value) {
        this._linuxOsConfig.internalValue = value;
    }
    resetLinuxOsConfig() {
        this._linuxOsConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get linuxOsConfigInput() {
        return this._linuxOsConfig.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    get upgradeSettings() {
        return this._upgradeSettings;
    }
    putUpgradeSettings(value) {
        this._upgradeSettings.internalValue = value;
    }
    resetUpgradeSettings() {
        this._upgradeSettings.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get upgradeSettingsInput() {
        return this._upgradeSettings.internalValue;
    }
    get windowsProfile() {
        return this._windowsProfile;
    }
    putWindowsProfile(value) {
        this._windowsProfile.internalValue = value;
    }
    resetWindowsProfile() {
        this._windowsProfile.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get windowsProfileInput() {
        return this._windowsProfile.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            capacity_reservation_group_id: cdktf.stringToTerraform(this._capacityReservationGroupId),
            custom_ca_trust_enabled: cdktf.booleanToTerraform(this._customCaTrustEnabled),
            enable_auto_scaling: cdktf.booleanToTerraform(this._enableAutoScaling),
            enable_host_encryption: cdktf.booleanToTerraform(this._enableHostEncryption),
            enable_node_public_ip: cdktf.booleanToTerraform(this._enableNodePublicIp),
            eviction_policy: cdktf.stringToTerraform(this._evictionPolicy),
            fips_enabled: cdktf.booleanToTerraform(this._fipsEnabled),
            host_group_id: cdktf.stringToTerraform(this._hostGroupId),
            id: cdktf.stringToTerraform(this._id),
            kubelet_disk_type: cdktf.stringToTerraform(this._kubeletDiskType),
            kubernetes_cluster_id: cdktf.stringToTerraform(this._kubernetesClusterId),
            max_count: cdktf.numberToTerraform(this._maxCount),
            max_pods: cdktf.numberToTerraform(this._maxPods),
            message_of_the_day: cdktf.stringToTerraform(this._messageOfTheDay),
            min_count: cdktf.numberToTerraform(this._minCount),
            mode: cdktf.stringToTerraform(this._mode),
            name: cdktf.stringToTerraform(this._name),
            node_count: cdktf.numberToTerraform(this._nodeCount),
            node_labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._nodeLabels),
            node_public_ip_prefix_id: cdktf.stringToTerraform(this._nodePublicIpPrefixId),
            node_taints: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nodeTaints),
            orchestrator_version: cdktf.stringToTerraform(this._orchestratorVersion),
            os_disk_size_gb: cdktf.numberToTerraform(this._osDiskSizeGb),
            os_disk_type: cdktf.stringToTerraform(this._osDiskType),
            os_sku: cdktf.stringToTerraform(this._osSku),
            os_type: cdktf.stringToTerraform(this._osType),
            pod_subnet_id: cdktf.stringToTerraform(this._podSubnetId),
            priority: cdktf.stringToTerraform(this._priority),
            proximity_placement_group_id: cdktf.stringToTerraform(this._proximityPlacementGroupId),
            scale_down_mode: cdktf.stringToTerraform(this._scaleDownMode),
            spot_max_price: cdktf.numberToTerraform(this._spotMaxPrice),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            ultra_ssd_enabled: cdktf.booleanToTerraform(this._ultraSsdEnabled),
            vm_size: cdktf.stringToTerraform(this._vmSize),
            vnet_subnet_id: cdktf.stringToTerraform(this._vnetSubnetId),
            workload_runtime: cdktf.stringToTerraform(this._workloadRuntime),
            zones: cdktf.listMapper(cdktf.stringToTerraform, false)(this._zones),
            kubelet_config: kubernetesClusterNodePoolKubeletConfigToTerraform(this._kubeletConfig.internalValue),
            linux_os_config: kubernetesClusterNodePoolLinuxOsConfigToTerraform(this._linuxOsConfig.internalValue),
            timeouts: kubernetesClusterNodePoolTimeoutsToTerraform(this._timeouts.internalValue),
            upgrade_settings: kubernetesClusterNodePoolUpgradeSettingsToTerraform(this._upgradeSettings.internalValue),
            windows_profile: kubernetesClusterNodePoolWindowsProfileToTerraform(this._windowsProfile.internalValue),
        };
    }
}
exports.KubernetesClusterNodePool = KubernetesClusterNodePool;
_g = JSII_RTTI_SYMBOL_1;
KubernetesClusterNodePool[_g] = { fqn: "@cdktf/provider-azurerm.kubernetesClusterNodePool.KubernetesClusterNodePool", version: "4.0.7" };
// =================
// STATIC PROPERTIES
// =================
KubernetesClusterNodePool.tfResourceType = "azurerm_kubernetes_cluster_node_pool";
//# sourceMappingURL=data:application/json;base64,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