"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
// eslint-disable-next-line import/no-extraneous-dependencies
const promise_1 = require("mysql2/promise");
const util_1 = require("./util");
const adminSecretArn = process.env.ADMIN_SECRET_ARN;
const databaseName = process.env.DB_NAME;
const characterSet = process.env.DB_CHARACTER_SET || "utf8mb4";
const collation = process.env.DB_COLLATION;
const secretsManagerClient = new client_secrets_manager_1.SecretsManagerClient({});
const ownerSecretArns = util_1.parseJsonArrayFromEnv("OWNER_SECRETS");
const readerSecretArns = util_1.parseJsonArrayFromEnv("READER_SECRETS");
const unprivilegedSecretArns = util_1.parseJsonArrayFromEnv("UNPRIVILEGED_SECRETS");
async function createUser(connection, user, password) {
    const escapedPassword = connection.escape(password);
    let createUserSql = `CREATE USER IF NOT EXISTS ${user} IDENTIFIED BY ${escapedPassword}`;
    console.log(`About to create user: ${user}`);
    await connection.execute(createUserSql, [password]);
    console.log(`User created: ${user}`);
}
async function applyGrant(connection, user, privileges) {
    let grantPrivSql = `GRANT ${privileges} ON ${databaseName}.* TO ${user}`;
    console.log(`About to grant privileges to user: ${user}`);
    await connection.execute(grantPrivSql);
    console.log(`Privileges granted: ${privileges} ON ${databaseName}.*`);
}
const handler = async () => {
    const adminSecret = await util_1.fetchSecret(adminSecretArn, secretsManagerClient);
    const connection = await promise_1.createConnection({
        host: adminSecret.host,
        user: adminSecret.username,
        password: adminSecret.password,
        port: adminSecret.port,
        ssl: "Amazon RDS",
    });
    let createDbSql = `CREATE DATABASE IF NOT EXISTS ${databaseName} CHARACTER SET ${characterSet}`;
    if (collation) {
        createDbSql += ` COLLATE ${collation}`;
    }
    console.log(`About to create database: ${databaseName}`);
    await connection.execute(createDbSql);
    console.log(`Database created: ${databaseName}`);
    const ownerSecrets = await util_1.fetchAllSecrets(ownerSecretArns, secretsManagerClient);
    for (const userSecret of ownerSecrets) {
        const mysqlUser = `'${userSecret.username}'@'%'`;
        await createUser(connection, mysqlUser, userSecret.password);
        await applyGrant(connection, mysqlUser, "ALL PRIVILEGES");
    }
    const readerSecrets = await util_1.fetchAllSecrets(readerSecretArns, secretsManagerClient);
    for (const userSecret of readerSecrets) {
        const mysqlUser = `'${userSecret.username}'@'%'`;
        await createUser(connection, mysqlUser, userSecret.password);
        await applyGrant(connection, mysqlUser, "SELECT, SHOW VIEW");
    }
    const unprivilegedSecrets = await util_1.fetchAllSecrets(unprivilegedSecretArns, secretsManagerClient);
    for (const userSecret of unprivilegedSecrets) {
        const mysqlUser = `'${userSecret.username}'@'%'`;
        await createUser(connection, mysqlUser, userSecret.password);
    }
    let flushSql = "FLUSH PRIVILEGES";
    console.log("About to flush privileges");
    await connection.execute(flushSql);
    console.log("Privileges flushed");
    console.log("About to close the connection");
    await connection.end();
    console.log("Connection closed");
};
module.exports = { handler };
//# sourceMappingURL=data:application/json;base64,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