"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findInstanceOf = exports.assertType = void 0;
/**
 * Asserts that a value is an instance of a given type.
 *
 * @param value The value to test.
 * @param type The type of which value must be an instance.
 */
function assertType(value, type) {
    if (value instanceof type) {
        return value;
    }
    throw new TypeError(`Expected value of type: ${type} but got ${typeof value}`);
}
exports.assertType = assertType;
/**
 * Locates an instance of a given type within an array.
 *
 * @param container The array to search.
 * @param type The type of which value must be an instance.
 * @return The located value
 * @throws {TypeError} if the value was not found or not of
 */
function findInstanceOf(container, type) {
    const value = container.find((v) => v instanceof type);
    if (value !== undefined) {
        return value;
    }
    throw new TypeError(`Array does not contain a value of type: ${type}`);
}
exports.findInstanceOf = findInstanceOf;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdXRpbC90eXBlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTs7Ozs7R0FLRztBQUNILFNBQWdCLFVBQVUsQ0FBSSxLQUFVLEVBQUUsSUFBNkI7SUFDckUsSUFBSSxLQUFLLFlBQVksSUFBSSxFQUFFO1FBQ3pCLE9BQU8sS0FBVSxDQUFDO0tBQ25CO0lBQ0QsTUFBTSxJQUFJLFNBQVMsQ0FDakIsMkJBQTJCLElBQUksWUFBWSxPQUFPLEtBQUssRUFBRSxDQUMxRCxDQUFDO0FBQ0osQ0FBQztBQVBELGdDQU9DO0FBRUQ7Ozs7Ozs7R0FPRztBQUNILFNBQWdCLGNBQWMsQ0FDNUIsU0FBYyxFQUNkLElBQTZCO0lBRTdCLE1BQU0sS0FBSyxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsWUFBWSxJQUFJLENBQUMsQ0FBQztJQUN2RCxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7UUFDdkIsT0FBTyxLQUFVLENBQUM7S0FDbkI7SUFDRCxNQUFNLElBQUksU0FBUyxDQUFDLDJDQUEyQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO0FBQ3pFLENBQUM7QUFURCx3Q0FTQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQXNzZXJ0cyB0aGF0IGEgdmFsdWUgaXMgYW4gaW5zdGFuY2Ugb2YgYSBnaXZlbiB0eXBlLlxuICpcbiAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUgdG8gdGVzdC5cbiAqIEBwYXJhbSB0eXBlIFRoZSB0eXBlIG9mIHdoaWNoIHZhbHVlIG11c3QgYmUgYW4gaW5zdGFuY2UuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBhc3NlcnRUeXBlPFQ+KHZhbHVlOiBhbnksIHR5cGU6IG5ldyAoLi4uYXJnczogYW55KSA9PiBUKTogVCB7XG4gIGlmICh2YWx1ZSBpbnN0YW5jZW9mIHR5cGUpIHtcbiAgICByZXR1cm4gdmFsdWUgYXMgVDtcbiAgfVxuICB0aHJvdyBuZXcgVHlwZUVycm9yKFxuICAgIGBFeHBlY3RlZCB2YWx1ZSBvZiB0eXBlOiAke3R5cGV9IGJ1dCBnb3QgJHt0eXBlb2YgdmFsdWV9YFxuICApO1xufVxuXG4vKipcbiAqIExvY2F0ZXMgYW4gaW5zdGFuY2Ugb2YgYSBnaXZlbiB0eXBlIHdpdGhpbiBhbiBhcnJheS5cbiAqXG4gKiBAcGFyYW0gY29udGFpbmVyIFRoZSBhcnJheSB0byBzZWFyY2guXG4gKiBAcGFyYW0gdHlwZSBUaGUgdHlwZSBvZiB3aGljaCB2YWx1ZSBtdXN0IGJlIGFuIGluc3RhbmNlLlxuICogQHJldHVybiBUaGUgbG9jYXRlZCB2YWx1ZVxuICogQHRocm93cyB7VHlwZUVycm9yfSBpZiB0aGUgdmFsdWUgd2FzIG5vdCBmb3VuZCBvciBub3Qgb2ZcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGZpbmRJbnN0YW5jZU9mPEEsIFQgZXh0ZW5kcyBBPihcbiAgY29udGFpbmVyOiBBW10sXG4gIHR5cGU6IG5ldyAoLi4uYXJnczogYW55KSA9PiBUXG4pIHtcbiAgY29uc3QgdmFsdWUgPSBjb250YWluZXIuZmluZCgodikgPT4gdiBpbnN0YW5jZW9mIHR5cGUpO1xuICBpZiAodmFsdWUgIT09IHVuZGVmaW5lZCkge1xuICAgIHJldHVybiB2YWx1ZSBhcyBUO1xuICB9XG4gIHRocm93IG5ldyBUeXBlRXJyb3IoYEFycmF5IGRvZXMgbm90IGNvbnRhaW4gYSB2YWx1ZSBvZiB0eXBlOiAke3R5cGV9YCk7XG59XG4iXX0=