# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetClusterWorkloadMappingResult',
    'AwaitableGetClusterWorkloadMappingResult',
    'get_cluster_workload_mapping',
    'get_cluster_workload_mapping_output',
]

@pulumi.output_type
class GetClusterWorkloadMappingResult:
    """
    A collection of values returned by getClusterWorkloadMapping.
    """
    def __init__(__self__, cluster_id=None, defined_tags=None, freeform_tags=None, id=None, mapped_compartment_id=None, mapped_tenancy_id=None, namespace=None, state=None, time_created=None, workload_mapping_id=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mapped_compartment_id and not isinstance(mapped_compartment_id, str):
            raise TypeError("Expected argument 'mapped_compartment_id' to be a str")
        pulumi.set(__self__, "mapped_compartment_id", mapped_compartment_id)
        if mapped_tenancy_id and not isinstance(mapped_tenancy_id, str):
            raise TypeError("Expected argument 'mapped_tenancy_id' to be a str")
        pulumi.set(__self__, "mapped_tenancy_id", mapped_tenancy_id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if workload_mapping_id and not isinstance(workload_mapping_id, str):
            raise TypeError("Expected argument 'workload_mapping_id' to be a str")
        pulumi.set(__self__, "workload_mapping_id", workload_mapping_id)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ocid of the workloadMapping.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mappedCompartmentId")
    def mapped_compartment_id(self) -> str:
        """
        The OCID of the mapped customer compartment.
        """
        return pulumi.get(self, "mapped_compartment_id")

    @property
    @pulumi.getter(name="mappedTenancyId")
    def mapped_tenancy_id(self) -> str:
        """
        The OCID of the mapped customer tenancy.
        """
        return pulumi.get(self, "mapped_tenancy_id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the workloadMapping.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the workloadMapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="workloadMappingId")
    def workload_mapping_id(self) -> str:
        return pulumi.get(self, "workload_mapping_id")


class AwaitableGetClusterWorkloadMappingResult(GetClusterWorkloadMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterWorkloadMappingResult(
            cluster_id=self.cluster_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            mapped_compartment_id=self.mapped_compartment_id,
            mapped_tenancy_id=self.mapped_tenancy_id,
            namespace=self.namespace,
            state=self.state,
            time_created=self.time_created,
            workload_mapping_id=self.workload_mapping_id)


def get_cluster_workload_mapping(cluster_id: Optional[str] = None,
                                 workload_mapping_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterWorkloadMappingResult:
    """
    This data source provides details about a specific Cluster Workload Mapping resource in Oracle Cloud Infrastructure Container Engine service.

    Get the specified workloadMapping for a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_workload_mapping = oci.ContainerEngine.get_cluster_workload_mapping(cluster_id=test_cluster["id"],
        workload_mapping_id=test_workload_mapping["id"])
    ```


    :param str cluster_id: The OCID of the cluster.
    :param str workload_mapping_id: The OCID of the workloadMapping.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['workloadMappingId'] = workload_mapping_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getClusterWorkloadMapping:getClusterWorkloadMapping', __args__, opts=opts, typ=GetClusterWorkloadMappingResult).value

    return AwaitableGetClusterWorkloadMappingResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        mapped_compartment_id=pulumi.get(__ret__, 'mapped_compartment_id'),
        mapped_tenancy_id=pulumi.get(__ret__, 'mapped_tenancy_id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        workload_mapping_id=pulumi.get(__ret__, 'workload_mapping_id'))
def get_cluster_workload_mapping_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                        workload_mapping_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterWorkloadMappingResult]:
    """
    This data source provides details about a specific Cluster Workload Mapping resource in Oracle Cloud Infrastructure Container Engine service.

    Get the specified workloadMapping for a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_workload_mapping = oci.ContainerEngine.get_cluster_workload_mapping(cluster_id=test_cluster["id"],
        workload_mapping_id=test_workload_mapping["id"])
    ```


    :param str cluster_id: The OCID of the cluster.
    :param str workload_mapping_id: The OCID of the workloadMapping.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['workloadMappingId'] = workload_mapping_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getClusterWorkloadMapping:getClusterWorkloadMapping', __args__, opts=opts, typ=GetClusterWorkloadMappingResult)
    return __ret__.apply(lambda __response__: GetClusterWorkloadMappingResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        mapped_compartment_id=pulumi.get(__response__, 'mapped_compartment_id'),
        mapped_tenancy_id=pulumi.get(__response__, 'mapped_tenancy_id'),
        namespace=pulumi.get(__response__, 'namespace'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        workload_mapping_id=pulumi.get(__response__, 'workload_mapping_id')))
