# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmClusterUpdateHistoryEntriesResult',
    'AwaitableGetVmClusterUpdateHistoryEntriesResult',
    'get_vm_cluster_update_history_entries',
    'get_vm_cluster_update_history_entries_output',
]

@pulumi.output_type
class GetVmClusterUpdateHistoryEntriesResult:
    """
    A collection of values returned by getVmClusterUpdateHistoryEntries.
    """
    def __init__(__self__, filters=None, id=None, state=None, update_type=None, vm_cluster_id=None, vm_cluster_update_history_entries=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_cluster_update_history_entries and not isinstance(vm_cluster_update_history_entries, list):
            raise TypeError("Expected argument 'vm_cluster_update_history_entries' to be a list")
        pulumi.set(__self__, "vm_cluster_update_history_entries", vm_cluster_update_history_entries)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVmClusterUpdateHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the maintenance update operation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> Optional[str]:
        """
        The type of VM cluster maintenance update.
        """
        return pulumi.get(self, "update_type")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        return pulumi.get(self, "vm_cluster_id")

    @property
    @pulumi.getter(name="vmClusterUpdateHistoryEntries")
    def vm_cluster_update_history_entries(self) -> Sequence['outputs.GetVmClusterUpdateHistoryEntriesVmClusterUpdateHistoryEntryResult']:
        """
        The list of vm_cluster_update_history_entries.
        """
        return pulumi.get(self, "vm_cluster_update_history_entries")


class AwaitableGetVmClusterUpdateHistoryEntriesResult(GetVmClusterUpdateHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterUpdateHistoryEntriesResult(
            filters=self.filters,
            id=self.id,
            state=self.state,
            update_type=self.update_type,
            vm_cluster_id=self.vm_cluster_id,
            vm_cluster_update_history_entries=self.vm_cluster_update_history_entries)


def get_vm_cluster_update_history_entries(filters: Optional[Sequence[Union['GetVmClusterUpdateHistoryEntriesFilterArgs', 'GetVmClusterUpdateHistoryEntriesFilterArgsDict']]] = None,
                                          state: Optional[str] = None,
                                          update_type: Optional[str] = None,
                                          vm_cluster_id: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterUpdateHistoryEntriesResult:
    """
    This data source provides the list of Vm Cluster Update History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the maintenance update actions performed on the specified VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_update_history_entries = oci.Database.get_vm_cluster_update_history_entries(vm_cluster_id=test_vm_cluster["id"],
        state=vm_cluster_update_history_entry_state,
        update_type=vm_cluster_update_history_entry_update_type)
    ```


    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str update_type: A filter to return only resources that match the given update type exactly.
    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['updateType'] = update_type
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterUpdateHistoryEntries:getVmClusterUpdateHistoryEntries', __args__, opts=opts, typ=GetVmClusterUpdateHistoryEntriesResult).value

    return AwaitableGetVmClusterUpdateHistoryEntriesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        update_type=pulumi.get(__ret__, 'update_type'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'),
        vm_cluster_update_history_entries=pulumi.get(__ret__, 'vm_cluster_update_history_entries'))
def get_vm_cluster_update_history_entries_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVmClusterUpdateHistoryEntriesFilterArgs', 'GetVmClusterUpdateHistoryEntriesFilterArgsDict']]]]] = None,
                                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                                 update_type: Optional[pulumi.Input[Optional[str]]] = None,
                                                 vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVmClusterUpdateHistoryEntriesResult]:
    """
    This data source provides the list of Vm Cluster Update History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the maintenance update actions performed on the specified VM cluster. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_update_history_entries = oci.Database.get_vm_cluster_update_history_entries(vm_cluster_id=test_vm_cluster["id"],
        state=vm_cluster_update_history_entry_state,
        update_type=vm_cluster_update_history_entry_update_type)
    ```


    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str update_type: A filter to return only resources that match the given update type exactly.
    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['updateType'] = update_type
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getVmClusterUpdateHistoryEntries:getVmClusterUpdateHistoryEntries', __args__, opts=opts, typ=GetVmClusterUpdateHistoryEntriesResult)
    return __ret__.apply(lambda __response__: GetVmClusterUpdateHistoryEntriesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        update_type=pulumi.get(__response__, 'update_type'),
        vm_cluster_id=pulumi.get(__response__, 'vm_cluster_id'),
        vm_cluster_update_history_entries=pulumi.get(__response__, 'vm_cluster_update_history_entries')))
