# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'FleetCredentialEntitySpecificsArgs',
    'FleetCredentialEntitySpecificsArgsDict',
    'FleetCredentialPasswordArgs',
    'FleetCredentialPasswordArgsDict',
    'FleetCredentialUserArgs',
    'FleetCredentialUserArgsDict',
    'FleetNotificationPreferencesArgs',
    'FleetNotificationPreferencesArgsDict',
    'FleetNotificationPreferencesPreferencesArgs',
    'FleetNotificationPreferencesPreferencesArgsDict',
    'FleetRuleSelectionCriteriaArgs',
    'FleetRuleSelectionCriteriaArgsDict',
    'FleetRuleSelectionCriteriaRuleArgs',
    'FleetRuleSelectionCriteriaRuleArgsDict',
    'FleetRuleSelectionCriteriaRuleConditionArgs',
    'FleetRuleSelectionCriteriaRuleConditionArgsDict',
    'SchedulerDefinitionActionGroupArgs',
    'SchedulerDefinitionActionGroupArgsDict',
    'SchedulerDefinitionRunBookArgs',
    'SchedulerDefinitionRunBookArgsDict',
    'SchedulerDefinitionRunBookInputParameterArgs',
    'SchedulerDefinitionRunBookInputParameterArgsDict',
    'SchedulerDefinitionRunBookInputParameterArgumentArgs',
    'SchedulerDefinitionRunBookInputParameterArgumentArgsDict',
    'SchedulerDefinitionScheduleArgs',
    'SchedulerDefinitionScheduleArgsDict',
    'GetAnnouncementsFilterArgs',
    'GetAnnouncementsFilterArgsDict',
    'GetFleetCredentialsFilterArgs',
    'GetFleetCredentialsFilterArgsDict',
    'GetFleetProductsFilterArgs',
    'GetFleetProductsFilterArgsDict',
    'GetFleetPropertiesFilterArgs',
    'GetFleetPropertiesFilterArgsDict',
    'GetFleetResourcesFilterArgs',
    'GetFleetResourcesFilterArgsDict',
    'GetFleetTargetsFilterArgs',
    'GetFleetTargetsFilterArgsDict',
    'GetFleetsFilterArgs',
    'GetFleetsFilterArgsDict',
    'GetInventoryResourcesFilterArgs',
    'GetInventoryResourcesFilterArgsDict',
    'GetMaintenanceWindowsFilterArgs',
    'GetMaintenanceWindowsFilterArgsDict',
    'GetOnboardingPoliciesFilterArgs',
    'GetOnboardingPoliciesFilterArgsDict',
    'GetOnboardingsFilterArgs',
    'GetOnboardingsFilterArgsDict',
    'GetPropertiesFilterArgs',
    'GetPropertiesFilterArgsDict',
    'GetRunbooksFilterArgs',
    'GetRunbooksFilterArgsDict',
    'GetSchedulerDefinitionScheduledFleetsFilterArgs',
    'GetSchedulerDefinitionScheduledFleetsFilterArgsDict',
    'GetSchedulerDefinitionsFilterArgs',
    'GetSchedulerDefinitionsFilterArgsDict',
    'GetTaskRecordsFilterArgs',
    'GetTaskRecordsFilterArgsDict',
]

MYPY = False

if not MYPY:
    class FleetCredentialEntitySpecificsArgsDict(TypedDict):
        credential_level: pulumi.Input[str]
        """
        (Updatable) Credential Level.
        """
        resource_id: pulumi.Input[str]
        """
        (Updatable) OCID of the resource associated with the target for which credential is created
        """
        target: pulumi.Input[str]
        """
        (Updatable) Target associated with the Credential
        """
elif False:
    FleetCredentialEntitySpecificsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetCredentialEntitySpecificsArgs:
    def __init__(__self__, *,
                 credential_level: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 target: pulumi.Input[str]):
        """
        :param pulumi.Input[str] credential_level: (Updatable) Credential Level.
        :param pulumi.Input[str] resource_id: (Updatable) OCID of the resource associated with the target for which credential is created
        :param pulumi.Input[str] target: (Updatable) Target associated with the Credential
        """
        pulumi.set(__self__, "credential_level", credential_level)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="credentialLevel")
    def credential_level(self) -> pulumi.Input[str]:
        """
        (Updatable) Credential Level.
        """
        return pulumi.get(self, "credential_level")

    @credential_level.setter
    def credential_level(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_level", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the resource associated with the target for which credential is created
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        (Updatable) Target associated with the Credential
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)


if not MYPY:
    class FleetCredentialPasswordArgsDict(TypedDict):
        credential_type: pulumi.Input[str]
        """
        (Updatable) Credential Type
        """
        key_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        key_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The Vault Key version.
        """
        secret_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        secret_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The secret version.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The value corresponding to the credential
        """
        vault_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
elif False:
    FleetCredentialPasswordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetCredentialPasswordArgs:
    def __init__(__self__, *,
                 credential_type: pulumi.Input[str],
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_type: (Updatable) Credential Type
        :param pulumi.Input[str] key_id: (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param pulumi.Input[str] key_version: (Updatable) The Vault Key version.
        :param pulumi.Input[str] secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param pulumi.Input[str] secret_version: (Updatable) The secret version.
        :param pulumi.Input[str] value: (Updatable) The value corresponding to the credential
        :param pulumi.Input[str] vault_id: (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Credential Type
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The secret version.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_version", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)


if not MYPY:
    class FleetCredentialUserArgsDict(TypedDict):
        credential_type: pulumi.Input[str]
        """
        (Updatable) Credential Type
        """
        key_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        key_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The Vault Key version.
        """
        secret_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        secret_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The secret version.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The value corresponding to the credential
        """
        vault_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    FleetCredentialUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetCredentialUserArgs:
    def __init__(__self__, *,
                 credential_type: pulumi.Input[str],
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 secret_version: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_type: (Updatable) Credential Type
        :param pulumi.Input[str] key_id: (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        :param pulumi.Input[str] key_version: (Updatable) The Vault Key version.
        :param pulumi.Input[str] secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        :param pulumi.Input[str] secret_version: (Updatable) The secret version.
        :param pulumi.Input[str] value: (Updatable) The value corresponding to the credential
        :param pulumi.Input[str] vault_id: (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "credential_type", credential_type)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Credential Type
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID for the Vault Key that will be used to encrypt/decrypt the value given.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Vault Key version.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The secret version.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_version", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The value corresponding to the credential
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID for the Vault that will be used to fetch key to encrypt/decrypt the value given.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)


if not MYPY:
    class FleetNotificationPreferencesArgsDict(TypedDict):
        compartment_id: pulumi.Input[str]
        """
        (Updatable) Copartment Id of the topic where the notifications will be directed
        """
        topic_id: pulumi.Input[str]
        """
        (Updatable) Topic Id where the notifications will be directed
        """
        preferences: NotRequired[pulumi.Input['FleetNotificationPreferencesPreferencesArgsDict']]
        """
        (Updatable) Preferences to send notifications on the fleet activities
        """
elif False:
    FleetNotificationPreferencesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetNotificationPreferencesArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 topic_id: pulumi.Input[str],
                 preferences: Optional[pulumi.Input['FleetNotificationPreferencesPreferencesArgs']] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) Copartment Id of the topic where the notifications will be directed
        :param pulumi.Input[str] topic_id: (Updatable) Topic Id where the notifications will be directed
        :param pulumi.Input['FleetNotificationPreferencesPreferencesArgs'] preferences: (Updatable) Preferences to send notifications on the fleet activities
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "topic_id", topic_id)
        if preferences is not None:
            pulumi.set(__self__, "preferences", preferences)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Copartment Id of the topic where the notifications will be directed
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Topic Id where the notifications will be directed
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_id", value)

    @property
    @pulumi.getter
    def preferences(self) -> Optional[pulumi.Input['FleetNotificationPreferencesPreferencesArgs']]:
        """
        (Updatable) Preferences to send notifications on the fleet activities
        """
        return pulumi.get(self, "preferences")

    @preferences.setter
    def preferences(self, value: Optional[pulumi.Input['FleetNotificationPreferencesPreferencesArgs']]):
        pulumi.set(self, "preferences", value)


if not MYPY:
    class FleetNotificationPreferencesPreferencesArgsDict(TypedDict):
        on_job_failure: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Enables or disables notification on Job Failures.'
        """
        on_topology_modification: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Enables or disables notification on Environment Fleet Topology Modification.
        """
        on_upcoming_schedule: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Enables notification on upcoming schedule.
        """
elif False:
    FleetNotificationPreferencesPreferencesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetNotificationPreferencesPreferencesArgs:
    def __init__(__self__, *,
                 on_job_failure: Optional[pulumi.Input[bool]] = None,
                 on_topology_modification: Optional[pulumi.Input[bool]] = None,
                 on_upcoming_schedule: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] on_job_failure: (Updatable) Enables or disables notification on Job Failures.'
        :param pulumi.Input[bool] on_topology_modification: (Updatable) Enables or disables notification on Environment Fleet Topology Modification.
        :param pulumi.Input[bool] on_upcoming_schedule: (Updatable) Enables notification on upcoming schedule.
        """
        if on_job_failure is not None:
            pulumi.set(__self__, "on_job_failure", on_job_failure)
        if on_topology_modification is not None:
            pulumi.set(__self__, "on_topology_modification", on_topology_modification)
        if on_upcoming_schedule is not None:
            pulumi.set(__self__, "on_upcoming_schedule", on_upcoming_schedule)

    @property
    @pulumi.getter(name="onJobFailure")
    def on_job_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enables or disables notification on Job Failures.'
        """
        return pulumi.get(self, "on_job_failure")

    @on_job_failure.setter
    def on_job_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_job_failure", value)

    @property
    @pulumi.getter(name="onTopologyModification")
    def on_topology_modification(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enables or disables notification on Environment Fleet Topology Modification.
        """
        return pulumi.get(self, "on_topology_modification")

    @on_topology_modification.setter
    def on_topology_modification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_topology_modification", value)

    @property
    @pulumi.getter(name="onUpcomingSchedule")
    def on_upcoming_schedule(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enables notification on upcoming schedule.
        """
        return pulumi.get(self, "on_upcoming_schedule")

    @on_upcoming_schedule.setter
    def on_upcoming_schedule(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "on_upcoming_schedule", value)


if not MYPY:
    class FleetRuleSelectionCriteriaArgsDict(TypedDict):
        match_condition: pulumi.Input[str]
        """
        (Updatable) Rule selection match condition.
        """
        rules: pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleArgsDict']]]
        """
        (Updatable) Rules.
        """
elif False:
    FleetRuleSelectionCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetRuleSelectionCriteriaArgs:
    def __init__(__self__, *,
                 match_condition: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleArgs']]]):
        """
        :param pulumi.Input[str] match_condition: (Updatable) Rule selection match condition.
        :param pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleArgs']]] rules: (Updatable) Rules.
        """
        pulumi.set(__self__, "match_condition", match_condition)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="matchCondition")
    def match_condition(self) -> pulumi.Input[str]:
        """
        (Updatable) Rule selection match condition.
        """
        return pulumi.get(self, "match_condition")

    @match_condition.setter
    def match_condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "match_condition", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleArgs']]]:
        """
        (Updatable) Rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class FleetRuleSelectionCriteriaRuleArgsDict(TypedDict):
        compartment_id: pulumi.Input[str]
        """
        (Updatable) Please provide the root compartmentId (TenancyId).
        """
        conditions: pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleConditionArgsDict']]]
        """
        (Updatable) Rule Conditions
        """
        resource_compartment_id: pulumi.Input[str]
        """
        (Updatable) Resource Compartment Id.Provide the compartmentId the resource belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        basis: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Rule to be be applied on.
        """
elif False:
    FleetRuleSelectionCriteriaRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetRuleSelectionCriteriaRuleArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 conditions: pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleConditionArgs']]],
                 resource_compartment_id: pulumi.Input[str],
                 basis: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) Please provide the root compartmentId (TenancyId).
        :param pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleConditionArgs']]] conditions: (Updatable) Rule Conditions
        :param pulumi.Input[str] resource_compartment_id: (Updatable) Resource Compartment Id.Provide the compartmentId the resource belongs to.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] basis: (Updatable) Rule to be be applied on.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        if basis is not None:
            pulumi.set(__self__, "basis", basis)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Please provide the root compartmentId (TenancyId).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleConditionArgs']]]:
        """
        (Updatable) Rule Conditions
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['FleetRuleSelectionCriteriaRuleConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Resource Compartment Id.Provide the compartmentId the resource belongs to.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_compartment_id")

    @resource_compartment_id.setter
    def resource_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_compartment_id", value)

    @property
    @pulumi.getter
    def basis(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Rule to be be applied on.
        """
        return pulumi.get(self, "basis")

    @basis.setter
    def basis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basis", value)


if not MYPY:
    class FleetRuleSelectionCriteriaRuleConditionArgsDict(TypedDict):
        attr_group: pulumi.Input[str]
        """
        (Updatable) Attribute Group.
        """
        attr_key: pulumi.Input[str]
        """
        (Updatable) Attribute Key.
        """
        attr_value: pulumi.Input[str]
        """
        (Updatable) Attribute Value.
        """
elif False:
    FleetRuleSelectionCriteriaRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetRuleSelectionCriteriaRuleConditionArgs:
    def __init__(__self__, *,
                 attr_group: pulumi.Input[str],
                 attr_key: pulumi.Input[str],
                 attr_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] attr_group: (Updatable) Attribute Group.
        :param pulumi.Input[str] attr_key: (Updatable) Attribute Key.
        :param pulumi.Input[str] attr_value: (Updatable) Attribute Value.
        """
        pulumi.set(__self__, "attr_group", attr_group)
        pulumi.set(__self__, "attr_key", attr_key)
        pulumi.set(__self__, "attr_value", attr_value)

    @property
    @pulumi.getter(name="attrGroup")
    def attr_group(self) -> pulumi.Input[str]:
        """
        (Updatable) Attribute Group.
        """
        return pulumi.get(self, "attr_group")

    @attr_group.setter
    def attr_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "attr_group", value)

    @property
    @pulumi.getter(name="attrKey")
    def attr_key(self) -> pulumi.Input[str]:
        """
        (Updatable) Attribute Key.
        """
        return pulumi.get(self, "attr_key")

    @attr_key.setter
    def attr_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "attr_key", value)

    @property
    @pulumi.getter(name="attrValue")
    def attr_value(self) -> pulumi.Input[str]:
        """
        (Updatable) Attribute Value.
        """
        return pulumi.get(self, "attr_value")

    @attr_value.setter
    def attr_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "attr_value", value)


if not MYPY:
    class SchedulerDefinitionActionGroupArgsDict(TypedDict):
        resource_id: pulumi.Input[str]
        """
        (Updatable) Provide the ID of the resource; Ex- fleetId.
        """
        runbook_id: pulumi.Input[str]
        """
        (Updatable) ID of the runbook
        """
        application_type: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Application Type associated. Only applicable if type is ENVIRONMENT.
        """
        lifecycle_operation: NotRequired[pulumi.Input[str]]
        """
        (Updatable) LifeCycle Operation
        """
        product: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Product associated. Only applicable if type is PRODUCT.
        """
        subjects: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) Provide subjects that need to be considered for the schedule.
        """
        target_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provide the target if schedule is created against the target
        """
        type: NotRequired[pulumi.Input[str]]
        """
        (Updatable) ActionGroup Type associated.
        """
elif False:
    SchedulerDefinitionActionGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerDefinitionActionGroupArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 runbook_id: pulumi.Input[str],
                 application_type: Optional[pulumi.Input[str]] = None,
                 lifecycle_operation: Optional[pulumi.Input[str]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 subjects: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_id: (Updatable) Provide the ID of the resource; Ex- fleetId.
        :param pulumi.Input[str] runbook_id: (Updatable) ID of the runbook
        :param pulumi.Input[str] application_type: (Updatable) Application Type associated. Only applicable if type is ENVIRONMENT.
        :param pulumi.Input[str] lifecycle_operation: (Updatable) LifeCycle Operation
        :param pulumi.Input[str] product: (Updatable) Product associated. Only applicable if type is PRODUCT.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subjects: (Updatable) Provide subjects that need to be considered for the schedule.
        :param pulumi.Input[str] target_id: (Updatable) Provide the target if schedule is created against the target
        :param pulumi.Input[str] type: (Updatable) ActionGroup Type associated.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "runbook_id", runbook_id)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if lifecycle_operation is not None:
            pulumi.set(__self__, "lifecycle_operation", lifecycle_operation)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Provide the ID of the resource; Ex- fleetId.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> pulumi.Input[str]:
        """
        (Updatable) ID of the runbook
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "runbook_id", value)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application Type associated. Only applicable if type is ENVIRONMENT.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="lifecycleOperation")
    def lifecycle_operation(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) LifeCycle Operation
        """
        return pulumi.get(self, "lifecycle_operation")

    @lifecycle_operation.setter
    def lifecycle_operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_operation", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Product associated. Only applicable if type is PRODUCT.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Provide subjects that need to be considered for the schedule.
        """
        return pulumi.get(self, "subjects")

    @subjects.setter
    def subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subjects", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provide the target if schedule is created against the target
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) ActionGroup Type associated.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class SchedulerDefinitionRunBookArgsDict(TypedDict):
        id: pulumi.Input[str]
        """
        (Updatable) The ID of the Runbook
        """
        input_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgsDict']]]]
        """
        (Updatable) Input Parameters for the Task
        """
elif False:
    SchedulerDefinitionRunBookArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerDefinitionRunBookArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 input_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgs']]]] = None):
        """
        :param pulumi.Input[str] id: (Updatable) The ID of the Runbook
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgs']]] input_parameters: (Updatable) Input Parameters for the Task
        """
        pulumi.set(__self__, "id", id)
        if input_parameters is not None:
            pulumi.set(__self__, "input_parameters", input_parameters)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        (Updatable) The ID of the Runbook
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="inputParameters")
    def input_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgs']]]]:
        """
        (Updatable) Input Parameters for the Task
        """
        return pulumi.get(self, "input_parameters")

    @input_parameters.setter
    def input_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgs']]]]):
        pulumi.set(self, "input_parameters", value)


if not MYPY:
    class SchedulerDefinitionRunBookInputParameterArgsDict(TypedDict):
        step_name: pulumi.Input[str]
        """
        (Updatable) stepName for which the input parameters are provided
        """
        arguments: NotRequired[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgumentArgsDict']]]]
        """
        (Updatable) Arguments for the Task
        """
elif False:
    SchedulerDefinitionRunBookInputParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerDefinitionRunBookInputParameterArgs:
    def __init__(__self__, *,
                 step_name: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgumentArgs']]]] = None):
        """
        :param pulumi.Input[str] step_name: (Updatable) stepName for which the input parameters are provided
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgumentArgs']]] arguments: (Updatable) Arguments for the Task
        """
        pulumi.set(__self__, "step_name", step_name)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)

    @property
    @pulumi.getter(name="stepName")
    def step_name(self) -> pulumi.Input[str]:
        """
        (Updatable) stepName for which the input parameters are provided
        """
        return pulumi.get(self, "step_name")

    @step_name.setter
    def step_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "step_name", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgumentArgs']]]]:
        """
        (Updatable) Arguments for the Task
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookInputParameterArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)


if not MYPY:
    class SchedulerDefinitionRunBookInputParameterArgumentArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        (Updatable) Name of the output variable
        """
        value: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The task output
        """
elif False:
    SchedulerDefinitionRunBookInputParameterArgumentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerDefinitionRunBookInputParameterArgumentArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Name of the output variable
        :param pulumi.Input[str] value: (Updatable) The task output
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the output variable
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The task output
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class SchedulerDefinitionScheduleArgsDict(TypedDict):
        execution_startdate: pulumi.Input[str]
        """
        (Updatable) Start Date for the schedule. An RFC3339 formatted datetime string
        """
        type: pulumi.Input[str]
        """
        (Updatable) Schedule Type


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        duration: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Duration if schedule type is Custom
        """
        maintenance_window_id: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        """
        recurrences: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Recurrence rule specification if Schedule Type is Custom and Recurring
        """
elif False:
    SchedulerDefinitionScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerDefinitionScheduleArgs:
    def __init__(__self__, *,
                 execution_startdate: pulumi.Input[str],
                 type: pulumi.Input[str],
                 duration: Optional[pulumi.Input[str]] = None,
                 maintenance_window_id: Optional[pulumi.Input[str]] = None,
                 recurrences: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] execution_startdate: (Updatable) Start Date for the schedule. An RFC3339 formatted datetime string
        :param pulumi.Input[str] type: (Updatable) Schedule Type
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] duration: (Updatable) Duration if schedule type is Custom
        :param pulumi.Input[str] maintenance_window_id: (Updatable) Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        :param pulumi.Input[str] recurrences: (Updatable) Recurrence rule specification if Schedule Type is Custom and Recurring
        """
        pulumi.set(__self__, "execution_startdate", execution_startdate)
        pulumi.set(__self__, "type", type)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if maintenance_window_id is not None:
            pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        if recurrences is not None:
            pulumi.set(__self__, "recurrences", recurrences)

    @property
    @pulumi.getter(name="executionStartdate")
    def execution_startdate(self) -> pulumi.Input[str]:
        """
        (Updatable) Start Date for the schedule. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "execution_startdate")

    @execution_startdate.setter
    def execution_startdate(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_startdate", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Schedule Type


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Duration if schedule type is Custom
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provide MaintenanceWindowId if Schedule Type is Maintenance Window
        """
        return pulumi.get(self, "maintenance_window_id")

    @maintenance_window_id.setter
    def maintenance_window_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_id", value)

    @property
    @pulumi.getter
    def recurrences(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Recurrence rule specification if Schedule Type is Custom and Recurring
        """
        return pulumi.get(self, "recurrences")

    @recurrences.setter
    def recurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrences", value)


if not MYPY:
    class GetAnnouncementsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetAnnouncementsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAnnouncementsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetFleetCredentialsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetFleetCredentialsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFleetCredentialsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetFleetProductsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetFleetProductsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFleetProductsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetFleetPropertiesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetFleetPropertiesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFleetPropertiesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetFleetResourcesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetFleetResourcesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFleetResourcesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetFleetTargetsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetFleetTargetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFleetTargetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetFleetsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetFleetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetFleetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetInventoryResourcesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetInventoryResourcesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInventoryResourcesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetMaintenanceWindowsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetMaintenanceWindowsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetMaintenanceWindowsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOnboardingPoliciesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetOnboardingPoliciesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOnboardingPoliciesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetOnboardingsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetOnboardingsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetOnboardingsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetPropertiesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        """
        Values of the property (must be a single value if selection = 'single choice')
        """
        regex: NotRequired[bool]
elif False:
    GetPropertiesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetPropertiesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param Sequence[str] values: Values of the property (must be a single value if selection = 'single choice')
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Values of the property (must be a single value if selection = 'single choice')
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetRunbooksFilterArgsDict(TypedDict):
        name: str
        """
        The name of the task
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetRunbooksFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetRunbooksFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the task
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the task
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetSchedulerDefinitionScheduledFleetsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetSchedulerDefinitionScheduledFleetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSchedulerDefinitionScheduledFleetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetSchedulerDefinitionsFilterArgsDict(TypedDict):
        name: str
        """
        Name of the output variable
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetSchedulerDefinitionsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetSchedulerDefinitionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the output variable
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the output variable
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetTaskRecordsFilterArgsDict(TypedDict):
        name: str
        """
        The name of the argument
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetTaskRecordsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetTaskRecordsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the argument
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the argument
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


