# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMediaWorkflowJobResult',
    'AwaitableGetMediaWorkflowJobResult',
    'get_media_workflow_job',
    'get_media_workflow_job_output',
]

@pulumi.output_type
class GetMediaWorkflowJobResult:
    """
    A collection of values returned by getMediaWorkflowJob.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_lock_override=None, lifecycle_details=None, locks=None, media_workflow_configuration_ids=None, media_workflow_id=None, media_workflow_job_id=None, media_workflow_name=None, outputs=None, parameters=None, runnable=None, state=None, system_tags=None, task_lifecycle_states=None, time_created=None, time_ended=None, time_started=None, time_updated=None, workflow_identifier_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if media_workflow_configuration_ids and not isinstance(media_workflow_configuration_ids, list):
            raise TypeError("Expected argument 'media_workflow_configuration_ids' to be a list")
        pulumi.set(__self__, "media_workflow_configuration_ids", media_workflow_configuration_ids)
        if media_workflow_id and not isinstance(media_workflow_id, str):
            raise TypeError("Expected argument 'media_workflow_id' to be a str")
        pulumi.set(__self__, "media_workflow_id", media_workflow_id)
        if media_workflow_job_id and not isinstance(media_workflow_job_id, str):
            raise TypeError("Expected argument 'media_workflow_job_id' to be a str")
        pulumi.set(__self__, "media_workflow_job_id", media_workflow_job_id)
        if media_workflow_name and not isinstance(media_workflow_name, str):
            raise TypeError("Expected argument 'media_workflow_name' to be a str")
        pulumi.set(__self__, "media_workflow_name", media_workflow_name)
        if outputs and not isinstance(outputs, list):
            raise TypeError("Expected argument 'outputs' to be a list")
        pulumi.set(__self__, "outputs", outputs)
        if parameters and not isinstance(parameters, str):
            raise TypeError("Expected argument 'parameters' to be a str")
        pulumi.set(__self__, "parameters", parameters)
        if runnable and not isinstance(runnable, str):
            raise TypeError("Expected argument 'runnable' to be a str")
        pulumi.set(__self__, "runnable", runnable)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if task_lifecycle_states and not isinstance(task_lifecycle_states, list):
            raise TypeError("Expected argument 'task_lifecycle_states' to be a list")
        pulumi.set(__self__, "task_lifecycle_states", task_lifecycle_states)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if workflow_identifier_type and not isinstance(workflow_identifier_type, str):
            raise TypeError("Expected argument 'workflow_identifier_type' to be a str")
        pulumi.set(__self__, "workflow_identifier_type", workflow_identifier_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Name of the Media Workflow Job. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID associated with the job output.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The lifecycle details of MediaWorkflowJob task.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetMediaWorkflowJobLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="mediaWorkflowConfigurationIds")
    def media_workflow_configuration_ids(self) -> Sequence[str]:
        """
        Configurations to be applied to this run of the workflow.
        """
        return pulumi.get(self, "media_workflow_configuration_ids")

    @property
    @pulumi.getter(name="mediaWorkflowId")
    def media_workflow_id(self) -> str:
        """
        The workflow to execute.
        """
        return pulumi.get(self, "media_workflow_id")

    @property
    @pulumi.getter(name="mediaWorkflowJobId")
    def media_workflow_job_id(self) -> str:
        return pulumi.get(self, "media_workflow_job_id")

    @property
    @pulumi.getter(name="mediaWorkflowName")
    def media_workflow_name(self) -> str:
        return pulumi.get(self, "media_workflow_name")

    @property
    @pulumi.getter
    def outputs(self) -> Sequence['outputs.GetMediaWorkflowJobOutputResult']:
        """
        A list of JobOutput for the workflowJob.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def parameters(self) -> str:
        """
        Parameters that override parameters specified in MediaWorkflowTaskDeclarations, the MediaWorkflow, the MediaWorkflow's MediaWorkflowConfigurations and the MediaWorkflowConfigurations of this MediaWorkflowJob. The parameters are given as JSON.  The top level and 2nd level elements must be JSON objects (vs arrays, scalars, etc). The top level keys refer to a task's key and the 2nd level keys refer to a parameter's name.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def runnable(self) -> str:
        """
        A JSON representation of the job as it will be run by the system. All the task declarations, configurations and parameters are merged. Parameter values are all fully resolved.
        """
        return pulumi.get(self, "runnable")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the MediaWorkflowJob task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="taskLifecycleStates")
    def task_lifecycle_states(self) -> Sequence['outputs.GetMediaWorkflowJobTaskLifecycleStateResult']:
        """
        Status of each task.
        """
        return pulumi.get(self, "task_lifecycle_states")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Creation time of the job. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        Time when the job finished. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Time when the job started to execute. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Updated time of the job. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="workflowIdentifierType")
    def workflow_identifier_type(self) -> str:
        return pulumi.get(self, "workflow_identifier_type")


class AwaitableGetMediaWorkflowJobResult(GetMediaWorkflowJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaWorkflowJobResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_lock_override=self.is_lock_override,
            lifecycle_details=self.lifecycle_details,
            locks=self.locks,
            media_workflow_configuration_ids=self.media_workflow_configuration_ids,
            media_workflow_id=self.media_workflow_id,
            media_workflow_job_id=self.media_workflow_job_id,
            media_workflow_name=self.media_workflow_name,
            outputs=self.outputs,
            parameters=self.parameters,
            runnable=self.runnable,
            state=self.state,
            system_tags=self.system_tags,
            task_lifecycle_states=self.task_lifecycle_states,
            time_created=self.time_created,
            time_ended=self.time_ended,
            time_started=self.time_started,
            time_updated=self.time_updated,
            workflow_identifier_type=self.workflow_identifier_type)


def get_media_workflow_job(media_workflow_job_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaWorkflowJobResult:
    """
    This data source provides details about a specific Media Workflow Job resource in Oracle Cloud Infrastructure Media Services service.

    Gets the MediaWorkflowJob.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_job = oci.MediaServices.get_media_workflow_job(media_workflow_job_id=test_media_workflow_job_oci_media_services_media_workflow_job["id"])
    ```


    :param str media_workflow_job_id: Unique MediaWorkflowJob identifier.
    """
    __args__ = dict()
    __args__['mediaWorkflowJobId'] = media_workflow_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getMediaWorkflowJob:getMediaWorkflowJob', __args__, opts=opts, typ=GetMediaWorkflowJobResult).value

    return AwaitableGetMediaWorkflowJobResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        media_workflow_configuration_ids=pulumi.get(__ret__, 'media_workflow_configuration_ids'),
        media_workflow_id=pulumi.get(__ret__, 'media_workflow_id'),
        media_workflow_job_id=pulumi.get(__ret__, 'media_workflow_job_id'),
        media_workflow_name=pulumi.get(__ret__, 'media_workflow_name'),
        outputs=pulumi.get(__ret__, 'outputs'),
        parameters=pulumi.get(__ret__, 'parameters'),
        runnable=pulumi.get(__ret__, 'runnable'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        task_lifecycle_states=pulumi.get(__ret__, 'task_lifecycle_states'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        workflow_identifier_type=pulumi.get(__ret__, 'workflow_identifier_type'))
def get_media_workflow_job_output(media_workflow_job_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMediaWorkflowJobResult]:
    """
    This data source provides details about a specific Media Workflow Job resource in Oracle Cloud Infrastructure Media Services service.

    Gets the MediaWorkflowJob.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_workflow_job = oci.MediaServices.get_media_workflow_job(media_workflow_job_id=test_media_workflow_job_oci_media_services_media_workflow_job["id"])
    ```


    :param str media_workflow_job_id: Unique MediaWorkflowJob identifier.
    """
    __args__ = dict()
    __args__['mediaWorkflowJobId'] = media_workflow_job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getMediaWorkflowJob:getMediaWorkflowJob', __args__, opts=opts, typ=GetMediaWorkflowJobResult)
    return __ret__.apply(lambda __response__: GetMediaWorkflowJobResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_lock_override=pulumi.get(__response__, 'is_lock_override'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        locks=pulumi.get(__response__, 'locks'),
        media_workflow_configuration_ids=pulumi.get(__response__, 'media_workflow_configuration_ids'),
        media_workflow_id=pulumi.get(__response__, 'media_workflow_id'),
        media_workflow_job_id=pulumi.get(__response__, 'media_workflow_job_id'),
        media_workflow_name=pulumi.get(__response__, 'media_workflow_name'),
        outputs=pulumi.get(__response__, 'outputs'),
        parameters=pulumi.get(__response__, 'parameters'),
        runnable=pulumi.get(__response__, 'runnable'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        task_lifecycle_states=pulumi.get(__response__, 'task_lifecycle_states'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        workflow_identifier_type=pulumi.get(__response__, 'workflow_identifier_type')))
