# generated by datamodel-codegen:
#   filename:  configuration/themeConfiguration.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class ThemeConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    primaryColor: Annotated[
        str,
        Field(
            description='Primary color used in the UI, in hex code format or empty.',
            pattern='^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$',
        ),
    ]
    errorColor: Annotated[
        str,
        Field(
            description='Color used to indicate errors in the UI, in hex code format or empty',
            pattern='^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$',
        ),
    ]
    successColor: Annotated[
        str,
        Field(
            description='Color used to indicate success in the UI, in hex code format or empty',
            pattern='^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$',
        ),
    ]
    warningColor: Annotated[
        str,
        Field(
            description='Color used to indicate warnings in the UI, in hex code format or empty',
            pattern='^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$',
        ),
    ]
    infoColor: Annotated[
        str,
        Field(
            description='Color used for informational messages in the UI, in hex code format or empty',
            pattern='^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$|^$',
        ),
    ]
