# generated by datamodel-codegen:
#   filename:  entity/applications/marketplace/appMarketPlaceDefinition.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    tagLabel,
)
from .. import app
from ..configuration import applicationConfig


class AppMarketPlaceDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this application.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the Application.')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name for the application.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Application.'),
    ]
    features: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Features of the Application.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this workflow.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with the entity.'),
    ]
    developer: Annotated[
        Optional[str], Field(None, description='Developer For the Application.')
    ]
    developerUrl: Annotated[
        Optional[str], Field(None, description='Url for the developer')
    ]
    privacyPolicyUrl: Annotated[
        Optional[str], Field(None, description='Privacy Policy for the developer')
    ]
    supportEmail: Annotated[
        Optional[str], Field(None, description='Support Email for the application')
    ]
    className: Annotated[
        str, Field(description='Full Qualified ClassName for the the application')
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully Qualified class name for the Python source that will execute the external application.',
        ),
    ]
    appType: Annotated[
        app.AppType, Field(description='This schema defines the type of application.')
    ]
    scheduleType: Annotated[
        app.ScheduleType,
        Field(description='This schema defines the Schedule Type of Application.'),
    ]
    permission: Annotated[
        app.Permissions, Field(description='Permission used by Native Applications.')
    ]
    runtime: Annotated[
        Optional[app.ExecutionContext],
        Field(
            None,
            description='If app type is live, user can provide additional runtime context.',
        ),
    ]
    allowConfiguration: Annotated[
        Optional[bool],
        Field(
            True,
            description='Allow users to configure the app from the UI. If `false`, the `configure` step will be hidden.',
        ),
    ]
    appConfiguration: Annotated[
        Optional[applicationConfig.AppConfig],
        Field(None, description='Application Configuration object.'),
    ]
    appLogoUrl: Annotated[
        Optional[AnyUrl], Field(None, description='Application Logo Url.')
    ]
    appScreenshots: Annotated[
        Optional[List[str]], Field(None, description='Application Screenshots.')
    ]
    system: Annotated[
        Optional[bool],
        Field(False, description='A system app cannot be uninstalled or modified.'),
    ]
    preview: Annotated[
        Optional[bool],
        Field(
            False,
            description="Flag to enable/disable preview for the application. If the app is in preview mode, it can't be installed.",
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    supportsInterrupt: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the app run can be interrupted as part of the execution.',
        ),
    ]
