# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/lookerConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....security.credentials import (
    bitbucketCredentials,
    githubCredentials,
    gitlabCredentials,
)
from .. import connectionBasicType


class LookerType(Enum):
    Looker = 'Looker'


class NoGitCredentials(BaseModel):
    pass
    model_config = ConfigDict(
        extra='forbid',
    )


class LookerConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[LookerType],
        Field(LookerType.Looker, description='Service Type', title='Service Type'),
    ]
    clientId: Annotated[
        str,
        Field(
            description="User's Client ID. This user should have privileges to read all the metadata in Looker.",
            title='Client ID',
        ),
    ]
    clientSecret: Annotated[
        CustomSecretStr,
        Field(description="User's Client Secret.", title='Client Secret'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='URL to the Looker instance.', title='Host and Port')
    ]
    gitCredentials: Annotated[
        Optional[
            Union[
                NoGitCredentials,
                githubCredentials.GitHubCredentials,
                bitbucketCredentials.BitBucketCredentials,
                gitlabCredentials.GitlabCredentials,
            ]
        ],
        Field(
            None,
            description='Credentials to extract the .lkml files from a repository. This is required to get all the lineage and definitions.',
            title='GitHub Credentials',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
