# generated by datamodel-codegen:
#   filename:  api/tests/createTestCaseResult.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...tests import basic as basic_1
from ...type import basic


class CreateTestCaseResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Annotated[
        basic.Timestamp, Field(description='Data one which test case result is taken.')
    ]
    testCaseStatus: Annotated[
        basic_1.TestCaseStatus, Field(description='Status of Test Case run.')
    ]
    result: Annotated[
        Optional[str], Field(None, description='Details of test case results.')
    ]
    sampleData: Annotated[
        Optional[str],
        Field(
            None,
            description="sample data to capture rows/columns that didn't match the expressed testcase.",
        ),
    ]
    testResultValue: List[basic_1.TestResultValue]
    passedRows: Annotated[
        Optional[int], Field(None, description='Number of rows that passed.')
    ]
    failedRows: Annotated[
        Optional[int], Field(None, description='Number of rows that failed.')
    ]
    passedRowsPercentage: Annotated[
        Optional[float], Field(None, description='Percentage of rows that passed.')
    ]
    failedRowsPercentage: Annotated[
        Optional[float], Field(None, description='Percentage of rows that failed.')
    ]
    incidentId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Incident State ID associated with this result. This association happens when the result is created, and will stay there even when the incident is resolved.',
        ),
    ]
    maxBound: Annotated[
        Optional[float],
        Field(
            None,
            description='Upper bound limit for the test case result as defined in the test definition.',
        ),
    ]
    minBound: Annotated[
        Optional[float],
        Field(
            None,
            description='Lower bound limit for the test case result as defined in the test definition.',
        ),
    ]
