# generated by datamodel-codegen:
#   filename:  email/emailRequest.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic


class ContentType(Enum):
    plain = 'plain'
    html = 'html'


class NameEmailPair(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Name')]
    email: Annotated[basic.Email, Field(description='Email address of the user.')]


class EmailRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    senderName: Annotated[Optional[str], Field(None, description='Sender Name')]
    senderMail: Annotated[Optional[str], Field(None, description='From Email Address')]
    recipientMails: Annotated[
        Optional[List[NameEmailPair]],
        Field(None, description='List of Receiver Name with Email'),
    ]
    ccMails: Annotated[
        Optional[List[NameEmailPair]], Field(None, description='List of CC')
    ]
    bccMails: Annotated[
        Optional[List[NameEmailPair]], Field(None, description='List of BCC')
    ]
    subject: Annotated[str, Field(description='Subject for Mail')]
    contentType: ContentType
    content: Annotated[Optional[str], Field(None, description='Content for mail')]
