# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/sigmaConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class SigmaType(Enum):
    Sigma = 'Sigma'


class SigmaConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SigmaType],
        Field(SigmaType.Sigma, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='Sigma API url.', title='Host and Port')
    ]
    clientId: Annotated[
        str, Field(description='client_id for Sigma.', title='Client ID')
    ]
    clientSecret: Annotated[
        CustomSecretStr,
        Field(description='clientSecret for Sigma.', title='Client Secret'),
    ]
    apiVersion: Annotated[
        Optional[str],
        Field('v2', description='Sigma API version.', title='API Version'),
    ]
