# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/couchbaseConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class CouchbaseType(Enum):
    Couchbase = 'Couchbase'


class CouchbaseScheme(Enum):
    couchbase = 'couchbase'


class CouchbaseConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[CouchbaseType],
        Field(
            CouchbaseType.Couchbase, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[CouchbaseScheme],
        Field(
            CouchbaseScheme.couchbase,
            description='Couchbase driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    bucket: Annotated[
        Optional[str],
        Field(
            None,
            description='Couchbase connection Bucket options.',
            title='Connection Bucket',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Couchbase. This user should have privileges to read all the metadata in Couchbase.',
            title='Username',
        ),
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='Password to connect to Couchbase.', title='Password'),
    ]
    hostport: Annotated[
        str, Field(description='Hostname of the Couchbase service.', title='Hostport')
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
