# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/pinotDBConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class PinotDBType(Enum):
    PinotDB = 'PinotDB'


class PinotDBScheme(Enum):
    pinot = 'pinot'
    pinot_http = 'pinot+http'
    pinot_https = 'pinot+https'


class PinotDBConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[PinotDBType],
        Field(PinotDBType.PinotDB, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[PinotDBScheme],
        Field(
            PinotDBScheme.pinot,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='username to connect to the PinotDB. This user should have privileges to read all the metadata in PinotDB.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(
            None, description='password to connect to the PinotDB.', title='Password'
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the PinotDB Broker service.',
            title='Pinot Broker Host and Port',
        ),
    ]
    pinotControllerHost: Annotated[
        str,
        Field(
            description='Pinot Controller Host and Port of the data source.',
            title='Pinot Controller Host and Port',
        ),
    ]
    database: Annotated[
        Optional[str],
        Field(
            None,
            description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
            title='Database',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsViewLineageExtraction: Optional[
        connectionBasicType.SupportsViewLineageExtraction
    ] = None
