# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/sapErpConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class SapErpType(Enum):
    SapErp = 'SapErp'


class SapErpConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SapErpType],
        Field(SapErpType.SapErp, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Host and Port of the SAP ERP instance.',
            title='Host and Port',
        ),
    ]
    apiKey: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='API key to authenticate with the SAP ERP APIs.',
            title='API Key',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the schema in OpenMetadata. If left blank, we will use default as the schema name',
            title='Database Schema',
        ),
    ]
    paginationLimit: Annotated[
        Optional[int],
        Field(
            10,
            description='Pagination limit used while querying the SAP ERP API for fetching the entities',
            title='Pagination Limit',
        ),
    ]
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
