# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/datafactoryConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import azureCredentials


class DataFactoryType(Enum):
    DataFactory = 'DataFactory'


class DataFactoryConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DataFactoryType],
        Field(
            DataFactoryType.DataFactory,
            description='Service Type',
            title='Service Type',
        ),
    ]
    subscription_id: Annotated[
        str,
        Field(
            description='The azure subscription identifier.', title='Subscription ID'
        ),
    ]
    resource_group_name: Annotated[
        str,
        Field(
            description='The name of your resource group the data factory is associated with.',
            title='Resource Group name',
        ),
    ]
    factory_name: Annotated[
        str,
        Field(
            description='The name of your azure data factory.',
            title='Azure Data Factory name',
        ),
    ]
    run_filter_days: Annotated[
        Optional[int],
        Field(
            7,
            description='Number of days in the past to filter pipeline runs.',
            title='Azure Data Factory pipeline runs day filter',
        ),
    ]
    configSource: Annotated[
        Optional[azureCredentials.AzureCredentials],
        Field(
            None,
            description='Available sources to fetch metadata.',
            title='Azure Data Factory Configuration',
        ),
    ]
