# generated by datamodel-codegen:
#   filename:  entity/services/connections/search/openSearchConnection.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .. import connectionBasicType


class OpenSearchType(Enum):
    OpenSearch = 'OpenSearch'


class OpensearchConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[OpenSearchType],
        Field(
            OpenSearchType.OpenSearch, description='Service Type', title='Service Type'
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the OpenSearch service.',
            title='Host and Port',
        ),
    ]
    scheme: Annotated[
        Optional[str], Field(None, description='Http/Https connection scheme')
    ]
    username: Annotated[
        Optional[str], Field(None, description='OpenSearch Username for Login')
    ]
    password: Annotated[
        Optional[str], Field(None, description='OpenSearch Password for Login')
    ]
    truststorePath: Annotated[Optional[str], Field(None, description='Truststore Path')]
    truststorePassword: Annotated[
        Optional[str], Field(None, description='Truststore Password')
    ]
    connectionTimeoutSecs: Annotated[
        Optional[int], Field(5, description='Connection Timeout in Seconds')
    ]
    socketTimeoutSecs: Annotated[
        Optional[int], Field(60, description='Socket Timeout in Seconds')
    ]
    keepAliveTimeoutSecs: Annotated[
        Optional[int], Field(None, description='Keep Alive Timeout in Seconds')
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
