# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class DatabaseMetadataConfigType(Enum):
    DatabaseMetadata = 'DatabaseMetadata'


class Incremental(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enabled: Annotated[
        bool,
        Field(
            description='If True, enables Metadata Extraction to be incremental',
            title='Enabled',
        ),
    ]
    lookbackDays: Annotated[
        Optional[int],
        Field(
            7,
            description='Number os days to search back for a successful pipeline run. The timestamp of the last found successful pipeline run will be used as a base to search for updated entities.',
            title='Successful Pipeline Run Lookback Days',
        ),
    ]
    safetyMarginDays: Annotated[
        Optional[int],
        Field(
            1,
            description='Number of days to add to the last successful pipeline run timestamp to search for updated entities.',
            title='Safety Margin Days',
        ),
    ]


class DatabaseServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatabaseMetadataConfigType],
        Field(DatabaseMetadataConfigType.DatabaseMetadata, description='Pipeline type'),
    ]
    markDeletedTables: Annotated[
        Optional[bool],
        Field(
            True,
            description='This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply solely to the schema that is currently being ingested via the pipeline. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted.',
            title='Mark Deleted Tables',
        ),
    ]
    markDeletedStoredProcedures: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete stored procedures in OpenMetadata if the source stored procedures are deleted. Also, if the stored procedures is deleted, all the associated entities like lineage, etc., with that stored procedures will be deleted',
            title='Mark Deleted Stored Procedures',
        ),
    ]
    includeTables: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for tables.',
            title='Include Tables',
        ),
    ]
    includeViews: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for views.',
            title='Include Views',
        ),
    ]
    includeTags: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle the tags ingestion.',
            title='Include Tags',
        ),
    ]
    includeOwners: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Include Owners' toggle to control whether to include owners to the ingested entity if the owner email matches with a user stored in the OM server as part of metadata ingestion. If the ingested entity already exists and has an owner, the owner will not be overwritten.",
            title='Include Owners',
        ),
    ]
    includeStoredProcedures: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to toggle the Stored Procedures ingestion.',
            title='Include Stored Procedures',
        ),
    ]
    includeDDL: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration to toggle the DDL Statements ingestion.',
            title='Include DDL Statements',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
    queryLogDuration: Annotated[
        Optional[int],
        Field(
            1,
            description='Configuration to tune how far we want to look back in query logs to process Stored Procedures results.',
            title='Query Log Duration',
        ),
    ]
    queryParsingTimeoutLimit: Annotated[
        Optional[int],
        Field(
            300,
            description='Configuration to set the timeout for parsing the query in seconds.',
            title='Query Parsing Timeout Limit',
        ),
    ]
    useFqnForFiltering: Annotated[
        Optional[bool],
        Field(
            False,
            description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
            title='Use FQN For Filtering',
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch tables or databases that matches the pattern.',
            title='Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude tables or databases that matches the pattern.',
            title='Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch databases that matches the pattern.',
            title='Database Filter Pattern',
        ),
    ]
    threads: Annotated[
        Optional[int],
        Field(
            1,
            description='Number of Threads to use in order to parallelize Table ingestion.',
            title='Number of Threads',
        ),
    ]
    incremental: Annotated[
        Optional[Incremental],
        Field(
            None,
            description='Use incremental Metadata extraction after the first execution. This is commonly done by getting the changes from Audit tables on the supporting databases.',
            title='Incremental Metadata Extraction Configuration',
        ),
    ]
