# generated by datamodel-codegen:
#   filename:  metadataIngestion/testSuitePipeline.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.data import table
from ..type import basic


class TestSuiteConfigType(Enum):
    TestSuite = 'TestSuite'


class TestSuitePipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[TestSuiteConfigType, Field(description='Pipeline type')]
    entityFullyQualifiedName: Annotated[
        basic.FullyQualifiedEntityName,
        Field(description='Fully qualified name of the entity to be tested.'),
    ]
    profileSample: Annotated[
        Optional[float],
        Field(
            None,
            description='Percentage of data or no. of rows we want to execute the profiler and tests on',
            title='Profile Sample',
        ),
    ]
    profileSampleType: Annotated[
        Optional[table.ProfileSampleType],
        Field(table.ProfileSampleType.PERCENTAGE, title='Profile Sample Type'),
    ]
    samplingMethodType: Annotated[
        Optional[table.SamplingMethodType], Field(None, title='Sampling Method Type')
    ]
    testCases: Annotated[
        Optional[List[basic.TestCaseEntityName]],
        Field(
            None,
            description='List of test cases to be executed on the entity. If null, all test cases will be executed.',
        ),
    ]
