# generated by datamodel-codegen:
#   filename:  security/credentials/gcpExternalAccount.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from typing import Dict, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated, Literal

from metadata.ingestion.models.custom_pydantic import BaseModel


class GcpExternalAccount(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Literal['external_account'],
        Field(
            'external_account',
            description='Google Cloud Platform account type.',
            title='Credentials Type',
        ),
    ]
    externalType: Annotated[
        Literal['external_account'],
        Field(
            'external_account',
            description='Google Cloud Platform account type.',
            title='Credentials Type',
        ),
    ]
    audience: Annotated[
        Optional[str],
        Field(
            None,
            description='Google Security Token Service audience which contains the resource name for the workload identity pool and the provider identifier in that pool.',
            title='Audience',
        ),
    ]
    subjectTokenType: Annotated[
        Optional[str],
        Field(
            None,
            description='Google Security Token Service subject token type based on the OAuth 2.0 token exchange spec.',
            title='Subject Token Type',
        ),
    ]
    tokenURL: Annotated[
        Optional[str],
        Field(
            None,
            description='Google Security Token Service token exchange endpoint.',
            title='Token URL',
        ),
    ]
    credentialSource: Annotated[
        Optional[Dict[str, str]],
        Field(
            None,
            description='This object defines the mechanism used to retrieve the external credential from the local environment so that it can be exchanged for a GCP access token via the STS endpoint',
            title='Credential Source',
        ),
    ]
