# generated by datamodel-codegen:
#   filename:  settings/settings.json
#   timestamp: 2024-12-10T09:05:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..configuration import (
    assetCertificationSettings,
    authenticationConfiguration,
    authorizerConfiguration,
    elasticSearchConfiguration,
    eventHandlerConfiguration,
    fernetConfiguration,
    jwtTokenConfiguration,
    lineageSettings,
    pipelineServiceClientConfiguration,
    profilerConfiguration,
    searchSettings,
    slackAppConfiguration,
    taskNotificationConfiguration,
)
from ..email import smtpSettings


class SettingType(Enum):
    authorizerConfiguration = 'authorizerConfiguration'
    authenticationConfiguration = 'authenticationConfiguration'
    jwtTokenConfiguration = 'jwtTokenConfiguration'
    elasticsearch = 'elasticsearch'
    eventHandlerConfiguration = 'eventHandlerConfiguration'
    airflowConfiguration = 'airflowConfiguration'
    fernetConfiguration = 'fernetConfiguration'
    slackEventPublishers = 'slackEventPublishers'
    secretsManagerConfiguration = 'secretsManagerConfiguration'
    sandboxModeEnabled = 'sandboxModeEnabled'
    slackChat = 'slackChat'
    emailConfiguration = 'emailConfiguration'
    customUiThemePreference = 'customUiThemePreference'
    loginConfiguration = 'loginConfiguration'
    slackAppConfiguration = 'slackAppConfiguration'
    slackBot = 'slackBot'
    slackInstaller = 'slackInstaller'
    slackState = 'slackState'
    profilerConfiguration = 'profilerConfiguration'
    searchSettings = 'searchSettings'
    assetCertificationSettings = 'assetCertificationSettings'
    lineageSettings = 'lineageSettings'


class Settings(BaseModel):
    config_type: Annotated[
        SettingType,
        Field(description='Unique identifier that identifies an entity instance.'),
    ]
    config_value: Optional[
        Union[
            pipelineServiceClientConfiguration.PipelineServiceClientConfiguration,
            authenticationConfiguration.AuthenticationConfiguration,
            authorizerConfiguration.AuthorizerConfiguration,
            elasticSearchConfiguration.ElasticSearchConfiguration,
            eventHandlerConfiguration.EventHandlerConfiguration,
            fernetConfiguration.FernetConfiguration,
            jwtTokenConfiguration.JWTTokenConfiguration,
            taskNotificationConfiguration.TaskNotificationConfiguration,
            smtpSettings.SmtpSettings,
            slackAppConfiguration.SlackAppConfiguration,
            profilerConfiguration.ProfilerConfiguration,
            searchSettings.SearchSettings,
            assetCertificationSettings.AssetCertificationSettings,
            lineageSettings.LineageSettings,
        ]
    ] = None
