# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBdsInstanceIdentityConfigurationsResult',
    'AwaitableGetBdsInstanceIdentityConfigurationsResult',
    'get_bds_instance_identity_configurations',
    'get_bds_instance_identity_configurations_output',
]

@pulumi.output_type
class GetBdsInstanceIdentityConfigurationsResult:
    """
    A collection of values returned by getBdsInstanceIdentityConfigurations.
    """
    def __init__(__self__, bds_instance_id=None, compartment_id=None, display_name=None, filters=None, id=None, identity_configurations=None, state=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_configurations and not isinstance(identity_configurations, list):
            raise TypeError("Expected argument 'identity_configurations' to be a list")
        pulumi.set(__self__, "identity_configurations", identity_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        the display name of the identity configuration
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBdsInstanceIdentityConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityConfigurations")
    def identity_configurations(self) -> Sequence['outputs.GetBdsInstanceIdentityConfigurationsIdentityConfigurationResult']:
        """
        The list of identity_configurations.
        """
        return pulumi.get(self, "identity_configurations")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Lifecycle state of the UPST config
        """
        return pulumi.get(self, "state")


class AwaitableGetBdsInstanceIdentityConfigurationsResult(GetBdsInstanceIdentityConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceIdentityConfigurationsResult(
            bds_instance_id=self.bds_instance_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            identity_configurations=self.identity_configurations,
            state=self.state)


def get_bds_instance_identity_configurations(bds_instance_id: Optional[str] = None,
                                             compartment_id: Optional[str] = None,
                                             display_name: Optional[str] = None,
                                             filters: Optional[Sequence[Union['GetBdsInstanceIdentityConfigurationsFilterArgs', 'GetBdsInstanceIdentityConfigurationsFilterArgsDict']]] = None,
                                             state: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceIdentityConfigurationsResult:
    """
    This data source provides the list of Bds Instance Identity Configurations in Oracle Cloud Infrastructure Big Data Service service.

    Returns a list of all identity configurations associated with this Big Data Service cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_identity_configurations = oci.BigDataService.get_bds_instance_identity_configurations(bds_instance_id=test_bds_instance["id"],
        compartment_id=compartment_id,
        display_name=bds_instance_identity_configuration_display_name,
        state=bds_instance_identity_configuration_state)
    ```


    :param str bds_instance_id: The OCID of the cluster.
    :param str compartment_id: The OCID of the compartment.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: The state of the identity config
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceIdentityConfigurations:getBdsInstanceIdentityConfigurations', __args__, opts=opts, typ=GetBdsInstanceIdentityConfigurationsResult).value

    return AwaitableGetBdsInstanceIdentityConfigurationsResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        identity_configurations=pulumi.get(__ret__, 'identity_configurations'),
        state=pulumi.get(__ret__, 'state'))
def get_bds_instance_identity_configurations_output(bds_instance_id: Optional[pulumi.Input[str]] = None,
                                                    compartment_id: Optional[pulumi.Input[str]] = None,
                                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBdsInstanceIdentityConfigurationsFilterArgs', 'GetBdsInstanceIdentityConfigurationsFilterArgsDict']]]]] = None,
                                                    state: Optional[pulumi.Input[Optional[str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceIdentityConfigurationsResult]:
    """
    This data source provides the list of Bds Instance Identity Configurations in Oracle Cloud Infrastructure Big Data Service service.

    Returns a list of all identity configurations associated with this Big Data Service cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_identity_configurations = oci.BigDataService.get_bds_instance_identity_configurations(bds_instance_id=test_bds_instance["id"],
        compartment_id=compartment_id,
        display_name=bds_instance_identity_configuration_display_name,
        state=bds_instance_identity_configuration_state)
    ```


    :param str bds_instance_id: The OCID of the cluster.
    :param str compartment_id: The OCID of the compartment.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: The state of the identity config
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceIdentityConfigurations:getBdsInstanceIdentityConfigurations', __args__, opts=opts, typ=GetBdsInstanceIdentityConfigurationsResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceIdentityConfigurationsResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        identity_configurations=pulumi.get(__response__, 'identity_configurations'),
        state=pulumi.get(__response__, 'state')))
