# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSensitiveDataModelReferentialRelationsResult',
    'AwaitableGetSensitiveDataModelReferentialRelationsResult',
    'get_sensitive_data_model_referential_relations',
    'get_sensitive_data_model_referential_relations_output',
]

@pulumi.output_type
class GetSensitiveDataModelReferentialRelationsResult:
    """
    A collection of values returned by getSensitiveDataModelReferentialRelations.
    """
    def __init__(__self__, column_names=None, filters=None, id=None, is_sensitive=None, objects=None, referential_relation_collections=None, relation_types=None, schema_names=None, sensitive_data_model_id=None):
        if column_names and not isinstance(column_names, list):
            raise TypeError("Expected argument 'column_names' to be a list")
        pulumi.set(__self__, "column_names", column_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_sensitive and not isinstance(is_sensitive, bool):
            raise TypeError("Expected argument 'is_sensitive' to be a bool")
        pulumi.set(__self__, "is_sensitive", is_sensitive)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if referential_relation_collections and not isinstance(referential_relation_collections, list):
            raise TypeError("Expected argument 'referential_relation_collections' to be a list")
        pulumi.set(__self__, "referential_relation_collections", referential_relation_collections)
        if relation_types and not isinstance(relation_types, list):
            raise TypeError("Expected argument 'relation_types' to be a list")
        pulumi.set(__self__, "relation_types", relation_types)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if sensitive_data_model_id and not isinstance(sensitive_data_model_id, str):
            raise TypeError("Expected argument 'sensitive_data_model_id' to be a str")
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSensitiveDataModelReferentialRelationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSensitive")
    def is_sensitive(self) -> Optional[bool]:
        """
        Determines if the columns present in the referential relation is present in the sensitive data model
        """
        return pulumi.get(self, "is_sensitive")

    @property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[str]]:
        """
        The database object that contains the columns.
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter(name="referentialRelationCollections")
    def referential_relation_collections(self) -> Sequence['outputs.GetSensitiveDataModelReferentialRelationsReferentialRelationCollectionResult']:
        """
        The list of referential_relation_collection.
        """
        return pulumi.get(self, "referential_relation_collections")

    @property
    @pulumi.getter(name="relationTypes")
    def relation_types(self) -> Optional[Sequence[str]]:
        """
        The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_types")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[str]]:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_names")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> str:
        """
        The OCID of the sensitive data model that contains the sensitive column.
        """
        return pulumi.get(self, "sensitive_data_model_id")


class AwaitableGetSensitiveDataModelReferentialRelationsResult(GetSensitiveDataModelReferentialRelationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensitiveDataModelReferentialRelationsResult(
            column_names=self.column_names,
            filters=self.filters,
            id=self.id,
            is_sensitive=self.is_sensitive,
            objects=self.objects,
            referential_relation_collections=self.referential_relation_collections,
            relation_types=self.relation_types,
            schema_names=self.schema_names,
            sensitive_data_model_id=self.sensitive_data_model_id)


def get_sensitive_data_model_referential_relations(column_names: Optional[Sequence[str]] = None,
                                                   filters: Optional[Sequence[Union['GetSensitiveDataModelReferentialRelationsFilterArgs', 'GetSensitiveDataModelReferentialRelationsFilterArgsDict']]] = None,
                                                   is_sensitive: Optional[bool] = None,
                                                   objects: Optional[Sequence[str]] = None,
                                                   relation_types: Optional[Sequence[str]] = None,
                                                   schema_names: Optional[Sequence[str]] = None,
                                                   sensitive_data_model_id: Optional[str] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensitiveDataModelReferentialRelationsResult:
    """
    This data source provides the list of Sensitive Data Model Referential Relations in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of referential relations present in the specified sensitive data model based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model_referential_relations = oci.DataSafe.get_sensitive_data_model_referential_relations(sensitive_data_model_id=test_sensitive_data_model["id"],
        column_names=sensitive_data_model_referential_relation_column_name,
        is_sensitive=sensitive_data_model_referential_relation_is_sensitive,
        objects=sensitive_data_model_referential_relation_object,
        relation_types=sensitive_data_model_referential_relation_relation_type,
        schema_names=sensitive_data_model_referential_relation_schema_name)
    ```


    :param Sequence[str] column_names: A filter to return only a specific column based on column name.
    :param bool is_sensitive: Returns referential relations containing sensitive columns when true. Returns referential relations containing non sensitive columns when false.
    :param Sequence[str] objects: A filter to return only items related to a specific object name.
    :param Sequence[str] relation_types: A filter to return sensitive columns based on their relationship with their parent columns. If set to NONE, it returns the sensitive columns that do not have any parent. The response includes the parent columns as well as the independent columns that are not in any relationship. If set to APP_DEFINED, it returns all the child columns that have application-level (non-dictionary) relationship with their parents. If set to DB_DEFINED, it returns all the child columns that have database-level (dictionary-defined) relationship with their parents.
    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    :param str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['columnNames'] = column_names
    __args__['filters'] = filters
    __args__['isSensitive'] = is_sensitive
    __args__['objects'] = objects
    __args__['relationTypes'] = relation_types
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSensitiveDataModelReferentialRelations:getSensitiveDataModelReferentialRelations', __args__, opts=opts, typ=GetSensitiveDataModelReferentialRelationsResult).value

    return AwaitableGetSensitiveDataModelReferentialRelationsResult(
        column_names=pulumi.get(__ret__, 'column_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_sensitive=pulumi.get(__ret__, 'is_sensitive'),
        objects=pulumi.get(__ret__, 'objects'),
        referential_relation_collections=pulumi.get(__ret__, 'referential_relation_collections'),
        relation_types=pulumi.get(__ret__, 'relation_types'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        sensitive_data_model_id=pulumi.get(__ret__, 'sensitive_data_model_id'))
def get_sensitive_data_model_referential_relations_output(column_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSensitiveDataModelReferentialRelationsFilterArgs', 'GetSensitiveDataModelReferentialRelationsFilterArgsDict']]]]] = None,
                                                          is_sensitive: Optional[pulumi.Input[Optional[bool]]] = None,
                                                          objects: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                          relation_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                          schema_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                          sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensitiveDataModelReferentialRelationsResult]:
    """
    This data source provides the list of Sensitive Data Model Referential Relations in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of referential relations present in the specified sensitive data model based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sensitive_data_model_referential_relations = oci.DataSafe.get_sensitive_data_model_referential_relations(sensitive_data_model_id=test_sensitive_data_model["id"],
        column_names=sensitive_data_model_referential_relation_column_name,
        is_sensitive=sensitive_data_model_referential_relation_is_sensitive,
        objects=sensitive_data_model_referential_relation_object,
        relation_types=sensitive_data_model_referential_relation_relation_type,
        schema_names=sensitive_data_model_referential_relation_schema_name)
    ```


    :param Sequence[str] column_names: A filter to return only a specific column based on column name.
    :param bool is_sensitive: Returns referential relations containing sensitive columns when true. Returns referential relations containing non sensitive columns when false.
    :param Sequence[str] objects: A filter to return only items related to a specific object name.
    :param Sequence[str] relation_types: A filter to return sensitive columns based on their relationship with their parent columns. If set to NONE, it returns the sensitive columns that do not have any parent. The response includes the parent columns as well as the independent columns that are not in any relationship. If set to APP_DEFINED, it returns all the child columns that have application-level (non-dictionary) relationship with their parents. If set to DB_DEFINED, it returns all the child columns that have database-level (dictionary-defined) relationship with their parents.
    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    :param str sensitive_data_model_id: The OCID of the sensitive data model.
    """
    __args__ = dict()
    __args__['columnNames'] = column_names
    __args__['filters'] = filters
    __args__['isSensitive'] = is_sensitive
    __args__['objects'] = objects
    __args__['relationTypes'] = relation_types
    __args__['schemaNames'] = schema_names
    __args__['sensitiveDataModelId'] = sensitive_data_model_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSensitiveDataModelReferentialRelations:getSensitiveDataModelReferentialRelations', __args__, opts=opts, typ=GetSensitiveDataModelReferentialRelationsResult)
    return __ret__.apply(lambda __response__: GetSensitiveDataModelReferentialRelationsResult(
        column_names=pulumi.get(__response__, 'column_names'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_sensitive=pulumi.get(__response__, 'is_sensitive'),
        objects=pulumi.get(__response__, 'objects'),
        referential_relation_collections=pulumi.get(__response__, 'referential_relation_collections'),
        relation_types=pulumi.get(__response__, 'relation_types'),
        schema_names=pulumi.get(__response__, 'schema_names'),
        sensitive_data_model_id=pulumi.get(__response__, 'sensitive_data_model_id')))
