# generated by datamodel-codegen:
#   filename:  api/data/createGlossary.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReferenceList, tagLabel


class CreateGlossaryRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this glossary.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this glossary.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the glossary instance.')
    ]
    reviewers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='User references of the reviewers for this glossary.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this glossary'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this glossary'),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            'false',
            description='Glossary terms that are direct children in this glossary are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the Glossary belongs to.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
