# generated by datamodel-codegen:
#   filename:  api/domains/createDataProduct.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityReferenceList, tagLabel


class CreateDataProductRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='A unique name of the DataProduct')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName of the Domain.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'Customer Churn', 'Sentiment Analysis', etc.",
        ),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the DataProduct.')
    ]
    style: Optional[basic.Style] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this DataProduct.'),
    ]
    domain: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Fully qualified name of the Domain the DataProduct belongs to.'
        ),
    ]
    experts: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of user/login names of users who are experts in this DataProduct.',
        ),
    ]
    assets: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Data assets collection that is part of this data product.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Data Product.'),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
