# generated by datamodel-codegen:
#   filename:  api/services/createMetadataService.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import metadataService
from ...type import basic, entityReferenceList, tagLabel


class CreateMetadataServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Metadata service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of Metadata entity.'),
    ]
    serviceType: metadataService.MetadataServiceType
    connection: Optional[metadataService.MetadataConnection] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Metadata service.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Metadata Service.'),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
