# generated by datamodel-codegen:
#   filename:  configuration/authorizerConfiguration.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class AuthorizerConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    className: Annotated[str, Field(description='Class Name for authorizer.')]
    containerRequestFilter: Annotated[
        str, Field(description='Filter for the request authorization.')
    ]
    adminPrincipals: Annotated[
        List[str], Field(description='List of unique admin principals.')
    ]
    botPrincipals: Annotated[
        Optional[List[str]],
        Field(None, description='**@Deprecated** List of unique bot principals'),
    ]
    testPrincipals: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of unique principals used as test users. **NOTE THIS IS ONLY FOR TEST SETUP AND NOT TO BE USED IN PRODUCTION SETUP**',
        ),
    ]
    allowedEmailRegistrationDomains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='List of unique email domains that are allowed to signup on the platforms',
        ),
    ]
    principalDomain: Annotated[str, Field(description='Principal Domain')]
    enforcePrincipalDomain: Annotated[
        bool, Field(description='Enable Enforce Principal Domain')
    ]
    enableSecureSocketConnection: Annotated[
        bool, Field(description='Enable Secure Socket Connection.')
    ]
    useRolesFromProvider: Annotated[
        Optional[bool], Field(False, description='Use Roles from Provider')
    ]
