# generated by datamodel-codegen:
#   filename:  configuration/kafkaEventConfiguration.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'
    SSL = 'SSL'


class KafkaEventConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    topics: Annotated[List[str], Field(description='Topics of Kafka Producer')]
    acks: Annotated[Optional[str], Field('all', description='Acknowledgment')]
    retries: Annotated[Optional[int], Field(3, description='No. of retries')]
    lingerMS: Annotated[
        Optional[int], Field(1, description='Artificial Delay in milliseconds')
    ]
    bufferMemory: Annotated[Optional[int], Field(33554432, description='Buffer Memory')]
    keySerializer: Annotated[
        Optional[str],
        Field(
            'org.apache.kafka.common.serialization.StringSerializer',
            description='Serializer class for key',
        ),
    ]
    valueSerializer: Annotated[
        Optional[str],
        Field(
            'org.apache.kafka.common.serialization.StringSerializer',
            description='Serializer class for value',
        ),
    ]
    securityProtocol: Annotated[
        Optional[SecurityProtocol],
        Field(SecurityProtocol.PLAINTEXT, description='Kafka security protocol config'),
    ]
    SSLProtocol: Annotated[
        Optional[str], Field('TLSv1.2', description='Kafka SSL protocol config')
    ]
    SSLTrustStoreLocation: Annotated[
        Optional[str], Field(None, description='Kafka SSL truststore location')
    ]
    SSLTrustStorePassword: Annotated[
        Optional[str], Field(None, description='Kafka SSL truststore password')
    ]
    SSLKeystoreLocation: Annotated[
        Optional[str], Field(None, description='Kafka SSL keystore location')
    ]
    SSLKeystorePassword: Annotated[
        Optional[str], Field(None, description='Kafka SSL keystore password')
    ]
    SSLKeyPassword: Annotated[
        Optional[str], Field(None, description='Kafka SSL key password')
    ]
