# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/automator/removeTagsAction.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......type import basic, tagLabel


class RemoveTagsActionType(Enum):
    RemoveTagsAction = 'RemoveTagsAction'


class LabelType(Enum):
    Manual = 'Manual'
    Propagated = 'Propagated'
    Automated = 'Automated'


class RemoveTagsAction(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        RemoveTagsActionType,
        Field(description='Application Type', title='Application Type'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]], Field(None, description='Tags to remove')
    ]
    labels: Annotated[
        Optional[List[LabelType]],
        Field(None, description='Remove tags by its label type'),
    ]
    applyToChildren: Annotated[
        Optional[List[basic.EntityName]],
        Field(
            None,
            description='Remove tags from the children of the selected assets. E.g., columns, tasks, topic fields,...',
            title='Apply to Children',
        ),
    ]
    applyToAll: Annotated[
        Optional[bool],
        Field(
            None,
            description='Remove tags from all the children and parent of the selected assets.',
            title='Apply to All',
        ),
    ]
