# generated by datamodel-codegen:
#   filename:  entity/data/glossaryTerm.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    tagLabel,
    votes,
)


class TermReference(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        Optional[str],
        Field(
            None,
            description='Name that identifies the source of an external glossary term. Example `HealthCare.gov`.',
        ),
    ]
    endpoint: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Name that identifies the source of an external glossary term. Example `HealthCare.gov`.',
        ),
    ]


class Status(Enum):
    Draft = 'Draft'
    In_Review = 'In Review'
    Approved = 'Approved'
    Deprecated = 'Deprecated'
    Rejected = 'Rejected'


class GlossaryTerm(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of a glossary term instance.')
    ]
    name: Annotated[
        basic.EntityName, Field(description='Preferred name for the glossary term.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this glossary.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the glossary term.')
    ]
    style: Optional[basic.Style] = None
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='A unique name that identifies a glossary term. It captures name hierarchy of glossary of terms in the form of `glossaryName.parentTerm.childTerm`.',
        ),
    ]
    synonyms: Annotated[
        Optional[List[basic.EntityName]],
        Field(
            None,
            description='Alternate names that are synonyms or near-synonyms for the glossary term.',
        ),
    ]
    glossary: Annotated[
        entityReference.EntityReference,
        Field(description='Glossary that this term belongs to.'),
    ]
    parent: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Parent glossary term that this term is child of. When `null` this term is the root term of the glossary.',
        ),
    ]
    children: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Other glossary terms that are children of this glossary term.',
        ),
    ]
    relatedTerms: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Other glossary terms that are related to this glossary term.',
        ),
    ]
    references: Annotated[
        Optional[List[TermReference]],
        Field(None, description='Link to a reference from an external glossary.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    reviewers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='User names of the reviewers for this glossary.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this glossary term.'),
    ]
    usageCount: Annotated[
        Optional[int],
        Field(
            None,
            description="Count of how many times this and it's children glossary terms are used as labels.",
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(
            [],
            description="Tags associated with this glossary term. These tags captures relationship of a glossary term with a tag automatically. As an example a glossary term 'User.PhoneNumber' might have an associated tag 'PII.Sensitive'. When 'User.Address' is used to label a column in a table, 'PII.Sensitive' label is also applied automatically due to Associated tag relationship.",
        ),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    status: Annotated[
        Optional[Status], Field(None, description='Status of the glossary term.')
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Annotated[
        Optional[bool],
        Field(
            None,
            description="System glossary can't be deleted. Use this flag to disable them.",
        ),
    ]
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            'false',
            description='Glossary terms that are children of this term are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity from this group. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the Glossary Term belongs to. When not set, the Glossary TErm inherits the domain from the Glossary it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    childrenCount: Annotated[
        Optional[int],
        Field(None, description='Count of immediate children glossary terms.'),
    ]
