# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/microStrategyConnection.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class MicroStrategyType(Enum):
    MicroStrategy = 'MicroStrategy'


class MicroStrategyConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MicroStrategyType],
        Field(
            MicroStrategyType.MicroStrategy,
            description='Service Type',
            title='Service Type',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to MicroStrategy. This user should have privileges to read all the metadata in MicroStrategy.',
            title='Username',
        ),
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='Password to connect to MicroStrategy.', title='Password'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Host and Port of the MicroStrategy instance.',
            title='Host and Port',
        ),
    ]
    projectName: Annotated[
        Optional[str],
        Field(None, description='MicroStrategy Project Name', title='Project Name'),
    ]
    loginMode: Annotated[
        Optional[str],
        Field(
            '1',
            description="Login Mode for Microstrategy's REST API connection. You can authenticate with one of the following authentication modes: `Standard (1)`, `Anonymous (8)`. Default will be `Standard (1)`. If you're using demo account for Microstrategy, it will be needed to authenticate through loginMode `8`.",
            title='Login Mode',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
