# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/powerBIReportServerConnection.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class PowerBIReportServerType(Enum):
    PowerBIReportServer = 'PowerBIReportServer'


class PowerBIReportServerConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[PowerBIReportServerType],
        Field(
            PowerBIReportServerType.PowerBIReportServer,
            description='Service Type',
            title='Service Type',
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Dashboard URL for PowerBI Report Server.',
            title='Host and Port',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to PowerBI report server.',
            title='Username',
        ),
    ]
    password: Annotated[
        CustomSecretStr,
        Field(
            description='Password to connect to PowerBI report server.',
            title='Password',
        ),
    ]
    webPortalVirtualDirectory: Annotated[
        Optional[str],
        Field(
            'Reports',
            description='Web Portal Virtual Directory Name.',
            title='Web Portal Virtual Directory Name',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
