# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/bigTableConnection.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import gcpCredentials
from .. import connectionBasicType


class BigtableType(Enum):
    BigTable = 'BigTable'


class BigTableConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[BigtableType],
        Field(BigtableType.BigTable, description='Service Type', title='Service Type'),
    ]
    credentials: Annotated[
        gcpCredentials.GCPCredentials,
        Field(description='GCP Credentials', title='GCP Credentials'),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
