# generated by datamodel-codegen:
#   filename:  entity/services/connections/testConnectionResult.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....type import basic


class TestConnectionStepResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[str, Field(description='Name of the step being tested')]
    mandatory: Annotated[
        bool, Field(description='Is this step mandatory to be passed?')
    ]
    passed: Annotated[bool, Field(description='Did the step pass successfully?')]
    message: Annotated[
        Optional[str],
        Field(
            None,
            description='Results or exceptions to be shared after running the test. This message comes from the test connection definition',
        ),
    ]
    errorLog: Annotated[
        Optional[str],
        Field(
            None,
            description='In case of failed step, this field would contain the actual error faced during the step.',
        ),
    ]


class StatusType(Enum):
    Successful = 'Successful'
    Failed = 'Failed'
    Running = 'Running'


class TestConnectionResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    lastUpdatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Last time that the test connection was executed'),
    ]
    status: Annotated[
        Optional[StatusType],
        Field(None, description='Test Connection Result computation status.'),
    ]
    steps: Annotated[
        List[TestConnectionStepResult],
        Field(description='Steps to test the connection. Order matters.'),
    ]
