# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtconfig/dbtGCSConfig.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...security.credentials import gcpCredentials


class DbtConfigType(Enum):
    gcs = 'gcs'


class DbtPrefixConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbtBucketName: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the bucket where the dbt files are stored',
            title='DBT Bucket Name',
        ),
    ]
    dbtObjectPrefix: Annotated[
        Optional[str],
        Field(
            None,
            description='Path of the folder where the dbt files are stored',
            title='DBT Object Prefix',
        ),
    ]


class DbtGcsConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbtConfigType: Annotated[DbtConfigType, Field(description='dbt Configuration type')]
    dbtSecurityConfig: Annotated[
        gcpCredentials.GCPCredentials, Field(title='DBT GCS Security Config')
    ]
    dbtPrefixConfig: Annotated[
        Optional[DbtPrefixConfig],
        Field(
            None,
            description='Details of the bucket where the dbt files are stored',
            title='DBT Prefix Config',
        ),
    ]
