# generated by datamodel-codegen:
#   filename:  type/schema.json
#   timestamp: 2025-04-08T13:18:29+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic, tagLabel


class SchemaType(Enum):
    Avro = 'Avro'
    Protobuf = 'Protobuf'
    JSON = 'JSON'
    Other = 'Other'
    None_ = 'None'


class DataTypeTopic(Enum):
    RECORD = 'RECORD'
    NULL = 'NULL'
    BOOLEAN = 'BOOLEAN'
    INT = 'INT'
    LONG = 'LONG'
    BYTES = 'BYTES'
    FLOAT = 'FLOAT'
    DOUBLE = 'DOUBLE'
    TIMESTAMP = 'TIMESTAMP'
    TIMESTAMPZ = 'TIMESTAMPZ'
    TIME = 'TIME'
    DATE = 'DATE'
    STRING = 'STRING'
    ARRAY = 'ARRAY'
    MAP = 'MAP'
    ENUM = 'ENUM'
    UNION = 'UNION'
    FIXED = 'FIXED'
    ERROR = 'ERROR'
    UNKNOWN = 'UNKNOWN'


class FieldName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Local name (not fully qualified name) of the field. ',
            max_length=128,
            min_length=1,
        ),
    ]


class FieldModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: FieldName
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this field name.'),
    ]
    dataType: Annotated[
        DataTypeTopic, Field(description='Data type of the field (int, date etc.).')
    ]
    dataTypeDisplay: Annotated[
        Optional[str],
        Field(
            None,
            description='Display name used for dataType. This is useful for complex types, such as `array<int>`, `map<int,string>`, `struct<>`, and union types.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the column.')
    ]
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with the column.'),
    ]
    children: Annotated[
        Optional[List[FieldModel]],
        Field(
            None,
            description='Child fields if dataType or arrayDataType is `map`, `record`, `message`',
        ),
    ]


class Topic(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    schemaText: Annotated[
        Optional[str],
        Field(
            None,
            description='Schema used for message serialization. Optional as some topics may not have associated schemas.',
        ),
    ]
    schemaType: Annotated[
        Optional[SchemaType],
        Field(SchemaType.None_, description='Schema used for message serialization.'),
    ]
    schemaFields: Annotated[
        Optional[List[FieldModel]], Field([], description='Columns in this schema.')
    ]


FieldModel.model_rebuild()
