# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOneoffPatchesResult',
    'AwaitableGetOneoffPatchesResult',
    'get_oneoff_patches',
    'get_oneoff_patches_output',
]

@pulumi.output_type
class GetOneoffPatchesResult:
    """
    A collection of values returned by getOneoffPatches.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, oneoff_patches=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if oneoff_patches and not isinstance(oneoff_patches, list):
            raise TypeError("Expected argument 'oneoff_patches' to be a list")
        pulumi.set(__self__, "oneoff_patches", oneoff_patches)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        One-off patch name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOneoffPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="oneoffPatches")
    def oneoff_patches(self) -> Sequence['outputs.GetOneoffPatchesOneoffPatchResult']:
        """
        The list of oneoff_patches.
        """
        return pulumi.get(self, "oneoff_patches")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the one-off patch.
        """
        return pulumi.get(self, "state")


class AwaitableGetOneoffPatchesResult(GetOneoffPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOneoffPatchesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            oneoff_patches=self.oneoff_patches,
            state=self.state)


def get_oneoff_patches(compartment_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[pulumi.InputType['GetOneoffPatchesFilterArgs']]] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOneoffPatchesResult:
    """
    This data source provides the list of Oneoff Patches in Oracle Cloud Infrastructure Database service.

    Lists one-off patches in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oneoff_patches = oci.Database.get_oneoff_patches(compartment_id=compartment_id,
        display_name=oneoff_patch_display_name,
        state=oneoff_patch_state)
    ```


    :param str compartment_id: (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getOneoffPatches:getOneoffPatches', __args__, opts=opts, typ=GetOneoffPatchesResult).value

    return AwaitableGetOneoffPatchesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        oneoff_patches=pulumi.get(__ret__, 'oneoff_patches'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_oneoff_patches)
def get_oneoff_patches_output(compartment_id: Optional[pulumi.Input[str]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOneoffPatchesFilterArgs']]]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOneoffPatchesResult]:
    """
    This data source provides the list of Oneoff Patches in Oracle Cloud Infrastructure Database service.

    Lists one-off patches in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oneoff_patches = oci.Database.get_oneoff_patches(compartment_id=compartment_id,
        display_name=oneoff_patch_display_name,
        state=oneoff_patch_state)
    ```


    :param str compartment_id: (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly
    """
    ...
