# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetWorkspaceResult',
    'AwaitableGetWorkspaceResult',
    'get_workspace',
    'get_workspace_output',
]

@pulumi.output_type
class GetWorkspaceResult:
    """
    A collection of values returned by getWorkspace.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, dns_server_ip=None, dns_server_zone=None, endpoint_compartment_id=None, endpoint_id=None, endpoint_name=None, freeform_tags=None, id=None, is_force_operation=None, is_private_network_enabled=None, quiesce_timeout=None, registry_compartment_id=None, registry_id=None, registry_name=None, state=None, state_message=None, subnet_id=None, time_created=None, time_updated=None, vcn_id=None, workspace_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dns_server_ip and not isinstance(dns_server_ip, str):
            raise TypeError("Expected argument 'dns_server_ip' to be a str")
        pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if dns_server_zone and not isinstance(dns_server_zone, str):
            raise TypeError("Expected argument 'dns_server_zone' to be a str")
        pulumi.set(__self__, "dns_server_zone", dns_server_zone)
        if endpoint_compartment_id and not isinstance(endpoint_compartment_id, str):
            raise TypeError("Expected argument 'endpoint_compartment_id' to be a str")
        pulumi.set(__self__, "endpoint_compartment_id", endpoint_compartment_id)
        if endpoint_id and not isinstance(endpoint_id, str):
            raise TypeError("Expected argument 'endpoint_id' to be a str")
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_name and not isinstance(endpoint_name, str):
            raise TypeError("Expected argument 'endpoint_name' to be a str")
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_force_operation and not isinstance(is_force_operation, bool):
            raise TypeError("Expected argument 'is_force_operation' to be a bool")
        pulumi.set(__self__, "is_force_operation", is_force_operation)
        if is_private_network_enabled and not isinstance(is_private_network_enabled, bool):
            raise TypeError("Expected argument 'is_private_network_enabled' to be a bool")
        pulumi.set(__self__, "is_private_network_enabled", is_private_network_enabled)
        if quiesce_timeout and not isinstance(quiesce_timeout, int):
            raise TypeError("Expected argument 'quiesce_timeout' to be a int")
        pulumi.set(__self__, "quiesce_timeout", quiesce_timeout)
        if registry_compartment_id and not isinstance(registry_compartment_id, str):
            raise TypeError("Expected argument 'registry_compartment_id' to be a str")
        pulumi.set(__self__, "registry_compartment_id", registry_compartment_id)
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if registry_name and not isinstance(registry_name, str):
            raise TypeError("Expected argument 'registry_name' to be a str")
        pulumi.set(__self__, "registry_name", registry_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the workspace.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user defined description for the workspace.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly display name for the workspace. Does not have to be unique, and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> str:
        """
        The IP of the custom DNS.
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="dnsServerZone")
    def dns_server_zone(self) -> str:
        """
        The DNS zone of the custom DNS to use to resolve names.
        """
        return pulumi.get(self, "dns_server_zone")

    @property
    @pulumi.getter(name="endpointCompartmentId")
    def endpoint_compartment_id(self) -> str:
        return pulumi.get(self, "endpoint_compartment_id")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        """
        DCMS endpoint associated with the container/workspace. Returns null if there is none.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        Name of the private endpoint associated with the container/workspace. Returns null if there is none.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A system-generated and immutable identifier assigned to the workspace upon creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isForceOperation")
    def is_force_operation(self) -> bool:
        return pulumi.get(self, "is_force_operation")

    @property
    @pulumi.getter(name="isPrivateNetworkEnabled")
    def is_private_network_enabled(self) -> bool:
        """
        Specifies whether the private network connection is enabled or disabled.
        """
        return pulumi.get(self, "is_private_network_enabled")

    @property
    @pulumi.getter(name="quiesceTimeout")
    def quiesce_timeout(self) -> int:
        return pulumi.get(self, "quiesce_timeout")

    @property
    @pulumi.getter(name="registryCompartmentId")
    def registry_compartment_id(self) -> str:
        return pulumi.get(self, "registry_compartment_id")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> str:
        """
        DCMS registry associated with the container/workspace. Returns null if there is none.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> str:
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle states for workspaces in Data Integration Service CREATING - The resource is being created and may not be usable until the entire metadata is defined UPDATING - The resource is being updated and may not be usable until all changes are commited DELETING - The resource is being deleted and might require deep cleanup of children. ACTIVE   - The resource is valid and available for access INACTIVE - The resource might be incomplete in its definition or might have been made unavailable for administrative reasons DELETED  - The resource has been deleted and isn't available FAILED   - The resource is in a failed state due to validation or other errors STARTING - The resource is being started and may not be usable until becomes ACTIVE again STOPPING - The resource is in the process of Stopping and may not be usable until it Stops or fails STOPPED  - The resource is in Stopped state due to stop operation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet for customer connected databases.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the workspace was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the workspace was updated, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN the subnet is in.
        """
        return pulumi.get(self, "vcn_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceResult(GetWorkspaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            dns_server_ip=self.dns_server_ip,
            dns_server_zone=self.dns_server_zone,
            endpoint_compartment_id=self.endpoint_compartment_id,
            endpoint_id=self.endpoint_id,
            endpoint_name=self.endpoint_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_force_operation=self.is_force_operation,
            is_private_network_enabled=self.is_private_network_enabled,
            quiesce_timeout=self.quiesce_timeout,
            registry_compartment_id=self.registry_compartment_id,
            registry_id=self.registry_id,
            registry_name=self.registry_name,
            state=self.state,
            state_message=self.state_message,
            subnet_id=self.subnet_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vcn_id=self.vcn_id,
            workspace_id=self.workspace_id)


def get_workspace(workspace_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceResult:
    """
    This data source provides details about a specific Workspace resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a Data Integration workspace using the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace = oci.DataIntegration.get_workspace(workspace_id=test_workspace_oci_dataintegration_workspace["id"])
    ```


    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspace:getWorkspace', __args__, opts=opts, typ=GetWorkspaceResult).value

    return AwaitableGetWorkspaceResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dns_server_ip=pulumi.get(__ret__, 'dns_server_ip'),
        dns_server_zone=pulumi.get(__ret__, 'dns_server_zone'),
        endpoint_compartment_id=pulumi.get(__ret__, 'endpoint_compartment_id'),
        endpoint_id=pulumi.get(__ret__, 'endpoint_id'),
        endpoint_name=pulumi.get(__ret__, 'endpoint_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_force_operation=pulumi.get(__ret__, 'is_force_operation'),
        is_private_network_enabled=pulumi.get(__ret__, 'is_private_network_enabled'),
        quiesce_timeout=pulumi.get(__ret__, 'quiesce_timeout'),
        registry_compartment_id=pulumi.get(__ret__, 'registry_compartment_id'),
        registry_id=pulumi.get(__ret__, 'registry_id'),
        registry_name=pulumi.get(__ret__, 'registry_name'),
        state=pulumi.get(__ret__, 'state'),
        state_message=pulumi.get(__ret__, 'state_message'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))


@_utilities.lift_output_func(get_workspace)
def get_workspace_output(workspace_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkspaceResult]:
    """
    This data source provides details about a specific Workspace resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a Data Integration workspace using the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace = oci.DataIntegration.get_workspace(workspace_id=test_workspace_oci_dataintegration_workspace["id"])
    ```


    :param str workspace_id: The workspace ID.
    """
    ...
