# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabaseToolsPrivateEndpointsResult',
    'AwaitableGetDatabaseToolsPrivateEndpointsResult',
    'get_database_tools_private_endpoints',
    'get_database_tools_private_endpoints_output',
]

@pulumi.output_type
class GetDatabaseToolsPrivateEndpointsResult:
    """
    A collection of values returned by getDatabaseToolsPrivateEndpoints.
    """
    def __init__(__self__, compartment_id=None, database_tools_private_endpoint_collections=None, display_name=None, endpoint_service_id=None, filters=None, id=None, state=None, subnet_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_tools_private_endpoint_collections and not isinstance(database_tools_private_endpoint_collections, list):
            raise TypeError("Expected argument 'database_tools_private_endpoint_collections' to be a list")
        pulumi.set(__self__, "database_tools_private_endpoint_collections", database_tools_private_endpoint_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoint_service_id and not isinstance(endpoint_service_id, str):
            raise TypeError("Expected argument 'endpoint_service_id' to be a str")
        pulumi.set(__self__, "endpoint_service_id", endpoint_service_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools private endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseToolsPrivateEndpointCollections")
    def database_tools_private_endpoint_collections(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointsDatabaseToolsPrivateEndpointCollectionResult']:
        """
        The list of database_tools_private_endpoint_collection.
        """
        return pulumi.get(self, "database_tools_private_endpoint_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointServiceId")
    def endpoint_service_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools Endpoint Service.
        """
        return pulumi.get(self, "endpoint_service_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabaseToolsPrivateEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Database Tools private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        """
        return pulumi.get(self, "subnet_id")


class AwaitableGetDatabaseToolsPrivateEndpointsResult(GetDatabaseToolsPrivateEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseToolsPrivateEndpointsResult(
            compartment_id=self.compartment_id,
            database_tools_private_endpoint_collections=self.database_tools_private_endpoint_collections,
            display_name=self.display_name,
            endpoint_service_id=self.endpoint_service_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            subnet_id=self.subnet_id)


def get_database_tools_private_endpoints(compartment_id: Optional[str] = None,
                                         display_name: Optional[str] = None,
                                         endpoint_service_id: Optional[str] = None,
                                         filters: Optional[Sequence[pulumi.InputType['GetDatabaseToolsPrivateEndpointsFilterArgs']]] = None,
                                         state: Optional[str] = None,
                                         subnet_id: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseToolsPrivateEndpointsResult:
    """
    This data source provides the list of Database Tools Private Endpoints in Oracle Cloud Infrastructure Database Tools service.

    Returns a list of Database Tools private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_private_endpoints = oci.DatabaseTools.get_database_tools_private_endpoints(compartment_id=compartment_id,
        display_name=database_tools_private_endpoint_display_name,
        endpoint_service_id=test_service["id"],
        state=database_tools_private_endpoint_state,
        subnet_id=test_subnet["id"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire specified display name.
    :param str endpoint_service_id: A filter to return only resources their `endpointServiceId` matches the specified `endpointServiceId`.
    :param str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
    :param str subnet_id: A filter to return only resources their `subnetId` matches the specified `subnetId`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['endpointServiceId'] = endpoint_service_id
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['subnetId'] = subnet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseTools/getDatabaseToolsPrivateEndpoints:getDatabaseToolsPrivateEndpoints', __args__, opts=opts, typ=GetDatabaseToolsPrivateEndpointsResult).value

    return AwaitableGetDatabaseToolsPrivateEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_tools_private_endpoint_collections=pulumi.get(__ret__, 'database_tools_private_endpoint_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoint_service_id=pulumi.get(__ret__, 'endpoint_service_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'))


@_utilities.lift_output_func(get_database_tools_private_endpoints)
def get_database_tools_private_endpoints_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                endpoint_service_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDatabaseToolsPrivateEndpointsFilterArgs']]]]] = None,
                                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                                subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseToolsPrivateEndpointsResult]:
    """
    This data source provides the list of Database Tools Private Endpoints in Oracle Cloud Infrastructure Database Tools service.

    Returns a list of Database Tools private endpoints.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_private_endpoints = oci.DatabaseTools.get_database_tools_private_endpoints(compartment_id=compartment_id,
        display_name=database_tools_private_endpoint_display_name,
        endpoint_service_id=test_service["id"],
        state=database_tools_private_endpoint_state,
        subnet_id=test_subnet["id"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire specified display name.
    :param str endpoint_service_id: A filter to return only resources their `endpointServiceId` matches the specified `endpointServiceId`.
    :param str state: A filter to return only resources their `lifecycleState` matches the specified `lifecycleState`.
    :param str subnet_id: A filter to return only resources their `subnetId` matches the specified `subnetId`.
    """
    ...
