# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AuditTrailArgs', 'AuditTrail']

@pulumi.input_type
class AuditTrailArgs:
    def __init__(__self__, *,
                 audit_trail_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[bool]] = None,
                 resume_trigger: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuditTrail resource.
        :param pulumi.Input[str] audit_trail_id: The OCID of the audit trail.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[int] resume_trigger: (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        """
        pulumi.set(__self__, "audit_trail_id", audit_trail_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_purge_enabled is not None:
            pulumi.set(__self__, "is_auto_purge_enabled", is_auto_purge_enabled)
        if resume_trigger is not None:
            pulumi.set(__self__, "resume_trigger", resume_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="auditTrailId")
    def audit_trail_id(self) -> pulumi.Input[str]:
        """
        The OCID of the audit trail.
        """
        return pulumi.get(self, "audit_trail_id")

    @audit_trail_id.setter
    def audit_trail_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "audit_trail_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @is_auto_purge_enabled.setter
    def is_auto_purge_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_purge_enabled", value)

    @property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resume_trigger")

    @resume_trigger.setter
    def resume_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resume_trigger", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _AuditTrailState:
    def __init__(__self__, *,
                 audit_collection_start_time: Optional[pulumi.Input[str]] = None,
                 audit_profile_id: Optional[pulumi.Input[str]] = None,
                 audit_trail_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 peer_target_database_key: Optional[pulumi.Input[int]] = None,
                 purge_job_details: Optional[pulumi.Input[str]] = None,
                 purge_job_status: Optional[pulumi.Input[str]] = None,
                 purge_job_time: Optional[pulumi.Input[str]] = None,
                 resume_trigger: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_collected: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 trail_location: Optional[pulumi.Input[str]] = None,
                 trail_source: Optional[pulumi.Input[str]] = None,
                 work_request_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuditTrail resources.
        :param pulumi.Input[str] audit_collection_start_time: The date from which the audit trail must start collecting data, in the format defined by RFC3339.
        :param pulumi.Input[str] audit_profile_id: The OCID of the  parent audit.
        :param pulumi.Input[str] audit_trail_id: The OCID of the audit trail.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the audit trail and is the same as the compartment of the audit profile resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the audit trail in Data Safe.
        :param pulumi.Input[int] peer_target_database_key: The secondary id assigned for the peer database registered with Data Safe.
        :param pulumi.Input[str] purge_job_details: The details of the audit trail purge job that ran on the "purgeJobTime".
        :param pulumi.Input[str] purge_job_status: The current status of the audit trail purge job.
        :param pulumi.Input[str] purge_job_time: The date and time of the last purge job, which deletes audit data in the target database every seven days so that the database's audit trail does not become too large. In the format defined by RFC3339.
        :param pulumi.Input[int] resume_trigger: (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[str] status: The current sub-state of the audit trail.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the Data Safe target for which the audit trail is created.
        :param pulumi.Input[str] time_created: The date and time the audit trail was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_collected: The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the audit trail was updated, in the format defined by RFC3339.
        :param pulumi.Input[str] trail_location: An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        :param pulumi.Input[str] trail_source: The underlying source of unified audit trail.
        :param pulumi.Input[str] work_request_id: The OCID of the workrequest for audit trail which collects audit records.
        """
        if audit_collection_start_time is not None:
            pulumi.set(__self__, "audit_collection_start_time", audit_collection_start_time)
        if audit_profile_id is not None:
            pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if audit_trail_id is not None:
            pulumi.set(__self__, "audit_trail_id", audit_trail_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_purge_enabled is not None:
            pulumi.set(__self__, "is_auto_purge_enabled", is_auto_purge_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if peer_target_database_key is not None:
            pulumi.set(__self__, "peer_target_database_key", peer_target_database_key)
        if purge_job_details is not None:
            pulumi.set(__self__, "purge_job_details", purge_job_details)
        if purge_job_status is not None:
            pulumi.set(__self__, "purge_job_status", purge_job_status)
        if purge_job_time is not None:
            pulumi.set(__self__, "purge_job_time", purge_job_time)
        if resume_trigger is not None:
            pulumi.set(__self__, "resume_trigger", resume_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_collected is not None:
            pulumi.set(__self__, "time_last_collected", time_last_collected)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trail_location is not None:
            pulumi.set(__self__, "trail_location", trail_location)
        if trail_source is not None:
            pulumi.set(__self__, "trail_source", trail_source)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date from which the audit trail must start collecting data, in the format defined by RFC3339.
        """
        return pulumi.get(self, "audit_collection_start_time")

    @audit_collection_start_time.setter
    def audit_collection_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_collection_start_time", value)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @audit_profile_id.setter
    def audit_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_profile_id", value)

    @property
    @pulumi.getter(name="auditTrailId")
    def audit_trail_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the audit trail.
        """
        return pulumi.get(self, "audit_trail_id")

    @audit_trail_id.setter
    def audit_trail_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_trail_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that contains the audit trail and is the same as the compartment of the audit profile resource.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @is_auto_purge_enabled.setter
    def is_auto_purge_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_purge_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the audit trail in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="peerTargetDatabaseKey")
    def peer_target_database_key(self) -> Optional[pulumi.Input[int]]:
        """
        The secondary id assigned for the peer database registered with Data Safe.
        """
        return pulumi.get(self, "peer_target_database_key")

    @peer_target_database_key.setter
    def peer_target_database_key(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_target_database_key", value)

    @property
    @pulumi.getter(name="purgeJobDetails")
    def purge_job_details(self) -> Optional[pulumi.Input[str]]:
        """
        The details of the audit trail purge job that ran on the "purgeJobTime".
        """
        return pulumi.get(self, "purge_job_details")

    @purge_job_details.setter
    def purge_job_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purge_job_details", value)

    @property
    @pulumi.getter(name="purgeJobStatus")
    def purge_job_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the audit trail purge job.
        """
        return pulumi.get(self, "purge_job_status")

    @purge_job_status.setter
    def purge_job_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purge_job_status", value)

    @property
    @pulumi.getter(name="purgeJobTime")
    def purge_job_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last purge job, which deletes audit data in the target database every seven days so that the database's audit trail does not become too large. In the format defined by RFC3339.
        """
        return pulumi.get(self, "purge_job_time")

    @purge_job_time.setter
    def purge_job_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purge_job_time", value)

    @property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resume_trigger")

    @resume_trigger.setter
    def resume_trigger(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resume_trigger", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current sub-state of the audit trail.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Data Safe target for which the audit trail is created.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the audit trail was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastCollected")
    def time_last_collected(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_collected")

    @time_last_collected.setter
    def time_last_collected(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_collected", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the audit trail was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> Optional[pulumi.Input[str]]:
        """
        An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        return pulumi.get(self, "trail_location")

    @trail_location.setter
    def trail_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trail_location", value)

    @property
    @pulumi.getter(name="trailSource")
    def trail_source(self) -> Optional[pulumi.Input[str]]:
        """
        The underlying source of unified audit trail.
        """
        return pulumi.get(self, "trail_source")

    @trail_source.setter
    def trail_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trail_source", value)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the workrequest for audit trail which collects audit records.
        """
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "work_request_id", value)


class AuditTrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_trail_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[bool]] = None,
                 resume_trigger: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Audit Trail resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit trail.

        ## Import

        AuditTrails can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditTrail:AuditTrail test_audit_trail "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_trail_id: The OCID of the audit trail.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[int] resume_trigger: (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditTrailArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Audit Trail resource in Oracle Cloud Infrastructure Data Safe service.

        Updates one or more attributes of the specified audit trail.

        ## Import

        AuditTrails can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditTrail:AuditTrail test_audit_trail "id"
        ```

        :param str resource_name: The name of the resource.
        :param AuditTrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditTrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_trail_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_purge_enabled: Optional[pulumi.Input[bool]] = None,
                 resume_trigger: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditTrailArgs.__new__(AuditTrailArgs)

            if audit_trail_id is None and not opts.urn:
                raise TypeError("Missing required property 'audit_trail_id'")
            __props__.__dict__["audit_trail_id"] = audit_trail_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_purge_enabled"] = is_auto_purge_enabled
            __props__.__dict__["resume_trigger"] = resume_trigger
            __props__.__dict__["state"] = state
            __props__.__dict__["audit_collection_start_time"] = None
            __props__.__dict__["audit_profile_id"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["peer_target_database_key"] = None
            __props__.__dict__["purge_job_details"] = None
            __props__.__dict__["purge_job_status"] = None
            __props__.__dict__["purge_job_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_collected"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["trail_location"] = None
            __props__.__dict__["trail_source"] = None
            __props__.__dict__["work_request_id"] = None
        super(AuditTrail, __self__).__init__(
            'oci:DataSafe/auditTrail:AuditTrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_collection_start_time: Optional[pulumi.Input[str]] = None,
            audit_profile_id: Optional[pulumi.Input[str]] = None,
            audit_trail_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_auto_purge_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            peer_target_database_key: Optional[pulumi.Input[int]] = None,
            purge_job_details: Optional[pulumi.Input[str]] = None,
            purge_job_status: Optional[pulumi.Input[str]] = None,
            purge_job_time: Optional[pulumi.Input[str]] = None,
            resume_trigger: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_collected: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            trail_location: Optional[pulumi.Input[str]] = None,
            trail_source: Optional[pulumi.Input[str]] = None,
            work_request_id: Optional[pulumi.Input[str]] = None) -> 'AuditTrail':
        """
        Get an existing AuditTrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_collection_start_time: The date from which the audit trail must start collecting data, in the format defined by RFC3339.
        :param pulumi.Input[str] audit_profile_id: The OCID of the  parent audit.
        :param pulumi.Input[str] audit_trail_id: The OCID of the audit trail.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that contains the audit trail and is the same as the compartment of the audit profile resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the audit trail.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_purge_enabled: (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the audit trail in Data Safe.
        :param pulumi.Input[int] peer_target_database_key: The secondary id assigned for the peer database registered with Data Safe.
        :param pulumi.Input[str] purge_job_details: The details of the audit trail purge job that ran on the "purgeJobTime".
        :param pulumi.Input[str] purge_job_status: The current status of the audit trail purge job.
        :param pulumi.Input[str] purge_job_time: The date and time of the last purge job, which deletes audit data in the target database every seven days so that the database's audit trail does not become too large. In the format defined by RFC3339.
        :param pulumi.Input[int] resume_trigger: (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        :param pulumi.Input[str] status: The current sub-state of the audit trail.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the Data Safe target for which the audit trail is created.
        :param pulumi.Input[str] time_created: The date and time the audit trail was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_collected: The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the audit trail was updated, in the format defined by RFC3339.
        :param pulumi.Input[str] trail_location: An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        :param pulumi.Input[str] trail_source: The underlying source of unified audit trail.
        :param pulumi.Input[str] work_request_id: The OCID of the workrequest for audit trail which collects audit records.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditTrailState.__new__(_AuditTrailState)

        __props__.__dict__["audit_collection_start_time"] = audit_collection_start_time
        __props__.__dict__["audit_profile_id"] = audit_profile_id
        __props__.__dict__["audit_trail_id"] = audit_trail_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_purge_enabled"] = is_auto_purge_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["peer_target_database_key"] = peer_target_database_key
        __props__.__dict__["purge_job_details"] = purge_job_details
        __props__.__dict__["purge_job_status"] = purge_job_status
        __props__.__dict__["purge_job_time"] = purge_job_time
        __props__.__dict__["resume_trigger"] = resume_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_collected"] = time_last_collected
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trail_location"] = trail_location
        __props__.__dict__["trail_source"] = trail_source
        __props__.__dict__["work_request_id"] = work_request_id
        return AuditTrail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> pulumi.Output[str]:
        """
        The date from which the audit trail must start collecting data, in the format defined by RFC3339.
        """
        return pulumi.get(self, "audit_collection_start_time")

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> pulumi.Output[str]:
        """
        The OCID of the  parent audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="auditTrailId")
    def audit_trail_id(self) -> pulumi.Output[str]:
        """
        The OCID of the audit trail.
        """
        return pulumi.get(self, "audit_trail_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment that contains the audit trail and is the same as the compartment of the audit profile resource.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the audit trail.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the audit trail. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAutoPurgeEnabled")
    def is_auto_purge_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if auto purge is enabled on the target database, which helps delete audit data in the target database every seven days so that the database's audit trail does not become too large.
        """
        return pulumi.get(self, "is_auto_purge_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the audit trail in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="peerTargetDatabaseKey")
    def peer_target_database_key(self) -> pulumi.Output[int]:
        """
        The secondary id assigned for the peer database registered with Data Safe.
        """
        return pulumi.get(self, "peer_target_database_key")

    @property
    @pulumi.getter(name="purgeJobDetails")
    def purge_job_details(self) -> pulumi.Output[str]:
        """
        The details of the audit trail purge job that ran on the "purgeJobTime".
        """
        return pulumi.get(self, "purge_job_details")

    @property
    @pulumi.getter(name="purgeJobStatus")
    def purge_job_status(self) -> pulumi.Output[str]:
        """
        The current status of the audit trail purge job.
        """
        return pulumi.get(self, "purge_job_status")

    @property
    @pulumi.getter(name="purgeJobTime")
    def purge_job_time(self) -> pulumi.Output[str]:
        """
        The date and time of the last purge job, which deletes audit data in the target database every seven days so that the database's audit trail does not become too large. In the format defined by RFC3339.
        """
        return pulumi.get(self, "purge_job_time")

    @property
    @pulumi.getter(name="resumeTrigger")
    def resume_trigger(self) -> pulumi.Output[Optional[int]]:
        """
        (Updatable) An optional property when incremented triggers Resume. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resume_trigger")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the Audit Trail. Could be set to `ACTIVE` or `INACTIVE`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current sub-state of the audit trail.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Data Safe target for which the audit trail is created.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the audit trail was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastCollected")
    def time_last_collected(self) -> pulumi.Output[str]:
        """
        The date and time until when the audit events were collected from the target database by the Data Safe audit trail  collection process, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_collected")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the audit trail was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> pulumi.Output[str]:
        """
        An audit trail location represents the source of audit records that provides documentary evidence of the sequence of activities in the target database.
        """
        return pulumi.get(self, "trail_location")

    @property
    @pulumi.getter(name="trailSource")
    def trail_source(self) -> pulumi.Output[str]:
        """
        The underlying source of unified audit trail.
        """
        return pulumi.get(self, "trail_source")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Output[str]:
        """
        The OCID of the workrequest for audit trail which collects audit records.
        """
        return pulumi.get(self, "work_request_id")

