# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetImportableComputeEntitiesResult',
    'AwaitableGetImportableComputeEntitiesResult',
    'get_importable_compute_entities',
    'get_importable_compute_entities_output',
]

@pulumi.output_type
class GetImportableComputeEntitiesResult:
    """
    A collection of values returned by getImportableComputeEntities.
    """
    def __init__(__self__, compartment_id=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetImportableComputeEntitiesItemResult']:
        """
        Array of importable compute entity objects.
        """
        return pulumi.get(self, "items")


class AwaitableGetImportableComputeEntitiesResult(GetImportableComputeEntitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImportableComputeEntitiesResult(
            compartment_id=self.compartment_id,
            id=self.id,
            items=self.items)


def get_importable_compute_entities(compartment_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImportableComputeEntitiesResult:
    """
    This data source provides the list of Importable Compute Entities in Oracle Cloud Infrastructure Opsi service.

    Gets a list of available compute intances running cloud agent to add a new hostInsight.  An Compute entity is "available"
    and will be shown if all the following conditions are true:
       1. Compute is running OCA
       2. Oracle Cloud Infrastructure Management Agent is not enabled or If Oracle Cloud Infrastructure Management Agent is enabled
          2.1 The agent OCID is not already being used for an existing hostInsight.
          2.2 The agent availabilityStatus = 'ACTIVE'
          2.3 The agent lifecycleState = 'ACTIVE'

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_importable_compute_entities = oci.Opsi.get_importable_compute_entities(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getImportableComputeEntities:getImportableComputeEntities', __args__, opts=opts, typ=GetImportableComputeEntitiesResult).value

    return AwaitableGetImportableComputeEntitiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_importable_compute_entities)
def get_importable_compute_entities_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImportableComputeEntitiesResult]:
    """
    This data source provides the list of Importable Compute Entities in Oracle Cloud Infrastructure Opsi service.

    Gets a list of available compute intances running cloud agent to add a new hostInsight.  An Compute entity is "available"
    and will be shown if all the following conditions are true:
       1. Compute is running OCA
       2. Oracle Cloud Infrastructure Management Agent is not enabled or If Oracle Cloud Infrastructure Management Agent is enabled
          2.1 The agent OCID is not already being used for an existing hostInsight.
          2.2 The agent availabilityStatus = 'ACTIVE'
          2.3 The agent lifecycleState = 'ACTIVE'

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_importable_compute_entities = oci.Opsi.get_importable_compute_entities(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    ...
